/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;

final class ErrorDiffusionOpImage
extends UntiledOpImage {
    private static final float FLOAT_EPSILON = 1.1920929E-7f;
    private static final int NBANDS = 3;
    private static final int NGRAYS = 256;
    private static final int OVERSHOOT = 256;
    private static final int UNDERSHOOT = 256;
    private static final int TOTALGRAYS = 768;
    private static final int ERR_SHIFT = 8;
    protected LookupTableJAI colorMap;
    protected KernelJAI errorKernel;
    private int numBandsSource;
    private boolean isOptimizedCase = false;
    private float minPixelValue;
    private float maxPixelValue;

    private static boolean isFloydSteinbergKernel(KernelJAI kernelJAI) {
        int n = kernelJAI.getYOrigin();
        return kernelJAI.getWidth() == 3 && kernelJAI.getXOrigin() == 1 && kernelJAI.getHeight() - n == 2 && Math.abs(kernelJAI.getElement(2, n) - 0.4375f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(0, n + 1) - 0.1875f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(1, n + 1) - 0.3125f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(2, n + 1) - 0.0625f) < 1.1920929E-7f;
    }

    private static int[] initFloydSteinberg24To8(ColorCube colorCube) {
        int n;
        int[] nArray = new int[2304];
        float[] fArray = new float[256];
        int[] nArray2 = colorCube.getMultipliers();
        int[] nArray3 = colorCube.getDimsLessOne();
        int n2 = colorCube.getAdjustedOffset();
        int n3 = 0;
        while (n3 < 3) {
            int n4;
            n = n3 * 768;
            float f = 255.0f / (float)nArray3[n3];
            int n5 = 0;
            while (n5 < nArray3[n3]) {
                fArray[n5] = ((float)n5 + 0.5f) * f;
                ++n5;
            }
            fArray[nArray3[n3]] = 256.0f;
            n5 = 256;
            int n6 = -65536;
            int n7 = -256;
            while (n7 < 0) {
                nArray[n++] = n6;
                n6 += n5;
                ++n7;
            }
            n7 = 0;
            float f2 = 0.0f;
            int n8 = 0;
            float f3 = fArray[0];
            int n9 = 0;
            while (n9 < 256) {
                int n10 = n7;
                n4 = (int)(f2 + 0.5f);
                while ((float)n9 < f3) {
                    nArray[n++] = (n9 - n4 << 8) + n10;
                    ++n9;
                }
                f3 = fArray[++n8];
                n7 += nArray2[n3];
                f2 += f;
            }
            n4 = 255;
            n6 = 256 - n4 << 8 | (n7 -= nArray2[n3]);
            n9 = 256;
            while (n9 < 512) {
                nArray[n++] = n6;
                n6 += n5;
                ++n9;
            }
            ++n3;
        }
        n3 = 0;
        n = 768;
        while (n != 0) {
            int n11 = n3++;
            nArray[n11] = nArray[n11] + n2;
            --n;
        }
        return nArray;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, LookupTableJAI lookupTableJAI) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (lookupTableJAI.getNumBands() == 1 && lookupTableJAI.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel2 = imageLayout2.getColorModel(null);
            if (colorModel2 != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel2)) {
                imageLayout2.unsetValid(512);
            }
        }
        int n = lookupTableJAI.getNumBands();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = Math.max(lookupTableJAI.getOffset(n3) + lookupTableJAI.getNumEntries() - 1, n2);
            ++n3;
        }
        if (n2 > 255 && sampleModel.getDataType() == 0 || n2 > 65535 && sampleModel.getDataType() != 3) {
            n3 = n2 > 65535 ? 3 : 1;
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n3, sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel3 = imageLayout2.getColorModel(null);
            if (colorModel3 != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel3)) {
                imageLayout2.unsetValid(512);
            }
        }
        if (!(imageLayout != null && imageLayout2.isValid(512) || renderedImage.getSampleModel().getDataType() != 0 || sampleModel.getDataType() != 0 && sampleModel.getDataType() != 1 || lookupTableJAI.getDataType() != 0 || lookupTableJAI.getNumBands() != 3 || (colorModel = renderedImage.getColorModel()) != null && (colorModel == null || !colorModel.getColorSpace().isCS_sRGB()))) {
            int n4 = lookupTableJAI.getNumEntries();
            byte[][] byArray = new byte[3][n2 + 1];
            int n5 = 0;
            while (n5 < 3) {
                byte[] byArray2 = byArray[n5];
                byte[] byArray3 = lookupTableJAI.getByteData(n5);
                int n6 = lookupTableJAI.getOffset(n5);
                int n7 = n6 + n4;
                int n8 = n6;
                while (n8 < n7) {
                    byArray2[n8] = byArray3[n8 - n6];
                    ++n8;
                }
                ++n5;
            }
            n5 = sampleModel.getDataType() == 0 ? 8 : 16;
            imageLayout2.setColorModel(new IndexColorModel(n5, n2 + 1, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public ErrorDiffusionOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI, KernelJAI kernelJAI) {
        super(renderedImage, map, ErrorDiffusionOpImage.layoutHelper(imageLayout, renderedImage, lookupTableJAI));
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBandsSource = sampleModel.getNumBands();
        this.colorMap = lookupTableJAI;
        this.errorKernel = kernelJAI;
        this.isOptimizedCase = this.sampleModel.getTransferType() == 0 && sampleModel.getTransferType() == 0 && this.numBandsSource == 3 && lookupTableJAI instanceof ColorCube && ErrorDiffusionOpImage.isFloydSteinbergKernel(kernelJAI);
        switch (lookupTableJAI.getDataType()) {
            case 0: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 255.0f;
                break;
            }
            case 2: {
                this.minPixelValue = -32768.0f;
                this.maxPixelValue = 32767.0f;
                break;
            }
            case 1: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 65535.0f;
                break;
            }
            case 3: {
                this.minPixelValue = -2.1474836E9f;
                this.maxPixelValue = 2.1474836E9f;
                break;
            }
            case 4: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            case 5: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ErrorDiffusionOpImage0"));
            }
        }
    }

    @Override
    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (this.isOptimizedCase) {
            this.computeImageOptimized(raster, writableRaster, rectangle);
        } else {
            this.computeImageDefault(raster, writableRaster, rectangle);
        }
    }

    protected void computeImageDefault(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.minX;
        int n2 = n + this.width - 1;
        int n3 = this.minY;
        int n4 = n3 + this.height - 1;
        int n5 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin();
        float[][] fArray = new float[n5][this.width * this.numBandsSource];
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = n6;
            raster.getPixels(n, n3 + n6, this.width, 1, fArray[n6]);
            ++n6;
        }
        n6 = n5 - 1;
        int n7 = this.errorKernel.getWidth();
        float[] fArray2 = this.errorKernel.getKernelData();
        int n8 = n7 - this.errorKernel.getXOrigin() - 1;
        int n9 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin() - 1;
        int n10 = this.errorKernel.getYOrigin() * n7 + this.errorKernel.getXOrigin() + 1;
        int n11 = (this.errorKernel.getYOrigin() + 1) * n7;
        float[] fArray3 = new float[this.numBandsSource];
        this.colorMap.getOffset();
        float[] fArray4 = new float[this.numBandsSource];
        int[] nArray2 = new int[this.width];
        int n12 = n3;
        while (n12 <= n4) {
            int n13 = nArray[0];
            float[] fArray5 = fArray[n13];
            int n14 = 0;
            int n15 = n;
            int n16 = 0;
            while (n15 <= n2) {
                int n17 = 0;
                while (n17 < this.numBandsSource) {
                    fArray3[n17] = fArray5[n16++];
                    if (fArray3[n17] < this.minPixelValue || fArray3[n17] > this.maxPixelValue) {
                        fArray3[n17] = Math.max(fArray3[n17], this.minPixelValue);
                        fArray3[n17] = Math.min(fArray3[n17], this.maxPixelValue);
                    }
                    ++n17;
                }
                n17 = this.colorMap.findNearestEntry(fArray3);
                nArray2[n14++] = n17;
                boolean bl = false;
                int n18 = 0;
                while (n18 < this.numBandsSource) {
                    fArray4[n18] = fArray3[n18] - this.colorMap.lookupFloat(n18, n17);
                    if (fArray4[n18] != 0.0f) {
                        bl = true;
                    }
                    ++n18;
                }
                if (bl) {
                    int n19;
                    n18 = Math.min(n8, n2 - n15);
                    int n20 = n10;
                    int n21 = n16;
                    int n22 = 1;
                    while (n22 <= n18) {
                        n19 = 0;
                        while (n19 < this.numBandsSource) {
                            int n23 = n21++;
                            fArray5[n23] = fArray5[n23] + fArray4[n19] * fArray2[n20];
                            ++n19;
                        }
                        ++n20;
                        ++n22;
                    }
                    n22 = Math.min(n15 - n, n8);
                    n19 = Math.min(n15 + n8, n2) - Math.max(n15 - n8, n) + 1;
                    int n24 = 1;
                    while (n24 <= n9) {
                        float[] fArray6 = fArray[nArray[n24]];
                        n20 = n11;
                        n21 = n16 - (n22 + 1) * this.numBandsSource;
                        int n25 = 1;
                        while (n25 <= n19) {
                            int n26 = 0;
                            while (n26 < this.numBandsSource) {
                                int n27 = n21++;
                                fArray6[n27] = fArray6[n27] + fArray4[n26] * fArray2[n20];
                                ++n26;
                            }
                            ++n20;
                            ++n25;
                        }
                        ++n24;
                    }
                }
                ++n15;
            }
            writableRaster.setSamples(n, n12, rectangle.width, 1, 0, nArray2);
            n15 = 0;
            while (n15 < n6) {
                nArray[n15] = nArray[n15 + 1];
                ++n15;
            }
            nArray[n6] = n13;
            if (n12 + n5 < this.getMaxY()) {
                raster.getPixels(n, n12 + n5, this.width, 1, fArray[nArray[n6]]);
            }
            ++n12;
        }
    }

    protected void computeImageOptimized(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.minX;
        int n2 = n + this.width - 1;
        int n3 = this.minY;
        int n4 = n3 + this.height - 1;
        int[] nArray = ErrorDiffusionOpImage.initFloydSteinberg24To8((ColorCube)this.colorMap);
        int n5 = raster.getWidth() + 2;
        int[] nArray2 = new int[n5 * 3];
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n, n3, raster.getWidth(), raster.getHeight()), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        byte[] byArray2 = rasterAccessor.getByteDataArray(1);
        byte[] byArray3 = rasterAccessor.getByteDataArray(2);
        byte[] byArray4 = rasterAccessor2.getByteDataArray(0);
        int n10 = rasterAccessor.getBandOffset(0);
        int n11 = rasterAccessor.getBandOffset(1);
        int n12 = rasterAccessor.getBandOffset(2);
        int n13 = rasterAccessor2.getBandOffset(0);
        int n14 = n3;
        while (n14 <= n4) {
            int n15 = n10;
            int n16 = n11;
            int n17 = n12;
            int n18 = n13;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            int n29 = n;
            while (n29 <= n2) {
                int n30;
                int n31 = 256;
                int n32 = (n19 + nArray2[n28 + 3] + 8 >> 4) + (byArray[n15] & 0xFF);
                n15 += n6;
                int n33 = nArray[n31 + n32];
                int n34 = n30 = n33 >> 8;
                int n35 = n33 & 0xFF;
                int n36 = n30 + n30;
                nArray2[n28] = n20 + (n30 += n36);
                n20 = n21 + (n30 += n36);
                n21 = n34;
                n19 = n30 += n36;
                n32 = (n22 + nArray2[n28 + 4] + 8 >> 4) + (byArray2[n16] & 0xFF);
                n16 += n6;
                n33 = nArray[(n31 += 768) + n32];
                n34 = n30 = n33 >> 8;
                n35 += n33 & 0xFF;
                n36 = n30 + n30;
                nArray2[n28 + 1] = n23 + (n30 += n36);
                n23 = n24 + (n30 += n36);
                n24 = n34;
                n22 = n30 += n36;
                n32 = (n25 + nArray2[n28 + 5] + 8 >> 4) + (byArray3[n17] & 0xFF);
                n17 += n6;
                n33 = nArray[(n31 += 768) + n32];
                n34 = n30 = n33 >> 8;
                n35 += n33 & 0xFF;
                n36 = n30 + n30;
                nArray2[n28 + 2] = n26 + (n30 += n36);
                n26 = n27 + (n30 += n36);
                n27 = n34;
                n25 = n30 += n36;
                byArray4[n18] = (byte)(n35 & 0xFF);
                n18 += n8;
                n28 += 3;
                ++n29;
            }
            n29 = 3 * (n5 - 2);
            nArray2[n29] = n20;
            nArray2[n29 + 1] = n23;
            nArray2[n29 + 2] = n26;
            n10 += n7;
            n11 += n7;
            n12 += n7;
            n13 += n9;
            ++n14;
        }
        rasterAccessor2.copyDataToRaster();
    }
}

