/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

final class ErodeBinaryOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private int[] kdataPack;
    private int kwPack;
    private int dwidth;
    private int dheight;
    private int dnumBands;
    private int bits;
    private int dstDBOffset;
    private int dstScanlineStride;
    private int dstScanlineStrideBits;
    private int dstMinX;
    private int dstMinY;
    private int dstTransX;
    private int dstTransY;
    private int dstDataBitOffset;
    private int srcDBOffset;
    private int srcScanlineStride;
    private int srcScanlineStrideBits;
    private int srcMinX;
    private int srcMinY;
    private int srcTransX;
    private int srcTransY;
    private int srcDataBitOffset;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public ErodeBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, ErodeBinaryOpImage.configHelper(map), true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kwPack = (this.kw + 31) / 32;
        this.kdataPack = this.packKernel(kernelJAI);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData2 = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int[] nArray = new int[this.kwPack * this.kh];
        int n = rectangle.height;
        int n2 = rectangle.width;
        int n3 = packedImageData.offset;
        int n4 = packedImageData2.offset;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            byte by;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = 0;
            while (n12 < nArray.length) {
                nArray[n12] = 0;
                ++n12;
            }
            n12 = 0;
            while (n12 < this.kw - 1) {
                ErodeBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n11 = this.kwPack - 1;
                n10 = packedImageData.bitOffset + n12;
                n9 = n10 >> 3;
                n10 = 7 - (n10 & 7);
                n8 = 0;
                n7 = n3;
                while (n8 < this.kh) {
                    by = packedImageData.data[n7 + n9];
                    n6 = by >> n10 & 1;
                    int n13 = n11;
                    nArray[n13] = nArray[n13] | n6;
                    n11 += this.kwPack;
                    ++n8;
                    n7 += packedImageData.lineStride;
                }
                ++n12;
            }
            n12 = 0;
            while (n12 < n2) {
                ErodeBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n11 = this.kwPack - 1;
                n10 = packedImageData.bitOffset + n12 + this.kw - 1;
                n9 = n10 >> 3;
                n10 = 7 - (n10 & 7);
                n8 = 0;
                n7 = n3;
                while (n8 < this.kh) {
                    by = packedImageData.data[n7 + n9];
                    n6 = by >> n10 & 1;
                    int n14 = n11;
                    nArray[n14] = nArray[n14] | n6;
                    n11 += this.kwPack;
                    ++n8;
                    n7 += packedImageData.lineStride;
                }
                n8 = packedImageData2.bitOffset + n12;
                n7 = 7 - (n8 & 7);
                int n15 = (n8 >> 3) + n4;
                int n16 = packedImageData2.data[n15];
                n16 |= 1 << n7;
                int n17 = 0;
                while (n17 < nArray.length) {
                    if ((nArray[n17] & this.kdataPack[n17]) != this.kdataPack[n17]) {
                        n16 &= ~(1 << n7);
                        break;
                    }
                    ++n17;
                }
                packedImageData2.data[n15] = (byte)n16;
                ++n12;
            }
            n3 += packedImageData.lineStride;
            n4 += packedImageData2.lineStride;
            ++n5;
        }
        pixelAccessor.setPackedPixels(packedImageData2);
    }

    private final int[] packKernel(KernelJAI kernelJAI) {
        int n = kernelJAI.getWidth();
        int n2 = kernelJAI.getHeight();
        int n3 = (31 + n) / 32;
        int[] nArray = new int[n3 * n2];
        float[] fArray = kernelJAI.getKernelData();
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4;
            int n6 = n3 - 1;
            ErodeBinaryOpImage.bitShiftMatrixLeft(nArray, n2, n3);
            int n7 = 0;
            while (n7 < n2) {
                if (fArray[n5] > 0.9f) {
                    int n8 = n6;
                    nArray[n8] = nArray[n8] | 1;
                }
                ++n7;
                n6 += n3;
                n5 += n;
            }
            ++n4;
        }
        return nArray;
    }

    private static final void bitShiftMatrixLeft(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                nArray[n3] = nArray[n3] << 1 | nArray[n3 + 1] >>> 31;
                ++n3;
                ++n5;
            }
            int n6 = n3++;
            nArray[n6] = nArray[n6] << 1;
            ++n4;
        }
    }
}

