/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;

    public ConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f = 0.5f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f += (float)(byArray4[n20] & 0xFF) * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    n19 = (int)f;
                    if (n19 < 0) {
                        n19 = 0;
                    } else if (n19 > 255) {
                        n19 = 255;
                    }
                    byArray3[n15] = (byte)n19;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f = 0.5f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f += (float)sArray4[n20] * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    n19 = (int)f;
                    if (n19 < Short.MIN_VALUE) {
                        n19 = Short.MIN_VALUE;
                    } else if (n19 > Short.MAX_VALUE) {
                        n19 = Short.MAX_VALUE;
                    }
                    sArray3[n15] = (short)n19;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f = 0.5f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f += (float)(sArray4[n20] & 0xFFFF) * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    n19 = (int)f;
                    if (n19 < 0) {
                        n19 = 0;
                    } else if (n19 > 65535) {
                        n19 = 65535;
                    }
                    sArray3[n15] = (short)n19;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            int[] nArray5 = nArray[n10];
            int[] nArray6 = nArray3[n10];
            int n11 = nArray4[n10];
            int n12 = nArray2[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f = 0.5f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f += (float)nArray6[n20] * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    nArray5[n15] = (int)f;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            float[] fArray4 = fArray2[n10];
            float[] fArray5 = fArray3[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f = 0.0f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f += fArray5[n20] * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    fArray4[n15] = f;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            double[] dArray3 = dArray[n10];
            double[] dArray4 = dArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    double d = 0.5;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            d += dArray4[n20] * (double)fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    dArray3[n15] = d;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }
}

