/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ColorSpaceJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class ColorConvertOpImage
extends PointOpImage {
    private static final ColorSpace rgbColorSpace = ColorSpace.getInstance(1000);
    private static SoftReference softRef = null;
    private ImageParameters srcParam = null;
    private ImageParameters dstParam = null;
    private ImageParameters tempParam = null;
    private ColorConvertOp colorConvertOp = null;
    private int caseNumber;

    private static synchronized ColorConvertOp getColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2) {
        HashMap hashMap = null;
        if (softRef == null || (hashMap = (HashMap)softRef.get()) == null) {
            hashMap = new HashMap();
            softRef = new SoftReference<HashMap>(hashMap);
        }
        ArrayList<ColorSpace> arrayList = new ArrayList<ColorSpace>(2);
        arrayList.add(0, colorSpace);
        arrayList.add(1, colorSpace2);
        ColorConvertOp colorConvertOp = (ColorConvertOp)hashMap.get(arrayList);
        if (colorConvertOp == null) {
            colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
            hashMap.put(arrayList, colorConvertOp);
        }
        return colorConvertOp;
    }

    private static float getMinValue(int n) {
        float f = 0.0f;
        switch (n) {
            case 0: {
                f = 0.0f;
                break;
            }
            case 2: {
                f = -32768.0f;
                break;
            }
            case 1: {
                f = 0.0f;
                break;
            }
            case 3: {
                f = -2.1474836E9f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    private static float getRange(int n) {
        float f = 1.0f;
        switch (n) {
            case 0: {
                f = 255.0f;
                break;
            }
            case 2: {
                f = 65535.0f;
                break;
            }
            case 1: {
                f = 65535.0f;
                break;
            }
            case 3: {
                f = 4.2949673E9f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        return f;
    }

    public ColorConvertOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorModel colorModel) {
        super(renderedImage, imageLayout, map, true);
        this.colorModel = colorModel;
        this.srcParam = new ImageParameters(renderedImage.getColorModel(), renderedImage.getSampleModel());
        this.dstParam = new ImageParameters(colorModel, this.sampleModel);
        ColorSpace colorSpace = this.srcParam.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = this.dstParam.getColorModel().getColorSpace();
        if (colorSpace instanceof ColorSpaceJAI && colorSpace2 instanceof ColorSpaceJAI) {
            this.caseNumber = 1;
            this.tempParam = this.createTempParam();
        } else if (colorSpace instanceof ColorSpaceJAI) {
            if (colorSpace2 != rgbColorSpace) {
                this.caseNumber = 2;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = ColorConvertOpImage.getColorConvertOp(rgbColorSpace, colorSpace2);
            } else {
                this.caseNumber = 3;
            }
        } else if (colorSpace2 instanceof ColorSpaceJAI) {
            if (colorSpace != rgbColorSpace) {
                this.caseNumber = 4;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = ColorConvertOpImage.getColorConvertOp(colorSpace, rgbColorSpace);
            } else {
                this.caseNumber = 5;
            }
        } else {
            this.caseNumber = 6;
            this.colorConvertOp = ColorConvertOpImage.getColorConvertOp(colorSpace, colorSpace2);
        }
        this.permitInPlaceOperation();
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        WritableRaster writableRaster2 = null;
        Raster raster = rasterArray[0];
        if (!rectangle.equals(raster.getBounds())) {
            raster = raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        switch (this.caseNumber) {
            case 1: {
                writableRaster2 = this.computeRectColorSpaceJAIToRGB(raster, this.srcParam, null, this.tempParam);
                this.computeRectColorSpaceJAIFromRGB(writableRaster2, this.tempParam, writableRaster, this.dstParam);
                break;
            }
            case 2: {
                writableRaster2 = this.computeRectColorSpaceJAIToRGB(raster, this.srcParam, null, this.tempParam);
                this.computeRectNonColorSpaceJAI(writableRaster2, this.tempParam, writableRaster, this.dstParam, rectangle);
                break;
            }
            case 3: {
                this.computeRectColorSpaceJAIToRGB(raster, this.srcParam, writableRaster, this.dstParam);
                break;
            }
            case 4: {
                writableRaster2 = this.createTempWritableRaster(raster);
                this.computeRectNonColorSpaceJAI(raster, this.srcParam, writableRaster2, this.tempParam, rectangle);
                this.computeRectColorSpaceJAIFromRGB(writableRaster2, this.tempParam, writableRaster, this.dstParam);
                break;
            }
            case 5: {
                this.computeRectColorSpaceJAIFromRGB(raster, this.srcParam, writableRaster, this.dstParam);
                break;
            }
            case 6: {
                this.computeRectNonColorSpaceJAI(raster, this.srcParam, writableRaster, this.dstParam, rectangle);
            }
        }
    }

    private WritableRaster computeRectColorSpaceJAIToRGB(Raster raster, ImageParameters imageParameters, WritableRaster writableRaster, ImageParameters imageParameters2) {
        raster = this.convertRasterToUnsigned(raster);
        ColorSpaceJAI colorSpaceJAI = (ColorSpaceJAI)imageParameters.getColorModel().getColorSpace();
        writableRaster = colorSpaceJAI.toRGB(raster, imageParameters.getComponentSize(), writableRaster, imageParameters2.getComponentSize());
        writableRaster = this.convertRasterToSigned(writableRaster);
        return writableRaster;
    }

    private WritableRaster computeRectColorSpaceJAIFromRGB(Raster raster, ImageParameters imageParameters, WritableRaster writableRaster, ImageParameters imageParameters2) {
        raster = this.convertRasterToUnsigned(raster);
        ColorSpaceJAI colorSpaceJAI = (ColorSpaceJAI)imageParameters2.getColorModel().getColorSpace();
        writableRaster = colorSpaceJAI.fromRGB(raster, imageParameters.getComponentSize(), writableRaster, imageParameters2.getComponentSize());
        writableRaster = this.convertRasterToSigned(writableRaster);
        return writableRaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectNonColorSpaceJAI(Raster raster, ImageParameters imageParameters, WritableRaster writableRaster, ImageParameters imageParameters2, Rectangle rectangle) {
        if (!imageParameters.isFloat() && !imageParameters2.isFloat()) {
            WritableRaster writableRaster2;
            Raster raster2 = raster;
            if (raster2.getMinX() != rectangle.x || raster2.getMinY() != rectangle.y || raster2.getWidth() != rectangle.width || raster2.getHeight() != rectangle.height) {
                raster2 = raster2.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
            if ((writableRaster2 = writableRaster).getMinX() != rectangle.x || writableRaster2.getMinY() != rectangle.y || writableRaster2.getWidth() != rectangle.width || writableRaster2.getHeight() != rectangle.height) {
                writableRaster2 = writableRaster2.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
            Class<?> clazz = this.colorConvertOp.getClass();
            synchronized (clazz) {
                this.colorConvertOp.filter(raster2, writableRaster2);
            }
        } else {
            ColorSpace colorSpace = imageParameters.getColorModel().getColorSpace();
            ColorSpace colorSpace2 = imageParameters2.getColorModel().getColorSpace();
            boolean bl = imageParameters.isFloat();
            float f = imageParameters.getMinValue();
            float f2 = imageParameters.getRange();
            boolean bl2 = imageParameters2.isFloat();
            float f3 = imageParameters2.getMinValue();
            float f4 = imageParameters2.getRange();
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle.x + rectangle.width;
            int n3 = colorSpace.getNumComponents();
            float[] fArray = new float[n3];
            int n4 = rectangle.y;
            while (n4 < n) {
                int n5 = rectangle.x;
                while (n5 < n2) {
                    int n6;
                    fArray = raster.getPixel(n5, n4, fArray);
                    if (!bl) {
                        n6 = 0;
                        while (n6 < n3) {
                            fArray[n6] = (fArray[n6] - f) / f2;
                            ++n6;
                        }
                    }
                    float[] fArray2 = colorSpace.toCIEXYZ(fArray);
                    float[] fArray3 = colorSpace2.fromCIEXYZ(fArray2);
                    if (!bl2) {
                        n6 = 0;
                        while (n6 < n3) {
                            fArray3[n6] = fArray3[n6] * f4 + f3;
                            ++n6;
                        }
                    }
                    writableRaster.setPixel(n5, n4, fArray3);
                    ++n5;
                }
                ++n4;
            }
        }
    }

    private ImageParameters createTempParam() {
        ColorModel colorModel = null;
        SampleModel sampleModel = null;
        if (this.srcParam.getDataType() > this.dstParam.getDataType()) {
            colorModel = this.srcParam.getColorModel();
            sampleModel = this.srcParam.getSampleModel();
        } else {
            colorModel = this.dstParam.getColorModel();
            sampleModel = this.dstParam.getSampleModel();
        }
        colorModel = new ComponentColorModel(rgbColorSpace, colorModel.getComponentSize(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), sampleModel.getDataType());
        return new ImageParameters(colorModel, sampleModel);
    }

    private WritableRaster createTempWritableRaster(Raster raster) {
        Point point = new Point(raster.getMinX(), raster.getMinY());
        return RasterFactory.createWritableRaster(raster.getSampleModel(), point);
    }

    private Raster convertRasterToUnsigned(Raster raster) {
        int n = raster.getSampleModel().getDataType();
        WritableRaster writableRaster = null;
        if (n == 3 || n == 2) {
            int n2 = raster.getMinX();
            int n3 = raster.getMinY();
            int n4 = raster.getWidth();
            int n5 = raster.getHeight();
            int[] nArray = raster.getPixels(n2, n3, n4, n5, (int[])null);
            this.convertBufferToUnsigned(nArray, n);
            writableRaster = this.createTempWritableRaster(raster);
            writableRaster.setPixels(n2, n3, n4, n5, nArray);
            return writableRaster;
        }
        return raster;
    }

    private WritableRaster convertRasterToSigned(WritableRaster writableRaster) {
        int n = writableRaster.getSampleModel().getDataType();
        WritableRaster writableRaster2 = null;
        if (n == 3 || n == 2) {
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getMinY();
            int n4 = writableRaster.getWidth();
            int n5 = writableRaster.getHeight();
            int[] nArray = writableRaster.getPixels(n2, n3, n4, n5, (int[])null);
            this.convertBufferToSigned(nArray, n);
            writableRaster2 = writableRaster instanceof WritableRaster ? writableRaster : this.createTempWritableRaster(writableRaster);
            writableRaster2.setPixels(n2, n3, n4, n5, nArray);
            return writableRaster2;
        }
        return writableRaster;
    }

    private void convertBufferToSigned(int[] nArray, int n) {
        block4: {
            block3: {
                if (nArray == null) {
                    return;
                }
                if (n != 2) break block3;
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = n2++;
                    nArray[n3] = nArray[n3] + Short.MIN_VALUE;
                }
                break block4;
            }
            if (n != 3) break block4;
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = (int)(((long)nArray[n4] & 0xFFFFFFFFL) + Integer.MIN_VALUE);
                ++n4;
            }
        }
    }

    private void convertBufferToUnsigned(int[] nArray, int n) {
        block4: {
            block3: {
                if (nArray == null) {
                    return;
                }
                if (n != 2) break block3;
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = n2++;
                    nArray[n3] = nArray[n3] - Short.MIN_VALUE;
                }
                break block4;
            }
            if (n != 3) break block4;
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = (int)(((long)nArray[n4] & 0xFFFFFFFFL) - Integer.MIN_VALUE);
                ++n4;
            }
        }
    }

    private final class ImageParameters {
        private boolean isFloat;
        private ColorModel colorModel;
        private SampleModel sampleModel;
        private float minValue;
        private float range;
        private int[] componentSize;
        private int dataType;

        ImageParameters(ColorModel colorModel, SampleModel sampleModel) {
            this.colorModel = colorModel;
            this.sampleModel = sampleModel;
            this.dataType = sampleModel.getDataType();
            this.isFloat = this.dataType == 4 || this.dataType == 5;
            this.minValue = ColorConvertOpImage.getMinValue(this.dataType);
            this.range = ColorConvertOpImage.getRange(this.dataType);
            this.componentSize = colorModel.getComponentSize();
        }

        public boolean isFloat() {
            return this.isFloat;
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public SampleModel getSampleModel() {
            return this.sampleModel;
        }

        public float getMinValue() {
            return this.minValue;
        }

        public float getRange() {
            return this.range;
        }

        public int[] getComponentSize() {
            return this.componentSize;
        }

        public int getDataType() {
            return this.dataType;
        }
    }
}

