/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.DisposableNullOpImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.TileCache;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class CodecRIFUtil {
    private CodecRIFUtil() {
    }

    public static RenderedImage create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
        SeekableStream seekableStream = (SeekableStream)parameterBlock.getObjectParameter(0);
        ImageDecodeParam imageDecodeParam = null;
        if (parameterBlock.getNumParameters() > 1) {
            imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
        }
        int n = 0;
        if (parameterBlock.getNumParameters() > 2) {
            n = parameterBlock.getIntParameter(2);
        }
        ImageDecoder imageDecoder = ImageCodec.createImageDecoder(string, seekableStream, imageDecodeParam);
        try {
            RenderingHints.Key key;
            int n2 = 2;
            ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
            if (renderingHints != null && renderingHints.containsKey(key = JAI.KEY_OPERATION_BOUND)) {
                n2 = (Integer)renderingHints.get(key);
            }
            boolean bl = seekableStream.canSeekBackwards();
            long l = Long.MIN_VALUE;
            if (bl) {
                try {
                    l = seekableStream.getFilePointer();
                }
                catch (IOException iOException) {
                    imagingListener.errorOccurred(JaiI18N.getString("StreamRIF1"), iOException, CodecRIFUtil.class, false);
                    bl = false;
                }
            }
            OpImage opImage = null;
            try {
                opImage = new DisposableNullOpImage(imageDecoder.decodeAsRenderedImage(n), imageLayout, (Map)renderingHints, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (bl) {
                    TileCache tileCache;
                    TileCache tileCache2 = tileCache = opImage != null ? opImage.getTileCache() : RIFUtil.getTileCacheHint(renderingHints);
                    if (tileCache != null) {
                        tileCache.flush();
                    }
                    System.gc();
                    seekableStream.seek(l);
                    opImage = new DisposableNullOpImage(imageDecoder.decodeAsRenderedImage(n), imageLayout, (Map)renderingHints, n2);
                }
                String string2 = JaiI18N.getString("CodecRIFUtil0");
                imagingListener.errorOccurred(string2, new ImagingException(string2, outOfMemoryError), CodecRIFUtil.class, false);
            }
            return opImage;
        }
        catch (Exception exception) {
            imagingListener.errorOccurred(JaiI18N.getString("CodecRIFUtil1"), exception, CodecRIFUtil.class, false);
            return null;
        }
    }
}

