/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

class BandMergeOpImage
extends PointOpImage {
    ColorModel[] colorModels;

    public BandMergeOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(vector, BandMergeOpImage.layoutHelper(vector, imageLayout), map, true);
        this.permitInPlaceOperation();
        int n = vector.size();
        this.colorModels = new ColorModel[n];
        int n2 = 0;
        while (n2 < n) {
            this.colorModels[n2] = ((RenderedImage)vector.get(n2)).getColorModel();
            ++n2;
        }
    }

    private static int totalNumBands(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n2);
            n = renderedImage.getColorModel() instanceof IndexColorModel ? (n += renderedImage.getColorModel().getNumComponents()) : (n += renderedImage.getSampleModel().getNumBands());
            ++n2;
        }
        return n;
    }

    private static ImageLayout layoutHelper(Vector vector, ImageLayout imageLayout) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = vector.size();
        int n2 = BandMergeOpImage.totalNumBands(vector);
        int n3 = 0;
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        int n4 = 0;
        while (n4 < n) {
            renderedImage = (RenderedImage)vector.get(n4);
            rectangle = rectangle.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
            int n5 = renderedImage.getSampleModel().getTransferType();
            n3 = n5 > n3 ? n5 : n3;
            ++n4;
        }
        SampleModel sampleModel = imageLayout2.getSampleModel((RenderedImage)vector.get(0));
        if (sampleModel.getNumBands() < n2) {
            int[] nArray = new int[n2];
            int n6 = 0;
            while (n6 < n2) {
                nArray[n6] = n6;
                ++n6;
            }
            n6 = sampleModel.getWidth();
            int n7 = sampleModel.getHeight();
            if (imageLayout2.isValid(64)) {
                n6 = imageLayout2.getTileWidth((RenderedImage)vector.get(0));
            }
            if (imageLayout2.isValid(128)) {
                n7 = imageLayout2.getTileHeight((RenderedImage)vector.get(0));
            }
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n3, n6, n7, n2);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((colorModel = imageLayout2.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.unsetValid(512);
        }
        return imageLayout2;
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = writableRaster.getTransferType();
        switch (n) {
            case 0: {
                this.byteLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void byteLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        n2 = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        byte[][] byArray = (byte[][])unpackedImageData.data;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n4] instanceof IndexColorModel ? pixelAccessorArray[n4].getComponents(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType()) : pixelAccessorArray[n4].getPixels(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType(), false);
            int n6 = unpackedImageData2.pixelStride;
            int n7 = unpackedImageData2.lineStride;
            int n8 = unpackedImageData.pixelStride;
            int n9 = unpackedImageData.lineStride;
            int n10 = rectangle.width;
            int n11 = 0;
            while (n11 < nArray[n4]) {
                if (n5 >= n2) break;
                byte[] byArray2 = byArray[n5];
                byte[][] byArray3 = (byte[][])unpackedImageData2.data;
                byte[] byArray4 = byArray3[n11];
                int n12 = unpackedImageData2.bandOffsets[n11];
                int n13 = unpackedImageData.bandOffsets[n5];
                int n14 = 0;
                while (n14 < rectangle.height) {
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = n13;
                    while (n15 < n10) {
                        byArray2[n17] = byArray4[n16];
                        ++n15;
                        n16 += n6;
                        n17 += n8;
                    }
                    ++n14;
                    n12 += n7;
                    n13 += n9;
                }
                ++n11;
                ++n5;
            }
            ++n4;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void shortLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        n2 = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        short[][] sArray = (short[][])unpackedImageData.data;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n4] instanceof IndexColorModel ? pixelAccessorArray[n4].getComponents(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType()) : pixelAccessorArray[n4].getPixels(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType(), false);
            int n6 = unpackedImageData2.pixelStride;
            int n7 = unpackedImageData2.lineStride;
            int n8 = unpackedImageData.pixelStride;
            int n9 = unpackedImageData.lineStride;
            int n10 = rectangle.width;
            int n11 = 0;
            while (n11 < nArray[n4]) {
                if (n5 < n2) {
                    short[][] sArray2 = (short[][])unpackedImageData2.data;
                    int n12 = unpackedImageData2.bandOffsets[n11];
                    int n13 = unpackedImageData.bandOffsets[n5];
                    int n14 = 0;
                    while (n14 < rectangle.height) {
                        int n15 = 0;
                        int n16 = n12;
                        int n17 = n13;
                        while (n15 < n10) {
                            sArray[n5][n17] = sArray2[n11][n16];
                            ++n15;
                            n16 += n6;
                            n17 += n8;
                        }
                        ++n14;
                        n12 += n7;
                        n13 += n9;
                    }
                }
                ++n11;
                ++n5;
            }
            ++n4;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void intLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        n2 = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        int[][] nArray2 = (int[][])unpackedImageData.data;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n4] instanceof IndexColorModel ? pixelAccessorArray[n4].getComponents(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType()) : pixelAccessorArray[n4].getPixels(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType(), false);
            int n6 = unpackedImageData2.pixelStride;
            int n7 = unpackedImageData2.lineStride;
            int n8 = unpackedImageData.pixelStride;
            int n9 = unpackedImageData.lineStride;
            int n10 = rectangle.width;
            int n11 = 0;
            while (n11 < nArray[n4]) {
                if (n5 < n2) {
                    int[][] nArray3 = (int[][])unpackedImageData2.data;
                    int n12 = unpackedImageData2.bandOffsets[n11];
                    int n13 = unpackedImageData.bandOffsets[n5];
                    int n14 = 0;
                    while (n14 < rectangle.height) {
                        int n15 = 0;
                        int n16 = n12;
                        int n17 = n13;
                        while (n15 < n10) {
                            nArray2[n5][n17] = nArray3[n11][n16];
                            ++n15;
                            n16 += n6;
                            n17 += n8;
                        }
                        ++n14;
                        n12 += n7;
                        n13 += n9;
                    }
                }
                ++n11;
                ++n5;
            }
            ++n4;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void floatLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        n2 = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        float[][] fArray = (float[][])unpackedImageData.data;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n4] instanceof IndexColorModel ? pixelAccessorArray[n4].getComponents(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType()) : pixelAccessorArray[n4].getPixels(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType(), false);
            int n6 = unpackedImageData2.pixelStride;
            int n7 = unpackedImageData2.lineStride;
            int n8 = unpackedImageData.pixelStride;
            int n9 = unpackedImageData.lineStride;
            int n10 = rectangle.width;
            int n11 = 0;
            while (n11 < nArray[n4]) {
                if (n5 < n2) {
                    float[][] fArray2 = (float[][])unpackedImageData2.data;
                    int n12 = unpackedImageData2.bandOffsets[n11];
                    int n13 = unpackedImageData.bandOffsets[n5];
                    int n14 = 0;
                    while (n14 < rectangle.height) {
                        int n15 = 0;
                        int n16 = n12;
                        int n17 = n13;
                        while (n15 < n10) {
                            fArray[n5][n17] = fArray2[n11][n16];
                            ++n15;
                            n16 += n6;
                            n17 += n8;
                        }
                        ++n14;
                        n12 += n7;
                        n13 += n9;
                    }
                }
                ++n11;
                ++n5;
            }
            ++n4;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void doubleLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        n2 = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        double[][] dArray = (double[][])unpackedImageData.data;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n4] instanceof IndexColorModel ? pixelAccessorArray[n4].getComponents(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType()) : pixelAccessorArray[n4].getPixels(rasterArray[n4], rectangle, rasterArray[n4].getSampleModel().getTransferType(), false);
            int n6 = unpackedImageData2.pixelStride;
            int n7 = unpackedImageData2.lineStride;
            int n8 = unpackedImageData.pixelStride;
            int n9 = unpackedImageData.lineStride;
            int n10 = rectangle.width;
            int n11 = 0;
            while (n11 < nArray[n4]) {
                if (n5 < n2) {
                    double[][] dArray2 = (double[][])unpackedImageData2.data;
                    int n12 = unpackedImageData2.bandOffsets[n11];
                    int n13 = unpackedImageData.bandOffsets[n5];
                    int n14 = 0;
                    while (n14 < rectangle.height) {
                        int n15 = 0;
                        int n16 = n12;
                        int n17 = n13;
                        while (n15 < n10) {
                            dArray[n5][n17] = dArray2[n11][n16];
                            ++n15;
                            n16 += n6;
                            n17 += n8;
                        }
                        ++n14;
                        n12 += n7;
                        n13 += n9;
                    }
                }
                ++n11;
                ++n5;
            }
            ++n4;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }
}

