/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.util.Range;

class AffineNearestOpImage
extends AffineOpImage {
    public AffineNearestOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected Range performScanlineClipping(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        long l;
        long l2;
        long l3;
        long l4;
        int n11 = n5;
        int n12 = n6;
        long l5 = this.incx * 0x100000 + this.ifracdx;
        if (l5 != 0L) {
            l4 = (long)f + (long)n7;
            l3 = (long)f3 - (long)n8;
            l2 = (l4 - (long)n) * 0x100000L - (long)n3 + (long)n5 * l5;
            l = (l3 - (long)n) * 0x100000L - (long)n3 + (long)n5 * l5;
            if (l5 < 0L) {
                long l6 = l2;
                l2 = l;
                l = l6;
            }
            int n13 = AffineNearestOpImage.ceilRatio(l2, l5);
            n11 = Math.max(n11, n13);
            int n14 = AffineNearestOpImage.floorRatio(l, l5) + 1;
            n12 = Math.min(n12, n14);
        } else if ((float)n < f || (float)n >= f3) {
            n11 = n12 = n5;
            return new Range(Integer.class, new Integer(n11), new Integer(n12));
        }
        l4 = this.incy * 0x100000 + this.ifracdy;
        if (l4 != 0L) {
            l3 = (long)f2 + (long)n9;
            l2 = (long)f4 - (long)n10;
            l = (l3 - (long)n2) * 0x100000L - (long)n4 + (long)n5 * l4;
            long l7 = (l2 - (long)n2) * 0x100000L - (long)n4 + (long)n5 * l4;
            if (l4 < 0L) {
                long l8 = l;
                l = l7;
                l7 = l8;
            }
            int n15 = AffineNearestOpImage.ceilRatio(l, l4);
            n11 = Math.max(n11, n15);
            int n16 = AffineNearestOpImage.floorRatio(l7, l4) + 1;
            n12 = Math.min(n12, n16);
        } else if ((float)n2 < f2 || (float)n2 >= f4) {
            n11 = n12 = n5;
        }
        if (n11 > n6) {
            n11 = n6;
        }
        if (n12 < n5) {
            n12 = n5;
        }
        return new Range(Integer.class, new Integer(n11), new Integer(n12));
    }

    protected Point[] advanceToStartOfScanline(int n, int n2, int n3, int n4, int n5, int n6) {
        long l = n2 - n;
        long l2 = ((long)n5 + l * (long)this.ifracdx) / 0x100000L;
        long l3 = ((long)n6 + l * (long)this.ifracdy) / 0x100000L;
        n3 = (int)((long)n3 + (l * (long)this.incx + (long)((int)l2)));
        n4 = (int)((long)n4 + (l * (long)this.incy + (long)((int)l3)));
        long l4 = (long)n5 + l * (long)this.ifracdx;
        n5 = l4 >= 0L ? (int)(l4 % 0x100000L) : (int)(-(-l4 % 0x100000L));
        long l5 = (long)n6 + l * (long)this.ifracdy;
        n6 = l5 >= 0L ? (int)(l5 % 0x100000L) : (int)(-(-l5 % 0x100000L));
        return new Point[]{new Point(n3, n4), new Point(n5, n6)};
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                int n3 = rasterAccessor2.getNumBands();
                if (n3 == 1) {
                    this.byteLoop_1band(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                    break;
                }
                if (n3 == 3) {
                    this.byteLoop_3band(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                    break;
                }
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = this.incx * n6;
        int n14 = this.incx1 * n6;
        int n15 = this.incy * n7;
        int n16 = this.incy1 * n7;
        byte[] byArray3 = new byte[n8];
        int n17 = 0;
        while (n17 < n8) {
            byArray3[n17] = (byte)this.backgroundValues[n17];
            ++n17;
        }
        n17 = n10;
        while (n17 < n12) {
            int n18;
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n9, n11, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n9, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n7 + (n21 - n) * n6;
            if (this.setBackground) {
                n19 = n9;
                while (n19 < n25) {
                    n18 = 0;
                    while (n18 < n8) {
                        byArray[n18][n20 + nArray[n18]] = byArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n9) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                n18 = 0;
                while (n18 < n8) {
                    byArray[n18][n20 + nArray[n18]] = byArray2[n18][n27 + nArray2[n18]];
                    ++n18;
                }
                if (n23 < this.ifracdx1) {
                    n27 += n13;
                    n23 += this.ifracdx;
                } else {
                    n27 += n14;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n15;
                    n24 += this.ifracdy;
                } else {
                    n27 += n16;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n11) {
                    n18 = 0;
                    while (n18 < n8) {
                        byArray[n18][n20 + nArray[n18]] = byArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n17;
        }
    }

    private void byteLoop_1band(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[] byArray2 = byArray[0];
        int n6 = nArray[0];
        byte[][] byArray3 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        byte[] byArray4 = byArray3[0];
        int n9 = nArray2[0];
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int n14 = this.incx * n7;
        int n15 = this.incx1 * n7;
        int n16 = this.incy * n8;
        int n17 = this.incy1 * n8;
        byte by = (byte)this.backgroundValues[0];
        int n18 = n11;
        while (n18 < n13) {
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n10, n12, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n10, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n8 + (n21 - n) * n7;
            if (this.setBackground) {
                n19 = n10;
                while (n19 < n25) {
                    byArray2[n20 + n6] = by;
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n10) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                byArray2[n20 + n6] = byArray4[n27 + n9];
                if (n23 < this.ifracdx1) {
                    n27 += n14;
                    n23 += this.ifracdx;
                } else {
                    n27 += n15;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n16;
                    n24 += this.ifracdy;
                } else {
                    n27 += n17;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n12) {
                    byArray2[n20 + n6] = by;
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n18;
        }
    }

    private void byteLoop_3band(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = nArray[2];
        byte[][] byArray5 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        byte[] byArray6 = byArray5[0];
        byte[] byArray7 = byArray5[1];
        byte[] byArray8 = byArray5[2];
        int n11 = nArray2[0];
        int n12 = nArray2[1];
        int n13 = nArray2[2];
        int n14 = rectangle.x;
        int n15 = rectangle.y;
        int n16 = rectangle.x + rectangle.width;
        int n17 = rectangle.y + rectangle.height;
        int n18 = this.incx * n9;
        int n19 = this.incx1 * n9;
        int n20 = this.incy * n10;
        int n21 = this.incy1 * n10;
        byte by = (byte)this.backgroundValues[0];
        byte by2 = (byte)this.backgroundValues[1];
        byte by3 = (byte)this.backgroundValues[2];
        int n22 = n15;
        while (n22 < n17) {
            int n23;
            int n24 = n3;
            ((Point2D)float_).setLocation((double)n14 + 0.5, (double)n22 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n25 = (int)Math.floor(f5);
            int n26 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n25;
            double d2 = (double)f6 - (double)n26;
            int n27 = (int)Math.floor(d * 1048576.0);
            int n28 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n25, n26, n27, n28, n14, n16, 0, 0, 0, 0);
            int n29 = (Integer)range.getMinValue();
            int n30 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n14, n29, n25, n26, n27, n28);
            n25 = pointArray[0].x;
            n26 = pointArray[0].y;
            n27 = pointArray[1].x;
            n28 = pointArray[1].y;
            int n31 = (n26 - n2) * n10 + (n25 - n) * n9;
            if (this.setBackground) {
                n23 = n14;
                while (n23 < n29) {
                    byArray2[n24 + n6] = by;
                    byArray3[n24 + n7] = by2;
                    byArray4[n24 + n8] = by3;
                    n24 += n4;
                    ++n23;
                }
            } else {
                n24 += (n29 - n14) * n4;
            }
            n23 = n29;
            while (n23 < n30) {
                byArray2[n24 + n6] = byArray6[n31 + n11];
                byArray3[n24 + n7] = byArray7[n31 + n12];
                byArray4[n24 + n8] = byArray8[n31 + n13];
                if (n27 < this.ifracdx1) {
                    n31 += n18;
                    n27 += this.ifracdx;
                } else {
                    n31 += n19;
                    n27 -= this.ifracdx1;
                }
                if (n28 < this.ifracdy1) {
                    n31 += n20;
                    n28 += this.ifracdy;
                } else {
                    n31 += n21;
                    n28 -= this.ifracdy1;
                }
                n24 += n4;
                ++n23;
            }
            if (this.setBackground && n29 <= n30) {
                n23 = n30;
                while (n23 < n16) {
                    byArray2[n24 + n6] = by;
                    byArray3[n24 + n7] = by2;
                    byArray4[n24 + n8] = by3;
                    n24 += n4;
                    ++n23;
                }
            }
            n3 += n5;
            ++n22;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = this.incx * n6;
        int n14 = this.incx1 * n6;
        int n15 = this.incy * n7;
        int n16 = this.incy1 * n7;
        int[] nArray5 = new int[n8];
        int n17 = 0;
        while (n17 < n8) {
            nArray5[n17] = (int)this.backgroundValues[n17];
            ++n17;
        }
        n17 = n10;
        while (n17 < n12) {
            int n18;
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n9, n11, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n9, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n7 + (n21 - n) * n6;
            if (this.setBackground) {
                n19 = n9;
                while (n19 < n25) {
                    n18 = 0;
                    while (n18 < n8) {
                        nArray[n18][n20 + nArray2[n18]] = nArray5[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n9) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                n18 = 0;
                while (n18 < n8) {
                    nArray[n18][n20 + nArray2[n18]] = nArray3[n18][n27 + nArray4[n18]];
                    ++n18;
                }
                if (n23 < this.ifracdx1) {
                    n27 += n13;
                    n23 += this.ifracdx;
                } else {
                    n27 += n14;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n15;
                    n24 += this.ifracdy;
                } else {
                    n27 += n16;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n11) {
                    n18 = 0;
                    while (n18 < n8) {
                        nArray[n18][n20 + nArray2[n18]] = nArray5[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n17;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = this.incx * n6;
        int n14 = this.incx1 * n6;
        int n15 = this.incy * n7;
        int n16 = this.incy1 * n7;
        short[] sArray3 = new short[n8];
        int n17 = 0;
        while (n17 < n8) {
            sArray3[n17] = (short)this.backgroundValues[n17];
            ++n17;
        }
        n17 = n10;
        while (n17 < n12) {
            int n18;
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n9, n11, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n9, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n7 + (n21 - n) * n6;
            if (this.setBackground) {
                n19 = n9;
                while (n19 < n25) {
                    n18 = 0;
                    while (n18 < n8) {
                        sArray[n18][n20 + nArray[n18]] = sArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n9) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                n18 = 0;
                while (n18 < n8) {
                    sArray[n18][n20 + nArray[n18]] = sArray2[n18][n27 + nArray2[n18]];
                    ++n18;
                }
                if (n23 < this.ifracdx1) {
                    n27 += n13;
                    n23 += this.ifracdx;
                } else {
                    n27 += n14;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n15;
                    n24 += this.ifracdy;
                } else {
                    n27 += n16;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n11) {
                    n18 = 0;
                    while (n18 < n8) {
                        sArray[n18][n20 + nArray[n18]] = sArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n17;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = this.incx * n6;
        int n14 = this.incx1 * n6;
        int n15 = this.incy * n7;
        int n16 = this.incy1 * n7;
        float[] fArray3 = new float[n8];
        int n17 = 0;
        while (n17 < n8) {
            fArray3[n17] = (float)this.backgroundValues[n17];
            ++n17;
        }
        n17 = n10;
        while (n17 < n12) {
            int n18;
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n9, n11, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n9, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n7 + (n21 - n) * n6;
            if (this.setBackground) {
                n19 = n9;
                while (n19 < n25) {
                    n18 = 0;
                    while (n18 < n8) {
                        fArray[n18][n20 + nArray[n18]] = fArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n9) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                n18 = 0;
                while (n18 < n8) {
                    fArray[n18][n20 + nArray[n18]] = fArray2[n18][n27 + nArray2[n18]];
                    ++n18;
                }
                if (n23 < this.ifracdx1) {
                    n27 += n13;
                    n23 += this.ifracdx;
                } else {
                    n27 += n14;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n15;
                    n24 += this.ifracdy;
                } else {
                    n27 += n16;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n11) {
                    n18 = 0;
                    while (n18 < n8) {
                        fArray[n18][n20 + nArray[n18]] = fArray3[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n17;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = this.incx * n6;
        int n14 = this.incx1 * n6;
        int n15 = this.incy * n7;
        int n16 = this.incy1 * n7;
        int n17 = n10;
        while (n17 < n12) {
            int n18;
            int n19;
            int n20 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f5);
            int n22 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n21;
            double d2 = (double)f6 - (double)n22;
            int n23 = (int)Math.floor(d * 1048576.0);
            int n24 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n21, n22, n23, n24, n9, n11, 0, 0, 0, 0);
            int n25 = (Integer)range.getMinValue();
            int n26 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n9, n25, n21, n22, n23, n24);
            n21 = pointArray[0].x;
            n22 = pointArray[0].y;
            n23 = pointArray[1].x;
            n24 = pointArray[1].y;
            int n27 = (n22 - n2) * n7 + (n21 - n) * n6;
            if (this.setBackground) {
                n19 = n9;
                while (n19 < n25) {
                    n18 = 0;
                    while (n18 < n8) {
                        dArray[n18][n20 + nArray[n18]] = this.backgroundValues[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            } else {
                n20 += (n25 - n9) * n4;
            }
            n19 = n25;
            while (n19 < n26) {
                n18 = 0;
                while (n18 < n8) {
                    dArray[n18][n20 + nArray[n18]] = dArray2[n18][n27 + nArray2[n18]];
                    ++n18;
                }
                if (n23 < this.ifracdx1) {
                    n27 += n13;
                    n23 += this.ifracdx;
                } else {
                    n27 += n14;
                    n23 -= this.ifracdx1;
                }
                if (n24 < this.ifracdy1) {
                    n27 += n15;
                    n24 += this.ifracdy;
                } else {
                    n27 += n16;
                    n24 -= this.ifracdy1;
                }
                n20 += n4;
                ++n19;
            }
            if (this.setBackground && n25 <= n26) {
                n19 = n26;
                while (n19 < n11) {
                    n18 = 0;
                    while (n18 < n8) {
                        dArray[n18][n20 + nArray[n18]] = this.backgroundValues[n18];
                        ++n18;
                    }
                    n20 += n4;
                    ++n19;
                }
            }
            n3 += n5;
            ++n17;
        }
    }
}

