/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineNearestOpImage;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.util.Range;

final class AffineNearestBinaryOpImage
extends AffineNearestOpImage {
    private int black = 0;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public AffineNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, AffineNearestBinaryOpImage.configHelper(map), imageLayout, affineTransform, interpolation, dArray);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle);
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n5 = writableRaster.getSampleModelTranslateX();
        int n6 = writableRaster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n9 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n10 = dataBufferByte2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n11 = rectangle.x;
        int n12 = rectangle.y;
        int n13 = rectangle.x + rectangle.width;
        int n14 = rectangle.y + rectangle.height;
        int n15 = this.incy * n4;
        int n16 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n17 = n12;
        while (n17 < n14) {
            ((Point2D)float_).setLocation((double)n11 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n18 = (int)Math.floor(f5);
            int n19 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n18;
            double d2 = (double)f6 - (double)n19;
            int n20 = (int)Math.floor(d * 1048576.0);
            int n21 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n18, n19, n20, n21, n11, n13, 0, 0, 0, 0);
            int n22 = (Integer)range.getMinValue();
            int n23 = (Integer)range.getMaxValue();
            if (n22 <= n23) {
                int n24;
                int n25;
                int n26;
                int n27 = (n17 - n6) * n8 + n10;
                int n28 = n7 + (n11 - n5);
                int n29 = (n19 - n2) * n4 + n9;
                int n30 = n18 - n + n3;
                int n31 = n11;
                while (n31 < n22) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 3);
                        n25 = 7 - (n28 & 7);
                        n24 = byArray2[n26];
                        byArray2[n26] = (byte)(n24 |= this.black << n25);
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n22;
                while (n31 < n23) {
                    n26 = n29 + (n30 >> 3);
                    n25 = byArray[n26];
                    n24 = n25 >> 7 - (n30 & 7) & 1;
                    int n32 = n27 + (n28 >> 3);
                    int n33 = 7 - (n28 & 7);
                    int n34 = byArray2[n32];
                    byArray2[n32] = (byte)(n34 |= n24 << n33);
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n23;
                while (n31 < n13) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 3);
                        n25 = 7 - (n28 & 7);
                        n24 = byArray2[n26];
                        byArray2[n26] = (byte)(n24 |= this.black << n25);
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
            }
            ++n17;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n5 = writableRaster.getSampleModelTranslateX();
        int n6 = writableRaster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferUShort.getData();
        int n9 = dataBufferUShort.getOffset();
        short[] sArray2 = dataBufferUShort2.getData();
        int n10 = dataBufferUShort2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n11 = rectangle.x;
        int n12 = rectangle.y;
        int n13 = rectangle.x + rectangle.width;
        int n14 = rectangle.y + rectangle.height;
        int n15 = this.incy * n4;
        int n16 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n17 = n12;
        while (n17 < n14) {
            ((Point2D)float_).setLocation((double)n11 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n18 = (int)Math.floor(f5);
            int n19 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n18;
            double d2 = (double)f6 - (double)n19;
            int n20 = (int)Math.floor(d * 1048576.0);
            int n21 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n18, n19, n20, n21, n11, n13, 0, 0, 0, 0);
            int n22 = (Integer)range.getMinValue();
            int n23 = (Integer)range.getMaxValue();
            if (n22 <= n23) {
                int n24;
                int n25;
                int n26;
                int n27 = (n17 - n6) * n8 + n10;
                int n28 = n7 + (n11 - n5);
                int n29 = (n19 - n2) * n4 + n9;
                int n30 = n18 - n + n3;
                int n31 = n11;
                while (n31 < n22) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 4);
                        n25 = 15 - (n28 & 0xF);
                        n24 = sArray2[n26];
                        sArray2[n26] = (short)(n24 |= this.black << n25);
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n22;
                while (n31 < n23) {
                    n26 = n29 + (n30 >> 4);
                    n25 = sArray[n26];
                    n24 = n25 >> 15 - (n30 & 0xF) & 1;
                    int n32 = n27 + (n28 >> 4);
                    int n33 = 15 - (n28 & 0xF);
                    int n34 = sArray2[n32];
                    sArray2[n32] = (short)(n34 |= n24 << n33);
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n23;
                while (n31 < n13) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 4);
                        n25 = 15 - (n28 & 0xF);
                        n24 = sArray2[n26];
                        sArray2[n26] = (short)(n24 |= this.black << n25);
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
            }
            ++n17;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n5 = writableRaster.getSampleModelTranslateX();
        int n6 = writableRaster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n9 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n10 = dataBufferInt2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n11 = rectangle.x;
        int n12 = rectangle.y;
        int n13 = rectangle.x + rectangle.width;
        int n14 = rectangle.y + rectangle.height;
        int n15 = this.incy * n4;
        int n16 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n17 = n12;
        while (n17 < n14) {
            ((Point2D)float_).setLocation((double)n11 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n18 = (int)Math.floor(f5);
            int n19 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n18;
            double d2 = (double)f6 - (double)n19;
            int n20 = (int)Math.floor(d * 1048576.0);
            int n21 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n18, n19, n20, n21, n11, n13, 0, 0, 0, 0);
            int n22 = (Integer)range.getMinValue();
            int n23 = (Integer)range.getMaxValue();
            if (n22 <= n23) {
                int n24;
                int n25;
                int n26;
                int n27 = (n17 - n6) * n8 + n10;
                int n28 = n7 + (n11 - n5);
                int n29 = (n19 - n2) * n4 + n9;
                int n30 = n18 - n + n3;
                int n31 = n11;
                while (n31 < n22) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 5);
                        n25 = 31 - (n28 & 0x1F);
                        n24 = nArray2[n26];
                        nArray2[n26] = n24 |= this.black << n25;
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n22;
                while (n31 < n23) {
                    n26 = n29 + (n30 >> 5);
                    n25 = nArray[n26];
                    n24 = n25 >> 31 - (n30 & 0x1F) & 1;
                    int n32 = n27 + (n28 >> 5);
                    int n33 = 31 - (n28 & 0x1F);
                    int n34 = nArray2[n32];
                    nArray2[n32] = n34 |= n24 << n33;
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
                n31 = n23;
                while (n31 < n13) {
                    if (this.setBackground) {
                        n26 = n27 + (n28 >> 5);
                        n25 = 31 - (n28 & 0x1F);
                        n24 = nArray2[n26];
                        nArray2[n26] = n24 |= this.black << n25;
                    }
                    if (n20 < this.ifracdx1) {
                        n20 += this.ifracdx;
                        n30 += this.incx;
                    } else {
                        n20 -= this.ifracdx1;
                        n30 += this.incx1;
                    }
                    if (n21 < this.ifracdy1) {
                        n21 += this.ifracdy;
                        n29 += n15;
                    } else {
                        n21 -= this.ifracdy1;
                        n29 += n16;
                    }
                    ++n28;
                    ++n31;
                }
            }
            ++n17;
        }
    }
}

