/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBilinearOpImage
extends AffineOpImage {
    public AffineBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n8];
        int n13 = 0;
        while (n13 < n8) {
            byArray3[n13] = (byte)this.backgroundValues[n13];
            ++n13;
        }
        n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        byte[] byArray4 = byArray2[n26];
                        int n27 = nArray2[n26];
                        int n28 = byArray4[n21 + n27] & 0xFF;
                        int n29 = byArray4[n22 + n27] & 0xFF;
                        float f9 = (float)n28 + (float)(n29 - n28) * f7;
                        int n30 = byArray4[n23 + n27] & 0xFF;
                        int n31 = byArray4[n24 + n27] & 0xFF;
                        float f10 = (float)n30 + (float)(n31 - n30) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n32 = f11 < 0.5f ? 0 : (f11 > 254.5f ? 255 : (int)(f11 + 0.5f));
                        byArray[n26][n14 + nArray[n26]] = (byte)(n32 & 0xFF);
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        byArray[n26][n14 + nArray[n26]] = byArray3[n26];
                        ++n26;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n8];
        int n13 = 0;
        while (n13 < n8) {
            nArray5[n13] = (int)this.backgroundValues[n13];
            ++n13;
        }
        n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        int[] nArray6 = nArray3[n26];
                        int n27 = nArray4[n26];
                        int n28 = nArray6[n21 + n27];
                        int n29 = nArray6[n22 + n27];
                        float f9 = (float)n28 + (float)(n29 - n28) * f7;
                        int n30 = nArray6[n23 + n27];
                        int n31 = nArray6[n24 + n27];
                        float f10 = (float)n30 + (float)(n31 - n30) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n32 = f11 < -2.1474836E9f ? Integer.MIN_VALUE : (f11 > 2.1474836E9f ? Integer.MAX_VALUE : (f11 > 0.0f ? (int)(f11 + 0.5f) : (int)(f11 - 0.5f)));
                        nArray[n26][n14 + nArray2[n26]] = n32;
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        nArray[n26][n14 + nArray2[n26]] = nArray5[n26];
                        ++n26;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        short[] sArray4 = sArray2[n26];
                        int n27 = nArray2[n26];
                        short s = sArray4[n21 + n27];
                        short s2 = sArray4[n22 + n27];
                        float f9 = (float)s + (float)(s2 - s) * f7;
                        short s3 = sArray4[n23 + n27];
                        short s4 = sArray4[n24 + n27];
                        float f10 = (float)s3 + (float)(s4 - s3) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n28 = f11 < -32768.0f ? Short.MIN_VALUE : (f11 > 32767.0f ? Short.MAX_VALUE : (f11 > 0.0f ? (int)(f11 + 0.5f) : (int)(f11 - 0.5f)));
                        sArray[n26][n14 + nArray[n26]] = (short)n28;
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        sArray[n26][n14 + nArray[n26]] = sArray3[n26];
                        ++n26;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        short[] sArray4 = sArray2[n26];
                        int n27 = nArray2[n26];
                        int n28 = sArray4[n21 + n27] & 0xFFFF;
                        int n29 = sArray4[n22 + n27] & 0xFFFF;
                        float f9 = (float)n28 + (float)(n29 - n28) * f7;
                        int n30 = sArray4[n23 + n27] & 0xFFFF;
                        int n31 = sArray4[n24 + n27] & 0xFFFF;
                        float f10 = (float)n30 + (float)(n31 - n30) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n32 = (double)f11 < 0.0 ? 0 : (f11 > 65535.0f ? 65535 : (int)(f11 + 0.5f));
                        sArray[n26][n14 + nArray[n26]] = (short)(n32 & 0xFFFF);
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        sArray[n26][n14 + nArray[n26]] = sArray3[n26];
                        ++n26;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n8];
        int n13 = 0;
        while (n13 < n8) {
            fArray3[n13] = (float)this.backgroundValues[n13];
            ++n13;
        }
        n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        float f9;
                        float[] fArray4 = fArray2[n26];
                        int n27 = nArray2[n26];
                        float f10 = fArray4[n21 + n27];
                        float f11 = fArray4[n22 + n27];
                        float f12 = fArray4[n23 + n27];
                        float f13 = fArray4[n24 + n27];
                        float f14 = f10 + (f11 - f10) * f7;
                        float f15 = f12 + (f13 - f12) * f7;
                        fArray[n26][n14 + nArray[n26]] = f9 = f14 + (f15 - f14) * f8;
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        fArray[n26][n14 + nArray[n26]] = fArray3[n26];
                        ++n26;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        rasterAccessor2.getWidth();
        rasterAccessor2.getHeight();
        rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            double d = f5 - (float)n15;
            double d2 = f6 - (float)n16;
            int n17 = (n16 - n2) * n7;
            int n18 = (n15 - n) * n6;
            int n19 = n17 + n7;
            int n20 = n18 + n6;
            int n21 = n18 + n17;
            int n22 = n20 + n17;
            int n23 = n18 + n19;
            int n24 = n20 + n19;
            int n25 = n9;
            while (n25 < n11) {
                int n26;
                if ((float)n15 >= f && (float)n15 < f3 - 1.0f && (float)n16 >= f2 && (float)n16 < f4 - 1.0f) {
                    n26 = 0;
                    while (n26 < n8) {
                        double d3;
                        double[] dArray3 = dArray2[n26];
                        int n27 = nArray2[n26];
                        double d4 = dArray3[n21 + n27];
                        double d5 = dArray3[n22 + n27];
                        double d6 = dArray3[n23 + n27];
                        double d7 = dArray3[n24 + n27];
                        double d8 = d4 + (d5 - d4) * d;
                        double d9 = d6 + (d7 - d6) * d;
                        dArray[n26][n14 + nArray[n26]] = d3 = d8 + (d9 - d8) * d2;
                        ++n26;
                    }
                } else if (this.setBackground) {
                    n26 = 0;
                    while (n26 < n8) {
                        dArray[n26][n14 + nArray[n26]] = this.backgroundValues[n26];
                        ++n26;
                    }
                }
                if (d < this.fracdx1) {
                    n15 += this.incx;
                    d += this.fracdx;
                } else {
                    n15 += this.incx1;
                    d -= this.fracdx1;
                }
                if (d2 < this.fracdy1) {
                    n16 += this.incy;
                    d2 += this.fracdy;
                } else {
                    n16 += this.incy1;
                    d2 -= this.fracdy1;
                }
                n17 = (n16 - n2) * n7;
                n18 = (n15 - n) * n6;
                n19 = n17 + n7;
                n20 = n18 + n6;
                n21 = n18 + n17;
                n22 = n20 + n17;
                n23 = n18 + n19;
                n24 = n20 + n19;
                n14 += n4;
                ++n25;
            }
            n3 += n5;
            ++n13;
        }
    }
}

