/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AddCollectionOpImage
extends PointOpImage {
    private byte[][] byteTable = null;

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        this.byteTable = new byte[256][256];
        int n = 0;
        while (n < 256) {
            byte[] byArray = this.byteTable[n];
            int n2 = 0;
            while (n2 < 256) {
                byArray[n2] = ImageUtil.clampBytePositive(n + n2);
                ++n2;
            }
            ++n;
        }
    }

    public AddCollectionOpImage(Collection collection, Map map, ImageLayout imageLayout) {
        super(AddCollectionOpImage.vectorize(collection), imageLayout, map, true);
    }

    private static Vector vectorize(Collection collection) {
        if (collection instanceof Vector) {
            return (Vector)collection;
        }
        Vector vector = new Vector(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector;
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        int n = this.getNumSources();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[n], this.getColorModel());
        RasterAccessor[] rasterAccessorArray = new RasterAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = this.mapDestRect(rectangle, n2);
            rasterAccessorArray[n2] = new RasterAccessor(rasterArray[n2], rectangle2, rasterFormatTagArray[n2], this.getSourceImage(n2).getColorModel());
            ++n2;
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray, rasterAccessor);
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        this.initByteTable();
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray2[n10];
                byte[] byArray3 = byArray[n10];
                byte[] byArray4 = byArray2[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        byArray3[n14] = this.byteTable[byArray3[n14] & 0xFF][byArray4[n15] & 0xFF];
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray2[n10];
                short[] sArray3 = sArray[n10];
                short[] sArray4 = sArray2[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        sArray3[n14] = ImageUtil.clampUShortPositive((sArray3[n14] & 0xFFFF) + (sArray4[n15] & 0xFFFF));
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray2[n10];
                short[] sArray3 = sArray[n10];
                short[] sArray4 = sArray2[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        sArray3[n14] = ImageUtil.clampShort(sArray3[n14] + sArray4[n15]);
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray3 = rasterAccessor2.getBandOffsets();
            int[][] nArray4 = rasterAccessor2.getIntDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray3[n10];
                int[] nArray5 = nArray2[n10];
                int[] nArray6 = nArray4[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        nArray5[n14] = ImageUtil.clampInt((long)nArray5[n14] + (long)nArray6[n15]);
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray2[n10];
                float[] fArray3 = fArray[n10];
                float[] fArray4 = fArray2[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        fArray3[n14] = ImageUtil.clampFloat((double)fArray3[n14] + (double)fArray4[n15]);
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n6 = this.getNumSources();
        int n7 = 0;
        while (n7 < n6) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n7];
            int n8 = rasterAccessor2.getScanlineStride();
            int n9 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n10];
                int n12 = nArray2[n10];
                double[] dArray3 = dArray[n10];
                double[] dArray4 = dArray2[n10];
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = n11;
                    int n15 = n12;
                    n11 += n4;
                    n12 += n8;
                    int n16 = 0;
                    while (n16 < n) {
                        dArray3[n14] = dArray3[n14] + dArray4[n15];
                        n14 += n5;
                        n15 += n9;
                        ++n16;
                    }
                    ++n13;
                }
                ++n10;
            }
            ++n7;
        }
    }
}

