/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.JaiI18N;
import com.sun.media.jai.iterator.RectIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;

public abstract class RectIterCSM
extends RectIterFallback {
    protected int[] bankIndices;
    protected int scanlineStride;
    protected int pixelStride;
    protected int[] bandOffsets;
    protected int[] DBOffsets;
    protected int offset;
    protected int bandOffset;

    public RectIterCSM(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
        this.scanlineStride = componentSampleModel.getScanlineStride();
        this.pixelStride = componentSampleModel.getPixelStride();
        this.bankIndices = componentSampleModel.getBankIndices();
        int[] nArray = componentSampleModel.getBandOffsets();
        this.bandOffsets = new int[this.numBands + 1];
        int n = 0;
        while (n < this.numBands) {
            this.bandOffsets[n] = nArray[n];
            ++n;
        }
        this.bandOffsets[this.numBands] = 0;
        this.DBOffsets = new int[this.numBands];
        this.offset = (this.y - this.sampleModelTranslateY) * this.scanlineStride + (this.x - this.sampleModelTranslateX) * this.pixelStride;
        this.bandOffset = this.bandOffsets[0];
    }

    protected void dataBufferChanged() {
    }

    protected void adjustBandOffsets() {
        int[] nArray = this.dataBuffer.getOffsets();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.bankIndices[n];
            int n3 = n++;
            this.bandOffsets[n3] = this.bandOffsets[n3] + (nArray[n2] - this.DBOffsets[n2]);
        }
        this.DBOffsets = nArray;
    }

    @Override
    protected void setDataBuffer() {
        Raster raster = this.im.getTile(this.tileX, this.tileY);
        this.dataBuffer = raster.getDataBuffer();
        this.dataBufferChanged();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = this.sampleModelTranslateX - n;
        int n4 = this.sampleModelTranslateY - n2;
        this.offset += n4 * this.scanlineStride + n3 * this.pixelStride;
        this.sampleModelTranslateX = n;
        this.sampleModelTranslateY = n2;
    }

    @Override
    public void startLines() {
        this.offset += (this.bounds.y - this.y) * this.scanlineStride;
        this.y = this.bounds.y;
        this.tileY = this.startTileY;
        this.setTileYBounds();
        this.setDataBuffer();
    }

    @Override
    public void nextLine() {
        ++this.y;
        this.offset += this.scanlineStride;
    }

    @Override
    public void jumpLines(int n) {
        int n2 = this.y + n;
        if (n2 < this.bounds.y || n2 > this.lastY) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RectIterFallback1"));
        }
        this.y = n2;
        this.offset += n * this.scanlineStride;
        if (this.y < this.prevYBoundary || this.y > this.nextYBoundary) {
            this.tileY = PlanarImage.YToTileY(this.y, this.tileGridYOffset, this.tileHeight);
            this.setTileYBounds();
            this.setDataBuffer();
        }
    }

    @Override
    public void startPixels() {
        this.offset += (this.bounds.x - this.x) * this.pixelStride;
        this.x = this.bounds.x;
        this.tileX = this.startTileX;
        this.setTileXBounds();
        this.setDataBuffer();
    }

    @Override
    public void nextPixel() {
        ++this.x;
        this.offset += this.pixelStride;
    }

    @Override
    public void jumpPixels(int n) {
        int n2 = this.x + n;
        if (n2 < this.bounds.x || n2 > this.lastX) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RectIterFallback0"));
        }
        this.x = n2;
        this.offset += n * this.pixelStride;
        if (this.x < this.prevXBoundary || this.x > this.nextXBoundary) {
            this.tileX = PlanarImage.XToTileX(this.x, this.tileGridXOffset, this.tileWidth);
            this.setTileXBounds();
            this.setDataBuffer();
        }
    }

    @Override
    public void startBands() {
        this.b = 0;
        this.bandOffset = this.bandOffsets[0];
    }

    @Override
    public void nextBand() {
        ++this.b;
        this.bandOffset = this.bandOffsets[this.b];
    }
}

