/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;

public abstract class RandomIterCSM
extends RandomIterFallback {
    protected ComponentSampleModel sampleModel;
    protected int pixelStride;
    protected int scanlineStride;
    protected int[] bandOffsets;
    protected int numBands;

    public RandomIterCSM(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        this.sampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
        this.numBands = this.sampleModel.getNumBands();
        this.pixelStride = this.sampleModel.getPixelStride();
        this.scanlineStride = this.sampleModel.getScanlineStride();
    }

    protected void dataBufferChanged() {
    }

    protected final void makeCurrent(int n, int n2) {
        int n3 = this.xTiles[n];
        int n4 = this.yTiles[n2];
        if (n3 != this.xID || n4 != this.yID || this.dataBuffer == null) {
            this.xID = n3;
            this.yID = n4;
            Raster raster = this.im.getTile(this.xID, this.yID);
            this.dataBuffer = raster.getDataBuffer();
            this.dataBufferChanged();
            this.bandOffsets = this.dataBuffer.getOffsets();
        }
    }

    @Override
    public float getSampleFloat(int n, int n2, int n3) {
        return this.getSample(n, n2, n3);
    }

    @Override
    public double getSampleDouble(int n, int n2, int n3) {
        return this.getSample(n, n2, n3);
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n3 = 0;
        while (n3 < this.numBands) {
            nArray[n3] = this.getSample(n, n2, n3);
            ++n3;
        }
        return nArray;
    }

    @Override
    public float[] getPixel(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n3 = 0;
        while (n3 < this.numBands) {
            fArray[n3] = this.getSampleFloat(n, n2, n3);
            ++n3;
        }
        return fArray;
    }

    @Override
    public double[] getPixel(int n, int n2, double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        int n3 = 0;
        while (n3 < this.numBands) {
            dArray[n3] = this.getSampleDouble(n, n2, n3);
            ++n3;
        }
        return dArray;
    }
}

