/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import java.text.DecimalFormat;

public class FPXUtils {
    public static final short getShortLE(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)(n3 << 8 | n2);
    }

    public static final int getUnsignedShortLE(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return n3 << 8 | n2;
    }

    public static final int getIntLE(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n5 << 24 | n4 << 16 | n3 << 8 | n2;
    }

    public static final long getUnsignedIntLE(byte[] byArray, int n) {
        long l = byArray[n] & 0xFF;
        long l2 = byArray[n + 1] & 0xFF;
        long l3 = byArray[n + 2] & 0xFF;
        long l4 = byArray[n + 3] & 0xFF;
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public static final String getString(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "<none>";
        }
        n2 = n2 / 2 - 1;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = FPXUtils.getUnsignedShortLE(byArray, n);
            stringBuffer.append((char)n4);
            n += 2;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static void printDecimal(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("00000");
        System.out.print(decimalFormat.format(n));
    }

    private static void printHex(byte by) {
        int n = by & 0xFF;
        int n2 = n / 16;
        int n3 = n % 16;
        if (n2 < 10) {
            System.out.print((char)(48 + n2));
        } else {
            System.out.print((char)(97 + n2 - 10));
        }
        if (n3 < 10) {
            System.out.print((char)(48 + n3));
        } else {
            System.out.print((char)(97 + n3 - 10));
        }
    }

    private static void printChar(byte by) {
        char c = (char)(by & 0xFF);
        if (c >= '!' && c <= '~') {
            System.out.print(' ');
            System.out.print(c);
        } else if (c == '\u0000') {
            System.out.print("^@");
        } else if (c < ' ') {
            System.out.print('^');
            System.out.print((char)(65 + c - 1));
        } else if (c == ' ') {
            System.out.print("__");
        } else {
            System.out.print("??");
        }
    }

    public static void dumpBuffer(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 / 8;
        int n5 = 0;
        while (n5 < n4) {
            FPXUtils.printDecimal(n3);
            System.out.print(": ");
            int n6 = 0;
            while (n6 < 8) {
                FPXUtils.printHex(byArray[n + n6]);
                System.out.print("  ");
                ++n6;
            }
            n6 = 0;
            while (n6 < 8) {
                FPXUtils.printChar(byArray[n + n6]);
                System.out.print("  ");
                ++n6;
            }
            n += 8;
            n3 += 8;
            System.out.println();
            ++n5;
        }
    }
}

