/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoderImpl;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

final class WBMPImageDecoder
extends ImageDecoderImpl {
    public WBMPImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        super(seekableStream, imageDecodeParam);
    }

    @Override
    public RenderedImage decodeAsRenderedImage(int n) throws IOException {
        if (n != 0) {
            throw new IOException(JaiI18N.getString(JaiI18N.getString("WBMPImageDecoder0")));
        }
        this.input.read();
        this.input.read();
        int n2 = this.input.read();
        int n3 = n2 & 0x7F;
        while ((n2 & 0x80) == 128) {
            n3 <<= 7;
            n2 = this.input.read();
            n3 |= n2 & 0x7F;
        }
        n2 = this.input.read();
        int n4 = n2 & 0x7F;
        while ((n2 & 0x80) == 128) {
            n4 <<= 7;
            n2 = this.input.read();
            n4 |= n2 & 0x7F;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 12);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)bufferedImage.getSampleModel();
        this.input.readFully(((DataBufferByte)writableRaster.getDataBuffer()).getData(), 0, n4 * multiPixelPackedSampleModel.getScanlineStride());
        return bufferedImage;
    }
}

