/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.WBMPImageDecoder;
import com.sun.media.jai.codecimpl.WBMPImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class WBMPCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "wbmp";
    }

    @Override
    public Class getEncodeParamClass() {
        return Object.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        return n != 4 && n != 5 && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return new WBMPImageEncoder(outputStream, null);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new WBMPImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new WBMPImageDecoder(seekableStream, null);
    }

    @Override
    public int getNumHeaderBytes() {
        return 3;
    }

    @Override
    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 0 && byArray[1] == 0 && ((byArray[2] & 0x8F) != 0 || (byArray[2] & 0x7F) != 0);
    }
}

