/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SingleTileRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxEncoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import javax.media.jai.RasterFactory;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_GROUP3_1D = 2;
    private static final int COMP_GROUP3_2D = 3;
    private static final int COMP_GROUP4 = 4;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private boolean isLittleEndian = false;
    private static final int[] sizeOfType;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        sizeOfType = nArray;
    }

    private static final char[] intsToChars(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)(nArray[n2] & 0xFFFF);
            ++n2;
        }
        return cArray;
    }

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    @Override
    public void encode(RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        this.isLittleEndian = tIFFEncodeParam.getLittleEndian();
        this.writeFileHeader();
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        Object object2;
        Object object3;
        int n8;
        int[] nArray;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n15;
        if (CodecUtils.isPackedByteImage(renderedImage)) {
            ColorModel colorModel = renderedImage.getColorModel();
            ComponentColorModel componentColorModel = RasterFactory.createComponentColorModel(0, colorModel.getColorSpace(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency());
            Point point = new Point(renderedImage.getMinX(), renderedImage.getMinY());
            WritableRaster writableRaster = Raster.createWritableRaster(((ColorModel)componentColorModel).createCompatibleSampleModel(renderedImage.getWidth(), renderedImage.getHeight()), point);
            writableRaster.setRect(renderedImage.getData());
            renderedImage = new SingleTileRenderedImage(writableRaster, componentColorModel);
        }
        int n16 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n17 = renderedImage.getMinX();
        int n18 = renderedImage.getMinY();
        int n19 = renderedImage.getWidth();
        int n20 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray2 = sampleModel.getSampleSize();
        int n21 = 1;
        while (n21 < nArray2.length) {
            if (nArray2[n21] != nArray2[0]) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder0"));
            }
            ++n21;
        }
        n21 = sampleModel.getNumBands();
        if ((nArray2[0] == 1 || nArray2[0] == 4) && n21 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder1"));
        }
        int n22 = sampleModel.getDataType();
        switch (n22) {
            case 0: {
                if (nArray2[0] == 1 || nArray2[0] == 4 || nArray2[0] == 8) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray2[0] == 16) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray2[0] == 32) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n22 == 2 || n22 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n22 != 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n23 = 0;
        int[] nArray3 = null;
        int n24 = -1;
        int n25 = 0;
        int n26 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n15 = indexColorModel.getMapSize();
            if (nArray2[0] == 1 && n21 == 1) {
                if (n15 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder7"));
                }
                byArray2 = new byte[n15];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n15];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n15];
                indexColorModel.getBlues((byte[])object4);
                n24 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n21 == 1) {
                n24 = 3;
            }
        } else if (colorModel == null) {
            if (nArray2[0] == 1 && n21 == 1) {
                n24 = 1;
            } else {
                n24 = 8;
                if (n21 > 1) {
                    n25 = n21 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n24 = 5;
                    break;
                }
                case 6: {
                    n24 = 2;
                    break;
                }
                case 1: {
                    n24 = 7;
                    break;
                }
                case 5: {
                    if (n16 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n24 = 6;
                        break;
                    }
                    n24 = 4;
                    break;
                }
                case 3: {
                    n24 = 6;
                    break;
                }
                default: {
                    n24 = 8;
                }
            }
            if (n24 == 8) {
                n25 = n21 - 1;
            } else if (n21 > 1) {
                n25 = n21 - colorSpace.getNumComponents();
            }
            if (n25 == 1 && colorModel.hasAlpha()) {
                int n27 = n26 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n24 == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder8"));
        }
        if (n16 == 7) {
            if (n24 == 3) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder11"));
            }
            if (nArray2[0] != 8 || n24 != 2 && n24 != 4 && n24 != 6) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder9"));
            }
        }
        if (n24 != 0 && n24 != 1 && (n16 == 2 || n16 == 3 || n16 == 4)) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder12"));
        }
        n15 = -1;
        switch (n24) {
            case 0: {
                n15 = 0;
                break;
            }
            case 1: {
                n15 = 1;
                break;
            }
            case 2: 
            case 8: {
                n15 = 1;
                break;
            }
            case 3: {
                n15 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n23 = indexColorModel.getMapSize();
                byArray2 = new byte[n23];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n23];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n23];
                indexColorModel.getBlues((byte[])object4);
                n14 = 0;
                n13 = n23;
                n12 = 2 * n23;
                nArray3 = new int[n23 * 3];
                n11 = 0;
                while (n11 < n23) {
                    nArray3[n14++] = byArray2[n11] << 8 & 0xFFFF;
                    nArray3[n13++] = byArray[n11] << 8 & 0xFFFF;
                    nArray3[n12++] = object4[n11] << 8 & 0xFFFF;
                    ++n11;
                }
                n23 *= 3;
                break;
            }
            case 4: {
                n15 = 2;
                break;
            }
            case 5: {
                n15 = 5;
                break;
            }
            case 6: {
                n15 = 6;
                break;
            }
            case 7: {
                n15 = 8;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n10 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n9 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n10 = n19;
            n9 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n16 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n14 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
            n13 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
            n12 = 1;
            while (n12 < n21) {
                int n28;
                n11 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(n12);
                if (n11 > n14) {
                    n14 = n11;
                }
                if ((n28 = ((JPEGEncodeParam)object4).getVerticalSubsampling(n12)) > n13) {
                    n13 = n28;
                }
                ++n12;
            }
            n12 = 8 * n13;
            if ((n9 = (int)((float)n9 / (float)n12 + 0.5f) * n12) < n12) {
                n9 = n12;
            }
            if (bl2 && (n10 = (int)((float)n10 / (float)(n11 = 8 * n14) + 0.5f) * n11) < n11) {
                n10 = n11;
            }
        }
        n14 = bl2 ? (n19 + n10 - 1) / n10 * ((n20 + n9 - 1) / n9) : (int)Math.ceil((double)n20 / (double)n9);
        long[] lArray = new long[n14];
        long l = (long)Math.ceil((double)nArray2[0] / 8.0 * (double)n10 * (double)n21);
        long l2 = l * (long)n9;
        int n29 = 0;
        while (n29 < n14) {
            lArray[n29] = l2;
            ++n29;
        }
        if (!bl2) {
            long l3 = n20 - n9 * (n14 - 1);
            lArray[n14 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n14 - 1) + lArray[n14 - 1];
        long[] lArray2 = new long[n14];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n19}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n20}));
        treeSet.add(new TIFFField(258, 3, n21, TIFFImageEncoder.intsToChars(nArray2)));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n16}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n15}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n14, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n21}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(279, 4, n14, lArray));
        }
        if (nArray3 != null) {
            treeSet.add(new TIFFField(320, 3, n23, TIFFImageEncoder.intsToChars(nArray3)));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(324, 4, n14, lArray2));
            treeSet.add(new TIFFField(325, 4, n14, lArray));
        }
        if (n25 > 0) {
            nArray = new int[n25];
            n8 = 0;
            while (n8 < n25) {
                nArray[n8] = n26;
                ++n8;
            }
            treeSet.add(new TIFFField(338, 3, n25, TIFFImageEncoder.intsToChars(nArray)));
        }
        if (n22 != 0) {
            nArray = new int[n21];
            nArray[0] = n22 == 4 ? 3 : (n22 == 1 ? 1 : 2);
            n8 = 1;
            while (n8 < n21) {
                nArray[n8] = nArray[0];
                ++n8;
            }
            treeSet.add(new TIFFField(339, 3, n21, TIFFImageEncoder.intsToChars(nArray)));
        }
        boolean bl4 = tIFFEncodeParam.getReverseFillOrder();
        n8 = tIFFEncodeParam.getT4Encode2D();
        boolean bl5 = tIFFEncodeParam.getT4PadEOLs();
        TIFFFaxEncoder tIFFFaxEncoder = null;
        if (!(n24 != 1 && n24 != 0 || n16 != 2 && n16 != 3 && n16 != 4)) {
            tIFFFaxEncoder = new TIFFFaxEncoder(bl4);
            treeSet.add(new TIFFField(266, 3, 1, new char[]{bl4 ? (char)'\u0002' : '\u0001'}));
            if (n16 == 3) {
                long l5 = 0L;
                if (n8 != 0) {
                    l5 |= 1L;
                }
                if (bl5) {
                    l5 |= 4L;
                }
                treeSet.add(new TIFFField(292, 4, 1, new long[]{l5}));
            } else if (n16 == 4) {
                treeSet.add(new TIFFField(293, 4, 1, new long[1]));
            }
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        com.sun.image.codec.jpeg.JPEGImageEncoder jPEGImageEncoder = null;
        int n30 = 0;
        if (n16 == 7) {
            n30 = 0;
            switch (n24) {
                case 2: 
                case 3: {
                    n30 = 1;
                    break;
                }
                case 4: {
                    n30 = 2;
                    break;
                }
                case 6: {
                    n30 = 3;
                }
            }
            object3 = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n30);
            JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n21);
            if (((JPEGEncodeParam)object4).getWriteImageOnly()) {
                jPEGEncodeParam.setImageInfoValid(false);
                jPEGEncodeParam.setTableInfoValid(true);
                object2 = new ByteArrayOutputStream();
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                jPEGImageEncoder.encode((Raster)object3);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
                jPEGImageEncoder = null;
            }
        }
        if (n24 == 6) {
            int n31 = 1;
            int n32 = 1;
            if (n16 == 7) {
                n31 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
                n32 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
                int n33 = 1;
                while (n33 < n21) {
                    n7 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(n33);
                    if (n7 > n31) {
                        n31 = n7;
                    }
                    if ((n6 = ((JPEGEncodeParam)object4).getVerticalSubsampling(n33)) > n32) {
                        n32 = n6;
                    }
                    ++n33;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{(char)n31, (char)n32}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{n16 == 7 ? (char)'\u0001' : '\u0002'}));
            if (n16 == 7) {
                long[][] lArrayArray = new long[6][];
                long[] lArray3 = new long[2];
                lArray3[1] = 1L;
                lArrayArray[0] = lArray3;
                lArrayArray[1] = new long[]{255L, 1L};
                lArrayArray[2] = new long[]{128L, 1L};
                lArrayArray[3] = new long[]{255L, 1L};
                lArrayArray[4] = new long[]{128L, 1L};
                lArrayArray[5] = new long[]{255L, 1L};
                object = lArrayArray;
            } else {
                object = new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            }
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((object3 = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            for (TIFFField tIFFField : treeSet) {
                ((ArrayList)object2).add(new Integer(tIFFField.getTag()));
            }
            n7 = ((TIFFField[])object3).length;
            n6 = 0;
            while (n6 < n7) {
                TIFFField tIFFField = object3[n6];
                Integer n34 = new Integer(tIFFField.getTag());
                if (!((ArrayList)object2).contains(n34)) {
                    treeSet.add(tIFFField);
                    ((ArrayList)object2).add(n34);
                }
                ++n6;
            }
        }
        int n35 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n35;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n36 = 0;
        boolean bl6 = false;
        Deflater deflater = null;
        boolean bl7 = false;
        if (n16 == 1) {
            n5 = 0;
            if (nArray2[0] == 16 && lArray2[0] % 2L != 0L) {
                n5 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray2[0] == 32 && lArray2[0] % 4L != 0L) {
                n5 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n5;
            }
            int n37 = 1;
            while (n37 < n14) {
                lArray2[n37] = lArray2[n37 - 1] + lArray[n37 - 1];
                ++n37;
            }
            if (!bl && (n36 = (int)(lArray2[0] + l4)) % 2 != 0) {
                ++n36;
                bl6 = true;
            }
            this.writeDirectory(n, treeSet, n36);
            if (n5 != 0) {
                n37 = 0;
                while (n37 < n5) {
                    this.output.write(0);
                    ++n37;
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    file = null;
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            n5 = 0;
            switch (n16) {
                case 2: {
                    n5 = (int)Math.ceil((double)((n10 + 1) / 2 * 9 + 2) / 8.0);
                    break;
                }
                case 3: 
                case 4: {
                    n5 = (int)Math.ceil((double)((n10 + 1) / 2 * 9 + 2) / 8.0);
                    n5 = n9 * (n5 + 2) + 12;
                    break;
                }
                case 32773: {
                    n5 = (int)(l2 + (l + 127L) / 128L * (long)n9);
                    break;
                }
                case 7: {
                    n5 = 0;
                    if (n24 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl7 = true;
                    break;
                }
                case 32946: {
                    n5 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            if (n5 != 0) {
                byArray3 = new byte[n5];
            }
        }
        int[] nArray4 = null;
        float[] fArray = null;
        boolean bl8 = nArray2[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n22 == 0 || nArray2[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n16 != 7) {
            if (n22 == 0) {
                byArray4 = new byte[n9 * n10 * n21];
            } else if (bl3) {
                byArray4 = new byte[2 * n9 * n10 * n21];
            } else if (n22 == 3 || n22 == 4) {
                byArray4 = new byte[4 * n9 * n10 * n21];
            }
        }
        int n38 = n18 + n20;
        int n39 = n17 + n19;
        int n40 = 0;
        int n41 = n18;
        while (n41 < n38) {
            n4 = bl2 ? n9 : Math.min(n9, n38 - n41);
            n3 = n4 * n10 * n21;
            n2 = n17;
            while (n2 < n39) {
                int n42;
                int n43;
                int n44;
                Raster raster = renderedImage.getData(new Rectangle(n2, n41, n10, n4));
                boolean bl9 = false;
                if (n16 != 7) {
                    if (bl8) {
                        if (nArray2[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray5 = componentSampleModel.getBankIndices();
                            int[] nArray6 = componentSampleModel.getBandOffsets();
                            n44 = componentSampleModel.getPixelStride();
                            n43 = componentSampleModel.getScanlineStride();
                            if (n44 != n21 || (long)n43 != l) {
                                bl9 = false;
                            } else {
                                bl9 = true;
                                n42 = 0;
                                while (bl9 && n42 < n21) {
                                    if (nArray5[n42] != 0 || nArray6[n42] != n42) {
                                        bl9 = false;
                                    }
                                    ++n42;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl9 = true;
                            }
                        }
                    }
                    if (!bl9) {
                        if (n22 == 4) {
                            fArray = raster.getPixels(n2, n41, n10, n4, fArray);
                        } else {
                            nArray4 = raster.getPixels(n2, n41, n10, n4, nArray4);
                        }
                    }
                }
                int n45 = 0;
                int n46 = 0;
                switch (nArray2[0]) {
                    case 1: {
                        int n47;
                        int n48;
                        int n49;
                        if (bl9) {
                            byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n42 = multiPixelPackedSampleModel.getScanlineStride();
                            n49 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n41 - raster.getSampleModelTranslateY());
                            if (n42 == (int)l) {
                                System.arraycopy(byArray5, n49, byArray4, 0, (int)l * n4);
                            } else {
                                n48 = 0;
                                n47 = 0;
                                while (n47 < n4) {
                                    System.arraycopy(byArray5, n49, byArray4, n48, (int)l);
                                    n49 += n42;
                                    n48 += (int)l;
                                    ++n47;
                                }
                            }
                        } else {
                            int n50 = 0;
                            n44 = 0;
                            while (n44 < n4) {
                                n43 = 0;
                                while (n43 < n10 / 8) {
                                    n45 = nArray4[n50++] << 7 | nArray4[n50++] << 6 | nArray4[n50++] << 5 | nArray4[n50++] << 4 | nArray4[n50++] << 3 | nArray4[n50++] << 2 | nArray4[n50++] << 1 | nArray4[n50++];
                                    byArray4[n46++] = (byte)n45;
                                    ++n43;
                                }
                                if (n10 % 8 > 0) {
                                    n45 = 0;
                                    n43 = 0;
                                    while (n43 < n10 % 8) {
                                        n45 |= nArray4[n50++] << 7 - n43;
                                        ++n43;
                                    }
                                    byArray4[n46++] = (byte)n45;
                                }
                                ++n44;
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n10 + 7) / 8));
                            break;
                        }
                        if (n16 == 2) {
                            int n51 = (n10 + 7) / 8;
                            int n52 = 0;
                            n42 = 0;
                            n49 = 0;
                            while (n49 < n4) {
                                n48 = tIFFFaxEncoder.encodeRLE(byArray4, n52, 0, n10, byArray3);
                                this.output.write(byArray3, 0, n48);
                                n52 += n51;
                                n42 += n48;
                                ++n49;
                            }
                            lArray[n40++] = n42;
                            break;
                        }
                        if (n16 == 3) {
                            int n53 = tIFFFaxEncoder.encodeT4(n8 == 0, bl5, byArray4, (n10 + 7) / 8, 0, n10, n4, byArray3);
                            lArray[n40++] = n53;
                            this.output.write(byArray3, 0, n53);
                            break;
                        }
                        if (n16 == 4) {
                            int n54 = tIFFFaxEncoder.encodeT6(byArray4, (n10 + 7) / 8, 0, n10, n4, byArray3);
                            lArray[n40++] = n54;
                            this.output.write(byArray3, 0, n54);
                            break;
                        }
                        if (n16 == 32773) {
                            int n55 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n55;
                            this.output.write(byArray3, 0, n55);
                            break;
                        }
                        if (n16 != 32946) break;
                        int n56 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n56;
                        this.output.write(byArray3, 0, n56);
                        break;
                    }
                    case 4: {
                        int n57 = 0;
                        n44 = 0;
                        while (n44 < n4) {
                            n43 = 0;
                            while (n43 < n10 / 2) {
                                n45 = nArray4[n57++] << 4 | nArray4[n57++];
                                byArray4[n46++] = (byte)n45;
                                ++n43;
                            }
                            if (n10 % 2 == 1) {
                                n45 = nArray4[n57++] << 4;
                                byArray4[n46++] = (byte)n45;
                            }
                            ++n44;
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n10 + 1) / 2));
                            break;
                        }
                        if (n16 == 32773) {
                            n44 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n44;
                            this.output.write(byArray3, 0, n44);
                            break;
                        }
                        if (n16 != 32946) break;
                        n44 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n44;
                        this.output.write(byArray3, 0, n44);
                        break;
                    }
                    case 8: {
                        int n47;
                        int n48;
                        if (n16 != 7) {
                            if (bl9) {
                                byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n42 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n41 - raster.getSampleModelTranslateY());
                                int n58 = componentSampleModel.getScanlineStride();
                                if (n58 == (int)l) {
                                    System.arraycopy(byArray6, n42, byArray4, 0, (int)l * n4);
                                } else {
                                    n48 = 0;
                                    n47 = 0;
                                    while (n47 < n4) {
                                        System.arraycopy(byArray6, n42, byArray4, n48, (int)l);
                                        n42 += n58;
                                        n48 += (int)l;
                                        ++n47;
                                    }
                                }
                            } else {
                                n44 = 0;
                                while (n44 < n3) {
                                    byArray4[n44] = (byte)nArray4[n44];
                                    ++n44;
                                }
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3);
                            break;
                        }
                        if (n16 == 32773) {
                            n44 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n44;
                            this.output.write(byArray3, 0, n44);
                            break;
                        }
                        if (n16 == 7) {
                            long l6 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n30);
                                JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n21);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl7) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l7 = this.getOffset(this.output);
                            lArray[n40++] = (int)(l7 - l6);
                            break;
                        }
                        if (n16 != 32946) break;
                        n44 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n44;
                        this.output.write(byArray3, 0, n44);
                        break;
                    }
                    case 16: {
                        n44 = 0;
                        n43 = 0;
                        while (n43 < n3) {
                            n42 = (short)nArray4[n43];
                            byArray4[n44++] = (byte)((n42 & 0xFF00) >> 8);
                            byArray4[n44++] = (byte)(n42 & 0xFF);
                            ++n43;
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3 * 2);
                            break;
                        }
                        if (n16 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n43;
                            this.output.write(byArray3, 0, n43);
                            break;
                        }
                        if (n16 != 32946) break;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n43;
                        this.output.write(byArray3, 0, n43);
                        break;
                    }
                    case 32: {
                        if (n22 == 3) {
                            n43 = 0;
                            n42 = 0;
                            while (n42 < n3) {
                                int n59 = nArray4[n42];
                                byArray4[n43++] = (byte)((n59 & 0xFF000000) >> 24);
                                byArray4[n43++] = (byte)((n59 & 0xFF0000) >> 16);
                                byArray4[n43++] = (byte)((n59 & 0xFF00) >> 8);
                                byArray4[n43++] = (byte)(n59 & 0xFF);
                                ++n42;
                            }
                        } else {
                            n43 = 0;
                            n42 = 0;
                            while (n42 < n3) {
                                int n60 = Float.floatToIntBits(fArray[n42]);
                                byArray4[n43++] = (byte)((n60 & 0xFF000000) >> 24);
                                byArray4[n43++] = (byte)((n60 & 0xFF0000) >> 16);
                                byArray4[n43++] = (byte)((n60 & 0xFF00) >> 8);
                                byArray4[n43++] = (byte)(n60 & 0xFF);
                                ++n42;
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3 * 4);
                            break;
                        }
                        if (n16 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n43;
                            this.output.write(byArray3, 0, n43);
                            break;
                        }
                        if (n16 != 32946) break;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n43;
                        this.output.write(byArray3, 0, n43);
                    }
                }
                n2 += n10;
            }
            n41 += n9;
        }
        if (n16 == 1) {
            if (bl6) {
                this.output.write(0);
            }
        } else {
            n41 = 0;
            n4 = 1;
            while (n4 < n14) {
                n3 = (int)lArray[n4 - 1];
                n41 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
                ++n4;
            }
            int n61 = n36 = bl ? 0 : n + n35 + (n41 += (int)lArray[n14 - 1]);
            if (n36 % 2 != 0) {
                ++n36;
                bl6 = true;
            }
            if (object == null) {
                if (bl6) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l8 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n36);
                seekableOutputStream.seek(l8);
            } else if (file != null) {
                this.output.close();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output = object;
                this.writeDirectory(n, treeSet, n36);
                byte[] byArray7 = new byte[8192];
                n2 = 0;
                while (n2 < n41) {
                    int n62 = fileInputStream.read(byArray7);
                    if (n62 == -1) break;
                    this.output.write(byArray7, 0, n62);
                    n2 += n62;
                }
                fileInputStream.close();
                file.delete();
                if (bl6) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n36);
                byteArrayOutputStream.writeTo(this.output);
                if (bl6) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n36;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (TIFFField tIFFField : sortedSet) {
            int n3 = TIFFImageEncoder.getValueSize(tIFFField);
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        if (this.isLittleEndian) {
            this.output.write(73);
            this.output.write(73);
        } else {
            this.output.write(77);
            this.output.write(77);
        }
        this.writeUnsignedShort(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (TIFFField tIFFField : sortedSet) {
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? n7 : n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        int n8 = 0;
        while (n8 < arrayList.size()) {
            this.writeValues((TIFFField)arrayList.get(n8));
            ++n8;
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            int n4 = 0;
            while (n4 < n2) {
                byte[] byArray = tIFFField.getAsString(n4).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] != 0) {
                    ++n3;
                }
                ++n4;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4 - n2) {
                    this.output.write(0);
                    ++n3;
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                int n4 = 0;
                while (n4 < n2) {
                    this.writeUnsignedShort(cArray[n4]);
                    ++n4;
                }
                n4 = 0;
                while (n4 < 2 - n2) {
                    this.writeUnsignedShort(0);
                    ++n4;
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeUnsignedShort(sArray[n5]);
                    ++n5;
                }
                n5 = 0;
                while (n5 < 2 - n2) {
                    this.writeUnsignedShort(0);
                    ++n5;
                }
                break;
            }
            case 4: {
                this.writeLong(tIFFField.getAsLong(0));
                break;
            }
            case 9: {
                this.writeLong(tIFFField.getAsInt(0));
                break;
            }
            case 11: {
                this.writeLong(Float.floatToIntBits(tIFFField.getAsFloat(0)));
                break;
            }
            case 2: {
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2) {
                    byte[] byArray = tIFFField.getAsString(n7).getBytes();
                    this.output.write(byArray);
                    n6 += byArray.length;
                    if (byArray[byArray.length - 1] != 0) {
                        this.output.write(0);
                        ++n6;
                    }
                    ++n7;
                }
                n7 = 0;
                while (n7 < 4 - n6) {
                    this.output.write(0);
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                int n4 = 0;
                while (n4 < n2) {
                    this.writeUnsignedShort(cArray[n4]);
                    ++n4;
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeUnsignedShort(sArray[n5]);
                    ++n5;
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                int n6 = 0;
                while (n6 < n2) {
                    this.writeLong(lArray[n6]);
                    ++n6;
                }
                break;
            }
            case 9: {
                int[] nArray = tIFFField.getAsInts();
                int n7 = 0;
                while (n7 < n2) {
                    this.writeLong(nArray[n7]);
                    ++n7;
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = Float.floatToIntBits(fArray[n8]);
                    this.writeLong(n9);
                    ++n8;
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                int n10 = 0;
                while (n10 < n2) {
                    long l = Double.doubleToLongBits(dArray[n10]);
                    this.writeLong((int)(l >> 32));
                    this.writeLong((int)(l & 0xFFFFFFFFFFFFFFFFL));
                    ++n10;
                }
                break;
            }
            case 5: {
                long[][] lArray = tIFFField.getAsRationals();
                int n11 = 0;
                while (n11 < n2) {
                    this.writeLong(lArray[n11][0]);
                    this.writeLong(lArray[n11][1]);
                    ++n11;
                }
                break;
            }
            case 10: {
                int[][] nArray = tIFFField.getAsSRationals();
                int n12 = 0;
                while (n12 < n2) {
                    this.writeLong(nArray[n12][0]);
                    this.writeLong(nArray[n12][1]);
                    ++n12;
                }
                break;
            }
            case 2: {
                int n13 = 0;
                while (n13 < n2) {
                    byte[] byArray = tIFFField.getAsString(n13).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] != 0) {
                        this.output.write(0);
                    }
                    ++n13;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        if (this.isLittleEndian) {
            this.output.write(n & 0xFF);
            this.output.write((n & 0xFF00) >>> 8);
        } else {
            this.output.write((n & 0xFF00) >>> 8);
            this.output.write(n & 0xFF);
        }
    }

    private void writeLong(long l) throws IOException {
        if (this.isLittleEndian) {
            this.output.write((int)l & 0xFF);
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        } else {
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)l & 0xFF);
        }
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
            ++n5;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6 = 1;
            byte by = byArray[n];
            while (n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]) {
                ++n6;
                ++n;
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            n6 = 0;
            int n7 = n3;
            while (n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2])) {
                ++n6;
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }
}

