/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.NoEOFStream;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxDecoder;
import com.sun.media.jai.codecimpl.TIFFLZWDecoder;
import com.sun.media.jai.util.SimpleCMYKColorSpace;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.FloatDoubleColorModel;
import javax.media.jai.RasterFactory;
import javax.media.jai.util.ImagingException;

public class TIFFImage
extends SimpleRenderedImage {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TYPE_CMYK = 9;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    private boolean isTiled;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;

    private static final Raster decodeJPEG(byte[] byArray, JPEGDecodeParam jPEGDecodeParam, boolean bl, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        Raster raster = null;
        try {
            raster = bl ? jPEGImageDecoder.decodeAsBufferedImage().getWritableTile(0, 0) : jPEGImageDecoder.decodeAsRaster();
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), TIFFImage.class, false);
        }
        return raster.createTranslatedChild(n, n2);
    }

    private final void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            String string = JaiI18N.getString("TIFFImage17");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, dataFormatException), this, false);
        }
        this.inflater.reset();
    }

    private static final SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        SampleModel sampleModel = null;
        if (n == 4) {
            try {
                Class<?> clazz = Class.forName("javax.media.jai.RasterFactory");
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class};
                Method method = clazz.getMethod("createPixelInterleavedSampleModel", classArray);
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), nArray};
                sampleModel = (SampleModel)method.invoke(null, objectArray);
            }
            catch (Exception exception) {}
        }
        if (n != 4 || sampleModel == null) {
            sampleModel = RasterFactory.createPixelInterleavedSampleModel(n, n2, n3, n4, n5, nArray);
        }
        return sampleModel;
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                lArray[n] = cArray[n] & 0xFFFF;
                ++n;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    private TIFFField getField(TIFFDirectory tIFFDirectory, int n, String string) {
        TIFFField tIFFField = tIFFDirectory.getField(n);
        if (tIFFField == null) {
            MessageFormat messageFormat = new MessageFormat(JaiI18N.getString("TIFFImage5"));
            messageFormat.setLocale(Locale.getDefault());
            throw new RuntimeException(messageFormat.format(new Object[]{string}));
        }
        return tIFFField;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n) throws IOException {
        int n2;
        Object object;
        Object object2;
        TIFFField tIFFField;
        int n3;
        TIFFField tIFFField2;
        int n4;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n);
        this.properties.put("tiff_directory", tIFFDirectory);
        TIFFField tIFFField3 = tIFFDirectory.getField(277);
        int n5 = tIFFField3 == null ? 1 : (int)tIFFField3.getAsLong(0);
        TIFFField tIFFField4 = tIFFDirectory.getField(284);
        if (tIFFField4 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField4.getAsChars();
        }
        if (cArray[0] != '\u0001' && n5 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage0"));
        }
        TIFFField tIFFField5 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField5 != null) {
            cArray4 = tIFFField5.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            int n6 = 1;
            while (n6 < cArray4.length) {
                if (cArray4[n6] != cArray4[0]) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage1"));
                }
                ++n6;
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField6 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField6 != null) {
            cArray5 = tIFFField6.getAsChars();
            n4 = 1;
            while (n4 < cArray5.length) {
                if (cArray5[n4] != cArray5[0]) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage2"));
                }
                ++n4;
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n4 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n4 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n4 = 1;
                break;
            }
            case 32: {
                this.dataType = cArray5[0] == '\u0003' ? 4 : 3;
                n4 = 1;
            }
        }
        if (n4 == 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage3"));
        }
        TIFFField tIFFField7 = tIFFDirectory.getField(259);
        this.compression = tIFFField7 == null ? 1 : tIFFField7.getAsInt(0);
        TIFFField tIFFField8 = tIFFDirectory.getField(262);
        int n7 = tIFFField8 != null ? (int)tIFFField8.getAsLong(0) : (tIFFDirectory.getField(320) != null ? 3 : (this.sampleSize == 1 ? (this.compression == 2 || this.compression == 3 || this.compression == 4 ? 0 : 1) : (n5 == 3 || n5 == 4 ? 2 : 1)));
        this.imageType = -1;
        switch (n7) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n5 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n5 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n5 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n5 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n5 != 1 || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n5 != 1) break;
                this.imageType = 0;
                break;
            }
            case 5: {
                if (this.sampleSize == 8 && n5 == 4) {
                    this.imageType = 9;
                }
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && n5 == 3) {
                    this.colorConvertJPEG = tIFFDecodeParam.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                tIFFField2 = tIFFDirectory.getField(530);
                if (tIFFField2 != null) {
                    this.chromaSubH = tIFFField2.getAsInt(0);
                    this.chromaSubV = tIFFField2.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || n5 != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage4"));
        }
        this.minY = 0;
        this.minX = 0;
        this.width = (int)this.getField(tIFFDirectory, 256, "Image Width").getAsLong(0);
        this.height = (int)this.getField(tIFFDirectory, 257, "Image Length").getAsLong(0);
        this.numBands = n5;
        tIFFField2 = tIFFDirectory.getField(338);
        int n8 = n3 = tIFFField2 == null ? 0 : (int)tIFFField2.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.isTiled = true;
            this.tileWidth = (int)this.getField(tIFFDirectory, 322, "Tile Width").getAsLong(0);
            this.tileHeight = (int)this.getField(tIFFDirectory, 323, "Tile Length").getAsLong(0);
            this.tileOffsets = this.getField(tIFFDirectory, 324, "Tile Offsets").getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(this.getField(tIFFDirectory, 325, "Tile Byte Counts"));
        } else {
            this.isTiled = false;
            this.tileWidth = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : this.width;
            tIFFField = tIFFDirectory.getField(278);
            if (tIFFField == null) {
                this.tileHeight = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : this.height;
            } else {
                long l = tIFFField.getAsLong(0);
                long l2 = 1L;
                this.tileHeight = l == (l2 = (l2 << 32) - 1L) || l > (long)this.height ? this.height : (int)l;
            }
            object2 = this.getField(tIFFDirectory, 273, "Strip Offsets");
            this.tileOffsets = this.getFieldAsLongs((TIFFField)object2);
            object = tIFFDirectory.getField(279);
            if (object == null) {
                int n9 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.height;
                n2 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.tileHeight;
                int n10 = 0;
                this.tileByteCounts = new long[this.tileOffsets.length];
                int n11 = 0;
                while (n11 < this.tileOffsets.length) {
                    this.tileByteCounts[n11] = Math.min(n9 - n10, n2);
                    n10 += n2;
                    ++n11;
                }
                if (this.compression != 1) {
                    this.stream = new NoEOFStream(seekableStream);
                }
            } else {
                this.tileByteCounts = this.getFieldAsLongs((TIFFField)object);
            }
            int n12 = this.width * this.height * this.numBands * ((this.sampleSize + 7) / 8);
            if (this.tileByteCounts.length == 1 && this.compression == 1 && this.tileByteCounts[0] > (long)n12) {
                this.tileByteCounts[0] = n12;
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    object2 = tIFFDirectory.getField(292);
                    this.tiffT4Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    object2 = tIFFDirectory.getField(293);
                    this.tiffT6Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
                break;
            }
            case 5: {
                object2 = tIFFDirectory.getField(317);
                if (object2 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = ((TIFFField)object2).getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(String.valueOf(this.sampleSize) + JaiI18N.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, n5);
                break;
            }
            case 6: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage15"));
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && n5 == 1 || this.imageType == 4 && n5 == 1 || this.imageType == 5 && n5 == 3))) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage16"));
                }
                if (!tIFFDirectory.isTagPresent(347)) break;
                object = tIFFDirectory.getField(347);
                byte[] byArray = ((TIFFField)object).getAsBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                jPEGImageDecoder.decodeAsRaster();
                this.decodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage10"));
            }
        }
        switch (this.imageType) {
            case 0: 
            case 1: {
                this.sampleModel = new MultiPixelPackedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.sampleSize);
                if (this.imageType == 0) {
                    object2 = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object2, (byte[])object2, (byte[])object2);
                    break;
                }
                this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, !this.isWhiteZero);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                int n13;
                object2 = new int[this.numBands];
                if (this.compression == 7) {
                    n13 = 0;
                    while (n13 < this.numBands) {
                        object2[n13] = this.numBands - 1 - n13;
                        ++n13;
                    }
                } else {
                    n13 = 0;
                    while (n13 < this.numBands) {
                        object2[n13] = n13;
                        ++n13;
                    }
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object2);
                if (this.imageType == 2 || this.imageType == 5) {
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                if (this.imageType == 9) {
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel, SimpleCMYKColorSpace.getInstance());
                    break;
                }
                n13 = 1;
                if (n3 == 1 || n3 == 2) {
                    n13 = 3;
                }
                this.colorModel = this.createAlphaComponentColorModel(this.dataType, this.numBands, n3 == 1, n13);
                break;
            }
            case 7: 
            case 8: {
                object = new int[this.numBands];
                int n14 = 0;
                while (n14 < this.numBands) {
                    object[n14] = n14;
                    ++n14;
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object);
                this.colorModel = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = this.getField(tIFFDirectory, 320, "Colormap");
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.numBands);
                }
                n2 = this.colormap.length / 3;
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                int n15 = n2;
                int n16 = n2 * 2;
                if (this.dataType == 2) {
                    int n17 = 0;
                    while (n17 < n2) {
                        byArray[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n17]);
                        byArray2[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n15 + n17]);
                        byArray3[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n16 + n17]);
                        ++n17;
                    }
                } else {
                    int n18 = 0;
                    while (n18 < n2) {
                        byArray[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n18] & 0xFFFF);
                        byArray2[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n15 + n18] & 0xFFFF);
                        byArray3[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n16 + n18] & 0xFFFF);
                        ++n18;
                    }
                }
                this.colorModel = new IndexColorModel(this.sampleSize, n2, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
    }

    public TIFFDirectory getPrivateIFD(long l) throws IOException {
        return new TIFFDirectory(this.stream, l, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Raster getTile(int n, int n2) {
        if (n < 0 || n >= this.tilesX || n2 < 0 || n2 >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImage12"));
        }
        WritableRaster writableRaster = null;
        SeekableStream seekableStream = this.stream;
        synchronized (seekableStream) {
            byte[] byArray;
            Object object;
            byte[] byArray2 = null;
            short[] sArray = null;
            int[] nArray = null;
            float[] fArray = null;
            DataBuffer dataBuffer = this.sampleModel.createDataBuffer();
            int n3 = this.sampleModel.getDataType();
            if (n3 == 0) {
                byArray2 = ((DataBufferByte)dataBuffer).getData();
            } else if (n3 == 1) {
                sArray = ((DataBufferUShort)dataBuffer).getData();
            } else if (n3 == 2) {
                sArray = ((DataBufferShort)dataBuffer).getData();
            } else if (n3 == 3) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else if (n3 == 4) {
                if (dataBuffer instanceof DataBufferFloat) {
                    fArray = ((DataBufferFloat)dataBuffer).getData();
                } else {
                    try {
                        Method method = dataBuffer.getClass().getMethod("getData", null);
                        fArray = (float[])method.invoke((Object)dataBuffer, null);
                    }
                    catch (Exception exception) {
                        String string = JaiI18N.getString("TIFFImage18");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
                    }
                }
            }
            writableRaster = RasterFactory.createWritableRaster(this.sampleModel, dataBuffer, new Point(this.tileXToX(n), this.tileYToY(n2)));
            long l = 0L;
            try {
                l = this.stream.getFilePointer();
                this.stream.seek(this.tileOffsets[n2 * this.tilesX + n]);
            }
            catch (IOException iOException) {
                object = JaiI18N.getString("TIFFImage13");
                ImagingListenerProxy.errorOccurred((String)object, new ImagingException((String)object, iOException), this, false);
            }
            int n4 = (int)this.tileByteCounts[n2 * this.tilesX + n];
            object = new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
            Object object2 = this.isTiled ? object : ((Rectangle)object).intersection(this.getBounds());
            int n5 = ((Rectangle)object2).width * ((Rectangle)object2).height * this.numBands;
            Object object3 = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n4] : null);
            if (this.imageType == 0) {
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        int n6 = ((Rectangle)object2).width % 8 == 0 ? ((Rectangle)object2).width / 8 * ((Rectangle)object2).height : (((Rectangle)object2).width / 8 + 1) * ((Rectangle)object2).height;
                        this.decodePackbits(byArray, n6, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object2).height);
                    } else if (this.compression == 2) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decoder.decode1D(byArray2, byArray, 0, ((Rectangle)object2).height);
                    } else if (this.compression == 3) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decoder.decode2D(byArray2, byArray, 0, ((Rectangle)object2).height, this.tiffT4Options);
                    } else if (this.compression == 4) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decoder.decodeT6(byArray2, byArray, 0, ((Rectangle)object2).height, this.tiffT6Options);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        this.inflate(byArray, byArray2);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray2, 0, n4);
                    }
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    String string = JaiI18N.getString("TIFFImage13");
                    ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                }
            } else if (this.imageType == 4) {
                if (this.sampleSize == 16) {
                    if (this.decodePaletteAsShorts) {
                        short[] sArray2 = null;
                        int n7 = n5 / 3;
                        int n8 = n7 * 2;
                        try {
                            byte[] byArray3;
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray3 = new byte[n8];
                                this.decodePackbits(byArray, n8, byArray3);
                                sArray2 = new short[n7];
                                this.interpretBytesAsShorts(byArray3, sArray2, n7);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray3 = new byte[n8];
                                this.lzwDecoder.decode(byArray, byArray3, ((Rectangle)object2).height);
                                sArray2 = new short[n7];
                                this.interpretBytesAsShorts(byArray3, sArray2, n7);
                            } else if (this.compression == 32946) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray3 = new byte[n8];
                                this.inflate(byArray, byArray3);
                                sArray2 = new short[n7];
                                this.interpretBytesAsShorts(byArray3, sArray2, n7);
                            } else if (this.compression == 1) {
                                sArray2 = new short[n4 / 2];
                                this.readShorts(n4 / 2, sArray2);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            String string = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                        }
                        if (n3 == 1) {
                            int n9 = 0;
                            int n10 = this.colormap.length / 3;
                            int n11 = n10 * 2;
                            int n12 = 0;
                            while (n12 < n7) {
                                int n13 = sArray2[n12] & 0xFFFF;
                                char c = this.colormap[n13 + n11];
                                sArray[n9++] = (short)(c & 0xFFFF);
                                c = this.colormap[n13 + n10];
                                sArray[n9++] = (short)(c & 0xFFFF);
                                c = this.colormap[n13];
                                sArray[n9++] = (short)(c & 0xFFFF);
                                ++n12;
                            }
                        } else if (n3 == 2) {
                            int n14 = 0;
                            int n15 = this.colormap.length / 3;
                            int n16 = n15 * 2;
                            int n17 = 0;
                            while (n17 < n7) {
                                int n18 = sArray2[n17] & 0xFFFF;
                                char c = this.colormap[n18 + n16];
                                sArray[n14++] = (short)c;
                                c = this.colormap[n18 + n15];
                                sArray[n14++] = (short)c;
                                c = this.colormap[n18];
                                sArray[n14++] = (short)c;
                                ++n17;
                            }
                        }
                    } else {
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray, 0, n4);
                                int n19 = n5 * 2;
                                byte[] byArray4 = new byte[n19];
                                this.decodePackbits(byArray, n19, byArray4);
                                this.interpretBytesAsShorts(byArray4, sArray, n5);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray, 0, n4);
                                byte[] byArray5 = new byte[n5 * 2];
                                this.lzwDecoder.decode(byArray, byArray5, ((Rectangle)object2).height);
                                this.interpretBytesAsShorts(byArray5, sArray, n5);
                            } else if (this.compression == 32946) {
                                this.stream.readFully(byArray, 0, n4);
                                byte[] byArray6 = new byte[n5 * 2];
                                this.inflate(byArray, byArray6);
                                this.interpretBytesAsShorts(byArray6, sArray, n5);
                            } else if (this.compression == 1) {
                                this.readShorts(n4 / 2, sArray);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            String string = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                        }
                    }
                } else if (this.sampleSize == 8) {
                    if (this.decodePaletteAsShorts) {
                        int n20;
                        Object object4;
                        byte[] byArray7 = null;
                        int n21 = n5 / 3;
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray7 = new byte[n21];
                                this.decodePackbits(byArray, n21, byArray7);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray7 = new byte[n21];
                                this.lzwDecoder.decode(byArray, byArray7, ((Rectangle)object2).height);
                            } else if (this.compression == 7) {
                                this.stream.readFully(byArray, 0, n4);
                                Raster raster = TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY());
                                object4 = new int[n21];
                                raster.getPixels(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), (int[])object4);
                                byArray7 = new byte[n21];
                                n20 = 0;
                                while (n20 < n21) {
                                    byArray7[n20] = (byte)object4[n20];
                                    ++n20;
                                }
                            } else if (this.compression == 32946) {
                                this.stream.readFully(byArray, 0, n4);
                                byArray7 = new byte[n21];
                                this.inflate(byArray, byArray7);
                            } else if (this.compression == 1) {
                                byArray7 = new byte[n4];
                                this.stream.readFully(byArray7, 0, n4);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            object4 = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred((String)object4, new ImagingException((String)object4, iOException), this, false);
                        }
                        int n22 = 0;
                        int n23 = this.colormap.length / 3;
                        int n24 = n23 * 2;
                        int n25 = 0;
                        while (n25 < n21) {
                            n20 = byArray7[n25] & 0xFF;
                            char c = this.colormap[n20 + n24];
                            sArray[n22++] = (short)(c & 0xFFFF);
                            c = this.colormap[n20 + n23];
                            sArray[n22++] = (short)(c & 0xFFFF);
                            c = this.colormap[n20];
                            sArray[n22++] = (short)(c & 0xFFFF);
                            ++n25;
                        }
                    } else {
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray, 0, n4);
                                this.decodePackbits(byArray, n5, byArray2);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray, 0, n4);
                                this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object2).height);
                            } else if (this.compression == 7) {
                                this.stream.readFully(byArray, 0, n4);
                                writableRaster.setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY()));
                            } else if (this.compression == 32946) {
                                this.stream.readFully(byArray, 0, n4);
                                this.inflate(byArray, byArray2);
                            } else if (this.compression == 1) {
                                this.stream.readFully(byArray2, 0, n4);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            String string = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                        }
                    }
                } else if (this.sampleSize == 4) {
                    int n26 = ((Rectangle)object2).width % 2 == 0 ? 0 : 1;
                    int n27 = (((Rectangle)object2).width / 2 + n26) * ((Rectangle)object2).height;
                    if (this.decodePaletteAsShorts) {
                        int n28;
                        byte[] byArray8 = null;
                        try {
                            this.stream.readFully(byArray, 0, n4);
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            String string = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                        }
                        if (this.compression == 32773) {
                            byArray8 = new byte[n27];
                            this.decodePackbits(byArray, n27, byArray8);
                        } else if (this.compression == 5) {
                            byArray8 = new byte[n27];
                            this.lzwDecoder.decode(byArray, byArray8, ((Rectangle)object2).height);
                        } else if (this.compression == 32946) {
                            byArray8 = new byte[n27];
                            this.inflate(byArray, byArray8);
                        } else if (this.compression == 1) {
                            byArray8 = byArray;
                        }
                        int n29 = n5 / 3;
                        byArray = new byte[n29];
                        int n30 = 0;
                        int n31 = 0;
                        int n32 = 0;
                        while (n32 < ((Rectangle)object2).height) {
                            n28 = 0;
                            while (n28 < ((Rectangle)object2).width / 2) {
                                byArray[n31++] = (byte)((byArray8[n30] & 0xF0) >> 4);
                                byArray[n31++] = (byte)(byArray8[n30++] & 0xF);
                                ++n28;
                            }
                            if (n26 == 1) {
                                byArray[n31++] = (byte)((byArray8[n30++] & 0xF0) >> 4);
                            }
                            ++n32;
                        }
                        n32 = this.colormap.length / 3;
                        n28 = n32 * 2;
                        int n33 = 0;
                        int n34 = 0;
                        while (n34 < n29) {
                            int n35 = byArray[n34] & 0xFF;
                            char c = this.colormap[n35 + n28];
                            sArray[n33++] = (short)(c & 0xFFFF);
                            c = this.colormap[n35 + n32];
                            sArray[n33++] = (short)(c & 0xFFFF);
                            c = this.colormap[n35];
                            sArray[n33++] = (short)(c & 0xFFFF);
                            ++n34;
                        }
                    } else {
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray, 0, n4);
                                this.decodePackbits(byArray, n27, byArray2);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray, 0, n4);
                                this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object2).height);
                            } else if (this.compression == 32946) {
                                this.stream.readFully(byArray, 0, n4);
                                this.inflate(byArray, byArray2);
                            } else if (this.compression == 1) {
                                this.stream.readFully(byArray2, 0, n4);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            String string = JaiI18N.getString("TIFFImage13");
                            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                        }
                    }
                }
            } else if (this.imageType == 1) {
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        int n36 = ((Rectangle)object2).width % 8 == 0 ? ((Rectangle)object2).width / 2 * ((Rectangle)object2).height : (((Rectangle)object2).width / 2 + 1) * ((Rectangle)object2).height;
                        this.decodePackbits(byArray, n36, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object2).height);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        this.inflate(byArray, byArray2);
                    } else {
                        this.stream.readFully(byArray2, 0, n4);
                    }
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    String string = JaiI18N.getString("TIFFImage13");
                    ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                }
            } else {
                Object object5;
                try {
                    if (this.sampleSize == 8) {
                        if (this.compression == 1) {
                            this.stream.readFully(byArray2, 0, n4);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object2).height);
                        } else if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            this.decodePackbits(byArray, n5, byArray2);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n4);
                            writableRaster.setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY()));
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            this.inflate(byArray, byArray2);
                        }
                    } else if (this.sampleSize == 16) {
                        if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray9 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray, byArray9, ((Rectangle)object2).height);
                            this.interpretBytesAsShorts(byArray9, sArray, n5);
                        } else if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            int n37 = n5 * 2;
                            object5 = new byte[n37];
                            this.decodePackbits(byArray, n37, (byte[])object5);
                            this.interpretBytesAsShorts((byte[])object5, sArray, n5);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray10 = new byte[n5 * 2];
                            this.inflate(byArray, byArray10);
                            this.interpretBytesAsShorts(byArray10, sArray, n5);
                        }
                    } else if (this.sampleSize == 32 && n3 == 3) {
                        if (this.compression == 1) {
                            this.readInts(n4 / 4, nArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray11 = new byte[n5 * 4];
                            this.lzwDecoder.decode(byArray, byArray11, ((Rectangle)object2).height);
                            this.interpretBytesAsInts(byArray11, nArray, n5);
                        } else if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            int n38 = n5 * 4;
                            object5 = new byte[n38];
                            this.decodePackbits(byArray, n38, (byte[])object5);
                            this.interpretBytesAsInts((byte[])object5, nArray, n5);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray12 = new byte[n5 * 4];
                            this.inflate(byArray, byArray12);
                            this.interpretBytesAsInts(byArray12, nArray, n5);
                        }
                    } else if (this.sampleSize == 32 && n3 == 4) {
                        if (this.compression == 1) {
                            this.readFloats(n4 / 4, fArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray13 = new byte[n5 * 4];
                            this.lzwDecoder.decode(byArray, byArray13, ((Rectangle)object2).height);
                            this.interpretBytesAsFloats(byArray13, fArray, n5);
                        } else if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            int n39 = n5 * 4;
                            object5 = new byte[n39];
                            this.decodePackbits(byArray, n39, (byte[])object5);
                            this.interpretBytesAsFloats((byte[])object5, fArray, n5);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byte[] byArray14 = new byte[n5 * 4];
                            this.inflate(byArray, byArray14);
                            this.interpretBytesAsFloats(byArray14, fArray, n5);
                        }
                    }
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    object5 = JaiI18N.getString("TIFFImage13");
                    ImagingListenerProxy.errorOccurred((String)object5, new ImagingException((String)object5, iOException), this, false);
                }
                switch (this.imageType) {
                    case 2: 
                    case 3: {
                        if (!this.isWhiteZero) break;
                        if (n3 == 0 && !(this.colorModel instanceof IndexColorModel)) {
                            int n40 = 0;
                            while (n40 < byArray2.length) {
                                byArray2[n40] = (byte)(255 - byArray2[n40]);
                                n40 += this.numBands;
                            }
                        } else if (n3 == 1) {
                            int n41 = 65535;
                            int n42 = 0;
                            while (n42 < sArray.length) {
                                sArray[n42] = (short)(n41 - sArray[n42]);
                                n42 += this.numBands;
                            }
                        } else if (n3 == 2) {
                            int n43 = 0;
                            while (n43 < sArray.length) {
                                sArray[n43] = ~sArray[n43];
                                n43 += this.numBands;
                            }
                        } else {
                            if (n3 != 3) break;
                            long l2 = -1L;
                            int n44 = 0;
                            while (n44 < nArray.length) {
                                nArray[n44] = (int)(l2 - (long)nArray[n44]);
                                n44 += this.numBands;
                            }
                        }
                        break;
                    }
                    case 7: {
                        int n45 = this.chromaSubH * this.chromaSubV;
                        int n46 = ((Rectangle)object2).width / this.chromaSubH;
                        int n47 = ((Rectangle)object2).height / this.chromaSubV;
                        byte[] byArray15 = new byte[n46 * n47 * (n45 + 2)];
                        System.arraycopy(byArray2, 0, byArray15, 0, byArray15.length);
                        int n48 = n45 * 3;
                        int[] nArray2 = new int[n48];
                        int n49 = 0;
                        int n50 = n45;
                        int n51 = n50 + 1;
                        int n52 = ((Rectangle)object2).y;
                        int n53 = 0;
                        while (n53 < n47) {
                            int n54 = ((Rectangle)object2).x;
                            int n55 = 0;
                            while (n55 < n46) {
                                int n56 = byArray15[n49 + n50];
                                int n57 = byArray15[n49 + n51];
                                int n58 = 0;
                                while (n58 < n48) {
                                    nArray2[n58++] = byArray15[n49++];
                                    nArray2[n58++] = n56;
                                    nArray2[n58++] = n57;
                                }
                                n49 += 2;
                                writableRaster.setPixels(n54, n52, this.chromaSubH, this.chromaSubV, nArray2);
                                n54 += this.chromaSubH;
                                ++n55;
                            }
                            n52 += this.chromaSubV;
                            ++n53;
                        }
                        break;
                    }
                }
            }
        }
        return writableRaster;
    }

    private void readShorts(int n, short[] sArray) {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsShorts(byArray, sArray, n);
    }

    private void readInts(int n, int[] nArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsInts(byArray, nArray, n);
    }

    private void readFloats(int n, float[] fArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsFloats(byArray, fArray, n);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = byArray[n2++] & 0xFF;
                int n5 = byArray[n2++] & 0xFF;
                sArray[n3] = (short)((n4 << 8) + n5);
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                int n7 = byArray[n2++] & 0xFF;
                int n8 = byArray[n2++] & 0xFF;
                sArray[n6] = (short)((n8 << 8) + n7);
                ++n6;
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                ++n4;
            }
        }
    }

    private void interpretBytesAsFloats(byte[] byArray, float[] fArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                fArray[n3] = Float.intBitsToFloat(n4);
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                int n6 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                fArray[n5] = Float.intBitsToFloat(n6);
                ++n5;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decodePackbits(byte[] var1_1, int var2_2, byte[] var3_3) {
        if (var3_3 == null) {
            var3_3 = new byte[var2_2];
        }
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = var1_1.length;
lbl6:
        // 3 sources

        try {
            while (var5_5 < var2_2 && var4_4 < var6_6) {
                block7: {
                    block6: {
                        if ((var8_8 = var1_1[var4_4++]) < 0 || var8_8 > 127) break block6;
                        var9_9 = 0;
                        while (var9_9 < var8_8 + 1) {
                            var3_3[var5_5++] = var1_1[var4_4++];
                            ++var9_9;
                        }
                        ** GOTO lbl6
                    }
                    if (var8_8 > -1 || var8_8 < -127) break block7;
                    var7_7 = var1_1[var4_4++];
                    var9_9 = 0;
                    while (var9_9 < -var8_8 + 1) {
                        var3_3[var5_5++] = var7_7;
                        ++var9_9;
                    }
                    ** GOTO lbl6
                }
                ++var4_4;
            }
        }
        catch (ArrayIndexOutOfBoundsException var9_10) {
            var10_11 = JaiI18N.getString("TIFFImage14");
            ImagingListenerProxy.errorOccurred(var10_11, new ImagingException(var10_11, var9_10), this, false);
        }
        return var3_3;
    }

    private ComponentColorModel createAlphaComponentColorModel(int n, int n2, boolean bl, int n3) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n2) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n == 4) {
            componentColorModel = new FloatDoubleColorModel(colorSpace, true, bl, n3, n);
        } else {
            int n4 = 0;
            switch (n) {
                case 0: {
                    n4 = 8;
                    break;
                }
                case 1: 
                case 2: {
                    n4 = 16;
                    break;
                }
                case 3: {
                    n4 = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            nArray = new int[n2];
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = n4;
                ++n5;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl, n3, n);
        }
        return componentColorModel;
    }
}

