/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.PNMImageDecoder;
import com.sun.media.jai.codecimpl.PNMImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "pnm";
    }

    @Override
    public Class getEncodeParamClass() {
        return PNMEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            return false;
        }
        int n2 = sampleModel.getNumBands();
        return n2 == 1 || n2 == 3;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNMEncodeParam pNMEncodeParam = null;
        if (imageEncodeParam != null) {
            pNMEncodeParam = (PNMEncodeParam)imageEncodeParam;
        }
        return new PNMImageEncoder(outputStream, pNMEncodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new PNMImageDecoder(seekableStream, null);
    }

    @Override
    public int getNumHeaderBytes() {
        return 2;
    }

    @Override
    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }
}

