/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGDecodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JPEGImageDecoder;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "jpeg";
    }

    @Override
    public Class getEncodeParamClass() {
        return JPEGEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return JPEGDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        JPEGEncodeParam jPEGEncodeParam = null;
        if (imageEncodeParam != null) {
            jPEGEncodeParam = (JPEGEncodeParam)imageEncodeParam;
        }
        return new JPEGImageEncoder(outputStream, jPEGEncodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder(inputStream, imageDecodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(file), imageDecodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder((InputStream)seekableStream, imageDecodeParam);
    }

    @Override
    public int getNumHeaderBytes() {
        return 3;
    }

    @Override
    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
    }
}

