/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoderImpl;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.GIFImage;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.media.jai.util.ImagingException;

public class GIFImageDecoder
extends ImageDecoderImpl {
    private byte[] globalColorTable = null;
    private boolean maxPageFound = false;
    private int maxPage;
    private int prevPage = -1;
    private int prevSyncedPage = -1;
    private HashMap images = new HashMap();

    private static byte[] readHeader(SeekableStream seekableStream) throws IOException {
        byte[] byArray = null;
        try {
            seekableStream.skipBytes(10);
            int n = seekableStream.readUnsignedByte();
            boolean bl = (n & 0x80) != 0;
            int n2 = 1 << (n & 7) + 1;
            seekableStream.readUnsignedByte();
            seekableStream.read();
            if (bl) {
                byArray = new byte[3 * n2];
                seekableStream.readFully(byArray);
            } else {
                byArray = null;
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("GIFImageDecoder0");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), GIFImageDecoder.class, false);
        }
        return byArray;
    }

    public GIFImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        super(seekableStream, imageDecodeParam);
    }

    public GIFImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        super(inputStream, imageDecodeParam);
    }

    @Override
    public int getNumPages() throws IOException {
        int n = this.prevPage + 1;
        while (!this.maxPageFound) {
            try {
                this.decodeAsRenderedImage(n++);
            }
            catch (IOException iOException) {}
        }
        return this.maxPage + 1;
    }

    @Override
    public synchronized RenderedImage decodeAsRenderedImage(int n) throws IOException {
        if (n < 0 || this.maxPageFound && n > this.maxPage) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder1"));
        }
        Integer n2 = new Integer(n);
        if (this.images.containsKey(n2)) {
            return (RenderedImage)this.images.get(n2);
        }
        if (this.prevPage == -1) {
            try {
                this.globalColorTable = GIFImageDecoder.readHeader(this.input);
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = -1;
                throw iOException;
            }
        }
        if (n > 0) {
            int n3 = this.prevSyncedPage + 1;
            while (n3 < n) {
                RenderedImage renderedImage = (RenderedImage)this.images.get(new Integer(n3));
                renderedImage.getTile(0, 0);
                this.prevSyncedPage = n3++;
            }
        }
        GIFImage gIFImage = null;
        while (this.prevPage < n) {
            int n4 = this.prevPage + 1;
            GIFImage gIFImage2 = null;
            try {
                gIFImage2 = new GIFImage(this.input, this.globalColorTable);
                this.images.put(new Integer(n4), gIFImage2);
                if (n4 < n) {
                    gIFImage2.getTile(0, 0);
                    this.prevSyncedPage = n4;
                }
                this.prevPage = n4;
                if (n4 != n) continue;
                gIFImage = gIFImage2;
                break;
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = this.prevPage;
                String string = JaiI18N.getString("GIFImage3");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
            }
        }
        return gIFImage;
    }
}

