/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.GIFImageDecoder;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class GIFCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "gif";
    }

    @Override
    public Class getEncodeParamClass() {
        return Object.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return false;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return null;
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new GIFImageDecoder(inputStream, imageDecodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new GIFImageDecoder(new FileInputStream(file), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new GIFImageDecoder(seekableStream, imageDecodeParam);
    }

    @Override
    public int getNumHeaderBytes() {
        return 4;
    }

    @Override
    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56;
    }
}

