/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.lang.reflect.Method;

class CodecUtils {
    static Method ioExceptionInitCause;

    static {
        try {
            Class<?> clazz = Class.forName("java.io.IOException");
            ioExceptionInitCause = clazz.getMethod("initCause", Throwable.class);
        }
        catch (Exception exception) {
            ioExceptionInitCause = null;
        }
    }

    CodecUtils() {
    }

    static final boolean isPackedByteImage(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            int n = 0;
            while (n < sampleModel.getNumBands()) {
                if (sampleModel.getSampleSize(n) > 8) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    static final IOException toIOException(Exception exception) {
        IOException iOException;
        if (exception != null) {
            if (exception instanceof IOException) {
                iOException = (IOException)exception;
            } else if (ioExceptionInitCause != null) {
                iOException = new IOException(exception.getMessage());
                try {
                    ioExceptionInitCause.invoke((Object)iOException, exception);
                }
                catch (Exception exception2) {}
            } else {
                iOException = new IOException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        } else {
            iOException = new IOException();
        }
        return iOException;
    }
}

