/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.output = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.version = bMPEncodeParam.getVersion();
        this.isCompressed = bMPEncodeParam.isCompressed();
        if (this.isCompressed && !(outputStream instanceof SeekableOutputStream)) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder6"));
        }
        this.isTopDown = bMPEncodeParam.isTopDown();
    }

    @Override
    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        int n2;
        int n3 = renderedImage.getMinX();
        int n4 = renderedImage.getMinY();
        this.w = renderedImage.getWidth();
        this.h = renderedImage.getHeight();
        int n5 = 24;
        boolean bl = false;
        int n6 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n7 != 1 && n7 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        int n8 = 1;
        while (n8 < nArray.length) {
            if (nArray[n8] != nArray[0]) {
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
            }
            ++n8;
        }
        n8 = sampleModel.getTransferType();
        if (n8 != 0 && !CodecUtils.isPackedByteImage(renderedImage)) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int n9 = this.w * n7;
        int n10 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n6 = indexColorModel.getMapSize();
            if (n6 <= 2) {
                n5 = 1;
                n9 = (int)Math.ceil((double)this.w / 8.0);
            } else if (n6 <= 16) {
                n5 = 4;
                n9 = (int)Math.ceil((double)this.w / 2.0);
            } else if (n6 <= 256) {
                n5 = 8;
            } else {
                n5 = 24;
                bl = false;
                n6 = 0;
                n9 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n6];
                byArray2 = new byte[n6];
                byArray3 = new byte[n6];
                byArray4 = new byte[n6];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n7 == 1) {
            bl = true;
            n6 = 256;
            n5 = nArray[0];
            n9 = (int)Math.ceil((double)(this.w * n5) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            n2 = 0;
            while (n2 < 256) {
                byArray[n2] = (byte)n2;
                byArray2[n2] = (byte)n2;
                byArray3[n2] = (byte)n2;
                byArray4[n2] = -1;
                ++n2;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n5 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            n9 = this.w * n5 + 7 >> 3;
        }
        n2 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n6;
        int n18 = 0;
        int n19 = n9 % 4;
        if (n19 != 0) {
            n18 = 4 - n19;
        }
        switch (this.version) {
            case 0: {
                n11 = 26 + n6 * 3;
                n12 = 12;
                n13 = (n9 + n18) * this.h;
                n2 = n13 + n11;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                if (this.isCompressed && n5 == 8) {
                    n10 = 1;
                } else if (this.isCompressed && n5 == 4) {
                    n10 = 2;
                }
                n11 = 54 + n6 * 4;
                n13 = (n9 + n18) * this.h;
                n2 = n13 + n11;
                n12 = 40;
                break;
            }
            case 2: {
                n12 = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        if (colorModel instanceof DirectColorModel) {
            n20 = ((DirectColorModel)colorModel).getRedMask();
            n22 = ((DirectColorModel)colorModel).getGreenMask();
            n21 = ((DirectColorModel)colorModel).getBlueMask();
            n9 = this.w;
            n10 = 3;
            n2 += 12;
            n11 += 12;
        }
        this.writeFileHeader(n2, n11);
        this.writeInfoHeader(n12, n5);
        this.writeDWord(n10);
        this.writeDWord(n13);
        this.writeDWord(n14);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        if (n10 == 3) {
            this.writeDWord(n20);
            this.writeDWord(n22);
            this.writeDWord(n21);
        }
        if (n10 == 3) {
            int n23 = 0;
            while (n23 < this.h) {
                Object object;
                int n24 = n4 + n23;
                if (!this.isTopDown) {
                    n24 = n4 + this.h - n23 - 1;
                }
                Rectangle rectangle = new Rectangle(n3, n24, this.w, 1);
                Raster raster = renderedImage.getData(rectangle);
                SampleModel sampleModel2 = raster.getSampleModel();
                int n25 = rectangle.x - raster.getSampleModelTranslateX();
                int n26 = rectangle.y - raster.getSampleModelTranslateY();
                if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
                    object = (SinglePixelPackedSampleModel)sampleModel2;
                    ((SinglePixelPackedSampleModel)object).getOffset(n25, n26);
                }
                switch (n8) {
                    case 2: {
                        object = ((DataBufferShort)raster.getDataBuffer()).getData();
                        int n27 = 0;
                        while (n27 < ((Object)object).length) {
                            this.writeWord((int)object[n27]);
                            ++n27;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = ((DataBufferUShort)raster.getDataBuffer()).getData();
                        int n28 = 0;
                        while (n28 < sArray.length) {
                            this.writeWord(sArray[n28]);
                            ++n28;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray2 = ((DataBufferInt)raster.getDataBuffer()).getData();
                        int n29 = 0;
                        while (n29 < nArray2.length) {
                            this.writeDWord(nArray2[n29]);
                            ++n29;
                        }
                        break;
                    }
                }
                ++n23;
            }
            return;
        }
        if (bl) {
            switch (this.version) {
                case 0: {
                    n = 0;
                    while (n < n6) {
                        this.output.write(byArray3[n]);
                        this.output.write(byArray2[n]);
                        this.output.write(byArray[n]);
                        ++n;
                    }
                    break;
                }
                default: {
                    n = 0;
                    while (n < n6) {
                        this.output.write(byArray3[n]);
                        this.output.write(byArray2[n]);
                        this.output.write(byArray[n]);
                        this.output.write(byArray4[n]);
                        ++n;
                    }
                    break block10;
                }
            }
        }
        n = this.w * n7;
        int[] nArray3 = new int[8 * n];
        byte[] byArray5 = new byte[n9];
        if (!this.isTopDown) {
            int n30 = n4 + this.h;
            int n31 = n30 - 1;
            while (n31 >= n4) {
                int n32 = Math.min(8, n31 - n4 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n3, n31 - n32 + 1, this.w, n32));
                raster.getPixels(n3, n31 - n32 + 1, this.w, n32, nArray3);
                int n33 = 0;
                int n34 = n * n32 - 1;
                int n35 = 0;
                while (n35 < n32) {
                    n33 = n34 - (n35 + 1) * n + 1;
                    this.writePixels(n33, n, n5, nArray3, byArray5, n18, n7, indexColorModel);
                    ++n35;
                }
                n31 -= 8;
            }
        } else {
            int n36 = n4 + this.h;
            int n37 = n4;
            while (n37 < n36) {
                int n38 = Math.min(8, n36 - n37);
                Raster raster = renderedImage.getData(new Rectangle(n3, n37, this.w, n38));
                raster.getPixels(n3, n37, this.w, n38, nArray3);
                int n39 = 0;
                int n40 = 0;
                while (n40 < n38) {
                    this.writePixels(n39, n, n5, nArray3, byArray5, n18, n7, indexColorModel);
                    ++n40;
                }
                n37 += 8;
            }
        }
        if (this.isCompressed && (n5 == 4 || n5 == 8)) {
            this.output.write(0);
            this.output.write(1);
            this.incCompImageSize(2);
            n13 = this.compImageSize;
            n2 = this.compImageSize + n11;
            this.writeSize(n2, 2);
            this.writeSize(n13, 34);
        }
    }

    private void writePixels(int n, int n2, int n3, int[] nArray, byte[] byArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8 = 0;
                while (n8 < n2 / 8) {
                    byArray[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                    ++n8;
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    n8 = 0;
                    while (n8 < n2 % 8) {
                        n6 |= nArray[n++] << 7 - n8;
                        ++n8;
                    }
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                if (this.isCompressed) {
                    byte[] byArray2 = new byte[n2];
                    int n9 = 0;
                    while (n9 < n2) {
                        byArray2[n9] = (byte)nArray[n++];
                        ++n9;
                    }
                    this.encodeRLE4(byArray2, n2);
                    break;
                }
                int n10 = 0;
                while (n10 < n2 / 2) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    byArray[n7++] = (byte)n6;
                    ++n10;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                if (this.isCompressed) {
                    int n11 = 0;
                    while (n11 < n2) {
                        byArray[n11] = (byte)nArray[n++];
                        ++n11;
                    }
                    this.encodeRLE8(byArray, n2);
                    break;
                }
                int n12 = 0;
                while (n12 < n2) {
                    byArray[n12] = (byte)nArray[n++];
                    ++n12;
                }
                this.output.write(byArray, 0, n2);
                break;
            }
            case 24: {
                if (n5 == 3) {
                    int n13 = 0;
                    while (n13 < n2) {
                        byArray[n7++] = (byte)nArray[n + 2];
                        byArray[n7++] = (byte)nArray[n + 1];
                        byArray[n7++] = (byte)nArray[n];
                        n += 3;
                        n13 += 3;
                    }
                    this.output.write(byArray, 0, n2);
                    break;
                }
                int n14 = indexColorModel.getMapSize();
                byte[] byArray3 = new byte[n14];
                byte[] byArray4 = new byte[n14];
                byte[] byArray5 = new byte[n14];
                indexColorModel.getReds(byArray3);
                indexColorModel.getGreens(byArray4);
                indexColorModel.getBlues(byArray5);
                int n15 = 0;
                while (n15 < n2) {
                    int n16 = nArray[n];
                    byArray[n7++] = byArray5[n16];
                    byArray[n7++] = byArray4[n16];
                    byArray[n7++] = byArray5[n16];
                    ++n;
                    ++n15;
                }
                this.output.write(byArray, 0, n2 * 3);
            }
        }
        if (!this.isCompressed || n3 != 8 && n3 != 4) {
            n7 = 0;
            while (n7 < n4) {
                this.output.write(0);
                ++n7;
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n) throws IOException {
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n4];
        byte[] byArray2 = new byte[256];
        while (n4 < n - 1) {
            int n5;
            if ((by2 = byArray[++n4]) == by) {
                if (n3 >= 3) {
                    this.output.write(0);
                    this.output.write(n3);
                    this.incCompImageSize(2);
                    n5 = 0;
                    while (n5 < n3) {
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(1);
                        ++n5;
                    }
                    if (!this.isEven(n3)) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    n5 = 0;
                    while (n5 < n3) {
                        this.output.write(1);
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(2);
                        ++n5;
                    }
                }
                n3 = -1;
                if (++n2 == 256) {
                    this.output.write(n2 - 1);
                    this.output.write(by);
                    this.incCompImageSize(2);
                    n2 = 1;
                }
            } else {
                if (n2 > 1) {
                    this.output.write(n2);
                    this.output.write(by);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                } else if (n3 < 254) {
                    byArray2[++n3] = by2;
                } else {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    n5 = 0;
                    while (n5 <= n3) {
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(1);
                        ++n5;
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by2;
                n2 = 1;
            }
            if (n4 != n - 1) continue;
            if (n3 == -1) {
                this.output.write(n2);
                this.output.write(by);
                this.incCompImageSize(2);
                n2 = 1;
            } else if (n3 >= 2) {
                this.output.write(0);
                this.output.write(n3 + 1);
                this.incCompImageSize(2);
                n5 = 0;
                while (n5 <= n3) {
                    this.output.write(byArray2[n5]);
                    this.incCompImageSize(1);
                    ++n5;
                }
                if (!this.isEven(n3 + 1)) {
                    this.output.write(0);
                    this.incCompImageSize(1);
                }
            } else if (n3 > -1) {
                n5 = 0;
                while (n5 <= n3) {
                    this.output.write(1);
                    this.output.write(byArray2[n5]);
                    this.incCompImageSize(2);
                    ++n5;
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n) throws IOException {
        int n2 = 2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n4];
        by2 = byArray[++n4];
        while (n4 < n - 2) {
            int n7;
            by3 = byArray[++n4];
            by4 = byArray[++n4];
            if (by3 == by) {
                if (n3 >= 4) {
                    this.output.write(0);
                    this.output.write(n3 - 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3 - 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    if (!this.isEven(n3 - 1)) {
                        n6 = byArray2[n3 - 2] << 4;
                        this.output.write(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 - 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    this.output.write(2);
                    n5 = byArray2[0] << 4 | byArray2[1];
                    this.output.write(n5);
                    this.incCompImageSize(2);
                }
                n3 = -1;
                if (by4 == by2) {
                    if ((n2 += 2) == 256) {
                        this.output.write(n2 - 1);
                        n5 = by << 4 | by2;
                        this.output.write(n5);
                        this.incCompImageSize(2);
                        n2 = 2;
                        if (n4 < n - 1) {
                            by = by2;
                            by2 = byArray[++n4];
                        } else {
                            this.output.write(1);
                            n7 = by2 << 4;
                            this.output.write(n7);
                            this.incCompImageSize(2);
                            n2 = -1;
                        }
                    }
                } else {
                    n5 = by << 4 | by2;
                    this.output.write(++n2);
                    this.output.write(n5);
                    this.incCompImageSize(2);
                    n2 = 2;
                    by = by4;
                    if (n4 < n - 1) {
                        by2 = byArray[++n4];
                    } else {
                        this.output.write(1);
                        n7 = by4 << 4;
                        this.output.write(n7);
                        this.incCompImageSize(2);
                        n2 = -1;
                    }
                }
            } else {
                if (n2 > 2) {
                    n5 = by << 4 | by2;
                    this.output.write(n2);
                    this.output.write(n5);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else if (n3 < 253) {
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by3;
                by2 = by4;
                n2 = 2;
            }
            if (n4 < n - 2) continue;
            if (n3 == -1 && n2 >= 2) {
                if (n4 == n - 2) {
                    if (byArray[++n4] == by) {
                        n5 = by << 4 | by2;
                        this.output.write(++n2);
                        this.output.write(n5);
                        this.incCompImageSize(2);
                    } else {
                        n5 = by << 4 | by2;
                        this.output.write(n2);
                        this.output.write(n5);
                        this.output.write(1);
                        n5 = byArray[n4] << 4;
                        this.output.write(n5);
                        byte cfr_ignored_0 = byArray[n4];
                        this.incCompImageSize(4);
                    }
                } else {
                    this.output.write(n2);
                    n5 = by << 4 | by2;
                    this.output.write(n5);
                    this.incCompImageSize(2);
                }
            } else if (n3 > -1) {
                if (n4 == n - 2) {
                    byArray2[++n3] = byArray[++n4];
                }
                if (n3 >= 2) {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    if (!this.isEven(n3 + 1)) {
                        n6 = byArray2[n3] << 4;
                        this.output.write(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 + 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            this.output.write(1);
                            n7 = byArray2[0] << 4;
                            this.output.write(n7);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.output.write(2);
                            n5 = byArray2[0] << 4 | byArray2[1];
                            this.output.write(n5);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n) {
        this.compImageSize += n;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void writeFileHeader(int n, int n2) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(n);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(n2);
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(n2);
    }

    public void writeWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
        this.output.write((n & 0xFF0000) >> 16);
        this.output.write((n & 0xFF000000) >> 24);
    }

    private void writeSize(int n, int n2) throws IOException {
        ((SeekableOutputStream)this.output).seek(n2);
        this.writeDWord(n);
    }
}

