/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.BMPImageDecoder;
import com.sun.media.jai.codecimpl.BMPImageEncoder;
import com.sun.media.jai.codecimpl.CodecUtils;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "bmp";
    }

    @Override
    public Class getEncodeParamClass() {
        return BMPEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n != 0 && !CodecUtils.isPackedByteImage(renderedImage)) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (!(imageEncodeParam instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
            int n2 = bMPEncodeParam.getVersion();
            if (n2 == 0 || n2 == 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        BMPEncodeParam bMPEncodeParam = null;
        if (imageEncodeParam != null) {
            bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
        }
        return new BMPImageEncoder(outputStream, bMPEncodeParam);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(inputStream, null);
    }

    @Override
    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new BMPImageDecoder(new FileInputStream(file), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder((InputStream)seekableStream, null);
    }

    @Override
    public int getNumHeaderBytes() {
        return 2;
    }

    @Override
    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 66 && byArray[1] == 77;
    }
}

