/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TIFFDirectory
implements Serializable {
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable fieldIndex = new Hashtable();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        sizeOfType = nArray;
    }

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n) {
        return n == 18761 || n == 19789;
    }

    public TIFFDirectory(SeekableStream seekableStream, int n) throws IOException {
        long l = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n2 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = n2 == 19789;
        int n3 = this.readUnsignedShort(seekableStream);
        if (n3 != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        long l2 = this.readUnsignedInt(seekableStream);
        int n4 = 0;
        while (n4 < n) {
            if (l2 == 0L) {
                throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory3"));
            }
            seekableStream.seek(l2);
            int n5 = this.readUnsignedShort(seekableStream);
            seekableStream.skip(12 * n5);
            l2 = this.readUnsignedInt(seekableStream);
            ++n4;
        }
        seekableStream.seek(l2);
        this.initialize(seekableStream);
        seekableStream.seek(l);
    }

    public TIFFDirectory(SeekableStream seekableStream, long l, int n) throws IOException {
        long l2 = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n2 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = n2 == 19789;
        seekableStream.seek(l);
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.readUnsignedShort(seekableStream);
            seekableStream.seek(l + (long)(12 * n4));
            l = this.readUnsignedInt(seekableStream);
            seekableStream.seek(l);
            ++n3;
        }
        this.initialize(seekableStream);
        seekableStream.seek(l2);
    }

    private void initialize(SeekableStream seekableStream) throws IOException {
        this.IFDOffset = seekableStream.getFilePointer();
        this.numEntries = this.readUnsignedShort(seekableStream);
        this.fields = new TIFFField[this.numEntries];
        int n = 0;
        while (n < this.numEntries) {
            block30: {
                long l;
                int n2;
                int n3;
                int n4;
                block29: {
                    n4 = this.readUnsignedShort(seekableStream);
                    n3 = this.readUnsignedShort(seekableStream);
                    n2 = (int)this.readUnsignedInt(seekableStream);
                    int n5 = 0;
                    l = seekableStream.getFilePointer() + 4L;
                    try {
                        if (n2 * sizeOfType[n3] <= 4) break block29;
                        n5 = (int)this.readUnsignedInt(seekableStream);
                        seekableStream.seek(n5);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(String.valueOf(n4) + " " + JaiI18N.getString("TIFFDirectory4"));
                        seekableStream.seek(l);
                        break block30;
                    }
                }
                this.fieldIndex.put(new Integer(n4), new Integer(n));
                Object object = null;
                try {
                    switch (n3) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 7: {
                            Object[] objectArray;
                            Object object2;
                            byte[] byArray = new byte[n2];
                            seekableStream.readFully(byArray, 0, n2);
                            if (n3 == 2) {
                                int n6 = 0;
                                int n7 = 0;
                                object2 = new Vector();
                                while (n6 < n2) {
                                    while (n6 < n2 && byArray[n6++] != 0) {
                                    }
                                    ((Vector)object2).add(new String(byArray, n7, n6 - n7));
                                    n7 = n6;
                                }
                                n2 = ((Vector)object2).size();
                                objectArray = new String[n2];
                                int n8 = 0;
                                while (n8 < n2) {
                                    objectArray[n8] = (short)((String)((Vector)object2).elementAt(n8));
                                    ++n8;
                                }
                                object = objectArray;
                                break;
                            }
                            object = byArray;
                            break;
                        }
                        case 3: {
                            char[] cArray = new char[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                cArray[n9] = (char)this.readUnsignedShort(seekableStream);
                                ++n9;
                            }
                            object = cArray;
                            break;
                        }
                        case 4: {
                            long[] lArray = new long[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                lArray[n9] = this.readUnsignedInt(seekableStream);
                                ++n9;
                            }
                            object = lArray;
                            break;
                        }
                        case 5: {
                            Object object2 = new long[n2][2];
                            int n9 = 0;
                            while (n9 < n2) {
                                object2[n9][0] = this.readUnsignedInt(seekableStream);
                                object2[n9][1] = this.readUnsignedInt(seekableStream);
                                ++n9;
                            }
                            object = object2;
                            break;
                        }
                        case 8: {
                            Object[] objectArray = new short[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                objectArray[n9] = this.readShort(seekableStream);
                                ++n9;
                            }
                            object = objectArray;
                            break;
                        }
                        case 9: {
                            int[] nArray = new int[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                nArray[n9] = this.readInt(seekableStream);
                                ++n9;
                            }
                            object = nArray;
                            break;
                        }
                        case 10: {
                            int[][] nArray = new int[n2][2];
                            int n9 = 0;
                            while (n9 < n2) {
                                nArray[n9][0] = this.readInt(seekableStream);
                                nArray[n9][1] = this.readInt(seekableStream);
                                ++n9;
                            }
                            object = nArray;
                            break;
                        }
                        case 11: {
                            float[] fArray = new float[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                fArray[n9] = this.readFloat(seekableStream);
                                ++n9;
                            }
                            object = fArray;
                            break;
                        }
                        case 12: {
                            double[] dArray = new double[n2];
                            int n9 = 0;
                            while (n9 < n2) {
                                dArray[n9] = this.readDouble(seekableStream);
                                ++n9;
                            }
                            object = dArray;
                            break;
                        }
                        default: {
                            System.err.println(JaiI18N.getString("TIFFDirectory0"));
                        }
                    }
                    this.fields[n] = new TIFFField(n4, n3, n2, object);
                }
                catch (EOFException eOFException) {
                    if (n4 <= 532 || n4 == 33432) {
                        throw eOFException;
                    }
                    this.fieldIndex.remove(new Integer(n4));
                }
                seekableStream.seek(l);
            }
            ++n;
        }
        this.nextIFDOffset = this.readUnsignedInt(seekableStream);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int n) {
        Integer n2 = (Integer)this.fieldIndex.get(new Integer(n));
        if (n2 == null) {
            return null;
        }
        return this.fields[n2];
    }

    public boolean isTagPresent(int n) {
        return this.fieldIndex.containsKey(new Integer(n));
    }

    public int[] getTags() {
        int[] nArray = new int[this.fieldIndex.size()];
        Enumeration enumeration = this.fieldIndex.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        byte[] byArray = this.fields[n3].getAsBytes();
        return byArray[n2];
    }

    public byte getFieldAsByte(int n) {
        return this.getFieldAsByte(n, 0);
    }

    public long getFieldAsLong(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsLong(n2);
    }

    public long getFieldAsLong(int n) {
        return this.getFieldAsLong(n, 0);
    }

    public float getFieldAsFloat(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsFloat(n2);
    }

    public float getFieldAsFloat(int n) {
        return this.getFieldAsFloat(n, 0);
    }

    public double getFieldAsDouble(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsDouble(n2);
    }

    public double getFieldAsDouble(int n) {
        return this.getFieldAsDouble(n, 0);
    }

    private short readShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readShort();
        }
        return seekableStream.readShortLE();
    }

    private int readUnsignedShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private int readInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readInt();
        }
        return seekableStream.readIntLE();
    }

    private long readUnsignedInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    private long readLong(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readLong();
        }
        return seekableStream.readLongLE();
    }

    private float readFloat(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readFloat();
        }
        return seekableStream.readFloatLE();
    }

    private double readDouble(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readDouble();
        }
        return seekableStream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream seekableStream) throws IOException {
        long l = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        boolean bl = n == 19789;
        int n2 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
        if (n2 != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        seekableStream.seek(4L);
        long l2 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
        int n3 = 0;
        while (l2 != 0L) {
            ++n3;
            try {
                seekableStream.seek(l2);
                int n4 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
                seekableStream.skip(12 * n4);
                l2 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
            }
            catch (EOFException eOFException) {
                --n3;
                break;
            }
        }
        seekableStream.seek(l);
        return n3;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

