/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;

public class ByteArraySeekableStream
extends SeekableStream {
    private byte[] src;
    private int offset;
    private int length;
    private int pointer;

    public ByteArraySeekableStream(byte[] byArray, int n, int n2) throws IOException {
        this.src = byArray;
        this.offset = n;
        this.length = n2;
    }

    public ByteArraySeekableStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int available() {
        this.ensureOpen();
        return Math.min(this.offset + this.length, this.src.length) - this.pointer;
    }

    @Override
    public boolean canSeekBackwards() {
        return true;
    }

    @Override
    public long getFilePointer() {
        return this.pointer;
    }

    @Override
    public void seek(long l) {
        this.pointer = (int)l;
    }

    @Override
    public int read() {
        if (this.pointer < this.length + this.offset) {
            return this.src[this.pointer++ + this.offset] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.pointer;
        this.pointer = Math.min(this.pointer + n2, this.length + this.offset);
        if (this.pointer == n3) {
            return -1;
        }
        System.arraycopy(this.src, n3, byArray, n, this.pointer - n3);
        return this.pointer - n3;
    }

    @Override
    public int skipBytes(int n) {
        int n2 = this.pointer;
        this.pointer = Math.min(this.pointer + n, this.length + this.offset);
        return this.pointer - n2;
    }

    @Override
    public void close() {
    }

    public long length() {
        return this.length;
    }

    private void ensureOpen() {
    }
}

