/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.stream;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import com.sun.media.imageioimpl.common.PackageUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ChannelImageInputStreamSpi
extends ImageInputStreamSpi {
    public ChannelImageInputStreamSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), ReadableByteChannel.class);
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object object, boolean bl, File file) throws IOException {
        if (object == null || !(object instanceof ReadableByteChannel)) {
            throw new IllegalArgumentException("XXX");
        }
        ImageInputStreamImpl imageInputStreamImpl = null;
        if (object instanceof FileChannel) {
            imageInputStreamImpl = new FileChannelImageInputStream((FileChannel)object);
        } else {
            InputStream inputStream = Channels.newInputStream((ReadableByteChannel)object);
            if (bl) {
                try {
                    imageInputStreamImpl = new FileCacheImageInputStream(inputStream, file);
                }
                catch (IOException iOException) {}
            }
            if (imageInputStreamImpl == null) {
                imageInputStreamImpl = new MemoryCacheImageInputStream(inputStream);
            }
        }
        return imageInputStreamImpl;
    }

    @Override
    public String getDescription(Locale locale) {
        return "NIO Channel ImageInputStream";
    }
}

