/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.wbmp.I18N;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class WBMPMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_wbmp_image_1.0";
    public int wbmpType;
    public int width;
    public int height;

    public WBMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("WBMPMetadata0"));
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(iIOMetadataNode, "WBMPType", new Integer(this.wbmpType));
        this.addChildNode(iIOMetadataNode, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode, "Height", new Integer(this.height));
        return iIOMetadataNode;
    }

    @Override
    public void setFromTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    @Override
    public void mergeTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    @Override
    public void reset() {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode2.setAttribute("name", "GRAY");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

