/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.wbmp.WBMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"wbmp", "WBMP"};
    private static String[] entensions = new String[]{"wbmp"};
    private static String[] mimeType = new String[]{"image/vnd.wap.wbmp"};
    private boolean registered = false;

    public WBMPImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReader", STANDARD_INPUT_TYPE, writerSpiNames, true, null, null, null, null, true, "com_sun_media_imageio_plugins_wbmp_image_1.0", "com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        ImageUtil.processOnRegistration(serviceRegistry, clazz, "WBMP", this, 8, 7);
    }

    @Override
    public String getDescription(Locale locale) {
        String string = String.valueOf(PackageUtil.getSpecificationTitle()) + " WBMP Image Reader";
        return string;
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        byte by = imageInputStream.readByte();
        byte by2 = imageInputStream.readByte();
        int n = ImageUtil.readMultiByteInteger(imageInputStream);
        int n2 = ImageUtil.readMultiByteInteger(imageInputStream);
        long l = imageInputStream.length() - imageInputStream.getStreamPosition();
        imageInputStream.reset();
        if (by != 0 || by2 != 0) {
            return false;
        }
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        long l2 = n / 8 + (n % 8 == 0 ? 0 : 1);
        return l == l2 * (long)n2;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new WBMPImageReader(this);
    }
}

