/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFAttrInfo;
import com.sun.media.imageioimpl.plugins.tiff.TIFFElementInfo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.metadata.IIOMetadataFormat;

public abstract class TIFFMetadataFormat
implements IIOMetadataFormat {
    protected Map elementInfoMap = new HashMap();
    protected Map attrInfoMap = new HashMap();
    protected String resourceBaseName;
    protected String rootName;

    @Override
    public String getRootName() {
        return this.rootName;
    }

    private String getResource(String string, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBaseName, locale);
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private TIFFElementInfo getElementInfo(String string) {
        if (string == null) {
            throw new IllegalArgumentException("elementName == null!");
        }
        TIFFElementInfo tIFFElementInfo = (TIFFElementInfo)this.elementInfoMap.get(string);
        if (tIFFElementInfo == null) {
            throw new IllegalArgumentException("No such element: " + string);
        }
        return tIFFElementInfo;
    }

    private TIFFAttrInfo getAttrInfo(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("elementName == null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        String string3 = String.valueOf(string) + "/" + string2;
        TIFFAttrInfo tIFFAttrInfo = (TIFFAttrInfo)this.attrInfoMap.get(string3);
        if (tIFFAttrInfo == null) {
            throw new IllegalArgumentException("No such attribute: " + string3);
        }
        return tIFFAttrInfo;
    }

    @Override
    public int getElementMinChildren(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.minChildren;
    }

    @Override
    public int getElementMaxChildren(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.maxChildren;
    }

    @Override
    public String getElementDescription(String string, Locale locale) {
        if (!this.elementInfoMap.containsKey(string)) {
            throw new IllegalArgumentException("No such element: " + string);
        }
        return this.getResource(string, locale);
    }

    @Override
    public int getChildPolicy(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.childPolicy;
    }

    @Override
    public String[] getChildNames(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.childNames;
    }

    @Override
    public String[] getAttributeNames(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.attributeNames;
    }

    @Override
    public int getAttributeValueType(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.valueType;
    }

    @Override
    public int getAttributeDataType(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.dataType;
    }

    @Override
    public boolean isAttributeRequired(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.isRequired;
    }

    @Override
    public String getAttributeDefaultValue(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.defaultValue;
    }

    @Override
    public String[] getAttributeEnumerations(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.enumerations;
    }

    @Override
    public String getAttributeMinValue(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.minValue;
    }

    @Override
    public String getAttributeMaxValue(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.maxValue;
    }

    @Override
    public int getAttributeListMinLength(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.listMinLength;
    }

    @Override
    public int getAttributeListMaxLength(String string, String string2) {
        TIFFAttrInfo tIFFAttrInfo = this.getAttrInfo(string, string2);
        return tIFFAttrInfo.listMaxLength;
    }

    @Override
    public String getAttributeDescription(String string, String string2, Locale locale) {
        String string3 = String.valueOf(string) + "/" + string2;
        if (!this.attrInfoMap.containsKey(string3)) {
            throw new IllegalArgumentException("No such attribute: " + string3);
        }
        return this.getResource(string3, locale);
    }

    @Override
    public int getObjectValueType(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        return tIFFElementInfo.objectValueType;
    }

    public Class getObjectClass(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectClass;
    }

    @Override
    public Object getObjectDefaultValue(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectDefaultValue;
    }

    @Override
    public Object[] getObjectEnumerations(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectEnumerations;
    }

    public Comparable getObjectMinValue(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectMinValue;
    }

    public Comparable getObjectMaxValue(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectMaxValue;
    }

    @Override
    public int getObjectArrayMinLength(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectArrayMinLength;
    }

    @Override
    public int getObjectArrayMaxLength(String string) {
        TIFFElementInfo tIFFElementInfo = this.getElementInfo(string);
        if (tIFFElementInfo.objectValueType == 0) {
            throw new IllegalArgumentException("Element cannot contain an object value: " + string);
        }
        return tIFFElementInfo.objectArrayMaxLength;
    }
}

