/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.common.LZWCompressor;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class TIFFLZWCompressor
extends TIFFCompressor {
    int predictor;

    public TIFFLZWCompressor(int n) {
        super("LZW", 5, true);
        this.predictor = n;
    }

    @Override
    public void setStream(ImageOutputStream imageOutputStream) {
        super.setStream(imageOutputStream);
    }

    @Override
    public int encode(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4) throws IOException {
        boolean bl;
        LZWCompressor lZWCompressor = new LZWCompressor(this.stream, 8, true);
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n6 += nArray[n7];
            ++n7;
        }
        n7 = (n6 * n2 + 7) / 8;
        long l = this.stream.getStreamPosition();
        boolean bl2 = bl = this.predictor == 2;
        if (n7 == n4 && !bl) {
            lZWCompressor.compress(byArray, n, n7 * n3);
        } else {
            byte[] byArray2 = bl ? new byte[n7] : null;
            int n8 = 0;
            while (n8 < n3) {
                if (bl) {
                    System.arraycopy(byArray, n, byArray2, 0, n7);
                    int n9 = n7 - 1;
                    while (n9 >= n5) {
                        int n10 = n9;
                        byArray2[n10] = (byte)(byArray2[n10] - byArray2[n9 - n5]);
                        --n9;
                    }
                    lZWCompressor.compress(byArray2, 0, n7);
                } else {
                    lZWCompressor.compress(byArray, n, n7);
                }
                n += n4;
                ++n8;
            }
        }
        lZWCompressor.flush();
        int n11 = (int)(this.stream.getStreamPosition() - l);
        return n11;
    }
}

