/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFParentTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SingleTileRenderedImage;
import com.sun.media.imageioimpl.plugins.tiff.EmptyImage;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFDeflateCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFEXIFJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLSBCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLZWCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFNullCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFPackBitsCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRLECompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT4Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT6Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFZLibCompressor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class TIFFImageWriter
extends ImageWriter {
    private static final boolean DEBUG = false;
    static final String EXIF_JPEG_COMPRESSION_TYPE = "EXIF JPEG";
    public static final int DEFAULT_BYTES_PER_STRIP = 8192;
    public static final String[] TIFFCompressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final String[] compressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "Old JPEG", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final boolean[] isCompressionLossless;
    public static final int[] compressionNumbers;
    ImageOutputStream stream;
    long headerPosition;
    RenderedImage image;
    ImageTypeSpecifier imageType;
    ByteOrder byteOrder;
    ImageWriteParam param;
    TIFFCompressor compressor;
    TIFFColorConverter colorConverter;
    TIFFStreamMetadata streamMetadata;
    TIFFImageMetadata imageMetadata;
    int sourceXOffset;
    int sourceYOffset;
    int sourceWidth;
    int sourceHeight;
    int[] sourceBands;
    int periodX;
    int periodY;
    int bitDepth;
    int numBands;
    int tileWidth;
    int tileLength;
    int tilesAcross;
    int tilesDown;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    boolean isRescaling = false;
    boolean isBilevel;
    boolean isImageSimple;
    boolean isInverted;
    boolean isTiled;
    int nativePhotometricInterpretation;
    int photometricInterpretation;
    char[] bitsPerSample;
    int sampleFormat = 4;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;
    int compression;
    int predictor;
    int totalPixels;
    int pixelsDone;
    long nextIFDPointerPos;
    long nextSpace = 0L;
    boolean isWritingSequence = false;
    private boolean isInsertingEmpty = false;
    private boolean isWritingEmpty = false;
    private Object replacePixelsLock = new Object();
    private int replacePixelsIndex = -1;
    private TIFFImageMetadata replacePixelsMetadata = null;
    private long[] replacePixelsTileOffsets = null;
    private long[] replacePixelsByteCounts = null;
    private long replacePixelsOffsetsPosition = 0L;
    private long replacePixelsByteCountsPosition = 0L;
    private Rectangle replacePixelsRegion = null;
    private boolean inReplacePixelsNest = false;
    private TIFFImageReader reader = null;

    static {
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        isCompressionLossless = blArray;
        compressionNumbers = new int[]{2, 3, 4, 5, 6, 7, 8, 32773, 32946, 6};
    }

    public static int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public static int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam(this.getLocale());
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)object;
            try {
                this.headerPosition = this.stream.getStreamPosition();
                try {
                    byte[] byArray = new byte[4];
                    this.stream.readFully(byArray);
                    this.nextSpace = byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0 || byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42 ? this.stream.length() : this.headerPosition;
                }
                catch (IOException iOException) {
                    this.nextSpace = this.headerPosition;
                }
                this.stream.seek(this.headerPosition);
            }
            catch (IOException iOException) {
                this.headerPosition = 0L;
                this.nextSpace = 0L;
            }
        } else {
            this.stream = null;
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return new TIFFStreamMetadata();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        TIFFImageMetadata tIFFImageMetadata;
        ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
        arrayList.add(BaselineTIFFTagSet.getInstance());
        TIFFImageMetadata tIFFImageMetadata2 = new TIFFImageMetadata(arrayList);
        if (imageTypeSpecifier != null && (tIFFImageMetadata = (TIFFImageMetadata)this.convertImageMetadata(tIFFImageMetadata2, imageTypeSpecifier, imageWriteParam)) != null) {
            tIFFImageMetadata2 = tIFFImageMetadata;
        }
        return tIFFImageMetadata2;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        TIFFStreamMetadata tIFFStreamMetadata = null;
        if (iIOMetadata instanceof TIFFStreamMetadata) {
            tIFFStreamMetadata = new TIFFStreamMetadata();
            tIFFStreamMetadata.byteOrder = ((TIFFStreamMetadata)iIOMetadata).byteOrder;
            return tIFFStreamMetadata;
        }
        if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_stream_1.0")) {
            tIFFStreamMetadata = new TIFFStreamMetadata();
            String string = "com_sun_media_imageio_plugins_tiff_stream_1.0";
            try {
                tIFFStreamMetadata.mergeTree(string, iIOMetadata.getAsTree(string));
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {}
        }
        return tIFFStreamMetadata;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Object object;
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        if (iIOMetadata instanceof TIFFImageMetadata) {
            object = ((TIFFImageMetadata)iIOMetadata).getRootIFD();
            tIFFImageMetadata = new TIFFImageMetadata(((TIFFIFD)object).getShallowClone());
        } else if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
            try {
                tIFFImageMetadata = this.convertNativeImageMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {}
        } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
            try {
                tIFFImageMetadata = this.convertStandardImageMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {}
        }
        if (tIFFImageMetadata != null) {
            object = new TIFFImageWriter(this.originatingProvider);
            ((TIFFImageWriter)object).imageMetadata = tIFFImageMetadata;
            ((TIFFImageWriter)object).param = imageWriteParam;
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
            try {
                ((TIFFImageWriter)object).setupMetadata(imageTypeSpecifier.getColorModel(), sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
                return ((TIFFImageWriter)object).imageMetadata;
            }
            catch (IIOException iIOException) {
                return null;
            }
        }
        return tIFFImageMetadata;
    }

    private TIFFImageMetadata convertStandardImageMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (!iIOMetadata.isStandardMetadataFormatSupported()) {
            throw new IllegalArgumentException("inData does not support standard metadata format!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        String string = "javax_imageio_1.0";
        Node node = iIOMetadata.getAsTree(string);
        if (node != null) {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            tIFFImageMetadata.setFromTree(string, node);
        }
        return tIFFImageMetadata;
    }

    private TIFFImageMetadata convertNativeImageMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (!Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
            throw new IllegalArgumentException("inData does not support native metadata format!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        String string = "com_sun_media_imageio_plugins_tiff_image_1.0";
        Node node = iIOMetadata.getAsTree(string);
        if (node != null) {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            tIFFImageMetadata.setFromTree(string, node);
        }
        return tIFFImageMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setupMetadata(ColorModel colorModel, SampleModel sampleModel, int n, int n2) throws IIOException {
        Object object;
        TIFFField tIFFField;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object2;
        TIFFField tIFFField2;
        boolean bl;
        TIFFField tIFFField3;
        int n8;
        int n9;
        Object object3;
        Object object4;
        TIFFIFD tIFFIFD = this.imageMetadata.getRootIFD();
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFField tIFFField4 = tIFFIFD.getTIFFField(284);
        if (tIFFField4 != null && tIFFField4.getAsInt(0) != 1) {
            object4 = new TIFFField(baselineTIFFTagSet.getTag(284), 1);
            tIFFIFD.addTIFFField((TIFFField)object4);
        }
        object4 = null;
        this.photometricInterpretation = -1;
        boolean bl2 = false;
        tIFFField4 = tIFFIFD.getTIFFField(262);
        if (tIFFField4 != null) {
            this.photometricInterpretation = tIFFField4.getAsInt(0);
            if (this.photometricInterpretation == 3 && !(colorModel instanceof IndexColorModel)) {
                this.photometricInterpretation = -1;
            } else {
                bl2 = true;
            }
        }
        int[] nArray = sampleModel.getSampleSize();
        int n10 = sampleModel.getNumBands();
        int n11 = 0;
        if (n10 > 1 && colorModel != null && colorModel.hasAlpha()) {
            --n10;
            n11 = 1;
            object4 = new char[1];
            object4[0] = colorModel.isAlphaPremultiplied() ? (Object)true : (Object)2;
        }
        if (n10 == 3) {
            this.nativePhotometricInterpretation = 2;
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = 2;
            }
        } else if (sampleModel.getNumBands() == 1 && colorModel instanceof IndexColorModel) {
            object3 = (IndexColorModel)colorModel;
            int n12 = ((IndexColorModel)object3).getRed(0);
            n9 = ((IndexColorModel)object3).getRed(1);
            if (!(((IndexColorModel)object3).getMapSize() != 2 || n12 != ((IndexColorModel)object3).getGreen(0) || n12 != ((IndexColorModel)object3).getBlue(0) || n9 != ((IndexColorModel)object3).getGreen(1) || n9 != ((IndexColorModel)object3).getBlue(1) || n12 != 0 && n12 != 255 || n9 != 0 && n9 != 255 || n12 == n9)) {
                this.nativePhotometricInterpretation = n12 == 0 ? 1 : 0;
                if (this.photometricInterpretation != 1 && this.photometricInterpretation != 0) {
                    this.photometricInterpretation = n12 == 0 ? 1 : 0;
                }
            } else {
                this.photometricInterpretation = 3;
                this.nativePhotometricInterpretation = 3;
            }
        } else {
            if (colorModel != null) {
                switch (colorModel.getColorSpace().getType()) {
                    case 1: {
                        this.nativePhotometricInterpretation = 8;
                        break;
                    }
                    case 3: {
                        this.nativePhotometricInterpretation = 6;
                        break;
                    }
                    case 9: {
                        this.nativePhotometricInterpretation = 5;
                        break;
                    }
                    default: {
                        this.nativePhotometricInterpretation = 1;
                        break;
                    }
                }
            } else {
                this.nativePhotometricInterpretation = 1;
            }
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = this.nativePhotometricInterpretation;
            }
        }
        this.compressor = null;
        this.colorConverter = null;
        if (this.param instanceof TIFFImageWriteParam) {
            object3 = (TIFFImageWriteParam)this.param;
            if (((ImageWriteParam)object3).getCompressionMode() == 2) {
                this.compressor = ((TIFFImageWriteParam)object3).getTIFFCompressor();
                String string = this.param.getCompressionType();
                if (this.compressor != null && !this.compressor.getCompressionType().equals(string)) {
                    this.compressor = null;
                }
            } else {
                this.compressor = null;
            }
            this.colorConverter = ((TIFFImageWriteParam)object3).getColorConverter();
            if (this.colorConverter != null) {
                this.photometricInterpretation = ((TIFFImageWriteParam)object3).getPhotometricInterpretation();
            }
        }
        int n13 = this.param instanceof TIFFImageWriteParam ? this.param.getCompressionMode() : 1;
        switch (n13) {
            case 2: {
                String string = this.param.getCompressionType();
                if (string == null) {
                    this.compression = 1;
                } else {
                    n9 = compressionTypes.length;
                    n8 = 0;
                    while (n8 < n9) {
                        if (string.equals(compressionTypes[n8])) {
                            this.compression = compressionNumbers[n8];
                        }
                        ++n8;
                    }
                }
                if (this.compressor == null || this.compressor.getCompressionTagValue() == this.compression) break;
                this.compressor = null;
                break;
            }
            case 3: {
                TIFFField tIFFField5 = tIFFIFD.getTIFFField(259);
                if (tIFFField5 != null) {
                    this.compression = tIFFField5.getAsInt(0);
                    break;
                }
            }
            default: {
                this.compression = 1;
            }
        }
        if ((tIFFField3 = tIFFIFD.getTIFFField(317)) != null) {
            this.predictor = tIFFField3.getAsInt(0);
            if (nArray[0] != 8 || this.predictor != 1 && this.predictor != 2) {
                this.predictor = 1;
                TIFFField tIFFField6 = new TIFFField(baselineTIFFTagSet.getTag(317), this.predictor);
                tIFFIFD.addTIFFField(tIFFField6);
            }
        }
        TIFFField tIFFField7 = new TIFFField(baselineTIFFTagSet.getTag(259), this.compression);
        tIFFIFD.addTIFFField(tIFFField7);
        n8 = 0;
        if (n10 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
            if (tIFFIFD.getTIFFField(34665) != null) {
                if (this.compression == 1 && (this.photometricInterpretation == 2 || this.photometricInterpretation == 6)) {
                    n8 = 1;
                } else if (this.compression == 6) {
                    n8 = 1;
                }
            } else if (n13 == 2 && EXIF_JPEG_COMPRESSION_TYPE.equals(this.param.getCompressionType())) {
                n8 = 1;
            }
        }
        boolean bl3 = bl = n8 != 0 && this.compression == 6;
        if (this.compressor == null) {
            if (this.compression == 2) {
                if (this.compressor == null) {
                    this.compressor = new TIFFRLECompressor();
                }
                if (!bl2) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 3) {
                if (this.compressor == null) {
                    this.compressor = new TIFFT4Compressor();
                }
                if (!bl2) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 4) {
                if (this.compressor == null) {
                    this.compressor = new TIFFT6Compressor();
                }
                if (!bl2) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 5) {
                this.compressor = new TIFFLZWCompressor(this.predictor);
            } else if (this.compression == 6) {
                if (n8 == 0) throw new IIOException("Old JPEG compression not supported!");
                this.compressor = new TIFFEXIFJPEGCompressor(this.param);
            } else if (this.compression == 7) {
                if (n10 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
                    this.photometricInterpretation = 6;
                } else {
                    if (n10 != 1 || nArray[0] != 8) throw new IIOException("JPEG compression supported for 1- and 3-band byte images only!");
                    this.photometricInterpretation = 1;
                }
                this.compressor = new TIFFJPEGCompressor(this.param);
            } else if (this.compression == 8) {
                this.compressor = new TIFFZLibCompressor(this.param, this.predictor);
            } else if (this.compression == 32773) {
                this.compressor = new TIFFPackBitsCompressor();
            } else if (this.compression == 32946) {
                this.compressor = new TIFFDeflateCompressor(this.param, this.predictor);
            } else {
                tIFFField4 = tIFFIFD.getTIFFField(266);
                boolean bl4 = tIFFField4 != null && tIFFField4.getAsInt(0) == 2;
                this.compressor = bl4 ? new TIFFLSBCompressor() : new TIFFNullCompressor();
            }
        }
        if (this.colorConverter == null && colorModel != null && colorModel.getColorSpace().getType() == 5) {
            if (this.photometricInterpretation == 6 && this.compression != 7) {
                this.colorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            } else if (this.photometricInterpretation == 8) {
                this.colorConverter = new TIFFCIELabColorConverter();
            }
        }
        if (this.photometricInterpretation == 6 && this.compression != 7) {
            tIFFIFD.removeTIFFField(530);
            tIFFIFD.removeTIFFField(531);
            tIFFIFD.addTIFFField(new TIFFField(baselineTIFFTagSet.getTag(530), 3, 2, new char[]{'\u0001', '\u0001'}));
            tIFFIFD.addTIFFField(new TIFFField(baselineTIFFTagSet.getTag(531), 3, 1, new char[]{'\u0002'}));
        }
        TIFFField tIFFField8 = new TIFFField(baselineTIFFTagSet.getTag(262), this.photometricInterpretation);
        tIFFIFD.addTIFFField(tIFFField8);
        this.bitsPerSample = new char[n10 + n11];
        this.bitDepth = 0;
        int n14 = 0;
        while (n14 < n10) {
            this.bitDepth = Math.max(this.bitDepth, nArray[n14]);
            ++n14;
        }
        if (this.bitDepth == 3) {
            this.bitDepth = 4;
        } else if (this.bitDepth > 4 && this.bitDepth < 8) {
            this.bitDepth = 8;
        } else if (this.bitDepth > 8 && this.bitDepth < 16) {
            this.bitDepth = 16;
        } else if (this.bitDepth > 16) {
            this.bitDepth = 32;
        }
        n14 = 0;
        while (n14 < this.bitsPerSample.length) {
            this.bitsPerSample[n14] = (char)this.bitDepth;
            ++n14;
        }
        if (this.bitsPerSample.length != 1 || this.bitsPerSample[0] != '\u0001') {
            tIFFField2 = new TIFFField(baselineTIFFTagSet.getTag(258), 3, this.bitsPerSample.length, this.bitsPerSample);
            tIFFIFD.addTIFFField(tIFFField2);
        } else {
            int[] nArray2;
            tIFFField2 = tIFFIFD.getTIFFField(258);
            if (tIFFField2 != null && ((nArray2 = tIFFField2.getAsInts()) == null || nArray2.length != 1 || nArray2[0] != 1)) {
                tIFFIFD.removeTIFFField(258);
            }
        }
        tIFFField4 = tIFFIFD.getTIFFField(339);
        if (tIFFField4 == null && (this.bitDepth == 16 || this.bitDepth == 32)) {
            int n15 = sampleModel.getDataType();
            char c = this.bitDepth == 16 && n15 == 1 ? (char)'\u0001' : (this.bitDepth == 32 && n15 == 4 ? (char)'\u0003' : '\u0002');
            this.sampleFormat = c;
            object2 = new char[this.bitsPerSample.length];
            Arrays.fill((char[])object2, c);
            TIFFTag tIFFTag = baselineTIFFTagSet.getTag(339);
            TIFFField tIFFField9 = new TIFFField(tIFFTag, 3, ((char[])object2).length, object2);
            tIFFIFD.addTIFFField(tIFFField9);
        } else {
            this.sampleFormat = tIFFField4 != null ? tIFFField4.getAsInt(0) : 4;
        }
        if (object4 != null) {
            TIFFField tIFFField10 = new TIFFField(baselineTIFFTagSet.getTag(338), 3, ((Object)object4).length, object4);
            tIFFIFD.addTIFFField(tIFFField10);
        } else {
            tIFFIFD.removeTIFFField(338);
        }
        TIFFField tIFFField11 = new TIFFField(baselineTIFFTagSet.getTag(277), this.bitsPerSample.length);
        tIFFIFD.addTIFFField(tIFFField11);
        if (this.photometricInterpretation == 3 && colorModel instanceof IndexColorModel) {
            char[] cArray = new char[3 * ('\u0001' << this.bitsPerSample[0])];
            object2 = (IndexColorModel)colorModel;
            int n16 = '\u0001' << this.bitsPerSample[0];
            int n17 = Math.min(n16, ((IndexColorModel)object2).getMapSize());
            int n18 = 0;
            while (n18 < n17) {
                cArray[n18] = (char)(((IndexColorModel)object2).getRed(n18) * 65535 / 255);
                cArray[n16 + n18] = (char)(((IndexColorModel)object2).getGreen(n18) * 65535 / 255);
                cArray[2 * n16 + n18] = (char)(((IndexColorModel)object2).getBlue(n18) * 65535 / 255);
                ++n18;
            }
            TIFFField tIFFField12 = new TIFFField(baselineTIFFTagSet.getTag(320), 3, cArray.length, cArray);
            tIFFIFD.addTIFFField(tIFFField12);
        } else {
            tIFFIFD.removeTIFFField(320);
        }
        if (colorModel != null && tIFFIFD.getTIFFField(34675) == null && ImageUtil.isNonStandardICCColorSpace(colorModel.getColorSpace())) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorModel.getColorSpace();
            object2 = iCC_ColorSpace.getProfile().getData();
            TIFFField tIFFField13 = new TIFFField(baselineTIFFTagSet.getTag(34675), 7, ((Object)object2).length, object2);
            tIFFIFD.addTIFFField(tIFFField13);
        }
        TIFFField tIFFField14 = tIFFIFD.getTIFFField(282);
        object2 = tIFFIFD.getTIFFField(283);
        if (tIFFField14 == null && object2 == null) {
            long[][] lArray = new long[1][2];
            lArray[0] = new long[2];
            TIFFField tIFFField15 = tIFFIFD.getTIFFField(296);
            if (tIFFField15 == null && tIFFIFD.getTIFFField(286) == null && tIFFIFD.getTIFFField(287) == null) {
                lArray[0][0] = 1L;
                lArray[0][1] = 1L;
                tIFFField15 = new TIFFField(tIFFIFD.getTag(296), 1);
                tIFFIFD.addTIFFField(tIFFField15);
            } else {
                int n19 = tIFFField15 != null ? tIFFField15.getAsInt(0) : 2;
                int n20 = Math.max(n, n2);
                switch (n19) {
                    case 2: {
                        lArray[0][0] = n20;
                        lArray[0][1] = 4L;
                        break;
                    }
                    case 3: {
                        lArray[0][0] = 100L * (long)n20;
                        lArray[0][1] = 1016L;
                        break;
                    }
                    default: {
                        lArray[0][0] = 1L;
                        lArray[0][1] = 1L;
                    }
                }
            }
            tIFFField14 = new TIFFField(tIFFIFD.getTag(282), 5, 1, lArray);
            tIFFIFD.addTIFFField(tIFFField14);
            object2 = new TIFFField(tIFFIFD.getTag(283), 5, 1, lArray);
            tIFFIFD.addTIFFField((TIFFField)object2);
        } else if (tIFFField14 == null && object2 != null) {
            long[] lArray = (long[])((TIFFField)object2).getAsRational(0).clone();
            tIFFField14 = new TIFFField(tIFFIFD.getTag(282), 5, 1, lArray);
            tIFFIFD.addTIFFField(tIFFField14);
        } else if (tIFFField14 != null && object2 == null) {
            long[] lArray = (long[])tIFFField14.getAsRational(0).clone();
            object2 = new TIFFField(tIFFIFD.getTag(283), 5, 1, lArray);
            tIFFIFD.addTIFFField((TIFFField)object2);
        }
        int n21 = n;
        TIFFField tIFFField16 = new TIFFField(baselineTIFFTagSet.getTag(256), n21);
        tIFFIFD.addTIFFField(tIFFField16);
        int n22 = n2;
        TIFFField tIFFField17 = new TIFFField(baselineTIFFTagSet.getTag(257), n22);
        tIFFIFD.addTIFFField(tIFFField17);
        TIFFField tIFFField18 = tIFFIFD.getTIFFField(278);
        if (tIFFField18 != null) {
            n7 = tIFFField18.getAsInt(0);
            if (n7 < 0) {
                n7 = n22;
            }
        } else {
            n6 = this.bitDepth * (n10 + n11);
            n5 = (n6 * n21 + 7) / 8;
            n7 = Math.max(Math.max(8192 / n5, 1), 8);
        }
        n7 = Math.min(n7, n22);
        n6 = 0;
        int n23 = n5 = this.param instanceof TIFFImageWriteParam ? this.param.getTilingMode() : 1;
        if (n5 == 0 || n5 == 1) {
            this.tileWidth = n21;
            this.tileLength = n7;
            n6 = 0;
        } else if (n5 == 2) {
            this.tileWidth = this.param.getTileWidth();
            this.tileLength = this.param.getTileHeight();
            n6 = 1;
        } else {
            if (n5 != 3) throw new IIOException("Illegal value of tilingMode!");
            tIFFField4 = tIFFIFD.getTIFFField(322);
            if (tIFFField4 == null) {
                this.tileWidth = n21;
                n6 = 0;
            } else {
                this.tileWidth = tIFFField4.getAsInt(0);
                n6 = 1;
            }
            tIFFField4 = tIFFIFD.getTIFFField(323);
            if (tIFFField4 == null) {
                this.tileLength = n7;
            } else {
                this.tileLength = tIFFField4.getAsInt(0);
                n6 = 1;
            }
        }
        if (this.compression == 7) {
            int n24;
            if (n10 == 1) {
                n4 = 1;
                n3 = 1;
            } else {
                n4 = 2;
                n3 = 2;
            }
            if (n6 != 0) {
                n24 = 8 * n3;
                int n25 = 8 * n4;
                this.tileWidth = Math.max(n24 * ((this.tileWidth + n24 / 2) / n24), n24);
                this.tileLength = Math.max(n25 * ((this.tileLength + n25 / 2) / n25), n25);
            } else if (n7 < n22) {
                n24 = 8 * Math.max(n3, n4);
                n7 = this.tileLength = Math.max(n24 * ((this.tileLength + n24 / 2) / n24), n24);
            }
        } else if (bl) {
            this.tileWidth = n21;
            this.tileLength = n22;
        } else if (n6 != 0) {
            n3 = this.tileWidth % 16;
            if (n3 != 0) {
                this.tileWidth = Math.max(16 * ((this.tileWidth + 8) / 16), 16);
            }
            if ((n4 = this.tileLength % 16) != 0) {
                this.tileLength = Math.max(16 * ((this.tileLength + 8) / 16), 16);
            }
        }
        this.tilesAcross = (n21 + this.tileWidth - 1) / this.tileWidth;
        this.tilesDown = (n22 + this.tileLength - 1) / this.tileLength;
        if (n6 == 0) {
            this.isTiled = false;
            tIFFIFD.removeTIFFField(322);
            tIFFIFD.removeTIFFField(323);
            tIFFIFD.removeTIFFField(324);
            tIFFIFD.removeTIFFField(325);
            tIFFField18 = new TIFFField(baselineTIFFTagSet.getTag(278), n7);
            tIFFIFD.addTIFFField(tIFFField18);
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(273), 4, this.tilesDown);
            tIFFIFD.addTIFFField(tIFFField);
            object = new TIFFField(baselineTIFFTagSet.getTag(279), 4, this.tilesDown);
            tIFFIFD.addTIFFField((TIFFField)object);
        } else {
            this.isTiled = true;
            tIFFIFD.removeTIFFField(278);
            tIFFIFD.removeTIFFField(273);
            tIFFIFD.removeTIFFField(279);
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(322), this.tileWidth);
            tIFFIFD.addTIFFField(tIFFField);
            object = new TIFFField(baselineTIFFTagSet.getTag(323), this.tileLength);
            tIFFIFD.addTIFFField((TIFFField)object);
            TIFFField tIFFField19 = new TIFFField(baselineTIFFTagSet.getTag(324), 4, this.tilesDown * this.tilesAcross);
            tIFFIFD.addTIFFField(tIFFField19);
            TIFFField tIFFField20 = new TIFFField(baselineTIFFTagSet.getTag(325), 4, this.tilesDown * this.tilesAcross);
            tIFFIFD.addTIFFField(tIFFField20);
        }
        if (n8 == 0) return;
        boolean bl5 = this.isEncodingEmpty();
        if (this.compression == 6) {
            tIFFIFD.removeTIFFField(256);
            tIFFIFD.removeTIFFField(257);
            tIFFIFD.removeTIFFField(258);
            if (bl5) {
                tIFFIFD.removeTIFFField(259);
            }
            tIFFIFD.removeTIFFField(262);
            tIFFIFD.removeTIFFField(273);
            tIFFIFD.removeTIFFField(277);
            tIFFIFD.removeTIFFField(278);
            tIFFIFD.removeTIFFField(279);
            tIFFIFD.removeTIFFField(284);
            if (tIFFIFD.getTIFFField(296) == null) {
                tIFFField4 = new TIFFField(baselineTIFFTagSet.getTag(296), 2);
                tIFFIFD.addTIFFField(tIFFField4);
            }
            if (bl5) {
                tIFFIFD.removeTIFFField(513);
                tIFFIFD.removeTIFFField(514);
                tIFFIFD.removeTIFFField(530);
                if (tIFFIFD.getTIFFField(531) == null) {
                    tIFFField4 = new TIFFField(baselineTIFFTagSet.getTag(531), 3, 1, new char[]{'\u0001'});
                    tIFFIFD.addTIFFField(tIFFField4);
                }
            } else {
                tIFFField4 = new TIFFField(baselineTIFFTagSet.getTag(513), 4, 1);
                tIFFIFD.addTIFFField(tIFFField4);
                tIFFField4 = new TIFFField(baselineTIFFTagSet.getTag(514), 4, 1);
                tIFFIFD.addTIFFField(tIFFField4);
                tIFFIFD.removeTIFFField(530);
            }
        } else {
            if (tIFFIFD.getTIFFField(296) == null) {
                tIFFField4 = new TIFFField(baselineTIFFTagSet.getTag(296), 2);
                tIFFIFD.addTIFFField(tIFFField4);
            }
            tIFFIFD.removeTIFFField(513);
            tIFFIFD.removeTIFFField(514);
            if (this.photometricInterpretation == 2) {
                tIFFIFD.removeTIFFField(529);
                tIFFIFD.removeTIFFField(530);
                tIFFIFD.removeTIFFField(531);
            }
        }
        object = EXIFTIFFTagSet.getInstance();
        TIFFIFD tIFFIFD2 = null;
        tIFFField4 = tIFFIFD.getTIFFField(34665);
        if (tIFFField4 != null) {
            tIFFIFD2 = (TIFFIFD)tIFFField4.getData();
        } else if (bl5) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            tIFFIFD2 = new TIFFIFD(arrayList);
            EXIFParentTIFFTagSet eXIFParentTIFFTagSet = EXIFParentTIFFTagSet.getInstance();
            TIFFTag tIFFTag = eXIFParentTIFFTagSet.getTag(34665);
            tIFFIFD.addTIFFField(new TIFFField(tIFFTag, 4, 1, tIFFIFD2));
        }
        if (tIFFIFD2 == null) return;
        if (tIFFIFD2.getTIFFField(36864) == null) {
            tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(36864), 7, 4, EXIFTIFFTagSet.EXIF_VERSION_2_2);
            tIFFIFD2.addTIFFField(tIFFField4);
        }
        if (this.compression == 6) {
            if (tIFFIFD2.getTIFFField(37121) == null) {
                byte[] byArray = new byte[4];
                byArray[0] = 1;
                byArray[1] = 2;
                byArray[2] = 3;
                tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(37121), 7, 4, byArray);
                tIFFIFD2.addTIFFField(tIFFField4);
            }
        } else {
            tIFFIFD2.removeTIFFField(37121);
            tIFFIFD2.removeTIFFField(37122);
        }
        if (tIFFIFD2.getTIFFField(40960) == null) {
            tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(40960), 7, 4, new byte[]{48, 49, 48, 48});
            tIFFIFD2.addTIFFField(tIFFField4);
        }
        if (tIFFIFD2.getTIFFField(40961) == null) {
            tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(40961), 3, 1, new char[]{'\u0001'});
            tIFFIFD2.addTIFFField(tIFFField4);
        }
        if (this.compression == 6) {
            if (tIFFIFD2.getTIFFField(40962) == null) {
                tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(40962), n21);
                tIFFIFD2.addTIFFField(tIFFField4);
            }
            if (tIFFIFD2.getTIFFField(40963) != null) return;
            tIFFField4 = new TIFFField(((TIFFTagSet)object).getTag(40963), n22);
            tIFFIFD2.addTIFFField(tIFFField4);
            return;
        } else {
            tIFFIFD2.removeTIFFField(40965);
        }
    }

    private int writeTile(Rectangle rectangle, TIFFCompressor tIFFCompressor) throws IOException {
        SampleModel sampleModel;
        boolean bl;
        Rectangle rectangle2;
        Rectangle rectangle3 = new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
        if (!this.isTiled) {
            rectangle = rectangle2 = rectangle.intersection(rectangle3);
            bl = false;
        } else if (rectangle3.contains(rectangle)) {
            rectangle2 = rectangle;
            bl = false;
        } else {
            rectangle2 = rectangle3.intersection(rectangle);
            bl = true;
        }
        if (rectangle2.isEmpty()) {
            return 0;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.isImageSimple) {
            Object object;
            SampleModel sampleModel2 = this.image.getSampleModel();
            Object object2 = this.image.getData(rectangle2);
            if (bl) {
                object = ((Raster)object2).createCompatibleWritableRaster(n, n2, n3, n4);
                ((WritableRaster)object).setRect((Raster)object2);
                object2 = object;
            }
            if (this.isBilevel) {
                object = ImageUtil.getPackedBinaryData((Raster)object2, rectangle);
                if (this.isInverted) {
                    DataBuffer dataBuffer = ((Raster)object2).getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte && object == ((DataBufferByte)dataBuffer).getData()) {
                        byte[] byArray = new byte[((Object)object).length];
                        int n5 = ((Object)object).length;
                        int n6 = 0;
                        while (n6 < n5) {
                            byArray[n6] = (byte)(object[n6] ^ 0xFF);
                            ++n6;
                        }
                        object = byArray;
                    } else {
                        int n7 = ((Object)object).length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Object object3 = object;
                            int n9 = n8++;
                            object3[n9] = (byte)(object3[n9] ^ 0xFF);
                        }
                    }
                }
                return tIFFCompressor.encode((byte[])object, 0, n3, n4, this.sampleSize, (rectangle.width + 7) / 8);
            }
            if (this.bitDepth == 8 && sampleModel2.getDataType() == 0) {
                object = (ComponentSampleModel)((Raster)object2).getSampleModel();
                byte[] byArray = ((DataBufferByte)((Raster)object2).getDataBuffer()).getData();
                int n10 = ((ComponentSampleModel)object).getOffset(n - ((Raster)object2).getSampleModelTranslateX(), n2 - ((Raster)object2).getSampleModelTranslateY());
                return tIFFCompressor.encode(byArray, n10, n3, n4, this.sampleSize, ((ComponentSampleModel)object).getScanlineStride());
            }
        }
        int n11 = n;
        int n12 = this.periodX;
        int n13 = n2;
        int n14 = this.periodY;
        int n15 = (n3 + n12 - 1) / n12;
        int n16 = (n4 + n14 - 1) / n14;
        if (n15 == 0 || n16 == 0) {
            return 0;
        }
        n11 *= this.numBands;
        n12 *= this.numBands;
        int n17 = 8 / this.bitDepth;
        int n18 = n3 * this.numBands;
        int n19 = n15 * this.numBands;
        if (this.bitDepth < 8) {
            n19 = (n19 + n17 - 1) / n17;
        } else if (this.bitDepth == 16) {
            n19 *= 2;
        } else if (this.bitDepth == 32) {
            n19 *= 4;
        }
        int[] nArray = null;
        float[] fArray = null;
        if (this.sampleFormat == 3) {
            fArray = new float[n18];
        } else {
            nArray = new int[n18];
        }
        byte[] byArray = new byte[n19 * n16];
        if (!this.isInverted && !this.isRescaling && this.sourceBands == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null && (sampleModel = this.image.getSampleModel()) instanceof ComponentSampleModel && this.bitDepth == 8 && sampleModel.getDataType() == 0) {
            Object object;
            Object object4 = this.image.getData(rectangle2);
            if (bl) {
                object = ((Raster)object4).createCompatibleWritableRaster(n, n2, n3, n4);
                ((WritableRaster)object).setRect((Raster)object4);
                object4 = object;
            }
            object = (ComponentSampleModel)((Raster)object4).getSampleModel();
            int[] nArray2 = ((ComponentSampleModel)object).getBankIndices();
            byte[][] byArray2 = ((DataBufferByte)((Raster)object4).getDataBuffer()).getBankData();
            int n20 = ((ComponentSampleModel)object).getScanlineStride();
            int n21 = ((ComponentSampleModel)object).getPixelStride();
            int n22 = 0;
            while (n22 < this.numBands) {
                byte[] byArray3 = byArray2[nArray2[n22]];
                int n23 = ((ComponentSampleModel)object).getOffset(((Raster)object4).getMinX() - ((Raster)object4).getSampleModelTranslateX(), ((Raster)object4).getMinY() - ((Raster)object4).getSampleModelTranslateY(), n22);
                int n24 = n22;
                int n25 = 0;
                while (n25 < n16) {
                    int n26 = n23;
                    int n27 = 0;
                    while (n27 < n15) {
                        byArray[n24] = byArray3[n26];
                        n24 += this.numBands;
                        n26 += n21;
                        ++n27;
                    }
                    n23 += n20;
                    ++n25;
                }
                ++n22;
            }
            return tIFFCompressor.encode(byArray, 0, n3, n4, this.sampleSize, n3 * this.numBands);
        }
        int n28 = 0;
        int n29 = rectangle2.x;
        int n30 = rectangle2.y;
        int n31 = n30 + rectangle2.height - 1;
        int n32 = rectangle2.width;
        SampleModel sampleModel3 = null;
        if (bl) {
            sampleModel3 = this.image.getSampleModel().createCompatibleSampleModel(n3, 1);
        }
        int n33 = n13;
        while (n33 < n13 + n4) {
            Object object;
            Object object5 = null;
            if (bl) {
                object = Raster.createWritableRaster(sampleModel3, new Point(n, n33));
                if (n33 >= n30 && n33 <= n31) {
                    Rectangle rectangle4 = new Rectangle(n29, n33, n32, 1);
                    object5 = this.image.getData(rectangle4);
                    ((WritableRaster)object).setRect((Raster)object5);
                }
                object5 = object;
            } else {
                object = new Rectangle(n, n33, n3, 1);
                object5 = this.image.getData((Rectangle)object);
            }
            if (this.sourceBands != null) {
                object5 = ((Raster)object5).createChild(n, n33, n3, 1, n, n33, this.sourceBands);
            }
            if (this.sampleFormat == 3) {
                ((Raster)object5).getPixels(n, n33, n3, 1, fArray);
            } else {
                ((Raster)object5).getPixels(n, n33, n3, 1, nArray);
                if (this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1) {
                    int n34 = (1 << this.bitDepth) - 1;
                    int n35 = 0;
                    while (n35 < n18) {
                        int n36 = n35++;
                        nArray[n36] = nArray[n36] ^ n34;
                    }
                }
            }
            if (this.colorConverter != null) {
                int n37 = 0;
                float[] fArray2 = new float[3];
                if (this.sampleFormat == 3) {
                    int n38 = 0;
                    while (n38 < n3) {
                        float f = fArray[n37];
                        float f2 = fArray[n37 + 1];
                        float f3 = fArray[n37 + 2];
                        this.colorConverter.fromRGB(f, f2, f3, fArray2);
                        fArray[n37] = fArray2[0];
                        fArray[n37 + 1] = fArray2[1];
                        fArray[n37 + 2] = fArray2[2];
                        n37 += 3;
                        ++n38;
                    }
                } else {
                    int n39 = 0;
                    while (n39 < n3) {
                        float f = nArray[n37];
                        float f4 = nArray[n37 + 1];
                        float f5 = nArray[n37 + 2];
                        this.colorConverter.fromRGB(f, f4, f5, fArray2);
                        nArray[n37] = (int)fArray2[0];
                        nArray[n37 + 1] = (int)fArray2[1];
                        nArray[n37 + 2] = (int)fArray2[2];
                        n37 += 3;
                        ++n39;
                    }
                }
            }
            int n40 = 0;
            int n41 = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n42;
                    if (this.isRescaling) {
                        n42 = 0;
                        while (n42 < n18) {
                            byte by = this.scale0[nArray[n42]];
                            n40 = n40 << this.bitDepth | by;
                            if (++n41 == n17) {
                                byArray[n28++] = (byte)n40;
                                n40 = 0;
                                n41 = 0;
                            }
                            n42 += n12;
                        }
                    } else {
                        n42 = 0;
                        while (n42 < n18) {
                            byte by = (byte)nArray[n42];
                            n40 = n40 << this.bitDepth | by;
                            if (++n41 == n17) {
                                byArray[n28++] = (byte)n40;
                                n40 = 0;
                                n41 = 0;
                            }
                            n42 += n12;
                        }
                    }
                    if (n41 == 0) break;
                    byArray[n28++] = (byte)(n40 <<= (8 / this.bitDepth - n41) * this.bitDepth);
                    break;
                }
                case 8: {
                    if (this.numBands == 1) {
                        if (this.isRescaling) {
                            int n43 = 0;
                            while (n43 < n18) {
                                byArray[n28++] = this.scale0[nArray[n43]];
                                n43 += n12;
                            }
                        } else {
                            int n44 = 0;
                            while (n44 < n18) {
                                byArray[n28++] = (byte)nArray[n44];
                                n44 += n12;
                            }
                        }
                    } else if (this.isRescaling) {
                        int n45 = 0;
                        while (n45 < n18) {
                            int n46 = 0;
                            while (n46 < this.numBands) {
                                byArray[n28++] = this.scale[n46][nArray[n45 + n46]];
                                ++n46;
                            }
                            n45 += n12;
                        }
                    } else {
                        int n47 = 0;
                        while (n47 < n18) {
                            int n48 = 0;
                            while (n48 < this.numBands) {
                                byArray[n28++] = (byte)nArray[n47 + n48];
                                ++n48;
                            }
                            n47 += n12;
                        }
                    }
                    break;
                }
                case 16: {
                    if (this.isRescaling) {
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            int n49 = 0;
                            while (n49 < n18) {
                                int n50 = 0;
                                while (n50 < this.numBands) {
                                    int n51 = nArray[n49 + n50];
                                    byArray[n28++] = this.scaleh[n50][n51];
                                    byArray[n28++] = this.scalel[n50][n51];
                                    ++n50;
                                }
                                n49 += n12;
                            }
                        } else {
                            int n52 = 0;
                            while (n52 < n18) {
                                int n53 = 0;
                                while (n53 < this.numBands) {
                                    int n54 = nArray[n52 + n53];
                                    byArray[n28++] = this.scalel[n53][n54];
                                    byArray[n28++] = this.scaleh[n53][n54];
                                    ++n53;
                                }
                                n52 += n12;
                            }
                        }
                    } else if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        int n55 = 0;
                        while (n55 < n18) {
                            int n56 = 0;
                            while (n56 < this.numBands) {
                                int n57 = nArray[n55 + n56];
                                byArray[n28++] = (byte)(n57 >>> 8 & 0xFF);
                                byArray[n28++] = (byte)(n57 & 0xFF);
                                ++n56;
                            }
                            n55 += n12;
                        }
                    } else {
                        int n58 = 0;
                        while (n58 < n18) {
                            int n59 = 0;
                            while (n59 < this.numBands) {
                                int n60 = nArray[n58 + n59];
                                byArray[n28++] = (byte)(n60 & 0xFF);
                                byArray[n28++] = (byte)(n60 >>> 8 & 0xFF);
                                ++n59;
                            }
                            n58 += n12;
                        }
                    }
                    break;
                }
                case 32: {
                    if (this.sampleFormat == 3) {
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            int n61 = 0;
                            while (n61 < n18) {
                                int n62 = 0;
                                while (n62 < this.numBands) {
                                    float f = fArray[n61 + n62];
                                    int n63 = Float.floatToIntBits(f);
                                    byArray[n28++] = (byte)((n63 & 0xFF000000) >> 24);
                                    byArray[n28++] = (byte)((n63 & 0xFF0000) >> 16);
                                    byArray[n28++] = (byte)((n63 & 0xFF00) >> 8);
                                    byArray[n28++] = (byte)(n63 & 0xFF);
                                    ++n62;
                                }
                                n61 += n12;
                            }
                        } else {
                            int n64 = 0;
                            while (n64 < n18) {
                                int n65 = 0;
                                while (n65 < this.numBands) {
                                    float f = fArray[n64 + n65];
                                    int n66 = Float.floatToIntBits(f);
                                    byArray[n28++] = (byte)(n66 & 0xFF);
                                    byArray[n28++] = (byte)((n66 & 0xFF00) >> 8);
                                    byArray[n28++] = (byte)((n66 & 0xFF0000) >> 16);
                                    byArray[n28++] = (byte)((n66 & 0xFF000000) >> 24);
                                    ++n65;
                                }
                                n64 += n12;
                            }
                        }
                    } else if (this.isRescaling) {
                        long l;
                        int n67;
                        long[] lArray = new long[this.numBands];
                        long[] lArray2 = new long[this.numBands];
                        long l2 = (1L << (int)((long)this.bitDepth)) - 1L;
                        int n68 = 0;
                        while (n68 < this.numBands) {
                            lArray[n68] = (1L << (int)((long)this.sampleSize[n68])) - 1L;
                            lArray2[n68] = lArray[n68] / 2L;
                            ++n68;
                        }
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            n68 = 0;
                            while (n68 < n18) {
                                n67 = 0;
                                while (n67 < this.numBands) {
                                    l = ((long)nArray[n68 + n67] * l2 + lArray2[n67]) / lArray[n67];
                                    byArray[n28++] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
                                    byArray[n28++] = (byte)((l & 0xFF0000L) >> 16);
                                    byArray[n28++] = (byte)((l & 0xFF00L) >> 8);
                                    byArray[n28++] = (byte)(l & 0xFFL);
                                    ++n67;
                                }
                                n68 += n12;
                            }
                        } else {
                            n68 = 0;
                            while (n68 < n18) {
                                n67 = 0;
                                while (n67 < this.numBands) {
                                    l = ((long)nArray[n68 + n67] * l2 + lArray2[n67]) / lArray[n67];
                                    byArray[n28++] = (byte)(l & 0xFFL);
                                    byArray[n28++] = (byte)((l & 0xFF00L) >> 8);
                                    byArray[n28++] = (byte)((l & 0xFF0000L) >> 16);
                                    byArray[n28++] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
                                    ++n67;
                                }
                                n68 += n12;
                            }
                        }
                    } else if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        int n69 = 0;
                        while (n69 < n18) {
                            int n70 = 0;
                            while (n70 < this.numBands) {
                                int n71 = nArray[n69 + n70];
                                byArray[n28++] = (byte)((n71 & 0xFF000000) >> 24);
                                byArray[n28++] = (byte)((n71 & 0xFF0000) >> 16);
                                byArray[n28++] = (byte)((n71 & 0xFF00) >> 8);
                                byArray[n28++] = (byte)(n71 & 0xFF);
                                ++n70;
                            }
                            n69 += n12;
                        }
                    } else {
                        int n72 = 0;
                        while (n72 < n18) {
                            int n73 = 0;
                            while (n73 < this.numBands) {
                                int n74 = nArray[n72 + n73];
                                byArray[n28++] = (byte)(n74 & 0xFF);
                                byArray[n28++] = (byte)((n74 & 0xFF00) >> 8);
                                byArray[n28++] = (byte)((n74 & 0xFF0000) >> 16);
                                byArray[n28++] = (byte)((n74 & 0xFF000000) >> 24);
                                ++n73;
                            }
                            n72 += n12;
                        }
                    }
                    break;
                }
            }
            n33 += n14;
        }
        int[] nArray3 = new int[this.numBands];
        int n75 = 0;
        while (n75 < nArray3.length) {
            nArray3[n75] = this.bitDepth;
            ++n75;
        }
        n75 = tIFFCompressor.encode(byArray, 0, n15, n16, nArray3, n19);
        return n75;
    }

    private boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void initializeScaleTables(int[] nArray) {
        int n;
        if (this.bitDepth == this.scalingBitDepth && this.equals(nArray, this.sampleSize)) {
            return;
        }
        this.isRescaling = false;
        this.scalingBitDepth = -1;
        this.scaleh = null;
        this.scalel = null;
        this.scale = null;
        this.scale0 = null;
        this.sampleSize = nArray;
        if (this.bitDepth <= 16) {
            n = 0;
            while (n < this.numBands) {
                if (nArray[n] != this.bitDepth) {
                    this.isRescaling = true;
                    break;
                }
                ++n;
            }
        }
        if (!this.isRescaling) {
            return;
        }
        this.scalingBitDepth = this.bitDepth;
        n = (1 << this.bitDepth) - 1;
        if (this.bitDepth <= 8) {
            this.scale = new byte[this.numBands][];
            int n2 = 0;
            while (n2 < this.numBands) {
                int n3 = (1 << nArray[n2]) - 1;
                int n4 = n3 / 2;
                this.scale[n2] = new byte[n3 + 1];
                int n5 = 0;
                while (n5 <= n3) {
                    this.scale[n2][n5] = (byte)((n5 * n + n4) / n3);
                    ++n5;
                }
                ++n2;
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = null;
        } else if (this.bitDepth <= 16) {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            int n6 = 0;
            while (n6 < this.numBands) {
                int n7 = (1 << nArray[n6]) - 1;
                int n8 = n7 / 2;
                this.scaleh[n6] = new byte[n7 + 1];
                this.scalel[n6] = new byte[n7 + 1];
                int n9 = 0;
                while (n9 <= n7) {
                    int n10 = (n9 * n + n8) / n7;
                    this.scaleh[n6][n9] = (byte)(n10 >> 8);
                    this.scalel[n6][n9] = (byte)(n10 & 0xFF);
                    ++n9;
                }
                ++n6;
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.write(iIOMetadata, iIOImage, imageWriteParam, true, true);
    }

    private void writeHeader() throws IOException {
        this.byteOrder = this.streamMetadata != null ? this.streamMetadata.byteOrder : ByteOrder.BIG_ENDIAN;
        this.stream.setByteOrder(this.byteOrder);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.stream.writeShort(19789);
        } else {
            this.stream.writeShort(18761);
        }
        this.stream.writeShort(42);
        this.stream.writeInt(0);
        this.nextSpace = this.stream.getStreamPosition();
        this.headerPosition = this.nextSpace - 8L;
    }

    private void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam, boolean bl, boolean bl2) throws IOException {
        Object object;
        int n;
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (iIOImage.hasRaster() && !this.canWriteRasters()) {
            throw new UnsupportedOperationException("TIFF ImageWriter cannot write Rasters!");
        }
        this.image = iIOImage.getRenderedImage();
        SampleModel sampleModel = this.image.getSampleModel();
        this.sourceXOffset = this.image.getMinX();
        this.sourceYOffset = this.image.getMinY();
        this.sourceWidth = this.image.getWidth();
        this.sourceHeight = this.image.getHeight();
        Rectangle rectangle = new Rectangle(this.sourceXOffset, this.sourceYOffset, this.sourceWidth, this.sourceHeight);
        ColorModel colorModel = null;
        if (imageWriteParam == null) {
            this.param = this.getDefaultWriteParam();
            this.sourceBands = null;
            this.periodX = 1;
            this.periodY = 1;
            this.numBands = sampleModel.getNumBands();
            colorModel = this.image.getColorModel();
        } else {
            ColorModel colorModel2;
            this.param = imageWriteParam;
            Rectangle rectangle2 = this.param.getSourceRegion();
            if (rectangle2 != null) {
                rectangle2 = rectangle2.intersection(rectangle);
                this.sourceXOffset = rectangle2.x;
                this.sourceYOffset = rectangle2.y;
                this.sourceWidth = rectangle2.width;
                this.sourceHeight = rectangle2.height;
            }
            n = this.param.getSubsamplingXOffset();
            int n2 = this.param.getSubsamplingYOffset();
            this.sourceXOffset += n;
            this.sourceYOffset += n2;
            this.sourceWidth -= n;
            this.sourceHeight -= n2;
            this.periodX = this.param.getSourceXSubsampling();
            this.periodY = this.param.getSourceYSubsampling();
            object = this.param.getSourceBands();
            if (object != null) {
                this.sourceBands = object;
                this.numBands = this.sourceBands.length;
            } else {
                this.numBands = sampleModel.getNumBands();
            }
            ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType();
            if (imageTypeSpecifier != null && (colorModel2 = imageTypeSpecifier.getColorModel()).getNumComponents() == this.numBands) {
                colorModel = colorModel2;
            }
            if (colorModel == null) {
                colorModel = this.image.getColorModel();
            }
        }
        this.imageType = new ImageTypeSpecifier(colorModel, sampleModel);
        ImageUtil.canEncodeImage(this, this.imageType);
        int n3 = (this.sourceWidth + this.periodX - 1) / this.periodX;
        n = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (n3 <= 0 || n <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (bl) {
            this.streamMetadata = null;
            if (iIOMetadata != null) {
                this.streamMetadata = (TIFFStreamMetadata)this.convertStreamMetadata(iIOMetadata, this.param);
            }
            if (this.streamMetadata == null) {
                this.streamMetadata = (TIFFStreamMetadata)this.getDefaultStreamMetadata(this.param);
            }
            this.writeHeader();
            this.stream.seek(this.headerPosition + 4L);
            this.nextSpace = this.nextSpace + 3L & 0xFFFFFFFFFFFFFFFCL;
            this.stream.writeInt((int)this.nextSpace);
        }
        this.imageMetadata = null;
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        if (iIOMetadata2 != null) {
            if (iIOMetadata2 instanceof TIFFImageMetadata) {
                this.imageMetadata = ((TIFFImageMetadata)iIOMetadata2).getShallowClone();
            } else if (Arrays.asList(iIOMetadata2.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
                this.imageMetadata = this.convertNativeImageMetadata(iIOMetadata2);
            } else if (iIOMetadata2.isStandardMetadataFormatSupported()) {
                try {
                    this.imageMetadata = this.convertStandardImageMetadata(iIOMetadata2);
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {}
            }
        }
        if (this.imageMetadata == null) {
            this.imageMetadata = (TIFFImageMetadata)this.getDefaultImageMetadata(this.imageType, this.param);
        }
        this.setupMetadata(colorModel, sampleModel, n3, n);
        this.compressor.setWriter(this);
        this.compressor.setMetadata(this.imageMetadata);
        this.compressor.setStream(this.stream);
        sampleModel.getSampleSize();
        this.initializeScaleTables(sampleModel.getSampleSize());
        this.isBilevel = ImageUtil.isBinary(this.image.getSampleModel());
        this.isInverted = this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1;
        this.isImageSimple = (this.isBilevel || !this.isInverted && ImageUtil.imageIsContiguous(this.image)) && !this.isRescaling && this.sourceBands == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null;
        object = this.imageMetadata.getRootIFD();
        object.writeToStream(this.stream);
        this.nextIFDPointerPos = this.stream.getStreamPosition();
        this.stream.writeInt(0);
        long l = object.getLastPosition();
        this.stream.seek(l);
        if (l > this.nextSpace) {
            this.nextSpace = l;
        }
        if (!bl2) {
            return;
        }
        long l2 = object.getStripOrTileByteCountsPosition();
        long l3 = object.getStripOrTileOffsetsPosition();
        this.totalPixels = this.tileWidth * this.tileLength * this.tilesDown * this.tilesAcross;
        this.pixelsDone = 0;
        int n4 = 0;
        while (n4 < this.tilesDown) {
            int n5 = 0;
            while (n5 < this.tilesAcross) {
                long l4 = this.stream.getStreamPosition();
                Rectangle rectangle3 = new Rectangle(this.sourceXOffset + n5 * this.tileWidth * this.periodX, this.sourceYOffset + n4 * this.tileLength * this.periodY, this.tileWidth * this.periodX, this.tileLength * this.periodY);
                try {
                    int n6 = this.writeTile(rectangle3, this.compressor);
                    if (l4 + (long)n6 > this.nextSpace) {
                        this.nextSpace = l4 + (long)n6;
                    }
                    this.pixelsDone += rectangle3.width * rectangle3.height;
                    this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
                    this.stream.mark();
                    this.stream.seek(l3);
                    this.stream.writeInt((int)l4);
                    l3 += 4L;
                    this.stream.seek(l2);
                    this.stream.writeInt(n6);
                    l2 += 4L;
                    this.stream.reset();
                }
                catch (IOException iOException) {
                    throw new IIOException("I/O error writing TIFF file!", iOException);
                }
                if (this.abortRequested()) {
                    this.processWriteAborted();
                    return;
                }
                ++n5;
            }
            ++n4;
        }
        this.processImageComplete();
    }

    @Override
    public boolean canWriteSequence() {
        return true;
    }

    @Override
    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (iIOMetadata != null) {
            iIOMetadata = this.convertStreamMetadata(iIOMetadata, null);
        }
        if (iIOMetadata == null) {
            iIOMetadata = this.getDefaultStreamMetadata(null);
        }
        this.streamMetadata = (TIFFStreamMetadata)iIOMetadata;
        this.writeHeader();
        this.isWritingSequence = true;
    }

    @Override
    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() has not been called!");
        }
        this.writeInsert(-1, iIOImage, imageWriteParam);
    }

    @Override
    public void endWriteSequence() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() has not been called!");
        }
        this.isWritingSequence = false;
    }

    @Override
    public boolean canInsertImage(int n) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        this.stream.mark();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n, lArray, lArray2);
        this.stream.reset();
        return true;
    }

    private void locateIFD(int n, long[] lArray, long[] lArray2) throws IOException {
        if (n < -1) {
            throw new IndexOutOfBoundsException("imageIndex < -1!");
        }
        long l = this.stream.getStreamPosition();
        this.stream.seek(this.headerPosition);
        int n2 = this.stream.readUnsignedShort();
        if (n2 == 19789) {
            this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else if (n2 == 18761) {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream.seek(l);
            throw new IIOException("Illegal byte order");
        }
        if (this.stream.readUnsignedShort() != 42) {
            this.stream.seek(l);
            throw new IIOException("Illegal magic number");
        }
        lArray[0] = this.stream.getStreamPosition();
        lArray2[0] = this.stream.readUnsignedInt();
        if (lArray2[0] == 0L) {
            if (n > 0) {
                this.stream.seek(l);
                throw new IndexOutOfBoundsException("imageIndex is greater than the largest available index!");
            }
            return;
        }
        this.stream.seek(lArray2[0]);
        int n3 = 0;
        while (n == -1 || n3 < n) {
            short s;
            try {
                s = this.stream.readShort();
            }
            catch (EOFException eOFException) {
                this.stream.seek(l);
                lArray2[0] = 0L;
                return;
            }
            this.stream.skipBytes(12 * s);
            lArray[0] = this.stream.getStreamPosition();
            lArray2[0] = this.stream.readUnsignedInt();
            if (lArray2[0] == 0L) {
                if (n == -1 || n3 >= n - 1) break;
                this.stream.seek(l);
                throw new IndexOutOfBoundsException("imageIndex is greater than the largest available index!");
            }
            this.stream.seek(lArray2[0]);
            ++n3;
        }
    }

    @Override
    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.insert(n, iIOImage, imageWriteParam, true);
    }

    private void insert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam, boolean bl) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n, lArray, lArray2);
        this.stream.seek(lArray[0]);
        if (lArray[0] + 4L > this.nextSpace) {
            this.nextSpace = lArray[0] + 4L;
        }
        this.nextSpace = this.nextSpace + 3L & 0xFFFFFFFFFFFFFFFCL;
        this.stream.writeInt((int)this.nextSpace);
        this.stream.seek(this.nextSpace);
        this.write(null, iIOImage, imageWriteParam, false, bl);
        this.stream.seek(this.nextIFDPointerPos);
        this.stream.writeInt((int)lArray2[0]);
    }

    private boolean isEncodingEmpty() {
        return this.isInsertingEmpty || this.isWritingEmpty;
    }

    @Override
    public boolean canInsertEmpty(int n) throws IOException {
        return this.canInsertImage(n);
    }

    @Override
    public boolean canWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return true;
    }

    private void checkParamsEmpty(ImageTypeSpecifier imageTypeSpecifier, int n, int n2, List list) {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("width < 1 || height < 1!");
        }
        if (list != null) {
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3) {
                Object e = list.get(n4);
                if (e == null || !(e instanceof BufferedImage)) {
                    throw new IllegalArgumentException("thumbnails contains null references or objects other than BufferedImages!");
                }
                ++n4;
            }
        }
        if (this.isInsertingEmpty) {
            throw new IllegalStateException("Previous call to prepareInsertEmpty() without corresponding call to endInsertEmpty()!");
        }
        if (this.isWritingEmpty) {
            throw new IllegalStateException("Previous call to prepareWriteEmpty() without corresponding call to endWriteEmpty()!");
        }
    }

    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.checkParamsEmpty(imageTypeSpecifier, n2, n3, list);
        this.isInsertingEmpty = true;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        EmptyImage emptyImage = new EmptyImage(0, 0, n2, n3, 0, 0, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel, imageTypeSpecifier.getColorModel());
        this.insert(n, new IIOImage(emptyImage, null, iIOMetadata), imageWriteParam, false);
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.checkParamsEmpty(imageTypeSpecifier, n, n2, list);
        this.isWritingEmpty = true;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        EmptyImage emptyImage = new EmptyImage(0, 0, n, n2, 0, 0, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel, imageTypeSpecifier.getColorModel());
        this.write(iIOMetadata, new IIOImage(emptyImage, null, iIOMetadata2), imageWriteParam, true, false);
    }

    @Override
    public void endInsertEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isInsertingEmpty) {
            throw new IllegalStateException("No previous call to prepareInsertEmpty()!");
        }
        if (this.isWritingEmpty) {
            throw new IllegalStateException("Previous call to prepareWriteEmpty() without corresponding call to endWriteEmpty()!");
        }
        if (this.inReplacePixelsNest) {
            throw new IllegalStateException("In nested call to prepareReplacePixels!");
        }
        this.isInsertingEmpty = false;
    }

    @Override
    public void endWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isWritingEmpty) {
            throw new IllegalStateException("No previous call to prepareWriteEmpty()!");
        }
        if (this.isInsertingEmpty) {
            throw new IllegalStateException("Previous call to prepareInsertEmpty() without corresponding call to endInsertEmpty()!");
        }
        if (this.inReplacePixelsNest) {
            throw new IllegalStateException("In nested call to prepareReplacePixels!");
        }
        this.isWritingEmpty = false;
    }

    private TIFFIFD readIFD(int n) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("imageIndex < 0!");
        }
        this.stream.mark();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n, lArray, lArray2);
        if (lArray2[0] == 0L) {
            this.stream.reset();
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
        arrayList.add(BaselineTIFFTagSet.getInstance());
        TIFFIFD tIFFIFD = new TIFFIFD(arrayList);
        tIFFIFD.initialize(this.stream, true);
        this.stream.reset();
        return tIFFIFD;
    }

    @Override
    public boolean canReplacePixels(int n) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        TIFFIFD tIFFIFD = this.readIFD(n);
        TIFFField tIFFField = tIFFIFD.getTIFFField(259);
        int n2 = tIFFField.getAsInt(0);
        return n2 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            if (this.stream == null) {
                throw new IllegalStateException("Output not set!");
            }
            if (rectangle == null) {
                throw new IllegalArgumentException("region == null!");
            }
            if (rectangle.getWidth() < 1.0) {
                throw new IllegalArgumentException("region.getWidth() < 1!");
            }
            if (rectangle.getHeight() < 1.0) {
                throw new IllegalArgumentException("region.getHeight() < 1!");
            }
            if (this.inReplacePixelsNest) {
                throw new IllegalStateException("In nested call to prepareReplacePixels!");
            }
            TIFFIFD tIFFIFD = this.readIFD(n);
            TIFFField tIFFField = tIFFIFD.getTIFFField(259);
            int n2 = tIFFField.getAsInt(0);
            if (n2 != 1) {
                throw new UnsupportedOperationException("canReplacePixels(imageIndex) == false!");
            }
            tIFFField = tIFFIFD.getTIFFField(256);
            if (tIFFField == null) {
                throw new IIOException("Cannot read ImageWidth field.");
            }
            int n3 = tIFFField.getAsInt(0);
            tIFFField = tIFFIFD.getTIFFField(257);
            if (tIFFField == null) {
                throw new IIOException("Cannot read ImageHeight field.");
            }
            int n4 = tIFFField.getAsInt(0);
            Rectangle rectangle2 = new Rectangle(0, 0, n3, n4);
            if ((rectangle = rectangle.intersection(rectangle2)).isEmpty()) {
                throw new IIOException("Region does not intersect image bounds");
            }
            this.replacePixelsRegion = rectangle;
            tIFFField = tIFFIFD.getTIFFField(324);
            if (tIFFField == null) {
                tIFFField = tIFFIFD.getTIFFField(273);
            }
            this.replacePixelsTileOffsets = tIFFField.getAsLongs();
            tIFFField = tIFFIFD.getTIFFField(325);
            if (tIFFField == null) {
                tIFFField = tIFFIFD.getTIFFField(279);
            }
            this.replacePixelsByteCounts = tIFFField.getAsLongs();
            this.replacePixelsOffsetsPosition = tIFFIFD.getStripOrTileOffsetsPosition();
            this.replacePixelsByteCountsPosition = tIFFIFD.getStripOrTileByteCountsPosition();
            this.replacePixelsMetadata = new TIFFImageMetadata(tIFFIFD);
            this.replacePixelsIndex = n;
            this.inReplacePixelsNest = true;
        }
    }

    private Raster subsample(Raster raster, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, Rectangle rectangle) {
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int n9 = raster.getWidth();
        int n10 = raster.getHeight();
        int n11 = raster.getSampleModel().getNumBands();
        int n12 = raster.getSampleModel().getDataType();
        int n13 = TIFFImageWriter.XToTileX(n7, n, n3) + n5;
        int n14 = TIFFImageWriter.YToTileY(n8, n2, n4) + n6;
        int n15 = TIFFImageWriter.XToTileX(n7 + n9 - 1, n, n3) + n5;
        int n16 = TIFFImageWriter.YToTileY(n8 + n10 - 1, n2, n4) + n6;
        int n17 = n15 - n13 + 1;
        int n18 = n16 - n14 + 1;
        if (n17 <= 0 || n18 <= 0) {
            return null;
        }
        int n19 = (n13 - n5) * n3 + n;
        int n20 = (n15 - n5) * n3 + n;
        int n21 = n20 - n19 + 1;
        int n22 = (n14 - n6) * n4 + n2;
        int n23 = (n16 - n6) * n4 + n2;
        int n24 = n23 - n22 + 1;
        WritableRaster writableRaster = raster.createCompatibleWritableRaster(n13, n14, n17, n18);
        int n25 = n22 + n24;
        if (n12 == 4 || n12 == 5) {
            float[] fArray = new float[n21];
            float[] fArray2 = new float[n17];
            int n26 = 0;
            while (n26 < n11) {
                int n27 = n14;
                int n28 = n22;
                while (n28 < n25) {
                    raster.getSamples(n19, n28, n21, 1, n26, fArray);
                    int n29 = 0;
                    int n30 = 0;
                    while (n30 < n21) {
                        fArray2[n29++] = fArray[n30];
                        n30 += n3;
                    }
                    writableRaster.setSamples(n13, n27++, n17, 1, n26, fArray2);
                    n28 += n4;
                }
                ++n26;
            }
        } else {
            int[] nArray2 = new int[n21];
            int[] nArray3 = new int[n17];
            int n31 = 0;
            while (n31 < n11) {
                int n32 = n14;
                int n33 = n22;
                while (n33 < n25) {
                    raster.getSamples(n19, n33, n21, 1, n31, nArray2);
                    int n34 = 0;
                    int n35 = 0;
                    while (n35 < n21) {
                        nArray3[n34++] = nArray2[n35];
                        n35 += n3;
                    }
                    writableRaster.setSamples(n13, n32++, n17, 1, n31, nArray3);
                    n33 += n4;
                }
                ++n31;
            }
        }
        return writableRaster.createChild(n13, n14, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePixels(RenderedImage renderedImage, ImageWriteParam object) throws IOException {
        Object object2 = this.replacePixelsLock;
        synchronized (object2) {
            int n;
            Object object3;
            if (this.stream == null) {
                throw new IllegalStateException("stream == null!");
            }
            if (renderedImage == null) {
                throw new IllegalArgumentException("image == null!");
            }
            if (!this.inReplacePixelsNest) {
                throw new IllegalStateException("No previous call to prepareReplacePixels!");
            }
            int n2 = 1;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            if (object == null) {
                object = this.getDefaultWriteParam();
            } else {
                object3 = this.getDefaultWriteParam();
                ((ImageWriteParam)object3).setCompressionMode(0);
                ((ImageWriteParam)object3).setTilingMode(3);
                ((IIOParam)object3).setDestinationOffset(((IIOParam)object).getDestinationOffset());
                ((IIOParam)object3).setSourceBands(((IIOParam)object).getSourceBands());
                ((IIOParam)object3).setSourceRegion(((IIOParam)object).getSourceRegion());
                n2 = ((IIOParam)object).getSourceXSubsampling();
                n3 = ((IIOParam)object).getSourceYSubsampling();
                n4 = ((IIOParam)object).getSubsamplingXOffset();
                n5 = ((IIOParam)object).getSubsamplingYOffset();
                object = object3;
            }
            object3 = this.replacePixelsMetadata.getTIFFField(258);
            if (object3 == null) {
                throw new IIOException("Cannot read destination BitsPerSample");
            }
            int[] nArray = ((TIFFField)object3).getAsInts();
            int[] nArray2 = renderedImage.getSampleModel().getSampleSize();
            int[] nArray3 = ((IIOParam)object).getSourceBands();
            if (nArray3 != null) {
                if (nArray3.length != nArray.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                n = 0;
                while (n < nArray3.length) {
                    if (nArray[n] != nArray2[nArray3[n]]) {
                        throw new IIOException("Source and destination have different BitsPerSample");
                    }
                    ++n;
                }
            } else {
                n = renderedImage.getSampleModel().getNumBands();
                if (n != nArray.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                int n6 = 0;
                while (n6 < n) {
                    if (nArray[n6] != nArray2[n6]) {
                        throw new IIOException("Source and destination have different BitsPerSample");
                    }
                    ++n6;
                }
            }
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            Rectangle rectangle2 = ((IIOParam)object).getSourceRegion();
            if (rectangle2 == null) {
                rectangle2 = rectangle;
            }
            int n7 = n2;
            int n8 = n3;
            int n9 = n4 + rectangle2.x;
            int n10 = n5 + rectangle2.y;
            if (!rectangle2.equals(rectangle) && (rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                throw new IllegalArgumentException("Source region does not intersect source image!");
            }
            Point point = ((IIOParam)object).getDestinationOffset();
            int n11 = TIFFImageWriter.XToTileX(rectangle2.x, n9, n7) + point.x;
            int n12 = TIFFImageWriter.YToTileY(rectangle2.y, n10, n8) + point.y;
            int n13 = TIFFImageWriter.XToTileX(rectangle2.x + rectangle2.width, n9, n7) + point.x;
            int n14 = TIFFImageWriter.YToTileY(rectangle2.y + rectangle2.height, n10, n8) + point.y;
            Rectangle rectangle3 = new Rectangle(point.x, point.y, n13 - n11, n14 - n12);
            if ((rectangle3 = rectangle3.intersection(this.replacePixelsRegion)).isEmpty()) {
                throw new IllegalArgumentException("Forward mapped source region does not intersect destination region!");
            }
            int n15 = (rectangle3.x - point.x) * n7 + n9;
            int n16 = (rectangle3.y - point.y) * n8 + n10;
            int n17 = (rectangle3.x + rectangle3.width - 1 - point.x) * n7 + n9;
            int n18 = n17 - n15 + 1;
            int n19 = (rectangle3.y + rectangle3.height - 1 - point.y) * n8 + n10;
            int n20 = n19 - n16 + 1;
            Rectangle rectangle4 = new Rectangle(n15, n16, n18, n20);
            if (rectangle4.intersection(rectangle).isEmpty()) {
                throw new IllegalArgumentException("Backward mapped destination region does not intersect source image!");
            }
            if (this.reader == null) {
                this.reader = new TIFFImageReader(new TIFFImageReaderSpi());
            } else {
                this.reader.reset();
            }
            this.stream.mark();
            try {
                this.stream.seek(this.headerPosition);
                this.reader.setInput(this.stream);
                this.imageMetadata = this.replacePixelsMetadata;
                this.param = object;
                SampleModel sampleModel = renderedImage.getSampleModel();
                ColorModel colorModel = renderedImage.getColorModel();
                this.numBands = sampleModel.getNumBands();
                this.imageType = new ImageTypeSpecifier(renderedImage);
                this.periodX = ((IIOParam)object).getSourceXSubsampling();
                this.periodY = ((IIOParam)object).getSourceYSubsampling();
                this.sourceBands = null;
                int[] nArray4 = ((IIOParam)object).getSourceBands();
                if (nArray4 != null) {
                    this.sourceBands = nArray4;
                    this.numBands = nArray3.length;
                }
                this.setupMetadata(colorModel, sampleModel, this.reader.getWidth(this.replacePixelsIndex), this.reader.getHeight(this.replacePixelsIndex));
                int[] nArray5 = sampleModel.getSampleSize();
                this.initializeScaleTables(nArray5);
                this.isBilevel = ImageUtil.isBinary(renderedImage.getSampleModel());
                this.isInverted = this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1;
                this.isImageSimple = (this.isBilevel || !this.isInverted && ImageUtil.imageIsContiguous(renderedImage)) && !this.isRescaling && nArray3 == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null;
                int n21 = TIFFImageWriter.XToTileX(rectangle3.x, 0, this.tileWidth);
                int n22 = TIFFImageWriter.YToTileY(rectangle3.y, 0, this.tileLength);
                int n23 = TIFFImageWriter.XToTileX(rectangle3.x + rectangle3.width - 1, 0, this.tileWidth);
                int n24 = TIFFImageWriter.YToTileY(rectangle3.y + rectangle3.height - 1, 0, this.tileLength);
                TIFFNullCompressor tIFFNullCompressor = new TIFFNullCompressor();
                tIFFNullCompressor.setWriter(this);
                tIFFNullCompressor.setStream(this.stream);
                tIFFNullCompressor.setMetadata(this.imageMetadata);
                Rectangle rectangle5 = new Rectangle();
                int n25 = n22;
                while (n25 <= n24) {
                    int n26 = n21;
                    while (n26 <= n23) {
                        block42: {
                            Raster raster;
                            WritableRaster writableRaster;
                            boolean bl;
                            int n27;
                            block41: {
                                Object object4;
                                block40: {
                                    n27 = n25 * this.tilesAcross + n26;
                                    boolean bl2 = bl = this.replacePixelsByteCounts[n27] == 0L;
                                    if (bl) {
                                        object4 = sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileLength);
                                        writableRaster = Raster.createWritableRaster((SampleModel)object4, null);
                                    } else {
                                        object4 = this.reader.readTile(this.replacePixelsIndex, n26, n25);
                                        writableRaster = ((BufferedImage)object4).getRaster();
                                    }
                                    rectangle5.setLocation(n26 * this.tileWidth, n25 * this.tileLength);
                                    rectangle5.setSize(writableRaster.getWidth(), writableRaster.getHeight());
                                    writableRaster = writableRaster.createWritableTranslatedChild(rectangle5.x, rectangle5.y);
                                    object4 = rectangle5.intersection(rectangle3);
                                    int n28 = (((Rectangle)object4).x - point.x) * n7 + n9;
                                    int n29 = (((Rectangle)object4).x + ((Rectangle)object4).width - 1 - point.x) * n7 + n9;
                                    int n30 = n29 - n28 + 1;
                                    int n31 = (((Rectangle)object4).y - point.y) * n8 + n10;
                                    int n32 = (((Rectangle)object4).y + ((Rectangle)object4).height - 1 - point.y) * n8 + n10;
                                    int n33 = n32 - n31 + 1;
                                    Rectangle rectangle6 = new Rectangle(n28, n31, n30, n33);
                                    raster = renderedImage.getData(rectangle6);
                                    if (n7 != 1 || n8 != 1 || n9 != 0 || n10 != 0) break block40;
                                    raster = raster.createChild(rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height, ((Rectangle)object4).x, ((Rectangle)object4).y, nArray3);
                                    break block41;
                                }
                                if ((raster = this.subsample(raster, nArray3, n9, n10, n7, n8, point.x, point.y, (Rectangle)object4)) == null) break block42;
                            }
                            writableRaster.setRect(raster);
                            if (bl) {
                                this.stream.seek(this.nextSpace);
                            } else {
                                this.stream.seek(this.replacePixelsTileOffsets[n27]);
                            }
                            this.image = new SingleTileRenderedImage(writableRaster, colorModel);
                            int n34 = this.writeTile(rectangle5, tIFFNullCompressor);
                            if (bl) {
                                this.stream.mark();
                                this.stream.seek(this.replacePixelsOffsetsPosition + (long)(4 * n27));
                                this.stream.writeInt((int)this.nextSpace);
                                this.stream.seek(this.replacePixelsByteCountsPosition + (long)(4 * n27));
                                this.stream.writeInt(n34);
                                this.stream.reset();
                                this.nextSpace += (long)n34;
                            }
                        }
                        ++n26;
                    }
                    ++n25;
                }
            }
            finally {
                this.stream.reset();
            }
        }
    }

    @Override
    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        if (raster == null) {
            throw new IllegalArgumentException("raster == null!");
        }
        this.replacePixels(new SingleTileRenderedImage(raster, this.image.getColorModel()), imageWriteParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endReplacePixels() throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            if (!this.inReplacePixelsNest) {
                throw new IllegalStateException("No previous call to prepareReplacePixels()!");
            }
            this.replacePixelsIndex = -1;
            this.replacePixelsMetadata = null;
            this.replacePixelsTileOffsets = null;
            this.replacePixelsByteCounts = null;
            this.replacePixelsOffsetsPosition = 0L;
            this.replacePixelsByteCountsPosition = 0L;
            this.replacePixelsRegion = null;
            this.inReplacePixelsNest = false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
        this.image = null;
        this.imageType = null;
        this.byteOrder = null;
        this.param = null;
        this.compressor = null;
        this.colorConverter = null;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.isWritingSequence = false;
        this.isWritingEmpty = false;
        this.isInsertingEmpty = false;
        this.replacePixelsIndex = -1;
        this.replacePixelsMetadata = null;
        this.replacePixelsTileOffsets = null;
        this.replacePixelsByteCounts = null;
        this.replacePixelsOffsetsPosition = 0L;
        this.replacePixelsByteCountsPosition = 0L;
        this.replacePixelsRegion = null;
        this.inReplacePixelsNest = false;
    }

    @Override
    public void dispose() {
        this.reset();
        super.dispose();
    }
}

