/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TIFFImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat";
    List tagSets;
    TIFFIFD rootIFD;
    private static final String[] colorSpaceNames = new String[]{"GRAY", "GRAY", "RGB", "RGB", "GRAY", "CMYK", "YCbCr", "Lab", "Lab"};
    private static final String[] orientationNames;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "Normal";
        stringArray[2] = "FlipH";
        stringArray[3] = "Rotate180";
        stringArray[4] = "FlipV";
        stringArray[5] = "FlipHRotate90";
        stringArray[6] = "Rotate270";
        stringArray[7] = "FlipVRotate90";
        stringArray[8] = "Rotate90";
        orientationNames = stringArray;
    }

    public TIFFImageMetadata(List list) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = list;
        this.rootIFD = new TIFFIFD(list);
    }

    public TIFFImageMetadata(TIFFIFD tIFFIFD) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = tIFFIFD.getTagSetList();
        this.rootIFD = tIFFIFD;
    }

    public void initializeFromStream(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.rootIFD.initialize(imageInputStream, bl);
    }

    public void addShortOrLongField(int n, int n2) {
        TIFFField tIFFField = new TIFFField(this.rootIFD.getTag(n), n2);
        this.rootIFD.addTIFFField(tIFFField);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private Node getIFDAsTree(TIFFIFD tIFFIFD, String string, int n) {
        Object object;
        Iterator iterator;
        List list;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("TIFFIFD");
        if (n != 0) {
            iIOMetadataNode.setAttribute("parentTagNumber", Integer.toString(n));
        }
        if (string != null) {
            iIOMetadataNode.setAttribute("parentTagName", string);
        }
        if ((list = tIFFIFD.getTagSetList()).size() > 0) {
            iterator = list.iterator();
            object = "";
            while (iterator.hasNext()) {
                TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
                object = String.valueOf(object) + tIFFTagSet.getClass().getName();
                if (!iterator.hasNext()) continue;
                object = String.valueOf(object) + ",";
            }
            iIOMetadataNode.setAttribute("tagSets", (String)object);
        }
        iterator = tIFFIFD.iterator();
        while (iterator.hasNext()) {
            object = (TIFFField)iterator.next();
            int n2 = ((TIFFField)object).getTagNumber();
            TIFFTag tIFFTag = TIFFIFD.getTag(n2, list);
            Node node = null;
            if (tIFFTag == null) {
                node = ((TIFFField)object).getAsNativeNode();
            } else if (tIFFTag.isIFDPointer()) {
                TIFFIFD tIFFIFD2 = (TIFFIFD)((TIFFField)object).getData();
                node = this.getIFDAsTree(tIFFIFD2, tIFFTag.getName(), tIFFTag.getNumber());
            } else {
                node = ((TIFFField)object).getAsNativeNode();
            }
            if (node == null) continue;
            iIOMetadataNode.appendChild(node);
        }
        return iIOMetadataNode;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        Node node = this.getIFDAsTree(this.rootIFD, null, 0);
        iIOMetadataNode.appendChild(node);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        int n = -1;
        boolean bl = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            n = tIFFField.getAsInt(0);
            bl = n == 3;
        }
        int n2 = -1;
        if (bl) {
            n2 = 3;
        } else {
            tIFFField = this.getTIFFField(277);
            if (tIFFField != null) {
                n2 = tIFFField.getAsInt(0);
            } else {
                tIFFField = this.getTIFFField(258);
                if (tIFFField != null) {
                    n2 = tIFFField.getCount();
                }
            }
        }
        if (n != -1) {
            if (n >= 0 && n < colorSpaceNames.length) {
                iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
                String string = n == 5 && n2 == 3 ? "CMY" : colorSpaceNames[n];
                iIOMetadataNode2.setAttribute("name", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
            iIOMetadataNode2.setAttribute("value", n == 0 ? "FALSE" : "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (n2 != -1) {
            iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode2.setAttribute("value", Integer.toString(n2));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if ((tIFFField = this.getTIFFField(320)) != null) {
            boolean bl2 = false;
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n3 = tIFFField.getCount() / (bl2 ? 4 : 3);
            int n4 = 0;
            while (n4 < n3) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n4));
                int n5 = tIFFField.getAsInt(n4) * 255 / 65535;
                int n6 = tIFFField.getAsInt(n3 + n4) * 255 / 65535;
                int n7 = tIFFField.getAsInt(2 * n3 + n4) * 255 / 65535;
                iIOMetadataNode3.setAttribute("red", Integer.toString(n5));
                iIOMetadataNode3.setAttribute("green", Integer.toString(n6));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(n7));
                if (bl2) {
                    int n8 = 0;
                    iIOMetadataNode3.setAttribute("alpha", Integer.toString(n8));
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                ++n4;
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        TIFFField tIFFField = this.getTIFFField(259);
        if (tIFFField != null) {
            String string = null;
            int n = tIFFField.getAsInt(0);
            boolean bl = true;
            if (n == 1) {
                string = "None";
                bl = true;
            } else {
                int[] nArray = TIFFImageWriter.compressionNumbers;
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (n == nArray[n2]) {
                        string = TIFFImageWriter.compressionTypes[n2];
                        bl = TIFFImageWriter.isCompressionLossless[n2];
                        break;
                    }
                    ++n2;
                }
            }
            if (string != null) {
                iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                iIOMetadataNode2 = new IIOMetadataNode("Lossless");
                iIOMetadataNode2.setAttribute("value", bl ? "TRUE" : "FALSE");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private String repeat(String string, int n) {
        if (n == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((string.length() + 1) * n - 1);
        stringBuffer.append(string);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    @Override
    public IIOMetadataNode getStandardDataNode() {
        int n;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        boolean bl = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            bl = tIFFField.getAsInt(0) == 3;
        }
        tIFFField = this.getTIFFField(284);
        String string = "PixelInterleaved";
        if (tIFFField != null && tIFFField.getAsInt(0) == 2) {
            string = "PlaneInterleaved";
        }
        iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            int n2 = tIFFField.getAsInt(0);
            String string2 = "UnsignedIntegral";
            if (n2 == 3) {
                string2 = "Index";
            } else {
                tIFFField = this.getTIFFField(339);
                if (tIFFField != null) {
                    n = tIFFField.getAsInt(0);
                    string2 = n == 2 ? "SignedIntegral" : (n == 1 ? "UnsignedIntegral" : (n == 3 ? "Real" : null));
                }
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        tIFFField = this.getTIFFField(258);
        int[] nArray = null;
        if (tIFFField != null) {
            nArray = tIFFField.getAsInts();
        } else {
            int n3;
            tIFFField = this.getTIFFField(259);
            int n4 = n3 = tIFFField != null ? tIFFField.getAsInt(0) : 1;
            nArray = this.getTIFFField(34665) != null || n3 == 7 || n3 == 6 || this.getTIFFField(513) != null ? ((tIFFField = this.getTIFFField(262)) != null && (tIFFField.getAsInt(0) == 0 || tIFFField.getAsInt(0) == 1) ? new int[]{8} : new int[]{8, 8, 8}) : new int[]{1};
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Integer.toString(nArray[n]));
            ++n;
        }
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        if (bl) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuffer.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuffer.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(266);
        n = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < nArray.length) {
            if (n5 > 0) {
                stringBuffer.append(" ");
            }
            int n6 = nArray[n5] == 1 ? 7 : nArray[n5] - 1;
            int n7 = n == 1 ? n6 : 0;
            stringBuffer.append(Integer.toString(n7));
            ++n5;
        }
        iIOMetadataNode2 = new IIOMetadataNode("SampleMSB");
        if (bl) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuffer.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuffer.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        int n;
        float f;
        int n2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        long[] lArray = null;
        long[] lArray2 = null;
        TIFFField tIFFField = this.getTIFFField(282);
        if (tIFFField != null) {
            lArray = (long[])tIFFField.getAsRational(0).clone();
        }
        if ((tIFFField = this.getTIFFField(283)) != null) {
            lArray2 = (long[])tIFFField.getAsRational(0).clone();
        }
        if (lArray != null && lArray2 != null) {
            iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            float f2 = (float)((double)lArray[1] * (double)lArray2[0]) / (float)(lArray[0] * lArray2[1]);
            iIOMetadataNode2.setAttribute("value", Float.toString(f2));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (lArray != null || lArray2 != null) {
            tIFFField = this.getTIFFField(296);
            int n3 = tIFFField != null ? tIFFField.getAsInt(0) : 2;
            int n4 = n2 = n3 != 1 ? 1 : 0;
            if (n3 == 2) {
                if (lArray != null) {
                    lArray[0] = lArray[0] * 100L;
                    lArray[1] = lArray[1] * 254L;
                }
                if (lArray2 != null) {
                    lArray2[0] = lArray2[0] * 100L;
                    lArray2[1] = lArray2[1] * 254L;
                }
            }
            if (n2 != 0) {
                if (lArray != null) {
                    f = (float)(10.0 * (double)lArray[1] / (double)lArray[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
                if (lArray2 != null) {
                    f = (float)(10.0 * (double)lArray2[1] / (double)lArray2[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
            }
        }
        int n5 = n = (tIFFField = this.getTIFFField(296)) != null ? tIFFField.getAsInt(0) : 2;
        if (n == 2 || n == 3) {
            tIFFField = this.getTIFFField(286);
            if (tIFFField != null) {
                long[] lArray3 = tIFFField.getAsRational(0);
                f = (float)lArray3[0] / (float)lArray3[1];
                f = n == 2 ? (f *= 254.0f) : (f *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("HorizontalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            if ((tIFFField = this.getTIFFField(287)) != null) {
                long[] lArray4 = tIFFField.getAsRational(0);
                f = (float)lArray4[0] / (float)lArray4[1];
                f = n == 2 ? (f *= 254.0f) : (f *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("VerticalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(274)) != null && (n2 = tIFFField.getAsInt(0)) >= 0 && n2 < orientationNames.length) {
            iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
            iIOMetadataNode2.setAttribute("value", orientationNames[n2]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", "6.0");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        TIFFField tIFFField = this.getTIFFField(254);
        if (tIFFField != null) {
            int n = tIFFField.getAsInt(0);
            String string2 = null;
            if ((n & 4) != 0) {
                string2 = "TransparencyMask";
            } else if ((n & 1) != 0) {
                string2 = "ReducedResolution";
            } else if ((n & 2) != 0) {
                string2 = "SinglePage";
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SubimageInterpretation");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(306)) != null && (string = tIFFField.getAsString(0)).length() == 19) {
            boolean bl;
            iIOMetadataNode2 = new IIOMetadataNode("ImageCreationTime");
            try {
                iIOMetadataNode2.setAttribute("year", string.substring(0, 4));
                iIOMetadataNode2.setAttribute("month", string.substring(5, 7));
                iIOMetadataNode2.setAttribute("day", string.substring(8, 10));
                iIOMetadataNode2.setAttribute("hour", string.substring(11, 13));
                iIOMetadataNode2.setAttribute("minute", string.substring(14, 16));
                iIOMetadataNode2.setAttribute("second", string.substring(17, 19));
                bl = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                bl = false;
            }
            if (bl) {
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = null;
        IIOMetadataNode iIOMetadataNode2 = null;
        int[] nArray = new int[]{269, 270, 271, 272, 285, 305, 315, 316, 333, 33432};
        int n = 0;
        while (n < nArray.length) {
            TIFFField tIFFField = this.getTIFFField(nArray[n]);
            if (tIFFField != null) {
                String string = tIFFField.getAsString(0);
                if (iIOMetadataNode == null) {
                    iIOMetadataNode = new IIOMetadataNode("Text");
                }
                iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", tIFFField.getTag().getName());
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            ++n;
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        String string = "none";
        TIFFField tIFFField = this.getTIFFField(338);
        if (tIFFField != null) {
            int[] nArray = tIFFField.getAsInts();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] == 1) {
                    string = "premultiplied";
                    break;
                }
                if (nArray[n] == 2) {
                    string = "nonpremultiplied";
                    break;
                }
                ++n;
            }
        }
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int[] listToIntArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n = new Integer((String)object);
            arrayList.add(n);
        }
        object = new int[arrayList.size()];
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return object;
    }

    private char[] listToCharArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n = new Integer((String)object);
            arrayList.add(n);
        }
        object = new char[arrayList.size()];
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (char)((Integer)arrayList.get(n)).intValue();
            ++n;
        }
        return object;
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        TIFFField tIFFField;
        TIFFTag tIFFTag;
        Object object;
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            TIFFImageMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        String string = null;
        Node node3 = this.getChildNode(node, "Data");
        boolean bl = false;
        if (node3 != null && (object = this.getChildNode(node3, "SampleFormat")) != null) {
            string = TIFFImageMetadata.getAttribute((Node)object, "value");
            bl = string.equals("Index");
        }
        if (!bl && (object = this.getChildNode(node, "Chroma")) != null && this.getChildNode((Node)object, "Palette") != null) {
            bl = true;
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            int n;
            int n2;
            object = node2.getNodeName();
            if (((String)object).equals("Chroma")) {
                String string2;
                Object object2;
                Object object3;
                int n3;
                String string3 = null;
                String string4 = null;
                boolean bl2 = false;
                Node node4 = node2.getFirstChild();
                while (node4 != null) {
                    String string5 = node4.getNodeName();
                    if (string5.equals("ColorSpaceType")) {
                        string3 = TIFFImageMetadata.getAttribute(node4, "name");
                    } else if (string5.equals("NumChannels")) {
                        tIFFTag = this.rootIFD.getTag(277);
                        n3 = bl ? 1 : Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "value"));
                        tIFFField = new TIFFField(tIFFTag, n3);
                        this.rootIFD.addTIFFField(tIFFField);
                    } else if (string5.equals("BlackIsZero")) {
                        string4 = TIFFImageMetadata.getAttribute(node4, "value");
                    } else if (string5.equals("Palette")) {
                        Node node5 = node4.getFirstChild();
                        object3 = new HashMap();
                        int n4 = -1;
                        while (node5 != null) {
                            object2 = node5.getNodeName();
                            if (((String)object2).equals("PaletteEntry")) {
                                string2 = TIFFImageMetadata.getAttribute(node5, "index");
                                n2 = Integer.parseInt(string2);
                                if (n2 > n4) {
                                    n4 = n2;
                                }
                                char c = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node5, "red"));
                                char c2 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node5, "green"));
                                char c3 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node5, "blue"));
                                ((HashMap)object3).put(new Integer(n2), new char[]{c, c2, c3});
                                bl2 = true;
                            }
                            node5 = node5.getNextSibling();
                        }
                        if (bl2) {
                            int n5 = n4 + 1;
                            int n6 = 3 * n5;
                            char[] cArray = new char[n6];
                            for (Integer n7 : ((HashMap)object3).keySet()) {
                                char[] cArray2 = (char[])((HashMap)object3).get(n7);
                                n = n7;
                                cArray[n] = (char)(cArray2[0] * 65535 / 255);
                                cArray[n5 + n] = (char)(cArray2[1] * 65535 / 255);
                                cArray[2 * n5 + n] = (char)(cArray2[2] * 65535 / 255);
                            }
                            tIFFTag = this.rootIFD.getTag(320);
                            tIFFField = new TIFFField(tIFFTag, 3, n6, cArray);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    node4 = node4.getNextSibling();
                }
                int n8 = -1;
                if ((string3 == null || string3.equals("GRAY")) && string4 != null && string4.equalsIgnoreCase("FALSE")) {
                    n8 = 0;
                } else if (string3 != null) {
                    if (string3.equals("GRAY")) {
                        NodeList nodeList;
                        n3 = 0;
                        if (node instanceof IIOMetadataNode && (nodeList = ((IIOMetadataNode)(object3 = (IIOMetadataNode)node)).getElementsByTagName("SubimageInterpretation")).getLength() == 1 && (string2 = TIFFImageMetadata.getAttribute((Node)(object2 = nodeList.item(0)), "value")).equals("TransparencyMask")) {
                            n3 = 1;
                        }
                        n8 = n3 != 0 ? 4 : 1;
                    } else if (string3.equals("RGB")) {
                        n8 = bl2 ? 3 : 2;
                    } else if (string3.equals("YCbCr")) {
                        n8 = 6;
                    } else if (string3.equals("CMYK")) {
                        n8 = 5;
                    } else if (string3.equals("Lab")) {
                        n8 = 8;
                    }
                }
                if (n8 != -1) {
                    tIFFTag = this.rootIFD.getTag(262);
                    tIFFField = new TIFFField(tIFFTag, n8);
                    this.rootIFD.addTIFFField(tIFFField);
                }
            } else if (((String)object).equals("Compression")) {
                Node node6 = node2.getFirstChild();
                while (node6 != null) {
                    String string6 = node6.getNodeName();
                    if (string6.equals("CompressionTypeName")) {
                        int n9 = -1;
                        String string7 = TIFFImageMetadata.getAttribute(node6, "value");
                        if (string7.equalsIgnoreCase("None")) {
                            n9 = 1;
                        } else {
                            String[] stringArray = TIFFImageWriter.compressionTypes;
                            int n10 = 0;
                            while (n10 < stringArray.length) {
                                if (stringArray[n10].equalsIgnoreCase(string7)) {
                                    n9 = TIFFImageWriter.compressionNumbers[n10];
                                    break;
                                }
                                ++n10;
                            }
                        }
                        if (n9 != -1) {
                            tIFFTag = this.rootIFD.getTag(259);
                            tIFFField = new TIFFField(tIFFTag, n9);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    node6 = node6.getNextSibling();
                }
            } else if (((String)object).equals("Data")) {
                Node node7 = node2.getFirstChild();
                while (node7 != null) {
                    String string8;
                    String string9 = node7.getNodeName();
                    if (string9.equals("PlanarConfiguration")) {
                        string8 = TIFFImageMetadata.getAttribute(node7, "value");
                        int n11 = -1;
                        if (string8.equals("PixelInterleaved")) {
                            n11 = 1;
                        } else if (string8.equals("PlaneInterleaved")) {
                            n11 = 2;
                        }
                        if (n11 != -1) {
                            tIFFTag = this.rootIFD.getTag(284);
                            tIFFField = new TIFFField(tIFFTag, n11);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    } else if (string9.equals("BitsPerSample")) {
                        string8 = TIFFImageMetadata.getAttribute(node7, "value");
                        char[] cArray = this.listToCharArray(string8);
                        tIFFTag = this.rootIFD.getTag(258);
                        tIFFField = bl ? new TIFFField(tIFFTag, 3, 1, new char[]{cArray[0]}) : new TIFFField(tIFFTag, 3, cArray.length, cArray);
                        this.rootIFD.addTIFFField(tIFFField);
                    } else if (string9.equals("SampleMSB")) {
                        string8 = TIFFImageMetadata.getAttribute(node7, "value");
                        int[] nArray = this.listToIntArray(string8);
                        boolean bl3 = true;
                        int n12 = 0;
                        while (n12 < nArray.length) {
                            if (nArray[n12] != 0) {
                                bl3 = false;
                                break;
                            }
                            ++n12;
                        }
                        n12 = bl3 ? 2 : 1;
                        tIFFTag = this.rootIFD.getTag(266);
                        tIFFField = new TIFFField(tIFFTag, n12);
                        this.rootIFD.addTIFFField(tIFFField);
                    }
                    node7 = node7.getNextSibling();
                }
            } else if (((String)object).equals("Dimension")) {
                float f = -1.0f;
                boolean bl4 = false;
                float f2 = -1.0f;
                boolean bl5 = false;
                float f3 = -1.0f;
                boolean bl6 = false;
                boolean bl7 = false;
                float f4 = -1.0f;
                boolean bl8 = false;
                float f5 = -1.0f;
                n2 = 0;
                Node node8 = node2.getFirstChild();
                while (node8 != null) {
                    String string10;
                    String string11 = node8.getNodeName();
                    if (string11.equals("PixelAspectRatio")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        f = Float.parseFloat(string10);
                        bl4 = true;
                    } else if (string11.equals("ImageOrientation")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        n = 0;
                        while (n < orientationNames.length) {
                            if (string10.equals(orientationNames[n])) {
                                char[] cArray = new char[]{(char)n};
                                tIFFField = new TIFFField(this.rootIFD.getTag(274), 3, 1, cArray);
                                this.rootIFD.addTIFFField(tIFFField);
                                break;
                            }
                            ++n;
                        }
                    } else if (string11.equals("HorizontalPixelSize")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        f2 = Float.parseFloat(string10);
                        bl5 = true;
                    } else if (string11.equals("VerticalPixelSize")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        f3 = Float.parseFloat(string10);
                        bl6 = true;
                    } else if (string11.equals("HorizontalPosition")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        f4 = Float.parseFloat(string10);
                        bl8 = true;
                    } else if (string11.equals("VerticalPosition")) {
                        string10 = TIFFImageMetadata.getAttribute(node8, "value");
                        f5 = Float.parseFloat(string10);
                        n2 = 1;
                    }
                    node8 = node8.getNextSibling();
                }
                boolean bl9 = bl7 = bl5 || bl6;
                if (bl4) {
                    if (bl5 && !bl6) {
                        f3 = f2 / f;
                        bl6 = true;
                    } else if (bl6 && !bl5) {
                        f2 = f3 * f;
                        bl5 = true;
                    } else if (!bl5 && !bl6) {
                        f2 = f;
                        f3 = 1.0f;
                        bl5 = true;
                        bl6 = true;
                    }
                }
                if (bl5) {
                    float f6 = (bl7 ? 10.0f : 1.0f) / f2;
                    long[][] lArray = new long[1][2];
                    lArray[0] = new long[2];
                    lArray[0][0] = (long)(f6 * 10000.0f);
                    lArray[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(282), 5, 1, lArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (bl6) {
                    float f7 = (bl7 ? 10.0f : 1.0f) / f3;
                    long[][] lArray = new long[1][2];
                    lArray[0] = new long[2];
                    lArray[0][0] = (long)(f7 * 10000.0f);
                    lArray[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(283), 5, 1, lArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                char[] cArray = new char[]{(char)(bl7 ? 3 : 1)};
                tIFFField = new TIFFField(this.rootIFD.getTag(296), 3, 1, cArray);
                this.rootIFD.addTIFFField(tIFFField);
                if (bl7) {
                    if (bl8) {
                        long[][] lArray = new long[1][2];
                        lArray[0][0] = (long)(f4 * 10000.0f);
                        lArray[0][1] = 100000L;
                        tIFFField = new TIFFField(this.rootIFD.getTag(286), 5, 1, lArray);
                        this.rootIFD.addTIFFField(tIFFField);
                    }
                    if (n2 != 0) {
                        long[][] lArray = new long[1][2];
                        lArray[0][0] = (long)(f5 * 10000.0f);
                        lArray[0][1] = 100000L;
                        tIFFField = new TIFFField(this.rootIFD.getTag(287), 5, 1, lArray);
                        this.rootIFD.addTIFFField(tIFFField);
                    }
                }
            } else if (((String)object).equals("Document")) {
                Node node9 = node2.getFirstChild();
                while (node9 != null) {
                    String string12;
                    String string13 = node9.getNodeName();
                    if (string13.equals("SubimageInterpretation")) {
                        string12 = TIFFImageMetadata.getAttribute(node9, "value");
                        int n13 = -1;
                        if (string12.equals("TransparencyMask")) {
                            n13 = 4;
                        } else if (string12.equals("ReducedResolution")) {
                            n13 = 1;
                        } else if (string12.equals("SinglePage")) {
                            n13 = 2;
                        }
                        if (n13 != -1) {
                            tIFFTag = this.rootIFD.getTag(254);
                            tIFFField = new TIFFField(tIFFTag, n13);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    if (string13.equals("ImageCreationTime")) {
                        string12 = TIFFImageMetadata.getAttribute(node9, "year");
                        String string14 = TIFFImageMetadata.getAttribute(node9, "month");
                        String string15 = TIFFImageMetadata.getAttribute(node9, "day");
                        String string16 = TIFFImageMetadata.getAttribute(node9, "hour");
                        String string17 = TIFFImageMetadata.getAttribute(node9, "minute");
                        String string18 = TIFFImageMetadata.getAttribute(node9, "second");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string12);
                        stringBuffer.append(":");
                        if (string14.length() == 1) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string14);
                        stringBuffer.append(":");
                        if (string15.length() == 1) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string15);
                        stringBuffer.append(" ");
                        if (string16.length() == 1) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string16);
                        stringBuffer.append(":");
                        if (string17.length() == 1) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string17);
                        stringBuffer.append(":");
                        if (string18.length() == 1) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string18);
                        String[] stringArray = new String[]{stringBuffer.toString()};
                        tIFFField = new TIFFField(this.rootIFD.getTag(306), 2, 1, stringArray);
                        this.rootIFD.addTIFFField(tIFFField);
                    }
                    node9 = node9.getNextSibling();
                }
            } else if (((String)object).equals("Text")) {
                Node node10 = node2.getFirstChild();
                String string19 = null;
                String string20 = null;
                String string21 = null;
                while (node10 != null) {
                    String string22 = node10.getNodeName();
                    if (string22.equals("TextEntry")) {
                        int n14 = -1;
                        NamedNodeMap namedNodeMap = node10.getAttributes();
                        Node node11 = namedNodeMap.getNamedItem("keyword");
                        if (node11 != null) {
                            String string23 = node11.getNodeValue();
                            String string24 = TIFFImageMetadata.getAttribute(node10, "value");
                            if (!string23.equals("") && !string24.equals("")) {
                                if (string23.equalsIgnoreCase("DocumentName")) {
                                    n14 = 269;
                                } else if (string23.equalsIgnoreCase("ImageDescription")) {
                                    n14 = 270;
                                } else if (string23.equalsIgnoreCase("Make")) {
                                    n14 = 271;
                                } else if (string23.equalsIgnoreCase("Model")) {
                                    n14 = 272;
                                } else if (string23.equalsIgnoreCase("PageName")) {
                                    n14 = 285;
                                } else if (string23.equalsIgnoreCase("Software")) {
                                    n14 = 305;
                                } else if (string23.equalsIgnoreCase("Artist")) {
                                    n14 = 315;
                                } else if (string23.equalsIgnoreCase("HostComputer")) {
                                    n14 = 316;
                                } else if (string23.equalsIgnoreCase("InkNames")) {
                                    n14 = 333;
                                } else if (string23.equalsIgnoreCase("Copyright")) {
                                    n14 = 33432;
                                } else if (string23.equalsIgnoreCase("author")) {
                                    string19 = string24;
                                } else if (string23.equalsIgnoreCase("description")) {
                                    string20 = string24;
                                } else if (string23.equalsIgnoreCase("title")) {
                                    string21 = string24;
                                }
                                if (n14 != -1) {
                                    tIFFField = new TIFFField(this.rootIFD.getTag(n14), 2, 1, new String[]{string24});
                                    this.rootIFD.addTIFFField(tIFFField);
                                }
                            }
                        }
                    }
                    node10 = node10.getNextSibling();
                }
                if (string19 != null && this.getTIFFField(315) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(315), 2, 1, new String[]{string19});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (string20 != null && this.getTIFFField(270) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(270), 2, 1, new String[]{string20});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (string21 != null && this.getTIFFField(269) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(269), 2, 1, new String[]{string21});
                    this.rootIFD.addTIFFField(tIFFField);
                }
            } else if (((String)object).equals("Transparency")) {
                Node node12 = node2.getFirstChild();
                while (node12 != null) {
                    String string25 = node12.getNodeName();
                    if (string25.equals("Alpha")) {
                        String string26 = TIFFImageMetadata.getAttribute(node12, "value");
                        tIFFField = null;
                        if (string26.equals("premultiplied")) {
                            tIFFField = new TIFFField(this.rootIFD.getTag(338), 1);
                        } else if (string26.equals("nonpremultiplied")) {
                            tIFFField = new TIFFField(this.rootIFD.getTag(338), 2);
                        }
                        if (tIFFField != null) {
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    node12 = node12.getNextSibling();
                }
            }
            node2 = node2.getNextSibling();
        }
        if (string != null) {
            int n = -1;
            if (string.equals("SignedIntegral")) {
                n = 2;
            } else if (string.equals("UnsignedIntegral")) {
                n = 1;
            } else if (string.equals("Real")) {
                n = 3;
            } else if (string.equals("Index")) {
                n = 1;
            }
            if (n != -1) {
                int n15 = 1;
                tIFFField = this.getTIFFField(277);
                if (tIFFField != null) {
                    n15 = tIFFField.getAsInt(0);
                } else {
                    tIFFField = this.getTIFFField(258);
                    if (tIFFField != null) {
                        n15 = tIFFField.getCount();
                    }
                }
                char[] cArray = new char[n15];
                Arrays.fill(cArray, (char)n);
                tIFFTag = this.rootIFD.getTag(339);
                tIFFField = new TIFFField(tIFFTag, 3, cArray.length, cArray);
                this.rootIFD.addTIFFField(tIFFField);
            }
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private Node getChildNode(Node node, String string) {
        Node node2 = null;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeName().equals(string)) {
                    node2 = node3;
                    break;
                }
                ++n2;
            }
        }
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    public static TIFFIFD parseIFD(Node node) throws IIOInvalidTreeException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        if (!node.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Expected \"TIFFIFD\" node");
        }
        String string2 = TIFFImageMetadata.getAttribute(node, "tagSets");
        ArrayList<TIFFTagSet> arrayList = new ArrayList<TIFFTagSet>(5);
        if (string2 != null) {
            object4 = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string = ((StringTokenizer)object4).nextToken();
                object3 = null;
                try {
                    object2 = Class.forName(string);
                    object = ((Class)object2).getMethod("getInstance", null);
                    object3 = ((Method)object).invoke(null, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                if (!(object3 instanceof TIFFTagSet)) {
                    TIFFImageMetadata.fatal(node, "Specified tag set class \"" + string + "\" is not an instance of TIFFTagSet");
                    continue;
                }
                arrayList.add((TIFFTagSet)object3);
            }
        }
        object4 = new TIFFIFD(arrayList);
        node = node.getFirstChild();
        while (node != null) {
            string = node.getNodeName();
            object3 = null;
            if (string.equals("TIFFIFD")) {
                void var9_20;
                void var9_18;
                int n;
                object2 = TIFFImageMetadata.parseIFD(node);
                object = TIFFImageMetadata.getAttribute(node, "parentTagName");
                String string3 = TIFFImageMetadata.getAttribute(node, "parentTagNumber");
                Object var9_15 = null;
                if (object != null) {
                    TIFFTag tIFFTag = TIFFIFD.getTag((String)object, arrayList);
                } else if (string3 != null) {
                    n = Integer.valueOf(string3);
                    TIFFTag tIFFTag = TIFFIFD.getTag(n, arrayList);
                }
                if (var9_18 == null) {
                    TIFFTag tIFFTag = new TIFFTag("unknown", 0, 0, null);
                }
                n = var9_20.isDataTypeOK(13) ? 13 : 4;
                object3 = new TIFFField((TIFFTag)var9_20, n, 1, object2);
            } else if (string.equals("TIFFField")) {
                int n = Integer.parseInt(TIFFImageMetadata.getAttribute(node, "number"));
                object = null;
                for (TIFFTagSet tIFFTagSet : arrayList) {
                    if (tIFFTagSet.getTag(n) == null) continue;
                    object = tIFFTagSet;
                    break;
                }
                object3 = TIFFField.createFromMetadataNode((TIFFTagSet)object, node);
            } else {
                TIFFImageMetadata.fatal(node, "Expected either \"TIFFIFD\" or \"TIFFField\" node, got " + string);
            }
            ((TIFFDirectory)object4).addTIFFField((TIFFField)object3);
            node = node.getNextSibling();
        }
        return object4;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Iterator iterator2;
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFImageMetadata.fatal(node2, "Root must be com_sun_media_imageio_plugins_tiff_image_1.0");
        }
        if ((node2 = node2.getFirstChild()) == null || !node2.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Root must have \"TIFFIFD\" child");
        }
        TIFFIFD tIFFIFD = TIFFImageMetadata.parseIFD(node2);
        List list = this.rootIFD.getTagSetList();
        for (Iterator iterator2 : tIFFIFD.getTagSetList()) {
            if (!(iterator2 instanceof TIFFTagSet) || list.contains(iterator2)) continue;
            this.rootIFD.addTagSet((TIFFTagSet)((Object)iterator2));
        }
        iterator2 = tIFFIFD.iterator();
        while (iterator2.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator2.next();
            this.rootIFD.addTIFFField(tIFFField);
        }
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    @Override
    public void reset() {
        this.rootIFD = new TIFFIFD(this.tagSets);
    }

    public TIFFIFD getRootIFD() {
        return this.rootIFD;
    }

    public TIFFField getTIFFField(int n) {
        return this.rootIFD.getTIFFField(n);
    }

    public void removeTIFFField(int n) {
        this.rootIFD.removeTIFFField(n);
    }

    public TIFFImageMetadata getShallowClone() {
        return new TIFFImageMetadata(this.rootIFD.getShallowClone());
    }
}

