/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class TIFFIFD
extends TIFFDirectory {
    private long stripOrTileByteCountsPosition = -1L;
    private long stripOrTileOffsetsPosition = -1L;
    private long lastPosition = -1L;

    public static TIFFTag getTag(int n, List list) {
        for (TIFFTagSet tIFFTagSet : list) {
            TIFFTag tIFFTag = tIFFTagSet.getTag(n);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    public static TIFFTag getTag(String string, List list) {
        for (TIFFTagSet tIFFTagSet : list) {
            TIFFTag tIFFTag = tIFFTagSet.getTag(string);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    private static void writeTIFFFieldToStream(TIFFField tIFFField, ImageOutputStream imageOutputStream) throws IOException {
        int n = tIFFField.getCount();
        Object object = tIFFField.getData();
        switch (tIFFField.getType()) {
            case 2: {
                int n2 = 0;
                while (n2 < n) {
                    String string = ((String[])object)[n2];
                    int n3 = string.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        imageOutputStream.writeByte(string.charAt(n4) & 0xFF);
                        ++n4;
                    }
                    imageOutputStream.writeByte(0);
                    ++n2;
                }
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                imageOutputStream.write((byte[])object);
                break;
            }
            case 3: {
                imageOutputStream.writeChars((char[])object, 0, ((char[])object).length);
                break;
            }
            case 8: {
                imageOutputStream.writeShorts((short[])object, 0, ((short[])object).length);
                break;
            }
            case 9: {
                imageOutputStream.writeInts((int[])object, 0, ((int[])object).length);
                break;
            }
            case 4: {
                int n5 = 0;
                while (n5 < n) {
                    imageOutputStream.writeInt((int)((long[])object)[n5]);
                    ++n5;
                }
                break;
            }
            case 13: {
                imageOutputStream.writeInt(0);
                break;
            }
            case 11: {
                imageOutputStream.writeFloats((float[])object, 0, ((float[])object).length);
                break;
            }
            case 12: {
                imageOutputStream.writeDoubles((double[])object, 0, ((double[])object).length);
                break;
            }
            case 10: {
                int n6 = 0;
                while (n6 < n) {
                    imageOutputStream.writeInt(((int[][])object)[n6][0]);
                    imageOutputStream.writeInt(((int[][])object)[n6][1]);
                    ++n6;
                }
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < n) {
                    long l = ((long[][])object)[n7][0];
                    long l2 = ((long[][])object)[n7][1];
                    imageOutputStream.writeInt((int)l);
                    imageOutputStream.writeInt((int)l2);
                    ++n7;
                }
                break;
            }
        }
    }

    public TIFFIFD(List list, TIFFTag tIFFTag) {
        super(list.toArray(new TIFFTagSet[list.size()]), tIFFTag);
    }

    public TIFFIFD(List list) {
        this(list, null);
    }

    public List getTagSetList() {
        return Arrays.asList(this.getTagSets());
    }

    public Iterator iterator() {
        return Arrays.asList(this.getTIFFFields()).iterator();
    }

    public void initialize(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.removeTIFFFields();
        List list = this.getTagSetList();
        int n = imageInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            int n3 = imageInputStream.readUnsignedShort();
            int n4 = imageInputStream.readUnsignedShort();
            int n5 = (int)imageInputStream.readUnsignedInt();
            TIFFTag tIFFTag = TIFFIFD.getTag(n3, list);
            if (bl && tIFFTag == null) {
                imageInputStream.skipBytes(4);
            } else {
                Object object;
                Object object2;
                Object object3;
                long l;
                block40: {
                    l = imageInputStream.getStreamPosition() + 4L;
                    int n6 = TIFFTag.getSizeOfType(n4);
                    if (n5 * n6 > 4) {
                        long l2 = imageInputStream.readUnsignedInt();
                        imageInputStream.seek(l2);
                    }
                    if (n3 == 279 || n3 == 325 || n3 == 514) {
                        this.stripOrTileByteCountsPosition = imageInputStream.getStreamPosition();
                    } else if (n3 == 273 || n3 == 324 || n3 == 513) {
                        this.stripOrTileOffsetsPosition = imageInputStream.getStreamPosition();
                    }
                    object3 = null;
                    try {
                        switch (n4) {
                            case 1: 
                            case 2: 
                            case 6: 
                            case 7: {
                                object2 = new byte[n5];
                                imageInputStream.readFully((byte[])object2, 0, n5);
                                if (n4 == 2) {
                                    String[] stringArray;
                                    object = new Vector();
                                    boolean bl2 = false;
                                    int n7 = 0;
                                    int n8 = 0;
                                    while (n8 <= n5) {
                                        if (n8 < n5 && object2[n8] != false) {
                                            if (!bl2) {
                                                n7 = n8;
                                                bl2 = true;
                                            }
                                        } else if (bl2) {
                                            String string = new String((byte[])object2, n7, n8 - n7);
                                            ((Vector)object).add(string);
                                            bl2 = false;
                                        }
                                        ++n8;
                                    }
                                    n5 = ((Vector)object).size();
                                    if (n5 != 0) {
                                        stringArray = new String[n5];
                                        int n9 = 0;
                                        while (n9 < n5) {
                                            stringArray[n9] = (String)((Vector)object).elementAt(n9);
                                            ++n9;
                                        }
                                    } else {
                                        n5 = 1;
                                        stringArray = new String[]{""};
                                    }
                                    object3 = stringArray;
                                    break;
                                }
                                object3 = object2;
                                break;
                            }
                            case 3: {
                                object = new char[n5];
                                int n10 = 0;
                                while (n10 < n5) {
                                    object[n10] = (char)imageInputStream.readUnsignedShort();
                                    ++n10;
                                }
                                object3 = object;
                                break;
                            }
                            case 4: 
                            case 13: {
                                long[] lArray = new long[n5];
                                int n11 = 0;
                                while (n11 < n5) {
                                    lArray[n11] = imageInputStream.readUnsignedInt();
                                    ++n11;
                                }
                                object3 = lArray;
                                break;
                            }
                            case 5: {
                                long[][] lArray = new long[n5][2];
                                int n12 = 0;
                                while (n12 < n5) {
                                    lArray[n12][0] = imageInputStream.readUnsignedInt();
                                    lArray[n12][1] = imageInputStream.readUnsignedInt();
                                    ++n12;
                                }
                                object3 = lArray;
                                break;
                            }
                            case 8: {
                                short[] sArray = new short[n5];
                                int n13 = 0;
                                while (n13 < n5) {
                                    sArray[n13] = imageInputStream.readShort();
                                    ++n13;
                                }
                                object3 = sArray;
                                break;
                            }
                            case 9: {
                                int[] nArray = new int[n5];
                                int n14 = 0;
                                while (n14 < n5) {
                                    nArray[n14] = imageInputStream.readInt();
                                    ++n14;
                                }
                                object3 = nArray;
                                break;
                            }
                            case 10: {
                                int[][] nArray = new int[n5][2];
                                int n15 = 0;
                                while (n15 < n5) {
                                    nArray[n15][0] = imageInputStream.readInt();
                                    nArray[n15][1] = imageInputStream.readInt();
                                    ++n15;
                                }
                                object3 = nArray;
                                break;
                            }
                            case 11: {
                                float[] fArray = new float[n5];
                                int n16 = 0;
                                while (n16 < n5) {
                                    fArray[n16] = imageInputStream.readFloat();
                                    ++n16;
                                }
                                object3 = fArray;
                                break;
                            }
                            case 12: {
                                double[] dArray = new double[n5];
                                int n17 = 0;
                                while (n17 < n5) {
                                    dArray[n17] = imageInputStream.readDouble();
                                    ++n17;
                                }
                                object3 = dArray;
                                break;
                            }
                        }
                    }
                    catch (EOFException eOFException) {
                        if (BaselineTIFFTagSet.getInstance().getTag(n3) != null) break block40;
                        throw eOFException;
                    }
                }
                if (tIFFTag != null && tIFFTag.isDataTypeOK(n4) && tIFFTag.isIFDPointer() && object3 != null) {
                    imageInputStream.mark();
                    imageInputStream.seek(((long[])object3)[0]);
                    object2 = new ArrayList(1);
                    object2.add(tIFFTag.getTagSet());
                    object = new TIFFIFD((List)object2);
                    ((TIFFIFD)object).initialize(imageInputStream, bl);
                    object3 = object;
                    imageInputStream.reset();
                }
                if (tIFFTag == null) {
                    tIFFTag = new TIFFTag(null, n3, 1 << n4, null);
                }
                if (object3 != null) {
                    object2 = new TIFFField(tIFFTag, n4, n5, object3);
                    this.addTIFFField((TIFFField)object2);
                }
                imageInputStream.seek(l);
            }
            ++n2;
        }
        this.lastPosition = imageInputStream.getStreamPosition();
    }

    public void writeToStream(ImageOutputStream imageOutputStream) throws IOException {
        int n = this.getNumTIFFFields();
        imageOutputStream.writeShort(n);
        long l = imageOutputStream.getStreamPosition() + (long)(12 * n) + 4L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            long l2;
            int n2;
            TIFFField tIFFField = (TIFFField)iterator.next();
            TIFFTag tIFFTag = tIFFField.getTag();
            int n3 = tIFFField.getType();
            int n4 = tIFFField.getCount();
            if (n3 == 0) {
                n3 = 7;
            }
            int n5 = n4 * TIFFTag.getSizeOfType(n3);
            if (n3 == 2) {
                n2 = 0;
                int n6 = 0;
                while (n6 < n4) {
                    n2 += tIFFField.getAsString(n6).length() + 1;
                    ++n6;
                }
                n5 = n4 = n2;
            }
            n2 = tIFFField.getTagNumber();
            imageOutputStream.writeShort(n2);
            imageOutputStream.writeShort(n3);
            imageOutputStream.writeInt(n4);
            imageOutputStream.writeInt(0);
            imageOutputStream.mark();
            imageOutputStream.skipBytes(-4);
            if (n5 > 4 || tIFFTag.isIFDPointer()) {
                l = l + 3L & 0xFFFFFFFFFFFFFFFCL;
                imageOutputStream.writeInt((int)l);
                imageOutputStream.seek(l);
                l2 = l;
                if (tIFFTag.isIFDPointer()) {
                    TIFFIFD tIFFIFD = (TIFFIFD)tIFFField.getData();
                    tIFFIFD.writeToStream(imageOutputStream);
                    l = tIFFIFD.lastPosition;
                } else {
                    TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
                    l = imageOutputStream.getStreamPosition();
                }
            } else {
                l2 = imageOutputStream.getStreamPosition();
                TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
            }
            if (n2 == 279 || n2 == 325 || n2 == 514) {
                this.stripOrTileByteCountsPosition = l2;
            } else if (n2 == 273 || n2 == 324 || n2 == 513) {
                this.stripOrTileOffsetsPosition = l2;
            }
            imageOutputStream.reset();
        }
        this.lastPosition = l;
    }

    public long getStripOrTileByteCountsPosition() {
        return this.stripOrTileByteCountsPosition;
    }

    public long getStripOrTileOffsetsPosition() {
        return this.stripOrTileOffsetsPosition;
    }

    public long getLastPosition() {
        return this.lastPosition;
    }

    void setPositions(long l, long l2, long l3) {
        this.stripOrTileOffsetsPosition = l;
        this.stripOrTileByteCountsPosition = l2;
        this.lastPosition = l3;
    }

    public TIFFIFD getShallowClone() {
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        List list = this.getTagSetList();
        if (!list.contains(baselineTIFFTagSet)) {
            return this;
        }
        TIFFIFD tIFFIFD = new TIFFIFD(list, this.getParentTag());
        SortedSet sortedSet = baselineTIFFTagSet.getTagNumbers();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField;
            TIFFField tIFFField2 = (TIFFField)iterator.next();
            Integer n = new Integer(tIFFField2.getTagNumber());
            if (sortedSet.contains(n)) {
                Object object = tIFFField2.getData();
                int n2 = tIFFField2.getType();
                try {
                    switch (n2) {
                        case 1: 
                        case 6: 
                        case 7: {
                            object = ((byte[])object).clone();
                            break;
                        }
                        case 2: {
                            object = ((String[])object).clone();
                            break;
                        }
                        case 3: {
                            object = ((char[])object).clone();
                            break;
                        }
                        case 4: 
                        case 13: {
                            object = ((long[])object).clone();
                            break;
                        }
                        case 5: {
                            object = ((long[][])object).clone();
                            break;
                        }
                        case 8: {
                            object = ((short[])object).clone();
                            break;
                        }
                        case 9: {
                            object = ((int[])object).clone();
                            break;
                        }
                        case 10: {
                            object = ((int[][])object).clone();
                            break;
                        }
                        case 11: {
                            object = ((float[])object).clone();
                            break;
                        }
                        case 12: {
                            object = ((double[])object).clone();
                        }
                    }
                }
                catch (Exception exception) {}
                tIFFField = new TIFFField(tIFFField2.getTag(), n2, tIFFField2.getCount(), object);
            } else {
                tIFFField = tIFFField2;
            }
            tIFFIFD.addTIFFField(tIFFField);
        }
        tIFFIFD.setPositions(this.stripOrTileOffsetsPosition, this.stripOrTileByteCountsPosition, this.lastPosition);
        return tIFFIFD;
    }
}

