/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import java.util.Arrays;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private boolean isIFD;
    private Boolean isInitialized = Boolean.FALSE;
    private TIFFField field;

    private static String getNodeName(TIFFField tIFFField) {
        return tIFFField.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField tIFFField) {
        super(TIFFFieldNode.getNodeName(tIFFField));
        this.isIFD = tIFFField.getData() instanceof TIFFDirectory;
        this.field = tIFFField;
        TIFFTag tIFFTag = tIFFField.getTag();
        int n = tIFFTag.getNumber();
        String string = tIFFTag.getName();
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory;
            TIFFTagSet[] tIFFTagSetArray;
            if (n != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(n));
            }
            if (string != null) {
                this.setAttribute("parentTagName", string);
            }
            if ((tIFFTagSetArray = (tIFFDirectory = (TIFFDirectory)tIFFField.getData()).getTagSets()) != null) {
                String string2 = "";
                int n2 = 0;
                while (n2 < tIFFTagSetArray.length) {
                    string2 = String.valueOf(string2) + tIFFTagSetArray[n2].getClass().getName();
                    if (n2 != tIFFTagSetArray.length - 1) {
                        string2 = String.valueOf(string2) + ",";
                    }
                    ++n2;
                }
                this.setAttribute("tagSets", string2);
            }
        } else {
            this.setAttribute("number", Integer.toString(n));
            this.setAttribute("name", string);
        }
    }

    private synchronized void initialize() {
        if (this.isInitialized == Boolean.TRUE) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory = (TIFFDirectory)this.field.getData();
            TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
            if (tIFFFieldArray != null) {
                TIFFTagSet[] tIFFTagSetArray = tIFFDirectory.getTagSets();
                List<TIFFTagSet> list = Arrays.asList(tIFFTagSetArray);
                int n = tIFFFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TIFFField tIFFField = tIFFFieldArray[n2];
                    int n3 = tIFFField.getTagNumber();
                    TIFFIFD.getTag(n3, list);
                    Node node = tIFFField.getAsNativeNode();
                    if (node != null) {
                        this.appendChild(node);
                    }
                    ++n2;
                }
            }
        } else {
            IIOMetadataNode iIOMetadataNode;
            int n = this.field.getCount();
            if (this.field.getType() == 7) {
                iIOMetadataNode = new IIOMetadataNode("TIFFUndefined");
                byte[] byArray = this.field.getAsBytes();
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = 0;
                while (n4 < n) {
                    stringBuffer.append(Integer.toString(byArray[n4] & 0xFF));
                    if (n4 < n - 1) {
                        stringBuffer.append(",");
                    }
                    ++n4;
                }
                iIOMetadataNode.setAttribute("value", stringBuffer.toString());
            } else {
                iIOMetadataNode = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tIFFTag = this.field.getTag();
                int n5 = 0;
                while (n5 < n) {
                    int n6;
                    String string;
                    IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                    iIOMetadataNode2.setAttribute("value", this.field.getValueAsString(n5));
                    if (tIFFTag.hasValueNames() && this.field.isIntegral() && (string = tIFFTag.getValueName(n6 = this.field.getAsInt(n5))) != null) {
                        iIOMetadataNode2.setAttribute("description", string);
                    }
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                    ++n5;
                }
            }
            this.appendChild(iIOMetadataNode);
        }
        this.isInitialized = Boolean.TRUE;
    }

    @Override
    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(node, null);
    }

    @Override
    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    @Override
    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    @Override
    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    @Override
    public Node insertBefore(Node node, Node node2) {
        this.initialize();
        return super.insertBefore(node, node2);
    }

    @Override
    public Node replaceChild(Node node, Node node2) {
        this.initialize();
        return super.replaceChild(node, node2);
    }

    @Override
    public Node removeChild(Node node) {
        this.initialize();
        return super.removeChild(node);
    }

    @Override
    public Node cloneNode(boolean bl) {
        this.initialize();
        return super.cloneNode(bl);
    }
}

