/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageReader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;

public class RawRenderedImage
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private RawImageInputStream iis = null;
    private RawImageReader reader;
    private ImageReadParam param = null;
    private int imageIndex;
    private Rectangle destinationRegion;
    private Rectangle originalRegion;
    private Point sourceOrigin;
    private Dimension originalDimension;
    private int maxXTile;
    private int maxYTile;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    private long position;
    private long tileDataSize;
    private int originalNumXTiles;

    public RawRenderedImage(RawImageInputStream rawImageInputStream, RawImageReader rawImageReader, ImageReadParam imageReadParam, int n) throws IOException {
        int n2;
        this.iis = rawImageInputStream;
        this.reader = rawImageReader;
        this.param = imageReadParam;
        this.imageIndex = n;
        this.position = rawImageInputStream.getImageOffset(n);
        this.originalDimension = rawImageInputStream.getImageDimension(n);
        ImageTypeSpecifier imageTypeSpecifier = rawImageInputStream.getImageType();
        this.sampleModel = this.originalSampleModel = imageTypeSpecifier.getSampleModel();
        this.colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = this.sourceBands = imageReadParam == null ? null : imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.originalSampleModel.getNumBands();
            this.sourceBands = new int[this.nComp];
            n2 = 0;
            while (n2 < this.nComp) {
                this.sourceBands[n2] = n2;
                ++n2;
            }
        } else {
            this.sampleModel = this.originalSampleModel.createSubsetSampleModel(this.sourceBands);
            this.colorModel = ImageUtil.createColorModel(null, this.sampleModel);
        }
        this.nComp = this.sourceBands.length;
        int[] nArray2 = this.destinationBands = imageReadParam == null ? null : imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            n2 = 0;
            while (n2 < this.nComp) {
                this.destinationBands[n2] = n2;
                ++n2;
            }
        }
        Dimension dimension = rawImageInputStream.getImageDimension(n);
        this.width = dimension.width;
        this.height = dimension.height;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)rectangle.clone();
        this.destinationRegion = (Rectangle)rectangle.clone();
        if (imageReadParam != null) {
            RawImageReader.computeRegionsWrapper(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, this.destinationRegion);
            this.scaleX = imageReadParam.getSourceXSubsampling();
            this.scaleY = imageReadParam.getSourceYSubsampling();
            this.xOffset = imageReadParam.getSubsamplingXOffset();
            this.yOffset = imageReadParam.getSubsamplingYOffset();
        }
        this.sourceOrigin = new Point(rectangle.x, rectangle.y);
        if (!this.destinationRegion.equals(rectangle)) {
            this.noTransform = false;
        }
        this.tileDataSize = ImageUtil.getTileSize(this.originalSampleModel);
        this.tileWidth = this.originalSampleModel.getWidth();
        this.tileHeight = this.originalSampleModel.getHeight();
        this.tileGridXOffset = this.destinationRegion.x;
        this.tileGridYOffset = this.destinationRegion.y;
        this.originalNumXTiles = this.getNumXTiles();
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.maxXTile = this.originalDimension.width / this.tileWidth;
        this.maxYTile = this.originalDimension.height / this.tileHeight;
    }

    @Override
    public synchronized Raster getTile(int n, int n2) {
        block21: {
            if (this.currentTile != null && this.currentTileGrid.x == n && this.currentTileGrid.y == n2) {
                return this.currentTile;
            }
            if (n >= this.getNumXTiles() || n2 >= this.getNumYTiles()) {
                throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
            }
            try {
                this.iis.seek(this.position + (long)(n2 * this.originalNumXTiles + n) * this.tileDataSize);
                int n3 = this.tileXToX(n);
                int n4 = this.tileYToY(n2);
                this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
                if (this.noTransform) {
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            byte[][] byArray = ((DataBufferByte)this.currentTile.getDataBuffer()).getBankData();
                            int n5 = 0;
                            while (n5 < byArray.length) {
                                this.iis.readFully(byArray[n5], 0, byArray[n5].length);
                                ++n5;
                            }
                            break block21;
                        }
                        case 2: {
                            short[][] sArray = ((DataBufferShort)this.currentTile.getDataBuffer()).getBankData();
                            int n6 = 0;
                            while (n6 < sArray.length) {
                                this.iis.readFully(sArray[n6], 0, sArray[n6].length);
                                ++n6;
                            }
                            break block21;
                        }
                        case 1: {
                            short[][] sArray = ((DataBufferUShort)this.currentTile.getDataBuffer()).getBankData();
                            int n7 = 0;
                            while (n7 < sArray.length) {
                                this.iis.readFully(sArray[n7], 0, sArray[n7].length);
                                ++n7;
                            }
                            break block21;
                        }
                        case 3: {
                            int[][] nArray = ((DataBufferInt)this.currentTile.getDataBuffer()).getBankData();
                            int n8 = 0;
                            while (n8 < nArray.length) {
                                this.iis.readFully(nArray[n8], 0, nArray[n8].length);
                                ++n8;
                            }
                            break block21;
                        }
                        case 4: {
                            float[][] fArray = ((DataBufferFloat)this.currentTile.getDataBuffer()).getBankData();
                            int n9 = 0;
                            while (n9 < fArray.length) {
                                this.iis.readFully(fArray[n9], 0, fArray[n9].length);
                                ++n9;
                            }
                            break block21;
                        }
                        case 5: {
                            double[][] dArray = ((DataBufferDouble)this.currentTile.getDataBuffer()).getBankData();
                            int n10 = 0;
                            while (n10 < dArray.length) {
                                this.iis.readFully(dArray[n10], 0, dArray[n10].length);
                                ++n10;
                            }
                            break block1;
                        }
                    }
                    break block21;
                }
                this.currentTile = this.readSubsampledRaster((WritableRaster)this.currentTile);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n, n2);
        } else {
            this.currentTileGrid.x = n;
            this.currentTileGrid.y = n2;
        }
        return this.currentTile;
    }

    public void readAsRaster(WritableRaster writableRaster) throws IOException {
        this.readSubsampledRaster(writableRaster);
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        Object object;
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int n = this.sourceBands.length;
        int n2 = this.sampleModel.getDataType();
        int n3 = DataBuffer.getDataTypeSize(n2);
        int n4 = (n3 + 7) / 8;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n5 = this.destinationRegion.x;
        int n6 = this.destinationRegion.y;
        int n7 = (rectangle.x - n5) * this.scaleX + this.sourceOrigin.x;
        int n8 = (rectangle.y - n6) * this.scaleY + this.sourceOrigin.y;
        int n9 = (rectangle.width - 1) * this.scaleX + n7;
        int n10 = (rectangle.height - 1) * this.scaleY + n8;
        int n11 = n7 / this.tileWidth;
        int n12 = n8 / this.tileHeight;
        int n13 = n9 / this.tileWidth;
        int n14 = n10 / this.tileHeight;
        n11 = this.clip(n11, 0, this.maxXTile);
        n12 = this.clip(n12, 0, this.maxYTile);
        n13 = this.clip(n13, 0, this.maxXTile);
        n14 = this.clip(n14, 0, this.maxYTile);
        int n15 = this.getNumXTiles();
        int n16 = this.getNumYTiles();
        int n17 = n15 * n16;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (this.originalSampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)this.originalSampleModel;
            nArray3 = ((ComponentSampleModel)object).getBankIndices();
            int n21 = 0;
            int n22 = 0;
            while (n22 < nArray3.length) {
                if (n21 > nArray3[n22]) {
                    n21 = nArray3[n22];
                }
                ++n22;
            }
            if (n21 > 0) {
                // empty if block
            }
            n18 = ((ComponentSampleModel)object).getPixelStride();
            n19 = ((ComponentSampleModel)object).getScanlineStride();
            nArray2 = ((ComponentSampleModel)object).getBandOffsets();
            n22 = 0;
            while (n22 < nArray2.length) {
                if (n20 < nArray2[n22]) {
                    n20 = nArray2[n22];
                }
                ++n22;
            }
        } else if (this.originalSampleModel instanceof MultiPixelPackedSampleModel) {
            n19 = ((MultiPixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        } else if (this.originalSampleModel instanceof SinglePixelPackedSampleModel) {
            n18 = 1;
            n19 = ((SinglePixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        }
        object = null;
        short[] sArray2 = null;
        int[] nArray4 = null;
        float[] fArray2 = null;
        double[] dArray2 = null;
        int[] nArray5 = null;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
            nArray3 = componentSampleModel.getBankIndices();
            nArray5 = componentSampleModel.getBandOffsets();
            n23 = componentSampleModel.getPixelStride();
            n24 = componentSampleModel.getScanlineStride();
            n25 = componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY()) - nArray5[0];
            switch (n2) {
                case 0: {
                    object = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 2: {
                    sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 1: {
                    sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 3: {
                    nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 4: {
                    fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 5: {
                    dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData();
                }
            }
        } else if (writableRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            n = 1;
            nArray3 = new int[1];
            nArray5 = new int[n];
            int n26 = 0;
            while (n26 < n) {
                nArray5[n26] = 0;
                ++n26;
            }
            n23 = 1;
            n24 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        }
        int n27 = n12;
        while (n27 <= n14) {
            if (this.reader.getAbortRequest()) break;
            int n28 = n11;
            while (n28 <= n13) {
                int n29;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36;
                int n37;
                if (this.reader.getAbortRequest()) break;
                long l = this.position + (long)(n27 * this.originalNumXTiles + n28) * this.tileDataSize;
                this.iis.seek(l);
                float f = (n28 - n11 + n27 * n15) / n15;
                int n38 = n28 * this.tileWidth;
                int n39 = n27 * this.tileHeight;
                int n40 = this.tileHeight;
                int n41 = this.tileWidth;
                if (n39 + n40 >= this.originalDimension.height) {
                    n40 = this.originalDimension.height - n39;
                }
                if (n38 + n41 >= this.originalDimension.width) {
                    n41 = this.originalDimension.width - n38;
                }
                int n42 = n38;
                int n43 = n39;
                if (n7 > n38) {
                    n41 += n38 - n7;
                    n42 = n7;
                    n38 = n7;
                }
                if (n8 > n39) {
                    n40 += n39 - n8;
                    n43 = n8;
                    n39 = n8;
                }
                if (n9 < n38 + n41 - 1) {
                    n41 += n9 - n38 - n41 + 1;
                }
                if (n10 < n39 + n40 - 1) {
                    n40 += n10 - n39 - n40 + 1;
                }
                int n44 = (n38 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n45 = (n38 + this.scaleX - 1 + n41 - this.sourceOrigin.x) / this.scaleX;
                int n46 = n45 - n44;
                n45 = (n45 - 1) * this.scaleX + this.sourceOrigin.x;
                int n47 = (n39 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n38 = n44 * this.scaleX + this.sourceOrigin.x;
                n39 = n47 * this.scaleY + this.sourceOrigin.y;
                n44 += n5;
                n47 += n6;
                n42 -= n28 * this.tileWidth;
                n43 -= n27 * this.tileHeight;
                if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.originalSampleModel;
                    this.iis.skipBytes(multiPixelPackedSampleModel.getOffset(n42, n43) * n4);
                    n37 = (multiPixelPackedSampleModel.getOffset(n45, 0) - multiPixelPackedSampleModel.getOffset(n38, 0) + 1) * n4;
                    n36 = (n19 * this.scaleY - n37) * n4;
                    if (byArray == null || byArray.length < (n37 *= n4)) {
                        byArray = new byte[n37];
                    }
                    n35 = multiPixelPackedSampleModel.getBitOffset(n42);
                    n34 = 0;
                    n33 = n47;
                    while (n34 < n40) {
                        if (this.reader.getAbortRequest()) break;
                        this.iis.readFully(byArray, 0, n37);
                        if (this.scaleX == 1) {
                            if (n35 != 0) {
                                n32 = 255 << n35 & 0xFF;
                                n31 = ~n32 & 0xFF;
                                n30 = 8 - n35;
                                n29 = 0;
                                while (n29 < n37 - 1) {
                                    byArray[n29] = (byte)((byArray[n29] & n31) << n30 | (byArray[n29 + 1] & n32) >> n35);
                                    ++n29;
                                }
                                byArray[n29] = (byte)((byArray[n29] & n31) << n30);
                            }
                        } else {
                            n32 = 7;
                            n31 = 0;
                            n30 = 0;
                            n29 = n38 & 7;
                            while (n30 < n46) {
                                byArray[n31] = (byte)(byArray[n31] & ~(1 << n32) | (byArray[n29 >> 3] >> 7 - (n29 & 7) & 1) << n32);
                                if (--n32 == -1) {
                                    n32 = 7;
                                    ++n31;
                                }
                                ++n30;
                                n29 += this.scaleX;
                            }
                        }
                        ImageUtil.setPackedBinaryData(byArray, writableRaster, new Rectangle(n44, n33, n46, 1));
                        this.iis.skipBytes(n36);
                        if (this.destImage != null) {
                            this.reader.processImageUpdateWrapper(this.destImage, n44, n33, n41, 1, 1, 1, this.destinationBands);
                        }
                        this.reader.processImageProgressWrapper(f + ((float)(n34 - n39) + 1.0f) / (float)n40 / (float)n17);
                        n34 += this.scaleY;
                        ++n33;
                    }
                } else {
                    int n48;
                    int n49;
                    int n50;
                    int n51;
                    int n52;
                    int n53;
                    if (n18 < n19) {
                        n53 = n41 * n18;
                        n37 = (n19 * this.scaleY - n53) * n4;
                    } else {
                        n53 = n40 * n19;
                        n37 = (n18 * this.scaleX - n53) * n4;
                    }
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            if (byArray != null && byArray.length >= n53) break;
                            byArray = new byte[n53];
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (sArray != null && sArray.length >= n53) break;
                            sArray = new short[n53];
                            break;
                        }
                        case 3: {
                            if (nArray != null && nArray.length >= n53) break;
                            nArray = new int[n53];
                            break;
                        }
                        case 4: {
                            if (fArray != null && fArray.length >= n53) break;
                            fArray = new float[n53];
                            break;
                        }
                        case 5: {
                            if (dArray != null && dArray.length >= n53) break;
                            dArray = new double[n53];
                        }
                    }
                    if (this.sampleModel instanceof PixelInterleavedSampleModel) {
                        this.iis.skipBytes((n42 * n18 + n43 * n19) * n4);
                        if (n18 < n19) {
                            n36 = 0;
                            n35 = n47;
                            n34 = this.scaleY;
                            n33 = n40;
                            n32 = this.scaleX * n18;
                            n31 = n23;
                            n30 = n24;
                        } else {
                            n36 = 0;
                            n35 = n44;
                            n34 = this.scaleX;
                            n33 = n41;
                            n32 = this.scaleY * n19;
                            n31 = n24;
                            n30 = n23;
                        }
                        n29 = n25 + (n47 - writableRaster.getSampleModelTranslateY()) * n24 + (n44 - writableRaster.getSampleModelTranslateX()) * n23;
                        int n54 = n36;
                        n52 = n35;
                        while (n54 < n33) {
                            if (!this.reader.getAbortRequest()) {
                                switch (n2) {
                                    case 0: {
                                        if (n32 == n && n31 == n) {
                                            this.iis.readFully((byte[])object, n29, n53);
                                            break;
                                        }
                                        this.iis.readFully(byArray, 0, n53);
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        if (n32 == n && n31 == n) {
                                            this.iis.readFully(sArray2, n29, n53);
                                            break;
                                        }
                                        this.iis.readFully(sArray, 0, n53);
                                        break;
                                    }
                                    case 3: {
                                        if (n32 == n && n31 == n) {
                                            this.iis.readFully(nArray4, n29, n53);
                                            break;
                                        }
                                        this.iis.readFully(nArray, 0, n53);
                                        break;
                                    }
                                    case 4: {
                                        if (n32 == n && n31 == n) {
                                            this.iis.readFully(fArray2, n29, n53);
                                            break;
                                        }
                                        this.iis.readFully(fArray, 0, n53);
                                        break;
                                    }
                                    case 5: {
                                        if (n32 == n && n31 == n) {
                                            this.iis.readFully(dArray2, n29, n53);
                                            break;
                                        }
                                        this.iis.readFully(dArray, 0, n53);
                                    }
                                }
                                if (n32 != n || n31 != n) {
                                    n51 = 0;
                                    while (n51 < n) {
                                        n50 = nArray5[this.destinationBands[n51]];
                                        n29 += n50;
                                        n49 = nArray2[this.sourceBands[n51]];
                                        switch (n2) {
                                            case 0: {
                                                n48 = 0;
                                                int n55 = n29;
                                                while (n48 < n53) {
                                                    object[n55] = byArray[n48 + n49];
                                                    n48 += n32;
                                                    n55 += n31;
                                                }
                                                break;
                                            }
                                            case 1: 
                                            case 2: {
                                                n48 = 0;
                                                int n55 = n29;
                                                while (n48 < n53) {
                                                    sArray2[n55] = sArray[n48 + n49];
                                                    n48 += n32;
                                                    n55 += n31;
                                                }
                                                break;
                                            }
                                            case 3: {
                                                n48 = 0;
                                                int n55 = n29;
                                                while (n48 < n53) {
                                                    nArray4[n55] = nArray[n48 + n49];
                                                    n48 += n32;
                                                    n55 += n31;
                                                }
                                                break;
                                            }
                                            case 4: {
                                                n48 = 0;
                                                int n55 = n29;
                                                while (n48 < n53) {
                                                    fArray2[n55] = fArray[n48 + n49];
                                                    n48 += n32;
                                                    n55 += n31;
                                                }
                                                break;
                                            }
                                            case 5: {
                                                n48 = 0;
                                                int n55 = n29;
                                                while (n48 < n53) {
                                                    dArray2[n55] = dArray[n48 + n49];
                                                    n48 += n32;
                                                    n55 += n31;
                                                }
                                                break;
                                            }
                                        }
                                        n29 -= n50;
                                        ++n51;
                                    }
                                }
                                this.iis.skipBytes(n37);
                                n29 += n30;
                                if (this.destImage != null) {
                                    if (n18 < n19) {
                                        this.reader.processImageUpdateWrapper(this.destImage, n44, n52, n33, 1, 1, 1, this.destinationBands);
                                    } else {
                                        this.reader.processImageUpdateWrapper(this.destImage, n52, n47, 1, n33, 1, 1, this.destinationBands);
                                    }
                                }
                                this.reader.processImageProgressWrapper(f + ((float)n54 + 1.0f) / (float)n33 / (float)n17);
                                n54 += n34;
                                ++n52;
                                continue;
                            }
                            break;
                        }
                    } else if (this.sampleModel instanceof BandedSampleModel || this.sampleModel instanceof SinglePixelPackedSampleModel || n20 == 0) {
                        boolean cfr_ignored_0 = this.sampleModel instanceof BandedSampleModel;
                        n36 = (int)ImageUtil.getBandSize(this.originalSampleModel);
                        n35 = 0;
                        while (n35 < n) {
                            int n56;
                            this.iis.seek(l + (long)(n36 * this.sourceBands[n35] * n4));
                            n34 = nArray5[this.destinationBands[n35]];
                            this.iis.skipBytes((n43 * n19 + n42 * n18) * n4);
                            if (n18 < n19) {
                                n33 = 0;
                                n32 = n47;
                                n31 = this.scaleY;
                                n30 = n40;
                                n29 = this.scaleX * n18;
                                n56 = n23;
                                n52 = n24;
                            } else {
                                n33 = 0;
                                n32 = n44;
                                n31 = this.scaleX;
                                n30 = n41;
                                n29 = this.scaleY * n19;
                                n56 = n24;
                                n52 = n23;
                            }
                            n51 = n25 + (n47 - writableRaster.getSampleModelTranslateY()) * n24 + (n44 - writableRaster.getSampleModelTranslateX()) * n23 + n34;
                            n50 = nArray3[this.destinationBands[n35]];
                            switch (n2) {
                                case 0: {
                                    object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n50);
                                    break;
                                }
                                case 2: {
                                    sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n50);
                                    break;
                                }
                                case 1: {
                                    sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n50);
                                    break;
                                }
                                case 3: {
                                    nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n50);
                                    break;
                                }
                                case 4: {
                                    fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n50);
                                    break;
                                }
                                case 5: {
                                    dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n50);
                                }
                            }
                            n49 = n33;
                            n48 = n32;
                            while (n49 < n30) {
                                if (this.reader.getAbortRequest()) break;
                                switch (n2) {
                                    case 0: {
                                        if (n29 == 1 && n56 == 1) {
                                            this.iis.readFully((byte[])object, n51, n53);
                                            break;
                                        }
                                        this.iis.readFully(byArray, 0, n53);
                                        int n57 = 0;
                                        int n58 = n51;
                                        while (n57 < n53) {
                                            object[n58] = byArray[n57];
                                            n57 += n29;
                                            n58 += n56;
                                        }
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        if (n29 == 1 && n56 == 1) {
                                            this.iis.readFully(sArray2, n51, n53);
                                            break;
                                        }
                                        this.iis.readFully(sArray, 0, n53);
                                        int n59 = 0;
                                        int n58 = n51;
                                        while (n59 < n53) {
                                            sArray2[n58] = sArray[n59];
                                            n59 += n29;
                                            n58 += n56;
                                        }
                                        break;
                                    }
                                    case 3: {
                                        if (n29 == 1 && n56 == 1) {
                                            this.iis.readFully(nArray4, n51, n53);
                                            break;
                                        }
                                        this.iis.readFully(nArray, 0, n53);
                                        int n60 = 0;
                                        int n58 = n51;
                                        while (n60 < n53) {
                                            nArray4[n58] = nArray[n60];
                                            n60 += n29;
                                            n58 += n56;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        if (n29 == 1 && n56 == 1) {
                                            this.iis.readFully(fArray2, n51, n53);
                                            break;
                                        }
                                        this.iis.readFully(fArray, 0, n53);
                                        int n61 = 0;
                                        int n58 = n51;
                                        while (n61 < n53) {
                                            fArray2[n58] = fArray[n61];
                                            n61 += n29;
                                            n58 += n56;
                                        }
                                        break;
                                    }
                                    case 5: {
                                        if (n29 == 1 && n56 == 1) {
                                            this.iis.readFully(dArray2, n51, n53);
                                            break;
                                        }
                                        this.iis.readFully(dArray, 0, n53);
                                        int n62 = 0;
                                        int n58 = n51;
                                        while (n62 < n53) {
                                            dArray2[n58] = dArray[n62];
                                            n62 += n29;
                                            n58 += n56;
                                        }
                                        break;
                                    }
                                }
                                this.iis.skipBytes(n37);
                                n51 += n52;
                                if (this.destImage != null) {
                                    int[] nArray6 = new int[]{this.destinationBands[n35]};
                                    if (n18 < n19) {
                                        this.reader.processImageUpdateWrapper(this.destImage, n44, n48, n30, 1, 1, 1, nArray6);
                                    } else {
                                        this.reader.processImageUpdateWrapper(this.destImage, n48, n47, 1, n30, 1, 1, nArray6);
                                    }
                                }
                                this.reader.processImageProgressWrapper((f + ((float)n49 + 1.0f) / (float)n30 / (float)n / (float)n17) * 100.0f);
                                n49 += n31;
                                ++n48;
                            }
                            ++n35;
                        }
                    } else if (this.sampleModel instanceof ComponentSampleModel) {
                        n36 = (int)this.tileDataSize;
                        switch (this.sampleModel.getDataType()) {
                            case 0: {
                                if (byArray == null || (long)byArray.length < this.tileDataSize) {
                                    byArray = new byte[(int)this.tileDataSize];
                                }
                                this.iis.readFully(byArray, 0, (int)this.tileDataSize);
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (sArray == null || sArray.length < (n36 /= 2)) {
                                    sArray = new short[n36];
                                }
                                this.iis.readFully(sArray, 0, n36);
                                break;
                            }
                            case 3: {
                                if (nArray == null || nArray.length < (n36 /= 4)) {
                                    nArray = new int[n36];
                                }
                                this.iis.readFully(nArray, 0, n36);
                                break;
                            }
                            case 4: {
                                if (fArray == null || fArray.length < (n36 /= 4)) {
                                    fArray = new float[n36];
                                }
                                this.iis.readFully(fArray, 0, n36);
                                break;
                            }
                            case 5: {
                                if (dArray == null || dArray.length < (n36 /= 8)) {
                                    dArray = new double[n36];
                                }
                                this.iis.readFully(dArray, 0, n36);
                            }
                        }
                        n35 = 0;
                        while (n35 < n) {
                            int cfr_ignored_1 = nArray5[this.destinationBands[n35]];
                            n34 = ((ComponentSampleModel)writableRaster.getSampleModel()).getOffset(n44 - writableRaster.getSampleModelTranslateX(), n47 - writableRaster.getSampleModelTranslateY(), this.destinationBands[n35]);
                            n33 = nArray3[this.destinationBands[n35]];
                            switch (n2) {
                                case 0: {
                                    object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n33);
                                    break;
                                }
                                case 2: {
                                    sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n33);
                                    break;
                                }
                                case 1: {
                                    sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n33);
                                    break;
                                }
                                case 3: {
                                    nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n33);
                                    break;
                                }
                                case 4: {
                                    fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n33);
                                    break;
                                }
                                case 5: {
                                    dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n33);
                                }
                            }
                            n32 = ((ComponentSampleModel)this.originalSampleModel).getOffset(n42, n43, this.sourceBands[n35]);
                            n31 = this.scaleX * n18;
                            n30 = 0;
                            n29 = n47;
                            while (n30 < n40) {
                                if (this.reader.getAbortRequest()) break;
                                switch (n2) {
                                    case 0: {
                                        int n63 = 0;
                                        n52 = n32;
                                        n51 = n34;
                                        while (n63 < n46) {
                                            object[n51] = byArray[n52];
                                            ++n63;
                                            n52 += n31;
                                            n51 += n23;
                                        }
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        int n64 = 0;
                                        n52 = n32;
                                        n51 = n34;
                                        while (n64 < n46) {
                                            sArray2[n51] = sArray[n52];
                                            ++n64;
                                            n52 += n31;
                                            n51 += n23;
                                        }
                                        break;
                                    }
                                    case 3: {
                                        int n65 = 0;
                                        n52 = n32;
                                        n51 = n34;
                                        while (n65 < n46) {
                                            nArray4[n51] = nArray[n52];
                                            ++n65;
                                            n52 += n31;
                                            n51 += n23;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        int n66 = 0;
                                        n52 = n32;
                                        n51 = n34;
                                        while (n66 < n46) {
                                            fArray2[n51] = fArray[n52];
                                            ++n66;
                                            n52 += n31;
                                            n51 += n23;
                                        }
                                        break;
                                    }
                                    case 5: {
                                        int n67 = 0;
                                        n52 = n32;
                                        n51 = n34;
                                        while (n67 < n46) {
                                            dArray2[n51] = dArray[n52];
                                            ++n67;
                                            n52 += n31;
                                            n51 += n23;
                                        }
                                        break;
                                    }
                                }
                                n34 += n24;
                                n32 += n19 * this.scaleY;
                                if (this.destImage != null) {
                                    int[] nArray7 = new int[]{this.destinationBands[n35]};
                                    this.reader.processImageUpdateWrapper(this.destImage, n44, n29, n40, 1, 1, 1, nArray7);
                                }
                                this.reader.processImageProgressWrapper(f + ((float)n30 + 1.0f) / (float)n40 / (float)n / (float)n17);
                                n30 += this.scaleY;
                                ++n29;
                            }
                            ++n35;
                        }
                    } else {
                        throw new IllegalArgumentException(I18N.getString("RawRenderedImage1"));
                    }
                }
                ++n28;
            }
            ++n27;
        }
        return writableRaster;
    }

    public void setDestImage(BufferedImage bufferedImage) {
        this.destImage = bufferedImage;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int n, int n2) {
        int n3 = (n2 - this.getMinTileY()) * this.getNumXTiles() + n - this.getMinTileX();
        if (n3 < 0 || n3 >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
        }
        return n3;
    }

    private int clip(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }
}

