/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageWriteParam;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class RawImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;
    private int imageIndex;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] sourceBands = null;
    private int numBands;
    private RenderedImage input;
    private Raster inputRaster;
    private Rectangle destinationRegion = null;
    private SampleModel sampleModel;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private boolean writeRaster = false;
    private boolean optimal = false;
    private int pxlStride;
    private int lineStride;
    private int bandStride;

    public RawImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("RawImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        this.clearAbortRequest();
        this.processImageStarted(this.imageIndex++);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        this.writeRaster = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        Rectangle rectangle2 = null;
        if (this.writeRaster) {
            this.inputRaster = iIOImage.getRaster();
            this.sampleModel = this.inputRaster.getSampleModel();
            rectangle2 = this.inputRaster.getBounds();
        } else {
            this.input = iIOImage.getRenderedImage();
            this.sampleModel = this.input.getSampleModel();
            rectangle2 = new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight());
            this.input.getColorModel();
        }
        rectangle = rectangle == null ? (Rectangle)rectangle2.clone() : rectangle.intersection(rectangle2);
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("RawImageWriter1"));
        }
        this.scaleX = imageWriteParam.getSourceXSubsampling();
        this.scaleY = imageWriteParam.getSourceYSubsampling();
        this.xOffset = imageWriteParam.getSubsamplingXOffset();
        this.yOffset = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(this.xOffset, this.yOffset);
        rectangle.width -= this.xOffset;
        rectangle.height -= this.yOffset;
        this.xOffset = rectangle.x % this.scaleX;
        this.yOffset = rectangle.y % this.scaleY;
        int n2 = rectangle.x / this.scaleX;
        int n3 = rectangle.y / this.scaleY;
        int n4 = (rectangle.width + this.scaleX - 1) / this.scaleX;
        int n5 = (rectangle.height + this.scaleY - 1) / this.scaleY;
        this.destinationRegion = new Rectangle(n2, n3, n4, n5);
        this.noTransform = this.destinationRegion.equals(rectangle2);
        this.tileHeight = this.sampleModel.getHeight();
        this.tileWidth = this.sampleModel.getWidth();
        if (this.noTransform) {
            if (this.writeRaster) {
                this.tileXOffset = this.inputRaster.getMinX();
                this.tileYOffset = this.inputRaster.getMinY();
            } else {
                this.tileXOffset = this.input.getTileGridXOffset();
                this.tileYOffset = this.input.getTileGridYOffset();
            }
        } else {
            this.tileXOffset = this.destinationRegion.x;
            this.tileYOffset = this.destinationRegion.y;
        }
        this.sourceBands = imageWriteParam.getSourceBands();
        this.numBands = this.sampleModel.getNumBands();
        if (this.sourceBands != null) {
            this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            this.numBands = this.sampleModel.getNumBands();
        } else {
            this.sourceBands = new int[this.numBands];
            int n6 = 0;
            while (n6 < this.numBands) {
                this.sourceBands[n6] = n6;
                ++n6;
            }
        }
        if (this.sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            this.bandStride = nArray[0];
            int n7 = 1;
            while (n7 < nArray.length) {
                if (this.bandStride > nArray[n7]) {
                    this.bandStride = nArray[n7];
                }
                ++n7;
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n = nArray2[0];
            int n8 = 1;
            while (n8 < nArray2.length) {
                if (n > nArray2[n8]) {
                    n = nArray2[n8];
                }
                ++n8;
            }
            this.pxlStride = componentSampleModel.getPixelStride();
            this.lineStride = componentSampleModel.getScanlineStride();
            this.optimal = this.bandStride == 0 || this.pxlStride < this.lineStride && this.pxlStride == this.numBands || this.lineStride < this.pxlStride && this.lineStride == this.numBands || this.pxlStride < this.lineStride && this.lineStride == this.numBands * componentSampleModel.getWidth() || this.lineStride < this.pxlStride && this.pxlStride == this.numBands * componentSampleModel.getHeight() || componentSampleModel instanceof BandedSampleModel;
        } else if (this.sampleModel instanceof SinglePixelPackedSampleModel || this.sampleModel instanceof MultiPixelPackedSampleModel) {
            this.optimal = true;
        }
        int n9 = this.getMaxTileX() - this.getMinTileX() + 1;
        int n10 = n9 * (this.getMaxTileY() - this.getMinTileY() + 1);
        int n11 = this.getMinTileY();
        while (n11 <= this.getMaxTileY()) {
            n = this.getMinTileX();
            while (n <= this.getMaxTileX()) {
                this.writeRaster(this.getTile(n, n11));
                float f = ((float)(n + n11 * n9) + 1.0f) / (float)n10;
                this.processImageProgress(f * 100.0f);
                ++n;
            }
            ++n11;
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public int getWidth() {
        return this.destinationRegion.width;
    }

    public int getHeight() {
        return this.destinationRegion.height;
    }

    private void writeRaster(Raster object) throws IOException {
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int n3 = 0;
        int n4 = this.sampleModel.getNumBands();
        int n5 = this.sampleModel.getDataType();
        if (this.sampleModel instanceof ComponentSampleModel) {
            object3 = (ComponentSampleModel)this.sampleModel;
            nArray2 = ((ComponentSampleModel)object3).getBandOffsets();
            int n6 = 0;
            while (n6 < n4) {
                if (n2 < nArray2[n6]) {
                    n2 = nArray2[n6];
                }
                ++n6;
            }
            nArray = ((ComponentSampleModel)object3).getBankIndices();
            n6 = 0;
            while (n6 < n4) {
                if (n < nArray[n6]) {
                    n = nArray[n6];
                }
                ++n6;
            }
            n3 = (int)ImageUtil.getBandSize(this.sampleModel);
        }
        object3 = null;
        short[] sArray = null;
        int[] nArray3 = null;
        float[] fArray = null;
        double[] dArray = null;
        if (((Raster)object).getParent() != null && !this.sampleModel.equals(((Raster)object).getParent().getSampleModel())) {
            object2 = Raster.createWritableRaster(this.sampleModel, new Point(((Raster)object).getMinX(), ((Raster)object).getMinY()));
            ((WritableRaster)object2).setRect((Raster)object);
            object = object2;
        }
        object2 = ((Raster)object).getDataBuffer();
        if (this.optimal) {
            if (n > 0) {
                int n7 = 0;
                while (n7 < this.numBands) {
                    int n8 = nArray[this.sourceBands[n7]];
                    switch (n5) {
                        case 0: {
                            object3 = ((DataBufferByte)object2).getData(n8);
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            break;
                        }
                        case 2: {
                            sArray = ((DataBufferShort)object2).getData(n8);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        case 1: {
                            sArray = ((DataBufferUShort)object2).getData(n8);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        case 3: {
                            nArray3 = ((DataBufferInt)object2).getData(n8);
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            break;
                        }
                        case 4: {
                            fArray = ((DataBufferFloat)object2).getData(n8);
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            break;
                        }
                        case 5: {
                            dArray = ((DataBufferDouble)object2).getData(n8);
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                    ++n7;
                }
            } else {
                switch (n5) {
                    case 0: {
                        object3 = ((DataBufferByte)object2).getData();
                        break;
                    }
                    case 2: {
                        sArray = ((DataBufferShort)object2).getData();
                        break;
                    }
                    case 1: {
                        sArray = ((DataBufferUShort)object2).getData();
                        break;
                    }
                    case 3: {
                        nArray3 = ((DataBufferInt)object2).getData();
                        break;
                    }
                    case 4: {
                        fArray = ((DataBufferFloat)object2).getData();
                        break;
                    }
                    case 5: {
                        dArray = ((DataBufferDouble)object2).getData();
                    }
                }
                if (!this.noSubband && n2 >= ((Raster)object).getWidth() * ((Raster)object).getHeight() * (this.numBands - 1)) {
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        int n10 = nArray2[this.sourceBands[n9]];
                        switch (n5) {
                            case 0: {
                                this.stream.write((byte[])object3, n10, n3);
                                break;
                            }
                            case 1: 
                            case 2: {
                                this.stream.writeShorts(sArray, n10, n3);
                                break;
                            }
                            case 3: {
                                this.stream.writeInts(nArray3, n10, n3);
                                break;
                            }
                            case 4: {
                                this.stream.writeFloats(fArray, n10, n3);
                                break;
                            }
                            case 5: {
                                this.stream.writeDoubles(dArray, n10, n3);
                            }
                        }
                        ++n9;
                    }
                } else {
                    switch (n5) {
                        case 0: {
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                }
            }
        } else if (this.sampleModel instanceof ComponentSampleModel) {
            switch (n5) {
                case 0: {
                    object3 = ((DataBufferByte)object2).getData();
                    break;
                }
                case 2: {
                    sArray = ((DataBufferShort)object2).getData();
                    break;
                }
                case 1: {
                    sArray = ((DataBufferUShort)object2).getData();
                    break;
                }
                case 3: {
                    nArray3 = ((DataBufferInt)object2).getData();
                    break;
                }
                case 4: {
                    fArray = ((DataBufferFloat)object2).getData();
                    break;
                }
                case 5: {
                    dArray = ((DataBufferDouble)object2).getData();
                }
            }
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int n11 = componentSampleModel.getOffset(((Raster)object).getMinX() - ((Raster)object).getSampleModelTranslateX(), ((Raster)object).getMinY() - ((Raster)object).getSampleModelTranslateY()) - nArray2[0];
            int n12 = this.pxlStride;
            int n13 = 1;
            int n14 = this.pxlStride;
            int n15 = ((Raster)object).getWidth();
            int n16 = ((Raster)object).getHeight();
            int n17 = n15;
            int n18 = n16;
            if (n12 < this.lineStride) {
                if (n2 > this.pxlStride) {
                    n13 = n15;
                }
                n12 = this.lineStride;
            } else {
                if (n2 > this.lineStride) {
                    n13 = n16;
                }
                n14 = this.lineStride;
                n17 = n16;
                n18 = n15;
            }
            int n19 = n17 * this.numBands;
            byte[] byArray = null;
            short[] sArray2 = null;
            int[] nArray4 = null;
            float[] fArray2 = null;
            double[] dArray2 = null;
            Object object4 = null;
            Object[] objectArray = null;
            switch (n5) {
                case 0: {
                    object4 = object3;
                    objectArray = byArray = new byte[n19];
                    break;
                }
                case 1: 
                case 2: {
                    object4 = sArray;
                    sArray2 = new short[n19];
                    objectArray = sArray2;
                    break;
                }
                case 3: {
                    object4 = nArray3;
                    nArray4 = new int[n19];
                    objectArray = nArray4;
                    break;
                }
                case 4: {
                    object4 = fArray;
                    fArray2 = new float[n19];
                    objectArray = fArray2;
                    break;
                }
                case 5: {
                    object4 = dArray;
                    dArray2 = new double[n19];
                    objectArray = dArray2;
                }
            }
            if (n13 > 1) {
                int n20 = 0;
                while (n20 < n18) {
                    int n21 = 0;
                    while (n21 < this.numBands) {
                        int n22 = nArray2[n21];
                        System.arraycopy(object4, n11 + n22, objectArray, n21 * n17, n17);
                        ++n21;
                    }
                    switch (n5) {
                        case 0: {
                            this.stream.write((byte[])objectArray, 0, n19);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts((short[])objectArray, 0, n19);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts((int[])objectArray, 0, n19);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats((float[])objectArray, 0, n19);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles((double[])objectArray, 0, n19);
                        }
                    }
                    n11 += n12;
                    ++n20;
                }
            } else {
                switch (n5) {
                    case 0: {
                        int n23 = 0;
                        while (n23 < n18) {
                            int n24 = 0;
                            int n25 = 0;
                            while (n24 < this.numBands) {
                                int n26 = nArray2[n24];
                                int n27 = 0;
                                int n28 = n11;
                                while (n27 < n17) {
                                    byArray[n25++] = (byte)object3[n28 + n26];
                                    ++n27;
                                    n28 += n14;
                                }
                                ++n24;
                            }
                            this.stream.write(byArray, 0, n19);
                            n11 += n12;
                            ++n23;
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        int n29 = 0;
                        while (n29 < n18) {
                            int n30 = 0;
                            int n31 = 0;
                            while (n30 < this.numBands) {
                                int n32 = nArray2[n30];
                                int n33 = 0;
                                int n34 = n11;
                                while (n33 < n17) {
                                    sArray2[n31++] = sArray[n34 + n32];
                                    ++n33;
                                    n34 += n14;
                                }
                                ++n30;
                            }
                            this.stream.writeShorts(sArray2, 0, n19);
                            n11 += n12;
                            ++n29;
                        }
                        break;
                    }
                    case 3: {
                        int n35 = 0;
                        while (n35 < n18) {
                            int n36 = 0;
                            int n37 = 0;
                            while (n36 < this.numBands) {
                                int n38 = nArray2[n36];
                                int n39 = 0;
                                int n40 = n11;
                                while (n39 < n17) {
                                    nArray4[n37++] = nArray3[n40 + n38];
                                    ++n39;
                                    n40 += n14;
                                }
                                ++n36;
                            }
                            this.stream.writeInts(nArray4, 0, n19);
                            n11 += n12;
                            ++n35;
                        }
                        break;
                    }
                    case 4: {
                        int n41 = 0;
                        while (n41 < n18) {
                            int n42 = 0;
                            int n43 = 0;
                            while (n42 < this.numBands) {
                                int n44 = nArray2[n42];
                                int n45 = 0;
                                int n46 = n11;
                                while (n45 < n17) {
                                    fArray2[n43++] = fArray[n46 + n44];
                                    ++n45;
                                    n46 += n14;
                                }
                                ++n42;
                            }
                            this.stream.writeFloats(fArray2, 0, n19);
                            n11 += n12;
                            ++n41;
                        }
                        break;
                    }
                    case 5: {
                        int n47 = 0;
                        while (n47 < n18) {
                            int n48 = 0;
                            int n49 = 0;
                            while (n48 < this.numBands) {
                                int n50 = nArray2[n48];
                                int n51 = 0;
                                int n52 = n11;
                                while (n51 < n17) {
                                    dArray2[n49++] = dArray[n52 + n50];
                                    ++n51;
                                    n52 += n14;
                                }
                                ++n48;
                            }
                            this.stream.writeDoubles(dArray2, 0, n19);
                            n11 += n12;
                            ++n47;
                        }
                        break;
                    }
                }
            }
        }
    }

    private Raster getTile(int n, int n2) {
        int n3 = this.tileXOffset + n * this.tileWidth;
        int n4 = this.tileYOffset + n2 * this.tileHeight;
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        if (this.writeRaster) {
            rectangle = rectangle.intersection(this.destinationRegion);
            if (this.noTransform) {
                return this.inputRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
            }
            n3 = rectangle.x;
            n4 = rectangle.y;
            WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
            int n5 = this.mapToSourceX(n3);
            int n6 = this.mapToSourceY(n4);
            int n7 = this.inputRaster.getMinY();
            int n8 = this.inputRaster.getMinY() + this.inputRaster.getHeight();
            int n9 = rectangle.width;
            int n10 = (n9 - 1) * this.scaleX + 1;
            int n11 = 0;
            while (n11 < rectangle.height) {
                if (n6 >= n7 && n6 < n8) {
                    Raster raster = this.inputRaster.createChild(n5, n6, n10, 1, n5, n6, null);
                    int n12 = n3;
                    int n13 = 0;
                    int n14 = n5;
                    while (n13 < n9) {
                        int n15 = 0;
                        while (n15 < this.numBands) {
                            int n16 = raster.getSample(n14, n6, this.sourceBands[n15]);
                            writableRaster.setSample(n12, n4, n15, n16);
                            ++n15;
                        }
                        ++n13;
                        ++n12;
                        n14 += this.scaleX;
                    }
                }
                ++n11;
                ++n4;
                n6 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.input.getTile(n, n2);
            if (this.destinationRegion.contains(rectangle) && this.noSubband) {
                return raster;
            }
            rectangle = rectangle.intersection(this.destinationRegion);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
        }
        rectangle = rectangle.intersection(this.destinationRegion);
        n3 = rectangle.x;
        n4 = rectangle.y;
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        int n17 = this.mapToSourceX(n3);
        int n18 = this.mapToSourceY(n4);
        int n19 = this.input.getMinY();
        int n20 = this.input.getMinY() + this.input.getHeight();
        int n21 = rectangle.width;
        int n22 = (n21 - 1) * this.scaleX + 1;
        int n23 = 0;
        while (n23 < rectangle.height) {
            if (n18 >= n19 && n18 < n20) {
                Raster raster = this.input.getData(new Rectangle(n17, n18, n22, 1));
                int n24 = n3;
                int n25 = 0;
                int n26 = n17;
                while (n25 < n21) {
                    int n27 = 0;
                    while (n27 < this.numBands) {
                        int n28 = raster.getSample(n26, n18, this.sourceBands[n27]);
                        writableRaster.setSample(n24, n4, n27, n28);
                        ++n27;
                    }
                    ++n25;
                    ++n24;
                    n26 += this.scaleX;
                }
            }
            ++n23;
            ++n4;
            n18 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n) {
        return n * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n) {
        return n * this.scaleY + this.yOffset;
    }

    private int getMinTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x, this.tileXOffset, this.tileWidth);
    }

    private int getMaxTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x + this.destinationRegion.width - 1, this.tileXOffset, this.tileWidth);
    }

    private int getMinTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y, this.tileYOffset, this.tileHeight);
    }

    private int getMaxTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y + this.destinationRegion.height - 1, this.tileYOffset, this.tileHeight);
    }

    private static int ToTile(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
        this.optimal = false;
        this.sourceBands = null;
        this.destinationRegion = null;
        this.noTransform = true;
        this.noSubband = true;
        this.writeRaster = false;
    }
}

