/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageio.plugins.pnm.PNMImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadata;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import sun.security.action.GetPropertyAction;

public class PNMImageWriter
extends ImageWriter {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.imageioimpl.PNMImageWriter";
    private static byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private ImageOutputStream stream = null;

    static {
        if (lineSeparator == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            lineSeparator = string.getBytes();
        }
    }

    public PNMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("PNMImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new PNMImageWriteParam();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new PNMMetadata(imageTypeSpecifier, imageWriteParam);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        PNMMetadata pNMMetadata = null;
        if (iIOMetadata instanceof PNMMetadata) {
            pNMMetadata = (PNMMetadata)((PNMMetadata)iIOMetadata).clone();
        } else {
            try {
                pNMMetadata = new PNMMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                pNMMetadata = new PNMMetadata();
            }
        }
        pNMMetadata.initialize(imageTypeSpecifier, imageWriteParam);
        return pNMMetadata;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        SampleModel sampleModel;
        int n;
        ImageTypeSpecifier imageTypeSpecifier;
        Object object;
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        SampleModel sampleModel2 = null;
        ColorModel colorModel = null;
        if (bl) {
            raster = iIOImage.getRaster();
            sampleModel2 = raster.getSampleModel();
            rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel2 = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
            Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            rectangle = rectangle == null ? rectangle2 : rectangle.intersection(rectangle2);
        }
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("PNMImageWrite1"));
        }
        ImageUtil.canEncodeImage(this, colorModel, sampleModel2);
        int n2 = imageWriteParam.getSourceXSubsampling();
        int n3 = imageWriteParam.getSourceYSubsampling();
        int n4 = imageWriteParam.getSubsamplingXOffset();
        int n5 = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(n4, n5);
        rectangle.width -= n4;
        rectangle.height -= n5;
        int n6 = rectangle.x / n2;
        int n7 = rectangle.y / n3;
        int n8 = (rectangle.width + n2 - 1) / n2;
        int n9 = (rectangle.height + n3 - 1) / n3;
        new Rectangle(n6, n7, n8, n9);
        sampleModel2.getHeight();
        int n10 = sampleModel2.getWidth();
        int[] nArray = sampleModel2.getSampleSize();
        int[] nArray2 = imageWriteParam.getSourceBands();
        int n11 = sampleModel2.getNumBands();
        if (nArray2 != null) {
            sampleModel2 = sampleModel2.createSubsetSampleModel(nArray2);
            colorModel = null;
            n11 = sampleModel2.getNumBands();
        } else {
            nArray2 = new int[n11];
            int n12 = 0;
            while (n12 < n11) {
                nArray2[n12] = n12;
                ++n12;
            }
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        boolean bl2 = false;
        if (n11 == 1) {
            if (colorModel instanceof IndexColorModel) {
                object = (IndexColorModel)colorModel;
                int n13 = ((IndexColorModel)object).getMapSize();
                if (n13 < 1 << nArray[0]) {
                    throw new RuntimeException(I18N.getString("PNMImageWrite2"));
                }
                if (nArray[0] == 1) {
                    this.variant = 52;
                    bl2 = ((IndexColorModel)object).getRed(1) > ((IndexColorModel)object).getRed(0);
                } else {
                    this.variant = 54;
                    byArray = new byte[n13];
                    byArray2 = new byte[n13];
                    byArray3 = new byte[n13];
                    ((IndexColorModel)object).getReds(byArray);
                    ((IndexColorModel)object).getGreens(byArray2);
                    ((IndexColorModel)object).getBlues(byArray3);
                }
            } else {
                this.variant = nArray[0] == 1 ? 52 : (nArray[0] <= 8 ? 53 : 50);
            }
        } else if (n11 == 3) {
            this.variant = nArray[0] <= 8 && nArray[1] <= 8 && nArray[2] <= 8 ? 54 : 51;
        } else {
            throw new RuntimeException(I18N.getString("PNMImageWrite3"));
        }
        object = iIOImage.getMetadata();
        if (colorModel != null) {
            imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel2);
        } else {
            int n14 = sampleModel2.getDataType();
            switch (n11) {
                case 1: {
                    imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(nArray[0], n14, false);
                    break;
                }
                case 3: {
                    ColorSpace colorSpace = ColorSpace.getInstance(1000);
                    int[] nArray3 = new int[3];
                    nArray3[1] = 1;
                    nArray3[2] = 2;
                    imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, nArray3, n14, false, false);
                    break;
                }
                default: {
                    throw new IIOException("Cannot encode image with " + n11 + " bands!");
                }
            }
        }
        PNMMetadata pNMMetadata = object != null ? (PNMMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam) : (PNMMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        boolean bl3 = imageWriteParam instanceof PNMImageWriteParam ? ((PNMImageWriteParam)imageWriteParam).getRaw() : pNMMetadata.isRaw();
        this.maxValue = pNMMetadata.getMaxValue();
        int n15 = 0;
        while (n15 < nArray.length) {
            n = (1 << nArray[n15]) - 1;
            if (n > this.maxValue) {
                this.maxValue = n;
            }
            ++n15;
        }
        if (bl3) {
            n15 = pNMMetadata.getMaxBitDepth();
            if (!this.isRaw(this.variant) && n15 <= 8) {
                this.variant += 3;
            } else if (this.isRaw(this.variant) && n15 > 8) {
                this.variant -= 3;
            }
        } else if (this.isRaw(this.variant)) {
            this.variant -= 3;
        }
        this.stream.writeByte(80);
        this.stream.writeByte(this.variant);
        this.stream.write(lineSeparator);
        this.stream.write(COMMENT.getBytes());
        Iterator iterator = pNMMetadata.getComments();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.stream.write(lineSeparator);
                String string = "# " + (String)iterator.next();
                this.stream.write(string.getBytes());
            }
        }
        this.stream.write(lineSeparator);
        this.writeInteger(this.stream, n8);
        this.stream.write(32);
        this.writeInteger(this.stream, n9);
        if (this.variant != 52 && this.variant != 49) {
            this.stream.write(lineSeparator);
            this.writeInteger(this.stream, this.maxValue);
        }
        if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
            this.stream.write(10);
        }
        n = 0;
        if (this.variant == 52 && sampleModel2.getTransferType() == 0 && sampleModel2 instanceof MultiPixelPackedSampleModel) {
            sampleModel = (MultiPixelPackedSampleModel)sampleModel2;
            int n16 = 0;
            n16 = bl ? raster.getMinX() : renderedImage.getMinX();
            if (((MultiPixelPackedSampleModel)sampleModel).getBitOffset((rectangle.x - n16) % n10) == 0 && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && n2 == 1) {
                n = 1;
            }
        } else if ((this.variant == 53 || this.variant == 54) && sampleModel2 instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && ((ComponentSampleModel)(sampleModel = (ComponentSampleModel)sampleModel2)).getPixelStride() == n11 && n2 == 1) {
            n = 1;
            if (this.variant == 54) {
                int[] nArray4 = ((ComponentSampleModel)sampleModel).getBandOffsets();
                int n17 = 0;
                while (n17 < n11) {
                    if (nArray4[n17] != n17) {
                        n = 0;
                        break;
                    }
                    ++n17;
                }
            }
        }
        if (n != 0) {
            int n18 = this.variant == 52 ? (n8 + 7) / 8 : n8 * sampleModel2.getNumBands();
            byte[] byArray4 = null;
            byte[] byArray5 = new byte[n18];
            int n19 = 0;
            while (n19 < rectangle.height) {
                if (this.abortRequested()) break;
                Raster raster2 = null;
                if (bl) {
                    raster2 = raster.createChild(rectangle.x, n19, rectangle.width, 1, 0, 0, null);
                } else {
                    raster2 = renderedImage.getData(new Rectangle(rectangle.x, rectangle.y + n19, n8, 1));
                    raster2 = raster2.createTranslatedChild(0, 0);
                }
                byArray4 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                sampleModel2 = raster2.getSampleModel();
                int n20 = 0;
                if (sampleModel2 instanceof ComponentSampleModel) {
                    n20 = ((ComponentSampleModel)sampleModel2).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinY() - raster2.getSampleModelTranslateY());
                } else if (sampleModel2 instanceof MultiPixelPackedSampleModel) {
                    n20 = ((MultiPixelPackedSampleModel)sampleModel2).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinX() - raster2.getSampleModelTranslateY());
                }
                if (bl2) {
                    int n21 = n20;
                    int n22 = 0;
                    while (n22 < n18) {
                        byArray5[n22] = ~byArray4[n21];
                        ++n21;
                        ++n22;
                    }
                    byArray4 = byArray5;
                    n20 = 0;
                }
                this.stream.write(byArray4, n20, n18);
                this.processImageProgress(100.0f * (float)n19 / (float)rectangle.height);
                ++n19;
            }
            this.stream.flush();
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
            }
            return;
        }
        int n23 = rectangle.width * n11;
        int[] nArray5 = new int[n23];
        byte[] byArray6 = byArray == null ? new byte[n8 * n11] : new byte[n8 * 3];
        int n24 = 0;
        int n25 = rectangle.y + rectangle.height;
        int n26 = rectangle.y;
        while (n26 < n25) {
            int n27;
            if (this.abortRequested()) break;
            Raster raster3 = null;
            raster3 = bl ? raster.createChild(rectangle.x, n26, rectangle.width, 1, rectangle.x, n26, nArray2) : renderedImage.getData(new Rectangle(rectangle.x, n26, rectangle.width, 1));
            raster3.getPixels(rectangle.x, n26, rectangle.width, 1, nArray5);
            if (bl2) {
                n27 = 0;
                while (n27 < n23) {
                    int n28 = n27;
                    byArray6[n28] = (byte)(byArray6[n28] ^ 1);
                    n27 += n2;
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    n27 = 0;
                    while (n27 < n23) {
                        if (n24++ % 16 == 0) {
                            this.stream.write(lineSeparator);
                        } else {
                            this.stream.write(32);
                        }
                        this.writeInteger(this.stream, nArray5[n27]);
                        n27 += n2;
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 51: {
                    int n29;
                    if (byArray == null) {
                        ((ComponentSampleModel)sampleModel2).getBandOffsets();
                        n27 = 0;
                        while (n27 < n23) {
                            n29 = 0;
                            while (n29 < n11) {
                                if (n24++ % 16 == 0) {
                                    this.stream.write(lineSeparator);
                                } else {
                                    this.stream.write(32);
                                }
                                this.writeInteger(this.stream, nArray5[n27 + n29]);
                                ++n29;
                            }
                            n27 += n2 * n11;
                        }
                    } else {
                        n27 = 0;
                        while (n27 < n23) {
                            if (n24++ % 5 == 0) {
                                this.stream.write(lineSeparator);
                            } else {
                                this.stream.write(32);
                            }
                            this.writeInteger(this.stream, byArray[nArray5[n27]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray2[nArray5[n27]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray3[nArray5[n27]] & 0xFF);
                            n27 += n2;
                        }
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 52: {
                    n27 = 0;
                    int n29 = 0;
                    int n30 = 7;
                    int n31 = 0;
                    while (n31 < n23) {
                        n29 |= nArray5[n31] << n30;
                        if (--n30 == -1) {
                            byArray6[n27++] = (byte)n29;
                            n29 = 0;
                            n30 = 7;
                        }
                        n31 += n2;
                    }
                    if (n30 != 7) {
                        byArray6[n27++] = (byte)n29;
                    }
                    this.stream.write(byArray6, 0, n27);
                    break;
                }
                case 53: {
                    int n31 = 0;
                    int n32 = 0;
                    while (n31 < n23) {
                        byArray6[n32++] = (byte)nArray5[n31];
                        n31 += n2;
                    }
                    this.stream.write(byArray6, 0, n8);
                    break;
                }
                case 54: {
                    int n32;
                    int n31;
                    if (byArray == null) {
                        n31 = 0;
                        n32 = 0;
                        while (n31 < n23) {
                            int n33 = 0;
                            while (n33 < n11) {
                                byArray6[n32++] = (byte)(nArray5[n31 + n33] & 0xFF);
                                ++n33;
                            }
                            n31 += n2 * n11;
                        }
                    } else {
                        n31 = 0;
                        n32 = 0;
                        while (n31 < n23) {
                            byArray6[n32++] = byArray[nArray5[n31]];
                            byArray6[n32++] = byArray2[nArray5[n31]];
                            byArray6[n32++] = byArray3[nArray5[n31]];
                            n31 += n2;
                        }
                    }
                    this.stream.write(byArray6, 0, byArray6.length);
                }
            }
            this.processImageProgress(100.0f * (float)(n26 - rectangle.y) / (float)rectangle.height);
            n26 += n3;
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void writeInteger(ImageOutputStream imageOutputStream, int n) throws IOException {
        imageOutputStream.write(Integer.toString(n).getBytes());
    }

    private void writeByte(ImageOutputStream imageOutputStream, byte by) throws IOException {
        imageOutputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }
}

