/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.pnm.PNMImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class PNMImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.pnm.PNMImageWriterSpi"};
    private static String[] formatNames = new String[]{"pnm", "PNM"};
    private static String[] entensions = new String[]{"pbm", "pgm", "ppm"};
    private static String[] mimeType = new String[]{"image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap"};
    private boolean registered = false;

    public PNMImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.pnm.PNMImageReader", STANDARD_INPUT_TYPE, writerSpiNames, true, null, null, null, null, true, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    @Override
    public String getDescription(Locale locale) {
        String string = String.valueOf(PackageUtil.getSpecificationTitle()) + " PNM Image Reader";
        return string;
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        byte[] byArray = new byte[2];
        imageInputStream.mark();
        imageInputStream.readFully(byArray);
        imageInputStream.reset();
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new PNMImageReader(this);
    }
}

