/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.security.action.GetPropertyAction;

public class PNMImageReader
extends ImageReader {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int LINE_FEED = 10;
    private static byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private long imageDataOffset;
    private int width;
    private int height;
    private String aLine;
    private StringTokenizer token;
    private PNMMetadata metadata;

    static {
        if (lineSeparator == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            lineSeparator = string.getBytes();
        }
    }

    public PNMImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.iis = (ImageInputStream)object;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    public int getVariant() {
        return this.variant;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("PNMImageReader1"));
        }
    }

    public synchronized void readHeader() throws IOException {
        if (this.gotHeader) {
            this.iis.seek(this.imageDataOffset);
            return;
        }
        if (this.iis != null) {
            if (this.iis.readByte() != 80) {
                throw new RuntimeException(I18N.getString("PNMImageReader0"));
            }
            this.variant = this.iis.readByte();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(I18N.getString("PNMImageReader0"));
            }
            this.metadata = new PNMMetadata();
            this.metadata.setVariant(this.variant);
            this.iis.readLine();
            this.readComments(this.iis, this.metadata);
            this.width = this.readInteger(this.iis);
            this.height = this.readInteger(this.iis);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(this.iis);
            this.metadata.setWidth(this.width);
            this.metadata.setHeight(this.height);
            this.metadata.setMaxBitDepth(this.maxValue);
            this.gotHeader = true;
            this.imageDataOffset = this.iis.getStreamPosition();
        }
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        int n2 = (this.variant - 49) % 3;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        int n3 = 3;
        if (this.maxValue < 256) {
            n3 = 0;
        } else if (this.maxValue < 65536) {
            n3 = 1;
        }
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        if (this.variant == 49 || this.variant == 52) {
            sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, 1);
            byte[] byArray = new byte[2];
            byArray[0] = -1;
            byte[] byArray2 = byArray;
            colorModel = new IndexColorModel(1, 2, byArray2, byArray2, byArray2);
        } else {
            int[] nArray;
            int n4 = n2 == 1 ? 1 : 3;
            int n5 = this.width * (n2 == 1 ? 1 : 3);
            if (n2 == 1) {
                nArray = new int[1];
            } else {
                int[] nArray2 = new int[3];
                nArray2[1] = 1;
                nArray = nArray2;
                nArray2[2] = 2;
            }
            sampleModel = new PixelInterleavedSampleModel(n3, this.width, this.height, n4, n5, nArray);
            colorModel = ImageUtil.createColorModel(null, sampleModel);
        }
        arrayList.add(new ImageTypeSpecifier(colorModel, sampleModel));
        return arrayList.iterator();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.metadata;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkIndex(n);
        return true;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Object object;
        block79: {
            int n2;
            boolean bl;
            this.checkIndex(n);
            this.clearAbortRequest();
            this.processImageStarted(n);
            if (imageReadParam == null) {
                imageReadParam = this.getDefaultReadParam();
            }
            this.readHeader();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            PNMImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, rectangle2);
            int n3 = imageReadParam.getSourceXSubsampling();
            int n4 = imageReadParam.getSourceYSubsampling();
            int[] nArray = imageReadParam.getSourceBands();
            int[] nArray2 = imageReadParam.getDestinationBands();
            boolean bl2 = nArray != null && nArray2 != null;
            boolean bl3 = bl = rectangle2.equals(new Rectangle(0, 0, this.width, this.height)) || bl2;
            if (this.isRaw(this.variant) && this.maxValue >= 256) {
                this.maxValue = 255;
            }
            int n5 = 1;
            if (this.variant == 51 || this.variant == 54) {
                n5 = 3;
            }
            if (!bl2) {
                nArray = new int[n5];
                nArray2 = new int[n5];
                n2 = 0;
                while (n2 < n5) {
                    nArray2[n2] = nArray[n2] = n2;
                    ++n2;
                }
            }
            n2 = 3;
            if (this.maxValue < 256) {
                n2 = 0;
            } else if (this.maxValue < 65536) {
                n2 = 1;
            }
            SampleModel sampleModel = null;
            ColorModel colorModel = null;
            if (this.variant == 49 || this.variant == 52) {
                sampleModel = new MultiPixelPackedSampleModel(0, rectangle2.width, rectangle2.height, 1);
                byte[] byArray = new byte[2];
                byArray[0] = -1;
                object = byArray;
                colorModel = new IndexColorModel(1, 2, (byte[])object, (byte[])object, (byte[])object);
            } else {
                sampleModel = new PixelInterleavedSampleModel(n2, rectangle2.width, rectangle2.height, nArray.length, rectangle2.width * nArray.length, nArray2);
                colorModel = ImageUtil.createColorModel(null, sampleModel);
            }
            object = imageReadParam.getDestination();
            WritableRaster writableRaster = null;
            if (object == null) {
                sampleModel = sampleModel.createCompatibleSampleModel(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                if (bl2) {
                    sampleModel = sampleModel.createSubsetSampleModel(nArray);
                }
                writableRaster = Raster.createWritableRaster(sampleModel, new Point());
                object = new BufferedImage(colorModel, writableRaster, false, null);
            } else {
                writableRaster = ((BufferedImage)object).getWritableTile(0, 0);
                sampleModel = ((BufferedImage)object).getSampleModel();
                colorModel = ((BufferedImage)object).getColorModel();
                bl &= rectangle2.equals(writableRaster.getBounds());
            }
            block0 : switch (this.variant) {
                case 52: {
                    DataBuffer dataBuffer = writableRaster.getDataBuffer();
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    if (bl) {
                        this.iis.readFully(byArray, 0, byArray.length);
                        this.processImageUpdate((BufferedImage)object, 0, 0, this.width, this.height, 1, 1, nArray2);
                        this.processImageProgress(100.0f);
                        break;
                    }
                    if (n3 == 1 && rectangle.x % 8 == 0) {
                        int n6 = rectangle.x >> 3;
                        int n7 = this.width + 7 >> 3;
                        int n8 = writableRaster.getWidth() + 7 >> 3;
                        int n9 = rectangle.width + 7 >> 3;
                        int n10 = rectangle.y * n7;
                        this.iis.skipBytes(n10 + n6);
                        n10 = n7 * (n4 - 1) + n7 - n9;
                        byte[] byArray2 = new byte[n9];
                        int n11 = rectangle2.x & 7;
                        boolean bl4 = n11 != 0;
                        int n12 = 0;
                        int n13 = 0;
                        int n14 = rectangle2.y * n8 + (rectangle2.x >> 3);
                        while (n12 < rectangle2.height) {
                            if (bl4) {
                                this.iis.read(byArray2, 0, n9);
                                int n15 = 255 << n11 & 0xFF;
                                int n16 = ~n15 & 0xFF;
                                int n17 = 8 - n11;
                                int n18 = 0;
                                int n19 = n14;
                                while (n18 < n9 - 1) {
                                    byArray[n19] = (byte)((byArray2[n18] & n16) << n17 | (byArray2[n18 + 1] & n15) >> n11);
                                    ++n18;
                                    ++n19;
                                }
                                byArray[n19] = (byte)((byArray2[n18] & n16) << n17);
                            } else {
                                this.iis.read(byArray, n14, n9);
                            }
                            this.iis.skipBytes(n10);
                            n14 += n8;
                            this.processImageUpdate((BufferedImage)object, 0, n12, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n12 / (float)rectangle2.height);
                            ++n12;
                            n13 += n4;
                        }
                    } else {
                        int n20 = this.width + 7 >> 3;
                        byte[] byArray3 = new byte[n20];
                        this.iis.skipBytes(rectangle.y * n20);
                        int n21 = ((BufferedImage)object).getWidth() + 7 >> 3;
                        int n22 = n20 * (n4 - 1);
                        int n23 = n21 * rectangle2.y + (rectangle2.x >> 3);
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = n23;
                        while (n24 < rectangle2.height) {
                            this.iis.read(byArray3, 0, n20);
                            this.iis.skipBytes(n22);
                            int n27 = 0;
                            int n28 = 7 - (rectangle2.x & 7);
                            int n29 = rectangle.x;
                            while (n29 < rectangle.x + rectangle.width) {
                                n27 |= (byArray3[n29 >> 3] >> 7 - (n29 & 7) & 1) << n28;
                                if (--n28 == -1) {
                                    byArray[n26++] = (byte)n27;
                                    n27 = 0;
                                    n28 = 7;
                                }
                                n29 += n3;
                            }
                            if (n28 != 7) {
                                byArray[n26++] = (byte)n27;
                            }
                            n26 += rectangle2.x >> 3;
                            this.processImageUpdate((BufferedImage)object, 0, n24, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n24 / (float)rectangle2.height);
                            ++n24;
                            n25 += n4;
                        }
                    }
                    break;
                }
                case 49: {
                    DataBuffer dataBuffer = writableRaster.getDataBuffer();
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    if (bl) {
                        int n30 = 0;
                        int n31 = 0;
                        while (n30 < this.height) {
                            int n32 = 0;
                            int n33 = 7;
                            int n34 = 0;
                            while (n34 < this.width) {
                                n32 |= (this.readInteger(this.iis) & 1) << n33;
                                if (--n33 == -1) {
                                    byArray[n31++] = (byte)n32;
                                    n32 = 0;
                                    n33 = 7;
                                }
                                ++n34;
                            }
                            if (n33 != 7) {
                                byArray[n31++] = (byte)n32;
                            }
                            this.processImageUpdate((BufferedImage)object, 0, n30, this.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n30 / (float)this.height);
                            ++n30;
                        }
                    } else {
                        this.skipInteger(this.iis, rectangle.y * this.width + rectangle.x);
                        int n35 = n3 - 1;
                        int n36 = (n4 - 1) * this.width + this.width - rectangle2.width * n3;
                        int n37 = (((BufferedImage)object).getWidth() + 7 >> 3) * rectangle2.y + (rectangle2.x >> 3);
                        int n38 = 0;
                        int n39 = n37;
                        while (n38 < rectangle2.height) {
                            int n40 = 0;
                            int n41 = 7 - (rectangle2.x & 7);
                            int n42 = 0;
                            while (n42 < rectangle2.width) {
                                n40 |= (this.readInteger(this.iis) & 1) << n41;
                                if (--n41 == -1) {
                                    byArray[n39++] = (byte)n40;
                                    n40 = 0;
                                    n41 = 7;
                                }
                                this.skipInteger(this.iis, n35);
                                ++n42;
                            }
                            if (n41 != 7) {
                                byArray[n39++] = (byte)n40;
                            }
                            n39 += rectangle2.x >> 3;
                            this.skipInteger(this.iis, n36);
                            this.processImageUpdate((BufferedImage)object, 0, n38, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n38 / (float)rectangle2.height);
                            ++n38;
                        }
                    }
                    break;
                }
                case 50: 
                case 51: 
                case 53: 
                case 54: {
                    int n43 = (n3 - 1) * n5;
                    int n44 = (n4 * this.width - rectangle2.width * n3) * n5;
                    int n45 = (((BufferedImage)object).getWidth() * rectangle2.y + rectangle2.x) * n5;
                    switch (n2) {
                        case 0: {
                            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                            byte[] byArray = dataBufferByte.getData();
                            if (this.isRaw(this.variant)) {
                                if (bl) {
                                    this.iis.readFully(byArray);
                                    this.processImageUpdate((BufferedImage)object, 0, 0, this.width, this.height, 1, 1, nArray2);
                                    this.processImageProgress(100.0f);
                                    break block0;
                                }
                                this.iis.skipBytes(rectangle.y * this.width * n5);
                                int n46 = (n4 - 1) * this.width * n5;
                                byte[] byArray4 = new byte[this.width * n5];
                                int n47 = n3 * n5;
                                int n48 = rectangle.x * n5;
                                int n49 = 0;
                                int n50 = n45;
                                while (n49 < rectangle2.height) {
                                    this.iis.read(byArray4);
                                    int n51 = rectangle.x;
                                    int n52 = n48;
                                    while (n51 < rectangle.x + rectangle.width) {
                                        int n53 = 0;
                                        while (n53 < nArray.length) {
                                            byArray[n50 + nArray2[n53]] = byArray4[n52 + nArray[n53]];
                                            ++n53;
                                        }
                                        n50 += nArray.length;
                                        n51 += n3;
                                        n52 += n47;
                                    }
                                    n50 += rectangle2.x * n5;
                                    this.iis.skipBytes(n46);
                                    this.processImageUpdate((BufferedImage)object, 0, n49, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)n49 / (float)rectangle2.height);
                                    ++n49;
                                }
                            } else {
                                this.skipInteger(this.iis, (rectangle.y * this.width + rectangle.x) * n5);
                                if (bl2) {
                                    byte[] byArray5 = new byte[n5];
                                    int n54 = 0;
                                    int n55 = n45;
                                    while (n54 < rectangle2.height) {
                                        int n56 = 0;
                                        while (n56 < rectangle2.width) {
                                            int n57 = 0;
                                            while (n57 < n5) {
                                                byArray5[n57] = (byte)this.readInteger(this.iis);
                                                ++n57;
                                            }
                                            n57 = 0;
                                            while (n57 < nArray.length) {
                                                byArray[n55 + nArray2[n57]] = byArray5[nArray[n57]];
                                                ++n57;
                                            }
                                            n55 += nArray.length;
                                            this.skipInteger(this.iis, n43);
                                            ++n56;
                                        }
                                        n55 += rectangle2.x * nArray.length;
                                        this.skipInteger(this.iis, n44);
                                        this.processImageUpdate((BufferedImage)object, 0, n54, rectangle2.width, 1, 1, 1, nArray2);
                                        this.processImageProgress(100.0f * (float)n54 / (float)rectangle2.height);
                                        ++n54;
                                    }
                                } else {
                                    int n58 = 0;
                                    int n59 = n45;
                                    while (n58 < rectangle2.height) {
                                        int n60 = 0;
                                        while (n60 < rectangle2.width) {
                                            int n61 = 0;
                                            while (n61 < n5) {
                                                byArray[n59++] = (byte)this.readInteger(this.iis);
                                                ++n61;
                                            }
                                            this.skipInteger(this.iis, n43);
                                            ++n60;
                                        }
                                        n59 += rectangle2.x * nArray.length;
                                        this.skipInteger(this.iis, n44);
                                        this.processImageUpdate((BufferedImage)object, 0, n58, rectangle2.width, 1, 1, 1, nArray2);
                                        this.processImageProgress(100.0f * (float)n58 / (float)rectangle2.height);
                                        ++n58;
                                    }
                                }
                            }
                            break block79;
                        }
                        case 1: {
                            DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                            short[] sArray = dataBufferUShort.getData();
                            this.skipInteger(this.iis, rectangle.y * this.width * n5 + rectangle.x);
                            if (bl2) {
                                short[] sArray2 = new short[n5];
                                int n62 = 0;
                                int n63 = n45;
                                while (n62 < rectangle2.height) {
                                    int n64 = 0;
                                    while (n64 < rectangle2.width) {
                                        int n65 = 0;
                                        while (n65 < n5) {
                                            sArray2[n65] = (short)this.readInteger(this.iis);
                                            ++n65;
                                        }
                                        n65 = 0;
                                        while (n65 < nArray.length) {
                                            sArray[n63 + nArray2[n65]] = sArray2[nArray[n65]];
                                            ++n65;
                                        }
                                        n63 += nArray.length;
                                        this.skipInteger(this.iis, n43);
                                        ++n64;
                                    }
                                    n63 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n44);
                                    this.processImageUpdate((BufferedImage)object, 0, n62, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)n62 / (float)rectangle2.height);
                                    ++n62;
                                }
                            } else {
                                int n66 = 0;
                                int n67 = n45;
                                while (n66 < rectangle2.height) {
                                    int n68 = 0;
                                    while (n68 < rectangle2.width) {
                                        int n69 = 0;
                                        while (n69 < n5) {
                                            sArray[n67++] = (short)this.readInteger(this.iis);
                                            ++n69;
                                        }
                                        this.skipInteger(this.iis, n43);
                                        ++n68;
                                    }
                                    n67 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n44);
                                    this.processImageUpdate((BufferedImage)object, 0, n66, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)n66 / (float)rectangle2.height);
                                    ++n66;
                                }
                            }
                            break block79;
                        }
                        case 3: {
                            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                            int[] nArray3 = dataBufferInt.getData();
                            this.skipInteger(this.iis, rectangle.y * this.width * n5 + rectangle.x);
                            if (bl2) {
                                int[] nArray4 = new int[n5];
                                int n70 = 0;
                                int n71 = n45;
                                while (n70 < rectangle2.height) {
                                    int n72 = 0;
                                    while (n72 < rectangle2.width) {
                                        int n73 = 0;
                                        while (n73 < n5) {
                                            nArray4[n73] = this.readInteger(this.iis);
                                            ++n73;
                                        }
                                        n73 = 0;
                                        while (n73 < nArray.length) {
                                            nArray3[n71 + nArray2[n73]] = nArray4[nArray[n73]];
                                            ++n73;
                                        }
                                        n71 += nArray.length;
                                        this.skipInteger(this.iis, n43);
                                        ++n72;
                                    }
                                    n71 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n44);
                                    this.processImageUpdate((BufferedImage)object, 0, n70, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)n70 / (float)rectangle2.height);
                                    ++n70;
                                }
                            } else {
                                int n74 = 0;
                                int n75 = n45;
                                while (n74 < rectangle2.height) {
                                    int n76 = 0;
                                    while (n76 < rectangle2.width) {
                                        int n77 = 0;
                                        while (n77 < n5) {
                                            nArray3[n75++] = this.readInteger(this.iis);
                                            ++n77;
                                        }
                                        this.skipInteger(this.iis, n43);
                                        ++n76;
                                    }
                                    n75 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n44);
                                    this.processImageUpdate((BufferedImage)object, 0, n74, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)n74 / (float)rectangle2.height);
                                    ++n74;
                                }
                                break block0;
                            }
                        }
                    }
                }
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return object;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n, imageReadParam);
        return bufferedImage.getData();
    }

    @Override
    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        System.gc();
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }

    private void readComments(ImageInputStream imageInputStream, PNMMetadata pNMMetadata) throws IOException {
        String string = null;
        int n = -1;
        imageInputStream.mark();
        while ((string = imageInputStream.readLine()) != null && (n = string.indexOf("#")) >= 0) {
            pNMMetadata.addComment(string.substring(n + 1).trim());
        }
        imageInputStream.reset();
    }

    private int readInteger(ImageInputStream imageInputStream) throws IOException {
        boolean bl = false;
        while (this.aLine == null) {
            this.aLine = imageInputStream.readLine();
            if (this.aLine == null) {
                return 0;
            }
            int n = this.aLine.indexOf("#");
            if (n == 0) {
                this.aLine = null;
            } else if (n > 0) {
                this.aLine = this.aLine.substring(0, n - 1);
            }
            if (this.aLine == null) continue;
            this.token = new StringTokenizer(this.aLine);
        }
        while (this.token.hasMoreTokens()) {
            String string = this.token.nextToken();
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!bl) {
            this.aLine = null;
            return this.readInteger(imageInputStream);
        }
        return 0;
    }

    private void skipInteger(ImageInputStream imageInputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.readInteger(imageInputStream);
            ++n2;
        }
    }
}

