/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.plugins.pcx.PCXConstants;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PCXMetadata
extends IIOMetadata
implements Cloneable,
PCXConstants {
    short version;
    byte bitsPerPixel;
    boolean gotxmin;
    boolean gotymin;
    short xmin;
    short ymin;
    int vdpi;
    int hdpi;
    int hsize;
    int vsize;

    PCXMetadata() {
        super(true, null, null, null, null);
        this.reset();
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeStandardTree(node);
    }

    @Override
    public void reset() {
        this.version = (short)5;
        this.bitsPerPixel = 0;
        this.gotxmin = false;
        this.gotymin = false;
        this.xmin = 0;
        this.ymin = 0;
        this.vdpi = 72;
        this.hdpi = 72;
        this.hsize = 0;
        this.vsize = 0;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        String string;
        switch (this.version) {
            case 0: {
                string = "2.5";
                break;
            }
            case 2: {
                string = "2.8 with palette";
                break;
            }
            case 3: {
                string = "2.8 without palette";
                break;
            }
            case 4: {
                string = "PC Paintbrush for Windows";
                break;
            }
            case 5: {
                string = "3.0";
                break;
            }
            default: {
                string = null;
            }
        }
        IIOMetadataNode iIOMetadataNode = null;
        if (string != null) {
            iIOMetadataNode = new IIOMetadataNode("Document");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelOffset");
        iIOMetadataNode2.setAttribute("value", String.valueOf(this.xmin));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelOffset");
        iIOMetadataNode2.setAttribute("value", String.valueOf(this.ymin));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
        iIOMetadataNode2.setAttribute("value", String.valueOf(254.0 / (double)this.hdpi));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
        iIOMetadataNode2.setAttribute("value", String.valueOf(254.0 / (double)this.vdpi));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.hsize != 0) {
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalScreenSize");
            iIOMetadataNode2.setAttribute("value", String.valueOf(this.hsize));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (this.vsize != 0) {
            iIOMetadataNode2 = new IIOMetadataNode("VerticalScreenSize");
            iIOMetadataNode2.setAttribute("value", String.valueOf(this.vsize));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            throw new IIOInvalidTreeException("Root must be javax_imageio_1.0", node2);
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            String string = node2.getNodeName();
            if (string.equals("Dimension")) {
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    String string2;
                    String string3 = node3.getNodeName();
                    if (string3.equals("HorizontalPixelOffset")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.xmin = Short.valueOf(string2);
                        this.gotxmin = true;
                    } else if (string3.equals("VerticalPixelOffset")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.ymin = Short.valueOf(string2);
                        this.gotymin = true;
                    } else if (string3.equals("HorizontalPixelSize")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.hdpi = (int)(254.0f / Float.parseFloat(string2) + 0.5f);
                    } else if (string3.equals("VerticalPixelSize")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.vdpi = (int)(254.0f / Float.parseFloat(string2) + 0.5f);
                    } else if (string3.equals("HorizontalScreenSize")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.hsize = Integer.valueOf(string2);
                    } else if (string3.equals("VerticalScreenSize")) {
                        string2 = PCXMetadata.getAttribute(node3, "value");
                        this.vsize = Integer.valueOf(string2);
                    }
                    node3 = node3.getNextSibling();
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 != null ? node2.getNodeValue() : null;
    }
}

