/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pcx.PCXConstants;
import com.sun.media.imageioimpl.plugins.pcx.PCXImageWriterSpi;
import com.sun.media.imageioimpl.plugins.pcx.PCXMetadata;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class PCXImageWriter
extends ImageWriter
implements PCXConstants {
    private ImageOutputStream ios;
    private Rectangle sourceRegion;
    private Rectangle destinationRegion;
    private int colorPlanes;
    private int bytesPerLine;
    private Raster inputRaster = null;
    private int scaleX;
    private int scaleY;

    public PCXImageWriter(PCXImageWriterSpi pCXImageWriterSpi) {
        super(pCXImageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not instance of ImageOutputStream");
            }
            this.ios = (ImageOutputStream)object;
            this.ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.ios = null;
        }
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata instanceof PCXMetadata) {
            return iIOMetadata;
        }
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        PCXMetadata pCXMetadata = new PCXMetadata();
        pCXMetadata.bitsPerPixel = (byte)imageTypeSpecifier.getSampleModel().getSampleSize()[0];
        return pCXMetadata;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        Cloneable cloneable;
        Object object;
        if (this.ios == null) {
            throw new IllegalStateException("output stream is null");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image is null");
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        boolean bl = iIOImage.hasRaster();
        this.sourceRegion = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        if (bl) {
            this.inputRaster = iIOImage.getRaster();
            sampleModel = this.inputRaster.getSampleModel();
            colorModel = ImageUtil.createColorModel(null, sampleModel);
            this.sourceRegion = this.sourceRegion == null ? this.inputRaster.getBounds() : this.sourceRegion.intersection(this.inputRaster.getBounds());
        } else {
            object = iIOImage.getRenderedImage();
            this.inputRaster = object.getData();
            sampleModel = object.getSampleModel();
            colorModel = object.getColorModel();
            cloneable = new Rectangle(object.getMinX(), object.getMinY(), object.getWidth(), object.getHeight());
            this.sourceRegion = this.sourceRegion == null ? cloneable : this.sourceRegion.intersection((Rectangle)cloneable);
        }
        if (this.sourceRegion.isEmpty()) {
            throw new IllegalArgumentException("source region is empty");
        }
        object = iIOImage.getMetadata();
        cloneable = null;
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        cloneable = object != null ? (PCXMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam) : (PCXMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        this.scaleX = imageWriteParam.getSourceXSubsampling();
        this.scaleY = imageWriteParam.getSourceYSubsampling();
        int n2 = imageWriteParam.getSubsamplingXOffset();
        int n3 = imageWriteParam.getSubsamplingYOffset();
        sampleModel.getDataType();
        this.sourceRegion.translate(n2, n3);
        this.sourceRegion.width -= n2;
        this.sourceRegion.height -= n3;
        int n4 = this.sourceRegion.x / this.scaleX;
        int n5 = this.sourceRegion.y / this.scaleY;
        int n6 = (this.sourceRegion.width + this.scaleX - 1) / this.scaleX;
        int n7 = (this.sourceRegion.height + this.scaleY - 1) / this.scaleY;
        n2 = this.sourceRegion.x % this.scaleX;
        n3 = this.sourceRegion.y % this.scaleY;
        this.destinationRegion = new Rectangle(n4, n5, n6, n7);
        this.destinationRegion.equals(this.sourceRegion);
        int[] nArray = imageWriteParam.getSourceBands();
        int n8 = sampleModel.getNumBands();
        if (nArray != null) {
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
            colorModel = null;
            n8 = sampleModel.getNumBands();
        } else {
            nArray = new int[n8];
            n = 0;
            while (n < n8) {
                nArray[n] = n;
                ++n;
            }
        }
        this.ios.writeByte(10);
        this.ios.writeByte(5);
        this.ios.writeByte(1);
        n = sampleModel.getSampleSize(0);
        this.ios.writeByte(n);
        this.ios.writeShort(this.destinationRegion.x);
        this.ios.writeShort(this.destinationRegion.y);
        this.ios.writeShort(this.destinationRegion.x + this.destinationRegion.width - 1);
        this.ios.writeShort(this.destinationRegion.y + this.destinationRegion.height - 1);
        this.ios.writeShort(((PCXMetadata)cloneable).hdpi);
        this.ios.writeShort(((PCXMetadata)cloneable).vdpi);
        byte[] byArray = this.createSmallPalette(colorModel);
        this.ios.write(byArray);
        this.ios.writeByte(0);
        this.colorPlanes = sampleModel.getNumBands();
        this.ios.writeByte(this.colorPlanes);
        this.bytesPerLine = this.destinationRegion.width * n / 8;
        this.bytesPerLine += this.bytesPerLine % 2;
        this.ios.writeShort(this.bytesPerLine);
        if (colorModel.getColorSpace().getType() == 6) {
            this.ios.writeShort(2);
        } else {
            this.ios.writeShort(1);
        }
        this.ios.writeShort(((PCXMetadata)cloneable).hsize);
        this.ios.writeShort(((PCXMetadata)cloneable).vsize);
        int n9 = 0;
        while (n9 < 54) {
            this.ios.writeByte(0);
            ++n9;
        }
        if (this.colorPlanes == 1 && n == 1) {
            this.write1Bit();
        } else if (this.colorPlanes == 1 && n == 4) {
            this.write4Bit();
        } else {
            this.write8Bit();
        }
        if (this.colorPlanes == 1 && n == 8 && colorModel.getColorSpace().getType() != 6) {
            this.ios.writeByte(12);
            this.ios.write(this.createLargePalette(colorModel));
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    private void write4Bit() throws IOException {
        int[] nArray = new int[this.sourceRegion.width];
        int[] nArray2 = new int[this.bytesPerLine];
        int n = 0;
        while (n < this.sourceRegion.height) {
            this.inputRaster.getSamples(this.sourceRegion.x, n + this.sourceRegion.y, this.sourceRegion.width, 1, 0, nArray);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.sourceRegion.width) {
                n2 |= nArray[n4] & 0xF;
                if (n5 == 1) {
                    nArray2[n3++] = n2;
                    n5 = 0;
                    n2 = 0;
                } else {
                    n5 = 1;
                    n2 <<= 4;
                }
                n4 += this.scaleX;
            }
            n4 = nArray2[0];
            n5 = 0;
            int n6 = 0;
            while (n6 < this.bytesPerLine) {
                int n7 = nArray2[n6];
                if (n7 != n4 || n5 == 63) {
                    this.writeRLE(n4, n5);
                    n5 = 1;
                    n4 = n7;
                } else {
                    ++n5;
                }
                n6 += this.scaleX;
            }
            if (n5 >= 1) {
                this.writeRLE(n4, n5);
            }
            this.processImageProgress(100.0f * (float)n / (float)this.sourceRegion.height);
            n += this.scaleY;
        }
    }

    private void write1Bit() throws IOException {
        int[] nArray = new int[this.sourceRegion.width];
        int[] nArray2 = new int[this.bytesPerLine];
        int n = 0;
        while (n < this.sourceRegion.height) {
            this.inputRaster.getSamples(this.sourceRegion.x, n + this.sourceRegion.y, this.sourceRegion.width, 1, 0, nArray);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 128;
            while (n4 < this.sourceRegion.width) {
                if (nArray[n4] > 0) {
                    n2 |= n5;
                }
                if (n5 == 1) {
                    nArray2[n3++] = n2;
                    n5 = 128;
                    n2 = 0;
                } else {
                    n5 >>= 1;
                }
                n4 += this.scaleX;
            }
            n4 = nArray2[0];
            n5 = 0;
            int n6 = 0;
            while (n6 < this.bytesPerLine) {
                int n7 = nArray2[n6];
                if (n7 != n4 || n5 == 63) {
                    this.writeRLE(n4, n5);
                    n5 = 1;
                    n4 = n7;
                } else {
                    ++n5;
                }
                n6 += this.scaleX;
            }
            if (n5 >= 1) {
                this.writeRLE(n4, n5);
            }
            this.processImageProgress(100.0f * (float)n / (float)this.sourceRegion.height);
            n += this.scaleY;
        }
    }

    private void write8Bit() throws IOException {
        int[][] nArray = new int[this.colorPlanes][this.bytesPerLine];
        int n = 0;
        while (n < this.sourceRegion.height) {
            int n2 = 0;
            while (n2 < this.colorPlanes) {
                this.inputRaster.getSamples(this.sourceRegion.x, n + this.sourceRegion.y, this.sourceRegion.width, 1, n2, nArray[n2]);
                ++n2;
            }
            n2 = nArray[0][0];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.colorPlanes) {
                int n5 = 0;
                while (n5 < this.bytesPerLine) {
                    int n6 = nArray[n4][n5];
                    if (n6 != n2 || n3 == 63) {
                        this.writeRLE(n2, n3);
                        n3 = 1;
                        n2 = n6;
                    } else {
                        ++n3;
                    }
                    n5 += this.scaleX;
                }
                ++n4;
            }
            if (n3 >= 1) {
                this.writeRLE(n2, n3);
            }
            this.processImageProgress(100.0f * (float)n / (float)this.sourceRegion.height);
            n += this.scaleY;
        }
    }

    private void writeRLE(int n, int n2) throws IOException {
        if (n2 == 1 && (n & 0xC0) != 192) {
            this.ios.writeByte(n);
        } else {
            this.ios.writeByte(0xC0 | n2);
            this.ios.writeByte(n);
        }
    }

    private byte[] createSmallPalette(ColorModel colorModel) {
        byte[] byArray = new byte[48];
        if (!(colorModel instanceof IndexColorModel)) {
            return byArray;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (indexColorModel.getMapSize() > 16) {
            return byArray;
        }
        int n = 0;
        int n2 = 0;
        while (n < indexColorModel.getMapSize()) {
            byArray[n2++] = (byte)indexColorModel.getRed(n);
            byArray[n2++] = (byte)indexColorModel.getGreen(n);
            byArray[n2++] = (byte)indexColorModel.getBlue(n);
            ++n;
        }
        return byArray;
    }

    private byte[] createLargePalette(ColorModel colorModel) {
        byte[] byArray = new byte[768];
        if (!(colorModel instanceof IndexColorModel)) {
            return byArray;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n = 0;
        int n2 = 0;
        while (n < indexColorModel.getMapSize()) {
            byArray[n2++] = (byte)indexColorModel.getRed(n);
            byArray[n2++] = (byte)indexColorModel.getGreen(n);
            byArray[n2++] = (byte)indexColorModel.getBlue(n);
            ++n;
        }
        return byArray;
    }
}

