/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.plugins.pcx.PCXConstants;
import com.sun.media.imageioimpl.plugins.pcx.PCXImageReaderSpi;
import com.sun.media.imageioimpl.plugins.pcx.PCXMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class PCXImageReader
extends ImageReader
implements PCXConstants {
    private ImageInputStream iis;
    private int width;
    private int height;
    private boolean gotHeader = false;
    private byte manufacturer;
    private byte encoding;
    private short xmax;
    private short ymax;
    private byte[] smallPalette = new byte[48];
    private byte[] largePalette = new byte[768];
    private byte colorPlanes;
    private short bytesPerLine;
    private short paletteType;
    private PCXMetadata metadata;
    private SampleModel sampleModel;
    private SampleModel originalSampleModel;
    private ColorModel colorModel;
    private ColorModel originalColorModel;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private BufferedImage bi;
    private boolean noTransform = true;
    private boolean seleBand = false;
    private int scaleX;
    private int scaleY;
    private int[] sourceBands;
    private int[] destBands;

    public PCXImageReader(PCXImageReaderSpi pCXImageReaderSpi) {
        super(pCXImageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.iis = (ImageInputStream)object;
        if (this.iis != null) {
            this.iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        this.gotHeader = false;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.metadata;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return Collections.singletonList(new ImageTypeSpecifier(this.originalColorModel, this.originalSampleModel)).iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("input is null");
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException("cannot search with forward only input");
        }
        return 1;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        if (this.iis == null) {
            throw new IllegalStateException("input is null");
        }
        this.clearAbortRequest();
        this.processImageStarted(n);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        PCXImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), this.sourceRegion, this.destinationRegion);
        this.scaleX = imageReadParam.getSourceXSubsampling();
        this.scaleY = imageReadParam.getSourceYSubsampling();
        this.sourceBands = imageReadParam.getSourceBands();
        this.destBands = imageReadParam.getDestinationBands();
        this.seleBand = this.sourceBands != null && this.destBands != null;
        boolean bl = this.noTransform = this.destinationRegion.equals(new Rectangle(0, 0, this.width, this.height)) || this.seleBand;
        if (!this.seleBand) {
            this.sourceBands = new int[this.colorPlanes];
            this.destBands = new int[this.colorPlanes];
            int n2 = 0;
            while (n2 < this.colorPlanes) {
                int n3 = n2;
                this.sourceBands[n2] = n3;
                this.destBands[n2] = n3;
                ++n2;
            }
        }
        this.bi = imageReadParam.getDestination();
        WritableRaster writableRaster = null;
        if (this.bi == null) {
            if (this.sampleModel != null && this.colorModel != null) {
                this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.destinationRegion.width + this.destinationRegion.x, this.destinationRegion.height + this.destinationRegion.y);
                if (this.seleBand) {
                    this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
                }
                writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(0, 0));
                this.bi = new BufferedImage(this.colorModel, writableRaster, false, null);
            }
        } else {
            writableRaster = this.bi.getWritableTile(0, 0);
            this.sampleModel = this.bi.getSampleModel();
            this.colorModel = this.bi.getColorModel();
            this.noTransform &= this.destinationRegion.equals(writableRaster.getBounds());
        }
        byte[] byArray = null;
        if (this.sampleModel.getDataType() == 0) {
            byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        }
        this.readImage(byArray);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.bi;
    }

    private void readImage(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[this.bytesPerLine * this.colorPlanes];
        if (this.noTransform) {
            try {
                int n = 0;
                int n2 = (this.width * this.metadata.bitsPerPixel + 8 - this.metadata.bitsPerPixel) / 8;
                int n3 = 0;
                while (n3 < this.height) {
                    this.readScanLine(byArray2);
                    int n4 = 0;
                    while (n4 < this.colorPlanes) {
                        System.arraycopy(byArray2, this.bytesPerLine * n4, byArray, n, n2);
                        n += n2;
                        ++n4;
                    }
                    this.processImageProgress(100.0f * (float)n3 / (float)this.height);
                    ++n3;
                }
            }
            catch (EOFException eOFException) {}
        } else if (this.metadata.bitsPerPixel == 1) {
            this.read1Bit(byArray);
        } else if (this.metadata.bitsPerPixel == 4) {
            this.read4Bit(byArray);
        } else {
            this.read8Bit(byArray);
        }
    }

    private void read1Bit(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[this.bytesPerLine];
        try {
            int n = 0;
            while (n < this.sourceRegion.y) {
                this.readScanLine(byArray2);
                ++n;
            }
            n = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n2 = this.destinationRegion.x;
            int n3 = this.sourceRegion.x;
            int n4 = 0;
            while (n2 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n4] = n3 >> 3;
                nArray[n4] = 7 - (n3 & 7);
                nArray4[n4] = n2 >> 3;
                nArray2[n4] = 7 - (n2 & 7);
                ++n2;
                ++n4;
                n3 += this.scaleX;
            }
            n2 = this.destinationRegion.y * n;
            n3 = 0;
            while (n3 < this.sourceRegion.height) {
                this.readScanLine(byArray2);
                if (n3 % this.scaleY == 0) {
                    n4 = 0;
                    while (n4 < this.destinationRegion.width) {
                        int n5 = byArray2[nArray3[n4]] >> nArray[n4] & 1;
                        int n6 = n2 + nArray4[n4];
                        byArray[n6] = (byte)(byArray[n6] | n5 << nArray2[n4]);
                        ++n4;
                    }
                    n2 += n;
                }
                this.processImageProgress(100.0f * (float)n3 / (float)this.sourceRegion.height);
                ++n3;
            }
        }
        catch (EOFException eOFException) {}
    }

    private void read4Bit(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[this.bytesPerLine];
        try {
            int n = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n2 = this.destinationRegion.x;
            int n3 = this.sourceRegion.x;
            int n4 = 0;
            while (n2 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n4] = n3 >> 1;
                nArray[n4] = 1 - (n3 & 1) << 2;
                nArray4[n4] = n2 >> 1;
                nArray2[n4] = 1 - (n2 & 1) << 2;
                ++n2;
                ++n4;
                n3 += this.scaleX;
            }
            n2 = this.destinationRegion.y * n;
            n3 = 0;
            while (n3 < this.sourceRegion.height) {
                this.readScanLine(byArray2);
                if (!this.abortRequested()) {
                    if (n3 % this.scaleY == 0) {
                        n4 = 0;
                        while (n4 < this.destinationRegion.width) {
                            int n5 = byArray2[nArray3[n4]] >> nArray[n4] & 0xF;
                            int n6 = n2 + nArray4[n4];
                            byArray[n6] = (byte)(byArray[n6] | n5 << nArray2[n4]);
                            ++n4;
                        }
                        n2 += n;
                    }
                    this.processImageProgress(100.0f * (float)n3 / (float)this.sourceRegion.height);
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {}
    }

    private void read8Bit(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[this.colorPlanes * this.bytesPerLine];
        try {
            int n = 0;
            while (n < this.sourceRegion.y) {
                this.readScanLine(byArray2);
                ++n;
            }
            n = this.destinationRegion.y * (this.destinationRegion.x + this.destinationRegion.width) * this.colorPlanes;
            int n2 = 0;
            while (n2 < this.sourceRegion.height) {
                this.readScanLine(byArray2);
                if (n2 % this.scaleY == 0) {
                    int n3 = this.sourceRegion.x;
                    int n4 = 0;
                    while (n4 < this.colorPlanes) {
                        n += this.destinationRegion.x;
                        int n5 = 0;
                        while (n5 < this.destinationRegion.width) {
                            byArray[n++] = byArray2[n3 + n5];
                            n5 += this.scaleX;
                        }
                        n3 += this.bytesPerLine;
                        ++n4;
                    }
                }
                this.processImageProgress(100.0f * (float)n2 / (float)this.sourceRegion.height);
                ++n2;
            }
        }
        catch (EOFException eOFException) {}
    }

    private void readScanLine(byte[] byArray) throws IOException {
        int n = this.bytesPerLine * this.colorPlanes;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.iis.readUnsignedByte();
            if ((n3 & 0xC0) == 192) {
                int n4 = n3 & 0xFFFFFF3F;
                n3 = this.iis.readUnsignedByte();
                int n5 = 0;
                while (n5 < n4 && n2 < n) {
                    byArray[n2++] = (byte)(n3 & 0xFF);
                    ++n5;
                }
                continue;
            }
            byArray[n2++] = (byte)(n3 & 0xFF);
        }
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("only one image exists in the stream");
        }
    }

    private void readHeader() throws IOException {
        if (this.gotHeader) {
            this.iis.seek(128L);
            return;
        }
        this.metadata = new PCXMetadata();
        this.manufacturer = this.iis.readByte();
        if (this.manufacturer != 10) {
            throw new IllegalStateException("image is not a PCX file");
        }
        this.metadata.version = this.iis.readByte();
        this.encoding = this.iis.readByte();
        if (this.encoding != 1) {
            throw new IllegalStateException("image is not a PCX file, invalid encoding " + this.encoding);
        }
        this.metadata.bitsPerPixel = this.iis.readByte();
        this.metadata.xmin = this.iis.readShort();
        this.metadata.ymin = this.iis.readShort();
        this.xmax = this.iis.readShort();
        this.ymax = this.iis.readShort();
        this.metadata.hdpi = this.iis.readShort();
        this.metadata.vdpi = this.iis.readShort();
        this.iis.readFully(this.smallPalette);
        this.iis.readByte();
        this.colorPlanes = this.iis.readByte();
        this.bytesPerLine = this.iis.readShort();
        this.paletteType = this.iis.readShort();
        this.metadata.hsize = this.iis.readShort();
        this.metadata.vsize = this.iis.readShort();
        this.iis.skipBytes(54);
        this.width = this.xmax - this.metadata.xmin + 1;
        this.height = this.ymax - this.metadata.ymin + 1;
        if (this.colorPlanes == 1) {
            if (this.paletteType == 2) {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{8};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
                this.sampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width, new int[1]);
            } else if (this.metadata.bitsPerPixel == 8) {
                this.iis.mark();
                if (this.iis.length() == -1L) {
                    while (this.iis.read() != -1) {
                    }
                    this.iis.seek(this.iis.getStreamPosition() - 768L - 1L);
                } else {
                    this.iis.seek(this.iis.length() - 768L - 1L);
                }
                int n = this.iis.read();
                if (n != 12) {
                    this.processWarningOccurred("Expected palette magic number 12; instead read " + n + " from this image.");
                }
                this.iis.readFully(this.largePalette);
                this.iis.reset();
                this.colorModel = new IndexColorModel((int)this.metadata.bitsPerPixel, 256, this.largePalette, 0, false);
                this.sampleModel = this.colorModel.createCompatibleSampleModel(this.width, this.height);
            } else {
                int n = this.metadata.bitsPerPixel == 1 ? 2 : 16;
                this.colorModel = new IndexColorModel((int)this.metadata.bitsPerPixel, n, this.smallPalette, 0, false);
                this.sampleModel = this.colorModel.createCompatibleSampleModel(this.width, this.height);
            }
        } else {
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            int[] nArray = new int[]{8, 8, 8};
            this.colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
            int[] nArray2 = new int[3];
            nArray2[1] = this.width;
            nArray2[2] = this.width * 2;
            this.sampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width * this.colorPlanes, nArray2);
        }
        this.originalSampleModel = this.sampleModel;
        this.originalColorModel = this.colorModel;
        this.gotHeader = true;
    }
}

