/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;

public class RenderedImageSrc
implements BlkImgDataSrc {
    private int w;
    private int h;
    int tileWidth;
    int tileHeight;
    int tileXOffset;
    int tileYOffset;
    int scaleX;
    int scaleY;
    int xOffset;
    int yOffset;
    int[] sourceBands = null;
    int minX;
    int minY;
    private int nc;
    private int rb;
    private int[][] barr = null;
    private DataBlkInt dbi = new DataBlkInt();
    private byte[] buf;
    private DataBlkInt intBlk;
    private RenderedImage src;
    private J2KImageWriteParamJava param;
    private Raster raster;
    private Raster aTile;
    private Point co = new Point();
    private int dcOffset = 0;
    private boolean isBinary = false;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private ColorModel cm;
    private SampleModel sm;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private J2KImageWriter writer;
    private boolean inputIsRaster = false;

    public RenderedImageSrc(Raster raster, J2KImageWriteParamJava j2KImageWriteParamJava, J2KImageWriter j2KImageWriter) {
        this.raster = raster;
        this.param = j2KImageWriteParamJava;
        this.writer = j2KImageWriter;
        this.inputIsRaster = true;
        this.sourceRegion = j2KImageWriteParamJava.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight()) : this.sourceRegion.intersection(raster.getBounds());
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = raster.getSampleModel();
        this.getFromParam();
        this.setSampleModelAndMore();
        this.setTile(0, 0);
    }

    public RenderedImageSrc(RenderedImage renderedImage, J2KImageWriteParamJava j2KImageWriteParamJava, J2KImageWriter j2KImageWriter) {
        this.src = renderedImage;
        this.param = j2KImageWriteParamJava;
        this.writer = j2KImageWriter;
        this.sourceRegion = j2KImageWriteParamJava.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()) : this.sourceRegion.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = renderedImage.getSampleModel();
        this.cm = renderedImage.getColorModel();
        this.getFromParam();
        this.setSampleModelAndMore();
    }

    private void getFromParam() {
        try {
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        catch (IllegalStateException illegalStateException) {
            this.param.setTilingMode(2);
            if (this.inputIsRaster) {
                this.param.setTiling(this.raster.getWidth(), this.raster.getHeight(), this.raster.getMinX(), this.raster.getMinY());
            } else {
                this.param.setTiling(this.src.getWidth(), this.src.getHeight(), this.src.getMinX(), this.src.getMinY());
            }
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        this.scaleX = this.param.getSourceXSubsampling();
        this.scaleY = this.param.getSourceYSubsampling();
        this.xOffset = this.param.getSubsamplingXOffset();
        this.yOffset = this.param.getSubsamplingYOffset();
        this.sourceRegion.translate(this.xOffset, this.yOffset);
        this.sourceRegion.width -= this.xOffset;
        this.sourceRegion.height -= this.yOffset;
        this.xOffset = this.sourceRegion.x % this.scaleX;
        this.yOffset = this.sourceRegion.y % this.scaleY;
        this.minX = this.sourceRegion.x / this.scaleX;
        this.minY = this.sourceRegion.y / this.scaleY;
        this.w = (this.sourceRegion.width + this.scaleX - 1) / this.scaleX;
        this.h = (this.sourceRegion.height + this.scaleY - 1) / this.scaleY;
        this.tileXOffset += (this.minX - this.tileXOffset) / this.tileWidth * this.tileWidth;
        this.tileYOffset += (this.minY - this.tileYOffset) / this.tileHeight * this.tileHeight;
        this.destinationRegion = new Rectangle(this.minX, this.minY, this.w, this.h);
        if (!this.destinationRegion.equals(this.sourceRegion) || this.tileWidth != this.sm.getWidth() || this.tileHeight != this.sm.getHeight() || !this.inputIsRaster && (this.tileXOffset != this.src.getTileGridXOffset() || this.tileYOffset != this.src.getTileGridYOffset()) || this.inputIsRaster && (this.tileXOffset != this.raster.getMinX() || this.tileYOffset != this.raster.getMinY())) {
            this.noTransform = false;
        }
    }

    private void setSampleModelAndMore() {
        int n;
        this.nc = this.sm.getNumBands();
        this.sourceBands = this.param.getSourceBands();
        if (this.sourceBands != null) {
            this.sm = this.sm.createSubsetSampleModel(this.sourceBands);
            this.noSubband = false;
        } else {
            this.sourceBands = new int[this.nc];
            n = 0;
            while (n < this.nc) {
                this.sourceBands[n] = n;
                ++n;
            }
        }
        this.sm = this.sm.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.nc = this.sm.getNumBands();
        this.isBinary = ImageUtil.isBinary(this.sm);
        if (this.cm != null) {
            this.rb = this.cm.getComponentSize(0);
            n = 1;
            while (n < this.cm.getNumComponents()) {
                if (this.rb < this.cm.getComponentSize(n)) {
                    this.rb = this.cm.getComponentSize(n);
                }
                ++n;
            }
        } else {
            this.rb = this.sm.getSampleSize(0);
            n = 1;
            while (n < this.sm.getNumBands()) {
                if (this.rb < this.sm.getSampleSize(n)) {
                    this.rb = this.sm.getSampleSize(n);
                }
                ++n;
            }
        }
        if (!this.isOrigSigned(0) && this.rb > 1) {
            this.dcOffset = 1 << this.rb - 1;
        }
    }

    @Override
    public int getTilePartULX() {
        return this.tileXOffset;
    }

    @Override
    public int getTilePartULY() {
        return this.tileYOffset;
    }

    @Override
    public int getTileWidth() {
        int n = this.tileWidth;
        int n2 = this.co.x * this.tileWidth + this.tileXOffset;
        int n3 = this.getImgULX() + this.getImgWidth();
        if (n2 + this.tileWidth >= n3) {
            n = n3 - n2;
        }
        return n;
    }

    @Override
    public int getTileHeight() {
        int n = this.tileHeight;
        int n2 = this.co.y * this.tileHeight + this.tileYOffset;
        int n3 = this.getImgULY() + this.getImgHeight();
        if (n2 + this.tileHeight >= n3) {
            n = n3 - n2;
        }
        return n;
    }

    @Override
    public int getNomTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getNomTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getImgWidth() {
        return this.w;
    }

    @Override
    public int getImgHeight() {
        return this.h;
    }

    @Override
    public int getNumComps() {
        return this.nc;
    }

    public int getTileGridXOffset() {
        return this.param.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.param.getTileGridYOffset();
    }

    @Override
    public int getTileCompHeight(int n, int n2) {
        return this.tileHeight;
    }

    @Override
    public int getTileCompWidth(int n, int n2) {
        return this.tileWidth;
    }

    @Override
    public int getCompSubsX(int n) {
        return 1;
    }

    @Override
    public int getCompSubsY(int n) {
        return 1;
    }

    public int getCompWidth(int n) {
        return this.w;
    }

    public int getCompHeight(int n) {
        return this.h;
    }

    @Override
    public int getCompImgWidth(int n) {
        return this.w;
    }

    @Override
    public int getCompImgHeight(int n) {
        return this.h;
    }

    @Override
    public void setTile(int n, int n2) {
        if (n >= this.getNumXTiles()) {
            n2 += n / this.getNumXTiles();
            n %= this.getNumXTiles();
        }
        this.co.x = n;
        this.co.y = n2;
        this.aTile = null;
    }

    @Override
    public void nextTile() {
        ++this.co.x;
        if (this.co.x >= this.getNumXTiles()) {
            this.co.x = 0;
            ++this.co.y;
        }
        this.setTile(this.co.x, this.co.y);
    }

    @Override
    public Point getTile(Point point) {
        if (point != null) {
            return point;
        }
        return new Point(0, 0);
    }

    @Override
    public int getTileIdx() {
        return this.getNumXTiles() * this.co.y + this.co.x;
    }

    public Point getTileOff(Point point, int n) {
        if (point != null) {
            point.x = this.co.x * this.tileWidth + this.tileXOffset;
            point.y = this.co.y * this.tileHeight + this.tileYOffset;
            return this.co;
        }
        return new Point(this.co.x * this.tileWidth + this.tileXOffset, this.co.y * this.tileHeight + this.tileYOffset);
    }

    @Override
    public int getCompULX(int n) {
        return this.raster.getMinX();
    }

    @Override
    public int getCompULY(int n) {
        return this.raster.getMinY();
    }

    @Override
    public int getImgULX() {
        return this.destinationRegion.x;
    }

    @Override
    public int getImgULY() {
        return this.destinationRegion.y;
    }

    @Override
    public Point getNumTiles(Point point) {
        if (point != null) {
            point.x = this.getNumXTiles();
            point.y = this.getNumYTiles();
            return point;
        }
        return new Point(this.getNumXTiles(), this.getNumYTiles());
    }

    @Override
    public int getNumTiles() {
        return this.getNumXTiles() * this.getNumYTiles();
    }

    @Override
    public int getNomRangeBits(int n) {
        return this.rb;
    }

    @Override
    public int getFixedPoint(int n) {
        return 0;
    }

    @Override
    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        if (this.writer != null && this.writer.getAbortRequest()) {
            throw new RuntimeException(J2KImageWriter.WRITE_ABORTED);
        }
        if (this.barr == null) {
            this.barr = new int[this.nc][];
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        float f = ((float)this.getTileIdx() + ((float)dataBlk.uly + 1.0f) / (float)dataBlk.h) / (float)this.getNumTiles();
        this.writer.processImageProgressWrapper(f * 100.0f);
        if (this.barr[n] == null || this.dbi.ulx > dataBlk.ulx || this.dbi.uly > dataBlk.uly || this.dbi.ulx + this.dbi.w < dataBlk.ulx + dataBlk.w || this.dbi.uly + this.dbi.h < dataBlk.uly + dataBlk.h) {
            if (this.barr[n] == null || this.barr[n].length < dataBlk.w * dataBlk.h) {
                this.barr[n] = new int[dataBlk.w * dataBlk.h];
            }
            dataBlk.setData(this.barr[n]);
            int n2 = (n + 1) % this.nc;
            while (n2 != n) {
                if (this.barr[n2] == null || this.barr[n2].length < dataBlk.w * dataBlk.h) {
                    this.barr[n2] = new int[dataBlk.w * dataBlk.h];
                }
                n2 = (n2 + 1) % this.nc;
            }
            this.dbi.ulx = dataBlk.ulx;
            this.dbi.uly = dataBlk.uly;
            this.dbi.w = dataBlk.w;
            this.dbi.h = dataBlk.h;
            if (this.aTile == null) {
                this.aTile = this.getTile(this.co.x, this.co.y);
                Rectangle rectangle = this.aTile.getBounds();
                this.aTile = this.aTile.createTranslatedChild(rectangle.x - this.minX, rectangle.y - this.minY);
            }
            n2 = 0;
            while (n2 < this.nc) {
                this.aTile.getSamples(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h, n2, this.barr[n2]);
                int n3 = 0;
                while (n3 < this.barr[n2].length) {
                    int[] nArray = this.barr[n2];
                    int n4 = n3++;
                    nArray[n4] = nArray[n4] - this.dcOffset;
                }
                ++n2;
            }
            dataBlk.setData(this.barr[n]);
            dataBlk.offset = 0;
            dataBlk.scanw = dataBlk.w;
        } else {
            dataBlk.setData(this.barr[n]);
            dataBlk.offset = (dataBlk.ulx - this.dbi.ulx) * this.dbi.w + dataBlk.ulx - this.dbi.ulx;
            dataBlk.scanw = this.dbi.scanw;
        }
        dataBlk.progressive = false;
        return dataBlk;
    }

    @Override
    public final DataBlk getCompData(DataBlk object, int n) {
        Object object2;
        if (((DataBlk)object).getDataType() != 3) {
            object2 = new DataBlkInt(((DataBlk)object).ulx, ((DataBlk)object).uly, ((DataBlk)object).w, ((DataBlk)object).h);
            object = object2;
        }
        object2 = (int[])((DataBlk)object).getData();
        int cfr_ignored_0 = ((DataBlk)object).ulx;
        int cfr_ignored_1 = ((DataBlk)object).uly;
        int n2 = ((DataBlk)object).w;
        int n3 = ((DataBlk)object).h;
        ((DataBlk)object).setData(null);
        this.getInternCompData((DataBlk)object, n);
        if (object2 == null) {
            object2 = new int[n2 * n3];
        }
        if (((DataBlk)object).offset == 0 && ((DataBlk)object).scanw == n2) {
            System.arraycopy(((DataBlk)object).getData(), 0, object2, 0, n2 * n3);
        } else {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                System.arraycopy(((DataBlk)object).getData(), ((DataBlk)object).offset + n4 * ((DataBlk)object).scanw, object2, n4 * n2, n2);
                --n4;
            }
        }
        ((DataBlk)object).setData(object2);
        ((DataBlk)object).offset = 0;
        ((DataBlk)object).scanw = ((DataBlk)object).w;
        return object;
    }

    public boolean isOrigSigned(int n) {
        if (this.isBinary) {
            return true;
        }
        SampleModel sampleModel = null;
        sampleModel = this.inputIsRaster ? this.raster.getSampleModel() : this.src.getSampleModel();
        return sampleModel.getDataType() != 1 && sampleModel.getDataType() != 0;
    }

    private int getNumXTiles() {
        int n = this.destinationRegion.x;
        int n2 = this.tileXOffset;
        int n3 = this.tileWidth;
        return RenderedImageSrc.ToTile(n + this.destinationRegion.width - 1, n2, n3) - RenderedImageSrc.ToTile(n, n2, n3) + 1;
    }

    private int getNumYTiles() {
        int n = this.destinationRegion.y;
        int n2 = this.tileYOffset;
        int n3 = this.tileHeight;
        return RenderedImageSrc.ToTile(n + this.destinationRegion.height - 1, n2, n3) - RenderedImageSrc.ToTile(n, n2, n3) + 1;
    }

    private static int ToTile(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    private Raster getTile(int n, int n2) {
        int n3 = this.tileXOffset + n * this.tileWidth;
        int n4 = this.tileYOffset + n2 * this.tileHeight;
        n += this.tileXOffset / this.tileWidth;
        n2 += this.tileYOffset / this.tileHeight;
        if (this.inputIsRaster) {
            if (this.noTransform) {
                return this.raster.createChild(n3, n4, this.getTileWidth(), this.getTileHeight(), n3, n4, this.sourceBands);
            }
            WritableRaster writableRaster = Raster.createWritableRaster(this.sm, new Point(n3, n4));
            int n5 = this.mapToSourceX(n3);
            int n6 = this.mapToSourceY(n4);
            int n7 = this.raster.getMinY();
            int n8 = this.raster.getMinY() + this.raster.getHeight();
            int n9 = this.getTileWidth();
            int n10 = 0;
            while (n10 < this.getTileHeight()) {
                if (n6 >= n7 && n6 < n8) {
                    Raster raster = this.raster.createChild(n5, n6, (n9 - 1) * this.scaleX + 1, 1, n5, n6, null);
                    int n11 = n3;
                    int n12 = 0;
                    int n13 = n5;
                    while (n12 < n9) {
                        int n14 = 0;
                        while (n14 < this.nc) {
                            int n15 = raster.getSample(n13, n6, this.sourceBands[n14]);
                            writableRaster.setSample(n11, n4, n14, n15);
                            ++n14;
                        }
                        ++n12;
                        ++n11;
                        n13 += this.scaleX;
                    }
                }
                ++n10;
                ++n4;
                n6 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.src.getTile(n, n2);
            if (this.noSubband) {
                return raster;
            }
            return raster.createChild(n3, n4, this.tileWidth, this.tileHeight, n3, n4, this.sourceBands);
        }
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, new Point(n3, n4));
        int n16 = this.mapToSourceX(n3);
        int n17 = this.mapToSourceY(n4);
        int n18 = this.src.getMinY();
        int n19 = this.src.getMinY() + this.src.getHeight();
        int n20 = this.tileWidth * this.scaleX;
        if (n16 + n20 >= this.src.getWidth()) {
            n20 = this.src.getWidth() - n16;
        }
        int n21 = (n20 + this.scaleX - 1) / this.scaleX;
        int n22 = 0;
        while (n22 < this.tileHeight) {
            if (n17 >= n18 && n17 < n19) {
                Raster raster = this.src.getData(new Rectangle(n16, n17, n20, 1));
                int n23 = n3;
                int n24 = 0;
                int n25 = n16;
                while (n24 < n21) {
                    int n26 = 0;
                    while (n26 < this.nc) {
                        int n27 = raster.getSample(n25, n17, this.sourceBands[n26]);
                        writableRaster.setSample(n23, n4, n26, n27);
                        ++n26;
                    }
                    ++n24;
                    ++n23;
                    n25 += this.scaleX;
                }
            }
            ++n22;
            ++n4;
            n17 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n) {
        return n * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n) {
        return n * this.scaleY + this.yOffset;
    }
}

