/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.IISRandomAccessIO;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class J2KReadState {
    private ImageInputStream iis = null;
    private FileFormatReader ff;
    private HeaderInfo hi;
    private HeaderDecoder hd;
    private RandomAccessIO in;
    private BitstreamReaderAgent breader;
    private EntropyDecoder entdec;
    private ROIDeScaler roids;
    private Dequantizer deq;
    private InverseWT invWT;
    private InvCompTransf ictransf;
    private ImgDataConverter converter;
    private ImgDataConverter converter2;
    private DecoderSpecs decSpec = null;
    private J2KImageReadParamJava j2krparam = null;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int[] levelShift = null;
    private int[] minValues = null;
    private int[] maxValues = null;
    private int[] fracBits = null;
    private DataBlkInt[] dataBlocks = null;
    private int[] bandOffsets = null;
    private int maxDepth = 0;
    private boolean isSigned = false;
    private ColorModel colorModel = null;
    private SampleModel sampleModel = null;
    private int nComp = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private Rectangle destinationRegion = null;
    private Point sourceOrigin;
    private int tileXOffset;
    private int tileYOffset;
    private int width;
    private int height;
    private int[] pixbuf = null;
    private byte[] bytebuf = null;
    private int[] channelMap = null;
    private boolean noTransform = true;
    private int resolution;
    private int stepX;
    private int stepY;
    private int tileStepX;
    private int tileStepY;
    private J2KMetadata metadata;
    private BufferedImage destImage;
    private J2KImageReader reader;

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null || j2KMetadata == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.metadata = j2KMetadata;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, j2KMetadata);
    }

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, null);
    }

    public int getWidth() throws IOException {
        return this.width;
    }

    public int getHeight() throws IOException {
        return this.height;
    }

    public HeaderDecoder getHeader() {
        return this.hd;
    }

    public Raster getTile(int n, int n2, WritableRaster writableRaster) throws IOException {
        Point point = this.ictransf.getNumTiles(null);
        if (this.noTransform) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n >= point.x || n2 >= point.y) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
            }
            this.ictransf.setTile(n * this.tileStepX, n2 * this.tileStepY);
            if (writableRaster != null && this.resolution < this.hd.getDecoderSpecs().dls.getMin() || this.stepX != 1 || this.stepY != 1) {
                n6 = writableRaster.getMinX();
                n5 = writableRaster.getMinY();
                n4 = Math.min(writableRaster.getWidth(), this.ictransf.getTileWidth());
                n3 = Math.min(writableRaster.getHeight(), this.ictransf.getTileHeight());
            } else {
                n6 = this.ictransf.getCompULX(0) - (this.ictransf.getImgULX() + this.ictransf.getCompSubsX(0) - 1) / this.ictransf.getCompSubsX(0) + this.destinationRegion.x;
                n5 = this.ictransf.getCompULY(0) - (this.ictransf.getImgULY() + this.ictransf.getCompSubsY(0) - 1) / this.ictransf.getCompSubsY(0) + this.destinationRegion.y;
                n4 = this.ictransf.getTileWidth();
                n3 = this.ictransf.getTileHeight();
            }
            if (writableRaster == null) {
                writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n6, n5));
            }
            int n7 = this.sampleModel.getNumBands();
            if (n6 + n4 >= this.destinationRegion.width + this.destinationRegion.x) {
                n4 = this.destinationRegion.width + this.destinationRegion.x - n6;
            }
            if (n5 + n3 >= this.destinationRegion.height + this.destinationRegion.y) {
                n3 = this.destinationRegion.height + this.destinationRegion.y - n5;
            }
            if (this.pixbuf == null || this.pixbuf.length < n4 * n7) {
                this.pixbuf = new int[n4 * n7];
            }
            boolean bl = false;
            int n8 = 0;
            while (n8 < n3) {
                if (!this.reader.getAbortRequest()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        int n10;
                        int n11;
                        if (this.reader.getAbortRequest()) break;
                        DataBlkInt dataBlkInt = this.dataBlocks[n9];
                        dataBlkInt.ulx = 0;
                        dataBlkInt.uly = n8;
                        dataBlkInt.w = n4;
                        dataBlkInt.h = 1;
                        this.ictransf.getInternCompData(dataBlkInt, this.channelMap[this.sourceBands[n9]]);
                        bl = bl || dataBlkInt.progressive;
                        int[] nArray = dataBlkInt.data;
                        int n12 = dataBlkInt.offset + n4 - 1;
                        int n13 = this.fracBits[n9];
                        int n14 = this.levelShift[n9];
                        int n15 = this.minValues[n9];
                        int n16 = this.maxValues[n9];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            n15 = 0;
                            n16 = 1;
                            if (this.bytebuf == null || this.bytebuf.length < n4 * n7) {
                                this.bytebuf = new byte[n4 * n7];
                            }
                            n11 = n4 - 1;
                            while (n11 >= 0) {
                                this.bytebuf[n11] = (byte)((n10 = (nArray[n12--] >> n13) + n14) < n15 ? n15 : (n10 > n16 ? n16 : n10));
                                --n11;
                            }
                            ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n6, n5 + n8, n4, 1));
                        } else {
                            n11 = n4 - 1;
                            while (n11 >= 0) {
                                this.pixbuf[n11] = (n10 = (nArray[n12--] >> n13) + n14) < n15 ? n15 : (n10 > n16 ? n16 : n10);
                                --n11;
                            }
                            writableRaster.setSamples(n6, n5 + n8, n4, 1, this.destinationBands[n9], this.pixbuf);
                        }
                        ++n9;
                    }
                    ++n8;
                    continue;
                }
                break;
            }
        } else {
            this.readSubsampledRaster(writableRaster);
        }
        return writableRaster;
    }

    public Rectangle getDestinationRegion() {
        return this.destinationRegion;
    }

    public BufferedImage readBufferedImage() throws IOException {
        this.colorModel = this.getColorModel();
        this.sampleModel = this.getSampleModel();
        WritableRaster writableRaster = null;
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        int n = this.destinationRegion.x;
        int n2 = this.destinationRegion.y;
        this.destinationRegion.setLocation(this.j2krparam.getDestinationOffset());
        if (bufferedImage == null) {
            ImageTypeSpecifier imageTypeSpecifier = this.j2krparam.getDestinationType();
            if (imageTypeSpecifier != null) {
                this.colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
            bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        this.destImage = bufferedImage;
        this.readSubsampledRaster(writableRaster);
        this.destinationRegion.setLocation(n, n2);
        this.destImage = null;
        return bufferedImage;
    }

    public Raster readAsRaster() throws IOException {
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        WritableRaster writableRaster = null;
        writableRaster = bufferedImage == null ? Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0)) : bufferedImage.getWritableTile(0, 0);
        this.readSubsampledRaster(writableRaster);
        return writableRaster;
    }

    private void initializeRead(int n, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata) {
        try {
            int n2;
            Object object;
            this.iis.mark();
            this.in = new IISRandomAccessIO(this.iis);
            this.ff = new FileFormatReader(this.in, j2KMetadata);
            this.ff.readFileFormat();
            this.in.seek(this.ff.getFirstCodeStreamPos());
            this.hi = new HeaderInfo();
            try {
                this.hd = new HeaderDecoder(this.in, this.j2krparam, this.hi);
            }
            catch (EOFException eOFException) {
                throw new RuntimeException(I18N.getString("J2KReadState2"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.width = this.hd.getImgWidth();
            this.height = this.hd.getImgHeight();
            Rectangle rectangle = j2KImageReadParamJava.getSourceRegion();
            this.sourceOrigin = new Point();
            rectangle = new Rectangle(this.hd.getImgULX(), this.hd.getImgULY(), this.width, this.height);
            this.stepX = this.hd.getCompSubsX(0);
            this.stepY = this.hd.getCompSubsY(0);
            int n3 = 1;
            while (n3 < this.nComp) {
                if (this.stepX != this.hd.getCompSubsX(n3) || this.stepY != this.hd.getCompSubsY(n3)) {
                    throw new RuntimeException(I18N.getString("J2KReadState12"));
                }
                ++n3;
            }
            n3 = this.hd.getDecoderSpecs().dls.getMin();
            int n4 = this.resolution = j2KImageReadParamJava != null ? j2KImageReadParamJava.getResolution() : n3;
            if (this.resolution < 0 || this.resolution > n3) {
                this.resolution = n3;
            }
            if (this.resolution != n3 || this.stepX != 1 || this.stepY != 1) {
                rectangle = J2KImageReader.getReducedRect(rectangle, n3, this.resolution, this.stepX, this.stepY);
            }
            this.destinationRegion = (Rectangle)rectangle.clone();
            J2KImageReader.computeRegionsWrapper(j2KImageReadParamJava, false, this.width, this.height, j2KImageReadParamJava.getDestination(), rectangle, this.destinationRegion);
            this.sourceOrigin = new Point(rectangle.x, rectangle.y);
            this.scaleX = j2KImageReadParamJava.getSourceXSubsampling();
            this.scaleY = j2KImageReadParamJava.getSourceYSubsampling();
            this.xOffset = j2KImageReadParamJava.getSubsamplingXOffset();
            this.yOffset = j2KImageReadParamJava.getSubsamplingYOffset();
            this.width = this.destinationRegion.width;
            this.height = this.destinationRegion.height;
            Point point = this.hd.getTilingOrigin(null);
            this.tileWidth = this.hd.getNomTileWidth();
            this.tileHeight = this.hd.getNomTileHeight();
            if (this.resolution != n3 || this.stepX != 1 || this.stepY != 1) {
                object = new Rectangle(point);
                ((Rectangle)object).width = this.tileWidth;
                ((Rectangle)object).height = this.tileHeight;
                object = J2KImageReader.getReducedRect((Rectangle)object, n3, this.resolution, this.stepX, this.stepY);
                point = ((Rectangle)object).getLocation();
                this.tileWidth = ((Rectangle)object).width;
                this.tileHeight = ((Rectangle)object).height;
            }
            this.tileXOffset = point.x;
            this.tileYOffset = point.y;
            this.tileStepX = this.tileWidth * (1 << n3 - this.resolution) * this.stepX > this.hd.getNomTileWidth() ? (this.tileWidth * (1 << n3 - this.resolution) * this.stepX + this.hd.getNomTileWidth() - 1) / this.hd.getNomTileWidth() : 1;
            this.tileStepY = this.tileHeight * (1 << n3 - this.resolution) * this.stepY > this.hd.getNomTileHeight() ? (this.tileHeight * (1 << n3 - this.resolution) * this.stepY + this.hd.getNomTileHeight() - 1) / this.hd.getNomTileHeight() : 1;
            if (!this.destinationRegion.equals(rectangle)) {
                this.noTransform = false;
            }
            this.decSpec = this.hd.getDecoderSpecs();
            this.nComp = this.hd.getNumComps();
            object = new int[this.nComp];
            int n5 = 0;
            while (n5 < this.nComp) {
                object[n5] = this.hd.getOriginalBitDepth(n5);
                ++n5;
            }
            ChannelDefinitionBox channelDefinitionBox = null;
            if (j2KMetadata != null) {
                channelDefinitionBox = (ChannelDefinitionBox)j2KMetadata.getElement("JPEG2000ChannelDefinitionBox");
            }
            this.channelMap = new int[this.nComp];
            if (channelDefinitionBox != null && j2KMetadata.getElement("JPEG2000PaletteBox") == null) {
                short[] sArray = channelDefinitionBox.getAssociation();
                short[] sArray2 = channelDefinitionBox.getTypes();
                short[] sArray3 = channelDefinitionBox.getChannel();
                int n6 = 0;
                while (n6 < sArray2.length) {
                    if (sArray2[n6] == 0) {
                        this.channelMap[sArray3[n6]] = sArray[n6] - 1;
                    } else if (sArray2[n6] == 1 || sArray2[n6] == 2) {
                        this.channelMap[sArray3[n6]] = sArray3[n6];
                    }
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < this.nComp) {
                    this.channelMap[n7] = n7;
                    ++n7;
                }
            }
            try {
                n2 = Boolean.getBoolean("jj2000.j2k.decoder.log");
                this.breader = BitstreamReaderAgent.createInstance(this.in, this.hd, this.j2krparam, this.decSpec, n2 != 0, this.hi);
            }
            catch (IOException iOException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState3")) + " " + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState4")) + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.entdec = this.hd.createEntropyDecoder(this.breader, this.j2krparam);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState5")) + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.roids = this.hd.createROIDeScaler(this.entdec, this.j2krparam, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState6")) + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.deq = this.hd.createDequantizer(this.roids, (int[])object, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState7")) + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.invWT = InverseWT.createInstance(this.deq, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState8")) + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            n2 = this.breader.getImgRes();
            this.decSpec.dls.getMin();
            this.invWT.setImgResLevel(n2);
            this.converter = new ImgDataConverter(this.invWT, 0);
            this.ictransf = new InvCompTransf(this.converter, this.decSpec, (int[])object);
            this.sourceBands = this.j2krparam.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.nComp];
                int n8 = 0;
                while (n8 < this.nComp) {
                    this.sourceBands[n8] = n8;
                    ++n8;
                }
            }
            this.nComp = this.sourceBands.length;
            this.destinationBands = this.j2krparam.getDestinationBands();
            if (this.destinationBands == null) {
                this.destinationBands = new int[this.nComp];
                int n9 = 0;
                while (n9 < this.nComp) {
                    this.destinationBands[n9] = n9;
                    ++n9;
                }
            }
            J2KImageReader.checkReadParamBandSettingsWrapper(j2KImageReadParamJava, this.hd.getNumComps(), this.destinationBands.length);
            this.levelShift = new int[this.nComp];
            this.minValues = new int[this.nComp];
            this.maxValues = new int[this.nComp];
            this.fracBits = new int[this.nComp];
            this.dataBlocks = new DataBlkInt[this.nComp];
            object = new int[this.nComp];
            this.bandOffsets = new int[this.nComp];
            this.maxDepth = 0;
            this.isSigned = false;
            int n10 = 0;
            while (n10 < this.nComp) {
                object[n10] = this.hd.getOriginalBitDepth(this.sourceBands[n10]);
                if (object[n10] > this.maxDepth) {
                    this.maxDepth = (int)object[n10];
                }
                this.dataBlocks[n10] = new DataBlkInt();
                this.bandOffsets[n10] = n10;
                if (this.hd.isOriginalSigned(this.sourceBands[n10])) {
                    this.isSigned = true;
                } else {
                    this.levelShift[n10] = 1 << this.ictransf.getNomRangeBits(this.sourceBands[n10]) - 1;
                }
                int n11 = this.ictransf.getNomRangeBits(this.sourceBands[n10]);
                this.maxValues[n10] = (1 << (this.isSigned ? n11 - 1 : n11)) - 1;
                this.minValues[n10] = this.isSigned ? -(this.maxValues[n10] + 1) : 0;
                this.fracBits[n10] = this.ictransf.getFixedPoint(this.sourceBands[n10]);
                ++n10;
            }
            this.iis.reset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Error error) {
            if (error.getMessage() != null) {
                throw new RuntimeException(error.getMessage(), error);
            }
            throw new RuntimeException(I18N.getString("J2KReadState9"), error);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage() != null) {
                throw new RuntimeException(String.valueOf(I18N.getString("J2KReadState10")) + " " + runtimeException.getMessage(), runtimeException);
            }
            throw new RuntimeException(I18N.getString("J2KReadState10"), runtimeException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(I18N.getString("J2KReadState10"), throwable);
        }
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int[] nArray = null;
        boolean bl = false;
        Point point = this.ictransf.getNumTiles(null);
        int n = this.sourceBands.length;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n2 = this.destinationRegion.x;
        int n3 = this.destinationRegion.y;
        int n4 = (rectangle.x - n2) * this.scaleX + this.sourceOrigin.x;
        int n5 = (rectangle.y - n3) * this.scaleY + this.sourceOrigin.y;
        int n6 = (rectangle.width - 1) * this.scaleX + n4;
        int n7 = (rectangle.height - 1) * this.scaleY + n5;
        int n8 = (n4 - this.tileXOffset) / this.tileWidth;
        int n9 = (n5 - this.tileYOffset) / this.tileHeight;
        int n10 = (n6 - this.tileXOffset) / this.tileWidth;
        int n11 = (n7 - this.tileYOffset) / this.tileHeight;
        n8 = this.clip(n8, 0, point.x - 1);
        n9 = this.clip(n9, 0, point.y - 1);
        n10 = this.clip(n10, 0, point.x - 1);
        n11 = this.clip(n11, 0, point.y - 1);
        int n12 = n10 - n8 + 1;
        int n13 = n11 - n9 + 1;
        int n14 = n12 * n13;
        int n15 = n9;
        while (n15 <= n11) {
            if (this.reader.getAbortRequest()) break;
            int n16 = n8;
            while (n16 <= n10) {
                if (this.reader.getAbortRequest()) break;
                float f = (n16 - n8 + (n15 - n9) * n12) / n14;
                this.ictransf.setTile(n16 * this.tileStepX, n15 * this.tileStepY);
                int n17 = this.hd.getCompSubsX(0);
                int n18 = (this.ictransf.getTileWidth() + n17 - 1) / n17;
                int n19 = this.hd.getCompSubsY(0);
                int n20 = (this.ictransf.getTileHeight() + n19 - 1) / n19;
                int n21 = 0;
                int n22 = 0;
                int n23 = this.tileXOffset + n16 * this.tileWidth;
                int n24 = this.tileYOffset + n15 * this.tileHeight;
                if (n4 > n23) {
                    if (n23 >= this.hd.getImgULX()) {
                        n21 = n4 - n23;
                        n18 -= n21;
                    }
                    n23 = n4;
                }
                if (n5 > n24) {
                    if (n24 >= this.hd.getImgULY()) {
                        n22 = n5 - n24;
                        n20 -= n22;
                    }
                    n24 = n5;
                }
                if (n6 < n23 + n18 - 1) {
                    n18 += n6 - n23 - n18 + 1;
                }
                if (n7 < n24 + n20 - 1) {
                    n20 += n7 - n24 - n20 + 1;
                }
                int n25 = (n23 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n26 = (n23 + this.scaleX - 1 + n18 - this.sourceOrigin.x) / this.scaleX;
                int n27 = n26 - n25;
                if (nArray == null || nArray.length < n27) {
                    nArray = new int[n27];
                }
                n26 = (n26 - 1) * this.scaleX + this.sourceOrigin.x - n23;
                int n28 = (n24 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n25 += n2;
                int n29 = n22;
                int n30 = n28 += n3;
                while (n29 < n22 + n20) {
                    if (this.reader.getAbortRequest()) break;
                    int n31 = 0;
                    while (n31 < n) {
                        int n32;
                        int n33;
                        DataBlkInt dataBlkInt = this.dataBlocks[n31];
                        dataBlkInt.ulx = n21;
                        dataBlkInt.uly = n29;
                        dataBlkInt.w = n18;
                        dataBlkInt.h = 1;
                        this.ictransf.getInternCompData(dataBlkInt, this.channelMap[this.sourceBands[n31]]);
                        bl = bl || dataBlkInt.progressive;
                        int[] nArray2 = dataBlkInt.data;
                        int n34 = dataBlkInt.offset + n26;
                        int n35 = this.fracBits[n31];
                        int n36 = this.levelShift[n31];
                        int n37 = this.minValues[n31];
                        int n38 = this.maxValues[n31];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            n37 = 0;
                            n38 = 1;
                            if (this.bytebuf == null || this.bytebuf.length < n18 * n) {
                                this.bytebuf = new byte[n18 * n];
                            }
                            n33 = n27 - 1;
                            while (n33 >= 0) {
                                n32 = (nArray2[n34] >> n35) + n36;
                                this.bytebuf[n33] = (byte)(n32 < n37 ? n37 : (n32 > n38 ? n38 : n32));
                                --n33;
                                n34 -= this.scaleX;
                            }
                            ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n25, n30, n27, 1));
                        } else {
                            n33 = n27 - 1;
                            while (n33 >= 0) {
                                n32 = (nArray2[n34] >> n35) + n36;
                                nArray[n33] = n32 < n37 ? n37 : (n32 > n38 ? n38 : n32);
                                --n33;
                                n34 -= this.scaleX;
                            }
                            writableRaster.setSamples(n25, n30, n27, 1, this.destinationBands[n31], nArray);
                        }
                        ++n31;
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, n25, n30, n18, 1, 1, 1, this.destinationBands);
                    }
                    float f2 = f + ((float)(n29 - n22) + 1.0f) / (float)n20 / (float)n14;
                    this.reader.processImageProgressWrapper(100.0f * f2);
                    n29 += this.scaleY;
                    ++n30;
                }
                ++n16;
            }
            ++n15;
        }
        return writableRaster;
    }

    public ImageTypeSpecifier getImageType() throws IOException {
        this.getSampleModel();
        this.getColorModel();
        return new ImageTypeSpecifier(this.colorModel, this.sampleModel);
    }

    public SampleModel getSampleModel() {
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.nComp == 1 && (this.maxDepth == 1 || this.maxDepth == 2 || this.maxDepth == 4)) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.maxDepth);
        } else if (this.maxDepth <= 8) {
            this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 16) {
            this.sampleModel = new PixelInterleavedSampleModel(this.isSigned ? 2 : 1, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 32) {
            this.sampleModel = new PixelInterleavedSampleModel(3, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else {
            throw new IllegalArgumentException(String.valueOf(I18N.getString("J2KReadState11")) + " " + this.maxDepth);
        }
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        this.colorModel = this.ff.getColorModel();
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.hi.siz.csiz <= 4) {
            ColorSpace colorSpace = this.hi.siz.csiz > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] nArray = new int[this.hi.siz.csiz];
            boolean bl = false;
            int n = -1;
            int n2 = 0;
            while (n2 < this.hi.siz.csiz) {
                nArray[n2] = this.hi.siz.getOrigBitDepth(n2);
                if (n < nArray[n2]) {
                    n = nArray[n2];
                }
                bl |= this.hi.siz.isOrigSigned(n2);
                n2 += 1;
            }
            n2 = this.hi.siz.csiz % 2 == 0 ? 1 : 0;
            int n3 = -1;
            if (n <= 8) {
                n3 = 0;
            } else if (n <= 16) {
                n3 = bl ? 2 : 1;
            } else if (n <= 32) {
                n3 = 3;
            }
            if (n3 != -1) {
                this.colorModel = this.hi.siz.csiz == 1 && (n == 1 || n == 2 || n == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel(colorSpace, nArray, n2 != 0, false, n2 != 0 ? 3 : 1, n3);
                return this.colorModel;
            }
        }
        if (this.sampleModel == null) {
            this.sampleModel = this.getSampleModel();
        }
        if (this.sampleModel == null) {
            return null;
        }
        return ImageUtil.createColorModel(null, this.sampleModel);
    }

    Rectangle getTile0Rect() {
        return new Rectangle(this.tileXOffset, this.tileYOffset, this.tileWidth, this.tileHeight);
    }

    private int clip(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    private void clipDestination(Rectangle rectangle) {
        Point point = this.j2krparam.getDestinationOffset();
        if (rectangle.x < point.x) {
            rectangle.width += rectangle.x - point.x;
            rectangle.x = point.x;
        }
        if (rectangle.y < point.y) {
            rectangle.height += rectangle.y - point.y;
            rectangle.y = point.y;
        }
    }
}

