/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.IISRandomAccessIO;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2KMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
    private J2KMetadataFormat format;
    private ArrayList boxes = new ArrayList();

    public J2KMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
        this.format = (J2KMetadataFormat)this.getMetadataFormat(nativeMetadataFormatName);
    }

    public J2KMetadata(ImageInputStream imageInputStream, J2KImageReader j2KImageReader) throws IOException {
        this();
        IISRandomAccessIO iISRandomAccessIO = new IISRandomAccessIO(imageInputStream);
        imageInputStream.mark();
        FileFormatReader fileFormatReader = new FileFormatReader(iISRandomAccessIO, this);
        fileFormatReader.readFileFormat();
        imageInputStream.reset();
    }

    public J2KMetadata(ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this(null, imageWriteParam, imageWriter);
    }

    public J2KMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this(imageTypeSpecifier != null ? imageTypeSpecifier.getColorModel() : null, imageTypeSpecifier != null ? imageTypeSpecifier.getSampleModel() : null, 0, 0, imageWriteParam, imageWriter);
    }

    public J2KMetadata(ColorModel colorModel, SampleModel sampleModel, int n, int n2, ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this();
        int n3;
        int n4;
        this.addNode(new SignatureBox());
        this.addNode(new FileTypeBox(1785737760, 0, new int[]{1785737760}));
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
            if (colorModel == null && sampleModel == null) {
                colorModel = imageTypeSpecifier == null ? null : imageTypeSpecifier.getColorModel();
                sampleModel = imageTypeSpecifier == null ? null : imageTypeSpecifier.getSampleModel();
            }
        }
        int[] nArray = null;
        if (colorModel != null) {
            nArray = colorModel.getComponentSize();
        } else if (sampleModel != null) {
            nArray = sampleModel.getSampleSize();
        }
        int n5 = 255;
        if (nArray != null) {
            n5 = nArray[0];
            n4 = nArray.length;
            n3 = 1;
            while (n3 < n4) {
                if (nArray[n3] > n5) {
                    n5 = nArray[n3];
                }
                ++n3;
            }
        }
        if (colorModel != null) {
            ColorSpace colorSpace = colorModel.getColorSpace();
            boolean cfr_ignored_0 = colorSpace instanceof ICC_ColorSpace;
            n3 = colorSpace.getType();
            if (n3 == 5) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 16, null));
            } else if (n3 == 6) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 17, null));
            } else if (colorSpace instanceof ICC_ColorSpace) {
                this.addNode(new ColorSpecificationBox(2, 0, 0, 0, ((ICC_ColorSpace)colorSpace).getProfile()));
            }
            if (colorModel.hasAlpha()) {
                this.addNode(new ChannelDefinitionBox(colorModel));
            }
            if (colorModel instanceof IndexColorModel) {
                this.addNode(new PaletteBox((IndexColorModel)colorModel));
                int n6 = colorModel.getComponentSize().length;
                short[] sArray = new short[n6];
                byte[] byArray = new byte[n6];
                byte[] byArray2 = new byte[n6];
                int n7 = 0;
                while (n7 < n6) {
                    sArray[n7] = 0;
                    byArray[n7] = 1;
                    byArray2[n7] = (byte)n7;
                    ++n7;
                }
                this.addNode(new ComponentMappingBox(sArray, byArray, byArray2));
            }
        }
        if (sampleModel != null) {
            if (n <= 0) {
                n = sampleModel.getWidth();
            }
            if (n2 <= 0) {
                n2 = sampleModel.getHeight();
            }
            n4 = n5 == 255 ? 255 : n5 - 1 | (this.isOriginalSigned(sampleModel) ? 128 : 0);
            this.addNode(new HeaderBox(n2, n, sampleModel.getNumBands(), n4, 7, colorModel == null ? 1 : 0, this.getElement("JPEG2000IntellectualPropertyRightsBox") == null ? 0 : 1));
        }
    }

    public Object clone() {
        J2KMetadata j2KMetadata = null;
        try {
            j2KMetadata = (J2KMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        if (this.boxes != null) {
            int n = this.boxes.size();
            int n2 = 0;
            while (n2 < n) {
                j2KMetadata.addNode((Box)this.boxes.get(n2));
                ++n2;
            }
        }
        return j2KMetadata;
    }

    @Override
    public Node getAsTree(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(String.valueOf(I18N.getString("J2KMetadata1")) + " " + string);
    }

    IIOMetadataNode getNativeTree() {
        Box box;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        Box box2 = null;
        Box box3 = null;
        Box box4 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.boxes.size();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4 && n5 < 3) {
            box = (Box)this.boxes.get(n6);
            if (Box.getName(box.getType()).equals("JPEG2000SignatureBox")) {
                box2 = box;
                n = n6;
                ++n5;
            } else if (Box.getName(box.getType()).equals("JPEG2000FileTypeBox")) {
                box3 = box;
                n2 = n6;
                ++n5;
            } else if (Box.getName(box.getType()).equals("JPEG2000HeaderBox")) {
                box4 = box;
                n3 = n6;
                ++n5;
            }
            ++n6;
        }
        if (box2 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box2.getNativeNode());
        }
        if (box3 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box3.getNativeNode());
        }
        if (box4 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box4.getNativeNode());
        }
        n6 = 0;
        while (n6 < n4) {
            if (n6 != n && n6 != n2 && n6 != n3) {
                box = (Box)this.boxes.get(n6);
                IIOMetadataNode iIOMetadataNode2 = box.getNativeNode();
                this.insertNodeIntoTree(iIOMetadataNode, iIOMetadataNode2);
            }
            ++n6;
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        PaletteBox paletteBox = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        ColorSpecificationBox colorSpecificationBox = (ColorSpecificationBox)this.getElement("JPEG2000ColorSpecificationBox");
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        if (headerBox != null) {
            if (headerBox.getUnknownColorspace() == 0 && colorSpecificationBox != null && colorSpecificationBox.getMethod() == 1) {
                iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
                int n = colorSpecificationBox.getEnumeratedColorSpace();
                if (n == 16) {
                    iIOMetadataNode2.setAttribute("name", "RGB");
                }
                if (n == 17) {
                    iIOMetadataNode2.setAttribute("name", "GRAY");
                }
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode2.setAttribute("value", "" + headerBox.getNumComponents());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            if (paletteBox != null) {
                iIOMetadataNode2.setAttribute("value", "" + paletteBox.getNumComp());
                iIOMetadataNode2 = new IIOMetadataNode("Palette");
                byte[][] byArray = paletteBox.getLUT();
                int n = byArray[0].length;
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                    iIOMetadataNode3.setAttribute("index", "" + n3);
                    iIOMetadataNode3.setAttribute("red", "" + (byArray[0][n3] & 0xFF));
                    iIOMetadataNode3.setAttribute("green", "" + (byArray[1][n3] & 0xFF));
                    iIOMetadataNode3.setAttribute("blue", "" + (byArray[2][n3] & 0xFF));
                    if (n2 == 4) {
                        iIOMetadataNode3.setAttribute("alpha", "" + (byArray[3][n3] & 0xFF));
                    }
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                    ++n3;
                }
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "JPEG2000");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        Object object;
        Object object2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        PaletteBox paletteBox = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        boolean bl = false;
        if (paletteBox != null) {
            object2 = new IIOMetadataNode("SampleFormat");
            ((IIOMetadataNode)object2).setAttribute("value", "Index");
            iIOMetadataNode.appendChild((Node)object2);
            bl = true;
        }
        object2 = (BitsPerComponentBox)this.getElement("JPEG2000BitsPerComponentBox");
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        if (object2 != null) {
            object = ((BitsPerComponentBox)object2).getBitDepth();
            if ((object[0] & 0x80) == 128) {
                bl2 = true;
            }
            int n = ((Object)object).length;
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + ((object[n2] & 0x7F) + 1);
                if (n2 != n - 1) {
                    string = String.valueOf(string) + " ";
                }
                ++n2;
            }
            bl3 = true;
        } else {
            object = (HeaderBox)this.getElement("JPEG2000HeaderBox");
            if (object != null) {
                int n = object.getBitDepth();
                if ((n & 0x80) == 128) {
                    bl2 = true;
                }
                n = (n & 0x7F) + 1;
                int n3 = object.getNumComponents();
                int n4 = 0;
                while (n4 < n3) {
                    string = String.valueOf(string) + n;
                    if (n4 != n3 - 1) {
                        string = String.valueOf(string) + " ";
                    }
                    ++n4;
                }
                bl3 = true;
            }
        }
        object = null;
        if (bl3) {
            object = new IIOMetadataNode("BitsPerSample");
            object.setAttribute("value", string);
            iIOMetadataNode.appendChild((Node)object);
        }
        object = new IIOMetadataNode("PlanarConfiguration");
        object.setAttribute("value", "TileInterleaved");
        iIOMetadataNode.appendChild((Node)object);
        if (!bl && bl3) {
            object = new IIOMetadataNode("SampleFormat");
            object.setAttribute("value", bl2 ? "SignedIntegral" : "UnsignedIntegral");
            iIOMetadataNode.appendChild((Node)object);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        ResolutionBox resolutionBox = (ResolutionBox)this.getElement("JPEG2000CaptureResolutionBox");
        if (resolutionBox != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
            float f = resolutionBox.getHorizontalResolution();
            float f2 = resolutionBox.getVerticalResolution();
            float f3 = f2 / f;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode2.setAttribute("value", "" + f3);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / f);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / f2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
            boolean bl = false;
            boolean bl2 = false;
            short[] sArray = channelDefinitionBox.getTypes();
            int n = 0;
            while (n < sArray.length) {
                if (sArray[n] == 1) {
                    bl = true;
                }
                if (sArray[n] == 2) {
                    bl2 = true;
                }
                ++n;
            }
            String string = "none";
            if (bl2) {
                string = "premultiplied";
            } else if (bl) {
                string = "nonpremultiplied";
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Alpha");
        iIOMetadataNode3.setAttribute("value", "none");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (this.boxes == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = null;
        for (Box box : this.boxes) {
            if (!(box instanceof XMLBox)) continue;
            if (iIOMetadataNode == null) {
                iIOMetadataNode = new IIOMetadataNode("Text");
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            String string = new String(box.getContent());
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(String.valueOf(I18N.getString("J2KMetadata1")) + " " + string);
        }
    }

    @Override
    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.boxes = new ArrayList();
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.boxes = new ArrayList();
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(String.valueOf(I18N.getString("J2KMetadata1")) + " " + string);
        }
    }

    @Override
    public void reset() {
        this.boxes.clear();
    }

    public void addNode(Box box) {
        if (this.boxes == null) {
            this.boxes = new ArrayList();
        }
        this.replace(Box.getName(box.getType()), box);
    }

    public Box getElement(String string) {
        int n = this.boxes.size() - 1;
        while (n >= 0) {
            Box box = (Box)this.boxes.get(n);
            if (string.equals(Box.getName(box.getType()))) {
                return box;
            }
            --n;
        }
        return null;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength() - 1;
        while (n >= 0) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (this.format.getParent(string) != null) {
                if (this.format.isLeaf(string)) {
                    String string2 = (String)Box.getAttribute(node2, "Type");
                    Box box = Box.createBox(Box.getTypeInt(string2), node2);
                    if (this.format.singleInstance(string) && this.getElement(string) != null) {
                        this.replace(string, box);
                    } else {
                        this.boxes.add(box);
                    }
                } else {
                    this.mergeNativeTree(node2);
                }
            }
            --n;
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node2 = nodeList.item(n2);
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                NodeList nodeList2 = node2.getChildNodes();
                int n3 = 0;
                while (n3 < nodeList2.getLength()) {
                    Node node3 = nodeList2.item(n3);
                    String string2 = node3.getNodeName();
                    if (string2.equals("NumChannels")) {
                        String string3 = (String)Box.getAttribute(node3, "value");
                        n = new Integer(string3);
                    }
                    if (string2.equals("ColorSpaceType")) {
                        this.createColorSpecificationBoxFromStandardNode(node3);
                    }
                    if (string2.equals("Palette")) {
                        this.createPaletteBoxFromStandardNode(node3);
                    }
                    ++n3;
                }
            } else if (!string.equals("Compression")) {
                if (string.equals("Data")) {
                    this.createBitsPerComponentBoxFromStandardNode(node2);
                    this.createHeaderBoxFromStandardNode(node2, n);
                } else if (string.equals("Dimension")) {
                    this.createResolutionBoxFromStandardNode(node2);
                } else if (string.equals("Document")) {
                    this.createXMLBoxFromStandardNode(node2);
                } else if (string.equals("Text")) {
                    this.createXMLBoxFromStandardNode(node2);
                } else if (string.equals("Transparency")) {
                    this.createChannelDefinitionFromStandardNode(node2);
                } else {
                    throw new IIOInvalidTreeException(String.valueOf(I18N.getString("J2KMetadata3")) + " " + string, node2);
                }
            }
            ++n2;
        }
    }

    private void createColorSpecificationBoxFromStandardNode(Node node) {
        int n;
        if (node.getNodeName() != "ColorSpaceType") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata4"));
        }
        String string = (String)Box.getAttribute(node, "name");
        int n2 = string.equals("RGB") ? 16 : (n = string.equals("Gray") ? 17 : 0);
        if (n == 16 || n == 17) {
            this.replace("JPEG2000ColorSpecificationBox", new ColorSpecificationBox(1, 0, 0, n, null));
        }
    }

    private void createPaletteBoxFromStandardNode(Node node) {
        Object object;
        if (node.getNodeName() != "Palette") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata5"));
        }
        NodeList nodeList = node.getChildNodes();
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node2 = nodeList.item(n2);
            String string = node2.getNodeName();
            if (string.equals("PaletteEntry")) {
                object = (String)Box.getAttribute(node2, "index");
                int n3 = new Integer((String)object);
                if (n3 > n) {
                    n = n3;
                }
                if (Box.getAttribute(node2, "alpha") != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        n2 = 32;
        int n4 = Integer.MIN_VALUE;
        while (n4 != 0 && (n & n4) == 0) {
            --n2;
            n4 >>>= 1;
        }
        int n5 = 1 << n2;
        object = new byte[n5];
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = bl ? new byte[n5] : null;
        int n6 = 0;
        while (n6 < nodeList.getLength()) {
            Node node3 = nodeList.item(n6);
            String string = node3.getNodeName();
            if (string.equals("PaletteEntry")) {
                String string2 = (String)Box.getAttribute(node3, "index");
                int n7 = new Integer(string2);
                string2 = (String)Box.getAttribute(node3, "red");
                object[n7] = (byte)new Integer(string2).intValue();
                string2 = (String)Box.getAttribute(node3, "green");
                byArray[n7] = (byte)new Integer(string2).intValue();
                string2 = (String)Box.getAttribute(node3, "blue");
                byArray2[n7] = (byte)new Integer(string2).intValue();
                int n8 = -1;
                string2 = (String)Box.getAttribute(node3, "alpha");
                if (string2 != null) {
                    n8 = (byte)new Integer(string2).intValue();
                }
                if (byArray3 != null) {
                    byArray3[n7] = n8;
                }
            }
            ++n6;
        }
        IndexColorModel indexColorModel = byArray3 == null ? new IndexColorModel(n2, n5, (byte[])object, byArray, byArray2) : new IndexColorModel(n2, n5, (byte[])object, byArray, byArray2, byArray3);
        this.replace("JPEG2000PaletteBox", new PaletteBox(indexColorModel));
    }

    private void createBitsPerComponentBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Data") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata6"));
        }
        NodeList nodeList = node.getChildNodes();
        byte[] byArray = null;
        boolean bl = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node2 = nodeList.item(n);
            String string2 = node2.getNodeName();
            if (string2.equals("BitsPerSample")) {
                string = (String)Box.getAttribute(node2, "value");
                byArray = (byte[])Box.parseByteArray(string).clone();
            } else if (string2.equals("SampleFormat")) {
                string = (String)Box.getAttribute(node2, "value");
                bl = string.equals("SignedIntegral");
            }
            ++n;
        }
        if (byArray != null) {
            n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)((byArray[n] & 0xFF) - 1);
                if (bl) {
                    int n2 = n;
                    byArray[n2] = (byte)(byArray[n2] | 0x80);
                }
                ++n;
            }
            this.replace("JPEG2000BitsPerComponent", new BitsPerComponentBox(byArray));
        }
    }

    private void createResolutionBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Dimension") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata7"));
        }
        NodeList nodeList = node.getChildNodes();
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node2 = nodeList.item(n);
            String string2 = node2.getNodeName();
            if (string2.equals("HorizontalPixelSize")) {
                string = (String)Box.getAttribute(node2, "value");
                f = new Float(string).floatValue();
                f = 1000.0f / f;
                bl = true;
            }
            if (string2.equals("VerticalPixelSize")) {
                string = (String)Box.getAttribute(node2, "value");
                f2 = new Float(string).floatValue();
                f2 = 1000.0f / f2;
                bl2 = true;
            }
            ++n;
        }
        if (bl && !bl2) {
            f2 = f;
        } else if (bl2 && !bl) {
            f = f2;
        }
        if (bl || bl2) {
            this.replace("JPEG2000CaptureResolutionBox", new ResolutionBox(1919251299, f, f2));
        }
    }

    private void createXMLBoxFromStandardNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "<" + node.getNodeName() + ">";
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string2 = node2.getNodeName();
            string = String.valueOf(string) + "<" + string2 + " ";
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                Node node3 = namedNodeMap.item(n2);
                string = String.valueOf(string) + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\" ";
                ++n2;
            }
            string = String.valueOf(string) + " />";
            ++n;
        }
        string = String.valueOf(string) + "</" + node.getNodeName() + ">";
        this.boxes.add(new XMLBox(string.getBytes()));
    }

    private void createHeaderBoxFromStandardNode(Node node, int n) {
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        byte by = (byte)(this.getElement("JPEG2000ColorSpecificationBox") == null ? 1 : 0);
        if (headerBox != null) {
            if (n == 0) {
                // empty if block
            }
            n = headerBox.getNumComponents();
            headerBox = new HeaderBox(headerBox.getHeight(), headerBox.getWidth(), n, headerBox.getBitDepth(), headerBox.getCompressionType(), by, headerBox.getIntellectualProperty());
        } else {
            headerBox = new HeaderBox(0, 0, n, 0, 0, by, 0);
        }
        this.replace("JPEG2000HeaderBox", headerBox);
    }

    private void createChannelDefinitionFromStandardNode(Node node) {
        Object object;
        Object object2;
        Object object3;
        if (node.getNodeName() != "Transparency") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata8"));
        }
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        int n = 3;
        if (headerBox != null) {
            n = headerBox.getNumComponents();
        }
        NodeList nodeList = node.getChildNodes();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            object3 = nodeList.item(n2);
            object2 = object3.getNodeName();
            if (((String)object2).equals("Alpha")) {
                object = (String)Box.getAttribute((Node)object3, "value");
                if (((String)object).equals("premultiplied")) {
                    bl2 = true;
                }
                if (((String)object).equals("nonpremultiplied")) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        n2 = (short)(n * (bl2 ? 3 : 2));
        object3 = new short[n2];
        object2 = new short[n2];
        object = new short[n2];
        ChannelDefinitionBox.fillBasedOnBands(n, bl2, (short[])object3, (short[])object2, (short[])object);
        this.replace("JPEG2000ChannelDefinitionBox", new ChannelDefinitionBox((short[])object3, (short[])object2, (short[])object));
    }

    private void replace(String string, Box box) {
        int n = this.boxes.size() - 1;
        while (n >= 0) {
            Box box2 = (Box)this.boxes.get(n);
            if (string.equals(Box.getName(box2.getType()))) {
                this.boxes.set(n, box);
                return;
            }
            --n;
        }
        this.boxes.add(box);
    }

    private boolean insertNodeIntoTree(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2) {
        String string = iIOMetadataNode2.getNodeName();
        String string2 = this.format.getParent(string);
        if (string2 == null) {
            return false;
        }
        IIOMetadataNode iIOMetadataNode3 = this.getNodeFromTree(iIOMetadataNode, string2, string);
        if (iIOMetadataNode3 == null) {
            iIOMetadataNode3 = this.createNodeIntoTree(iIOMetadataNode, string2);
        }
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        return true;
    }

    private IIOMetadataNode getNodeFromTree(IIOMetadataNode iIOMetadataNode, String string, String string2) {
        if (string.equals(iIOMetadataNode.getNodeName())) {
            return iIOMetadataNode;
        }
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(n);
            if (iIOMetadataNode2.getNodeName().equals(string)) {
                if (!string.equals("JPEG2000UUIDInfoBox") || !this.checkUUIDInfoBox(iIOMetadataNode2, string2)) {
                    return iIOMetadataNode2;
                }
            } else if ((iIOMetadataNode2 = this.getNodeFromTree(iIOMetadataNode2, string, string2)) != null) {
                return iIOMetadataNode2;
            }
            ++n;
        }
        return null;
    }

    private IIOMetadataNode createNodeIntoTree(IIOMetadataNode iIOMetadataNode, String string) {
        IIOMetadataNode iIOMetadataNode2 = this.getNodeFromTree(iIOMetadataNode, string, null);
        if (iIOMetadataNode2 != null) {
            return iIOMetadataNode2;
        }
        iIOMetadataNode2 = new IIOMetadataNode(string);
        String string2 = this.format.getParent(string);
        IIOMetadataNode iIOMetadataNode3 = this.createNodeIntoTree(iIOMetadataNode, string2);
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    private boolean isOriginalSigned(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        return n != 0 && n != 1;
    }

    private boolean checkUUIDInfoBox(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList.item(n);
            String string2 = iIOMetadataNode.getNodeName();
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

