/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.RenderedImageSrc;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import jj2000.j2k.codestream.writer.FileCodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.fileformat.writer.FileFormatWriter;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.CodestreamManipulator;
import jj2000.j2k.wavelet.analysis.ForwardWT;

public class J2KImageWriter
extends ImageWriter {
    public static String WRITE_ABORTED = "Write aborted.";
    private ImageOutputStream stream = null;

    public void processImageProgressWrapper(float f) {
        this.processImageProgress(f);
    }

    public J2KImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("J2KImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new J2KImageWriteParam();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new J2KMetadata(imageTypeSpecifier, imageWriteParam, this);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (iIOMetadata instanceof J2KMetadata) {
            return (IIOMetadata)((J2KMetadata)iIOMetadata).clone();
        }
        try {
            J2KMetadata j2KMetadata = new J2KMetadata();
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            String string = null;
            if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                string = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                string = "javax_imageio_1.0";
            }
            if (string != null) {
                j2KMetadata.setFromTree(string, iIOMetadata.getAsTree(string));
                return j2KMetadata;
            }
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        Object object;
        Object object2;
        ColorModel colorModel;
        int n;
        J2KImageWriteParamJava j2KImageWriteParamJava;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("J2KImageWriter7"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        RenderedImage renderedImage = null;
        boolean bl = iIOImage.hasRaster();
        Raster raster = null;
        SampleModel sampleModel = null;
        if (bl) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
        }
        this.checkSampleModel(sampleModel);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        if ((j2KImageWriteParamJava = new J2KImageWriteParamJava(iIOImage, imageWriteParam)).getPackPacketHeaderInTile() && j2KImageWriteParamJava.getPackPacketHeaderInMain()) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter1"));
        }
        if (j2KImageWriteParamJava.getLossless() && j2KImageWriteParamJava.getEncodingRate() != Double.MAX_VALUE) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter2"));
        }
        if (!bl && renderedImage.getColorModel() instanceof IndexColorModel || bl && raster.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            j2KImageWriteParamJava.setDecompositionLevel("0");
            j2KImageWriteParamJava.setLossless(true);
            j2KImageWriteParamJava.setEncodingRate(Double.MAX_VALUE);
            j2KImageWriteParamJava.setQuantizationType("reversible");
            j2KImageWriteParamJava.setFilters("w5x3");
        } else if (j2KImageWriteParamJava.getEncodingRate() == Double.MAX_VALUE) {
            j2KImageWriteParamJava.setLossless(true);
            j2KImageWriteParamJava.setQuantizationType("reversible");
            j2KImageWriteParamJava.setFilters("w5x3");
        }
        boolean bl2 = j2KImageWriteParamJava.getPackPacketHeaderInTile();
        boolean bl3 = j2KImageWriteParamJava.getPackPacketHeaderInMain();
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = imageWriteParam.getSourceBands();
        int n2 = sampleModel.getNumBands();
        if (nArray != null) {
            n2 = nArray.length;
        }
        RenderedImageSrc renderedImageSrc = null;
        renderedImageSrc = bl ? new RenderedImageSrc(raster, j2KImageWriteParamJava, this) : new RenderedImageSrc(renderedImage, j2KImageWriteParamJava, this);
        boolean[] blArray = new boolean[n2];
        if (nArray != null) {
            n = 0;
            while (n < n2) {
                blArray[n] = renderedImageSrc.isOrigSigned(nArray[n]);
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                blArray[n] = renderedImageSrc.isOrigSigned(n);
                ++n;
            }
        }
        n = j2KImageWriteParamJava.getTileWidth();
        int n3 = j2KImageWriteParamJava.getTileHeight();
        int n4 = j2KImageWriteParamJava.getMinX();
        int n5 = j2KImageWriteParamJava.getMinY();
        if (n4 < 0 || n5 < 0) {
            throw new IIOException(I18N.getString("J2KImageWriter3"));
        }
        int n6 = j2KImageWriteParamJava.getTileGridXOffset();
        int n7 = j2KImageWriteParamJava.getTileGridYOffset();
        if (n6 < 0 || n7 < 0 || n6 > n4 || n7 > n5) {
            throw new IIOException(I18N.getString("J2KImageWriter4"));
        }
        Tiler tiler = new Tiler(renderedImageSrc, n4, n5, n6, n7, n, n3);
        ForwCompTransf forwCompTransf = new ForwCompTransf(tiler, j2KImageWriteParamJava);
        ImgDataConverter imgDataConverter = new ImgDataConverter(forwCompTransf);
        ForwardWT forwardWT = ForwardWT.createInstance(imgDataConverter, j2KImageWriteParamJava);
        Quantizer quantizer = Quantizer.createInstance(forwardWT, j2KImageWriteParamJava);
        ROIScaler rOIScaler = ROIScaler.createInstance(quantizer, j2KImageWriteParamJava);
        EntropyCoder entropyCoder = EntropyCoder.createInstance(rOIScaler, j2KImageWriteParamJava, j2KImageWriteParamJava.getCodeBlockSize(), j2KImageWriteParamJava.getPrecinctPartition(), j2KImageWriteParamJava.getBypass(), j2KImageWriteParamJava.getResetMQ(), j2KImageWriteParamJava.getTerminateOnByte(), j2KImageWriteParamJava.getCausalCXInfo(), j2KImageWriteParamJava.getCodeSegSymbol(), j2KImageWriteParamJava.getMethodForMQLengthCalc(), j2KImageWriteParamJava.getMethodForMQTermination());
        File file = File.createTempFile("jiio-", ".tmp");
        file.deleteOnExit();
        FileCodestreamWriter fileCodestreamWriter = new FileCodestreamWriter(file, Integer.MAX_VALUE);
        float f = (float)j2KImageWriteParamJava.getEncodingRate();
        PostCompRateAllocator postCompRateAllocator = PostCompRateAllocator.createInstance(entropyCoder, f, fileCodestreamWriter, j2KImageWriteParamJava);
        HeaderEncoder headerEncoder = new HeaderEncoder(renderedImageSrc, blArray, forwardWT, tiler, j2KImageWriteParamJava, rOIScaler, postCompRateAllocator);
        postCompRateAllocator.setHeaderEncoder(headerEncoder);
        headerEncoder.encodeMainHeader();
        try {
            postCompRateAllocator.initialize();
        }
        catch (RuntimeException runtimeException) {
            if (WRITE_ABORTED.equals(runtimeException.getMessage())) {
                fileCodestreamWriter.close();
                file.delete();
                this.processWriteAborted();
                return;
            }
            throw runtimeException;
        }
        headerEncoder.reset();
        headerEncoder.encodeMainHeader();
        fileCodestreamWriter.commitBitstreamHeader(headerEncoder);
        postCompRateAllocator.runAndWrite();
        fileCodestreamWriter.close();
        int n8 = fileCodestreamWriter.getLength();
        int n9 = j2KImageWriteParamJava.getPacketPerTilePart();
        int n10 = tiler.getNumTiles();
        if (n9 > 0 || bl2 || bl3) {
            CodestreamManipulator codestreamManipulator = new CodestreamManipulator(file, n10, n9, bl3, bl2, bl4, bl5);
            n8 += codestreamManipulator.doCodestreamManipulation();
        }
        int n11 = renderedImageSrc.getNumComps();
        int[] nArray2 = new int[n11];
        int n12 = 0;
        while (n12 < n11) {
            nArray2[n12] = renderedImageSrc.getNomRangeBits(n12);
            ++n12;
        }
        ColorModel colorModel2 = colorModel = renderedImage != null ? renderedImage.getColorModel() : null;
        if (nArray != null && (object2 = imageWriteParam.getDestinationType()) != null) {
            colorModel = ((ImageTypeSpecifier)object2).getColorModel();
        }
        if (colorModel == null) {
            colorModel = ImageUtil.createColorModel(sampleModel);
        }
        object2 = null;
        if (imageWriteParam instanceof J2KImageWriteParam && !((J2KImageWriteParam)imageWriteParam).getWriteCodeStreamOnly()) {
            object = iIOImage.getMetadata();
            J2KMetadata j2KMetadata = new J2KMetadata(colorModel, sampleModel, renderedImageSrc.getImgWidth(), renderedImageSrc.getImgHeight(), imageWriteParam, this);
            if (object == null) {
                object2 = j2KMetadata;
            } else {
                if (colorModel != null) {
                    ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
                    object2 = (J2KMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam);
                } else {
                    String string = null;
                    List<String> list = Arrays.asList(((IIOMetadata)object).getMetadataFormatNames());
                    if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                        string = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
                    } else if (((IIOMetadata)object).isStandardMetadataFormatSupported()) {
                        string = "javax_imageio_1.0";
                    }
                    object2 = new J2KMetadata();
                    if (string != null) {
                        ((J2KMetadata)object2).setFromTree(string, ((IIOMetadata)object).getAsTree(string));
                    }
                }
                ((J2KMetadata)object2).mergeTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0", j2KMetadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0"));
            }
        }
        object = new FileFormatWriter(file, this.stream, renderedImageSrc.getImgHeight(), renderedImageSrc.getImgWidth(), n11, nArray2, n8, colorModel, sampleModel, (J2KMetadata)object2);
        n8 += ((FileFormatWriter)object).writeFileFormat();
        file.delete();
        this.processImageComplete();
    }

    @Override
    public synchronized void abort() {
        super.abort();
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private void checkSampleModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter5"));
        }
        if (sampleModel.getNumBands() > 16384) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter6"));
        }
    }
}

