/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.RenderedImageSrc;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.StringSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.entropy.ProgressionSpec;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.image.forwcomptransf.ForwCompTransfSpec;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class J2KImageWriteParamJava
extends ImageWriteParam {
    private boolean packPacketHeaderInTile = false;
    private boolean packPacketHeaderInMain = false;
    private int packetPerTilePart = 0;
    private double encodingRate = Double.MAX_VALUE;
    private boolean lossless = true;
    private ForwCompTransfSpec componentTransformation = null;
    private boolean enableCT = true;
    private AnWTFilterSpec filters = null;
    private IntegerSpec decompositionLevel = null;
    private GuardBitsSpec guardBits = null;
    private QuantStepSizeSpec quantizationStep = null;
    private QuantTypeSpec quantizationType = null;
    private int startLevelROI = -1;
    private boolean alignROI = false;
    private MaxShiftSpec ROIs = null;
    private CBlkSizeSpec codeBlockSize = null;
    private StringSpec bypass = null;
    private StringSpec resetMQ = null;
    private StringSpec terminateOnByte = null;
    private StringSpec causalCXInfo = null;
    private StringSpec codeSegSymbol = null;
    private StringSpec methodForMQTermination = null;
    private StringSpec methodForMQLengthCalc = null;
    private PrecinctSizeSpec precinctPartition = null;
    private ProgressionSpec progressionType = null;
    private String progressionName = null;
    private String layers = "0.015 +20 2.0 +10";
    private StringSpec EPH = null;
    private StringSpec SOP = null;
    private int numTiles;
    private int numComponents;
    private RenderedImage imgsrc;
    private Raster raster;
    private int minX;
    private int minY;

    public J2KImageWriteParamJava(RenderedImage renderedImage, Locale locale) {
        super(locale);
        this.setDefaults(renderedImage);
    }

    public J2KImageWriteParamJava(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        super(imageWriteParam.getLocale());
        if (iIOImage != null) {
            if (iIOImage.hasRaster()) {
                this.setDefaults(iIOImage.getRaster());
            } else {
                this.setDefaults(iIOImage.getRenderedImage());
            }
        }
        this.setSourceRegion(imageWriteParam.getSourceRegion());
        this.setSourceBands(imageWriteParam.getSourceBands());
        try {
            this.setTiling(imageWriteParam.getTileWidth(), imageWriteParam.getTileHeight(), imageWriteParam.getTileGridXOffset(), imageWriteParam.getTileGridYOffset());
        }
        catch (IllegalStateException illegalStateException) {}
        this.setDestinationOffset(imageWriteParam.getDestinationOffset());
        this.setSourceSubsampling(imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), imageWriteParam.getSubsamplingXOffset(), imageWriteParam.getSubsamplingYOffset());
        this.setDestinationType(imageWriteParam.getDestinationType());
        J2KImageWriteParam j2KImageWriteParam = imageWriteParam instanceof J2KImageWriteParam ? (J2KImageWriteParam)imageWriteParam : new J2KImageWriteParam();
        this.setDecompositionLevel("" + j2KImageWriteParam.getNumDecompositionLevels());
        this.setEncodingRate(j2KImageWriteParam.getEncodingRate());
        this.setLossless(j2KImageWriteParam.getLossless());
        this.setFilters(j2KImageWriteParam.getFilter());
        this.setEPH("" + j2KImageWriteParam.getEPH());
        this.setSOP("" + j2KImageWriteParam.getSOP());
        this.setProgressionName(j2KImageWriteParam.getProgressionType());
        int[] nArray = j2KImageWriteParam.getCodeBlockSize();
        this.setCodeBlockSize(nArray[0] + " " + nArray[1]);
        this.enableCT = j2KImageWriteParam.getComponentTransformation();
        this.setComponentTransformation("" + this.enableCT);
    }

    public J2KImageWriteParamJava() {
        this.setSuperProperties();
    }

    public J2KImageWriteParamJava(RenderedImage renderedImage) {
        this.setDefaults(renderedImage);
    }

    public J2KImageWriteParamJava(Raster raster) {
        this.setDefaults(raster);
    }

    private void setSuperProperties() {
        this.canOffsetTiles = true;
        this.canWriteTiles = true;
        this.canOffsetTiles = true;
        this.canWriteProgressive = true;
        this.tilingMode = 2;
    }

    private void setDefaults(Raster raster) {
        this.setSuperProperties();
        if (raster != null) {
            this.raster = raster;
            this.tileGridXOffset = raster.getMinX();
            this.tileGridYOffset = raster.getMinY();
            this.tileWidth = raster.getWidth();
            this.tileHeight = raster.getHeight();
            this.tilingSet = true;
            this.numTiles = 1;
            this.numComponents = raster.getSampleModel().getNumBands();
        }
        this.setDefaults();
    }

    private void setDefaults(RenderedImage renderedImage) {
        this.setSuperProperties();
        this.tilingMode = 2;
        if (renderedImage != null) {
            this.imgsrc = renderedImage;
            this.tileGridXOffset = renderedImage.getTileGridXOffset();
            this.tileGridYOffset = renderedImage.getTileGridYOffset();
            this.tileWidth = renderedImage.getTileWidth();
            this.tileHeight = renderedImage.getTileHeight();
            this.tilingSet = true;
            this.numTiles = renderedImage.getNumXTiles() * renderedImage.getNumYTiles();
            this.numComponents = renderedImage.getSampleModel().getNumBands();
        }
        this.setDefaults();
    }

    private void setDefaults() {
        this.setROIs(null);
        this.setQuantizationType(null);
        this.setQuantizationStep(null);
        this.setGuardBits(null);
        this.setFilters(null);
        this.setDecompositionLevel(null);
        this.setComponentTransformation(null);
        this.setMethodForMQLengthCalc(null);
        this.setMethodForMQTermination(null);
        this.setCodeSegSymbol(null);
        this.setCausalCXInfo(null);
        this.setTerminateOnByte(null);
        this.setResetMQ(null);
        this.setBypass(null);
        this.setCodeBlockSize(null);
        this.setPrecinctPartition(null);
        this.setSOP(null);
        this.setEPH(null);
    }

    public void setEncodingRate(double d) {
        this.encodingRate = d;
    }

    public double getEncodingRate() {
        return this.encodingRate;
    }

    public void setLossless(boolean bl) {
        this.lossless = bl;
    }

    public boolean getLossless() {
        return this.lossless;
    }

    public void setPacketPerTilePart(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriteParamJava0"));
        }
        this.packetPerTilePart = n;
        if (n > 0) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public int getPacketPerTilePart() {
        return this.packetPerTilePart;
    }

    public void setPackPacketHeaderInTile(boolean bl) {
        this.packPacketHeaderInTile = bl;
        if (bl) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public boolean getPackPacketHeaderInTile() {
        return this.packPacketHeaderInTile;
    }

    public void setPackPacketHeaderInMain(boolean bl) {
        this.packPacketHeaderInMain = bl;
        if (bl) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public boolean getPackPacketHeaderInMain() {
        return this.packPacketHeaderInMain;
    }

    public void setAlignROI(boolean bl) {
        this.alignROI = bl;
    }

    public boolean getAlignROI() {
        return this.alignROI;
    }

    public void setROIs(String string) {
        this.ROIs = new MaxShiftSpec(this.numTiles, this.numComponents, 2, string);
    }

    public MaxShiftSpec getROIs() {
        return this.ROIs;
    }

    public void setQuantizationType(String string) {
        this.quantizationType = new QuantTypeSpec(this.numTiles, this.numComponents, 2, this, string);
    }

    public QuantTypeSpec getQuantizationType() {
        return this.quantizationType;
    }

    public void setQuantizationStep(String string) {
        this.quantizationStep = new QuantStepSizeSpec(this.numTiles, this.numComponents, 2, this, string);
    }

    public QuantStepSizeSpec getQuantizationStep() {
        return this.quantizationStep;
    }

    public void setGuardBits(String string) {
        this.guardBits = new GuardBitsSpec(this.numTiles, this.numComponents, 2, this, string);
    }

    public GuardBitsSpec getGuardBits() {
        return this.guardBits;
    }

    public void setFilters(String string) {
        if ("w9x7".equals(string)) {
            this.setQuantizationType("expounded");
        } else {
            this.setQuantizationType("reversible");
        }
        this.filters = new AnWTFilterSpec(this.numTiles, this.numComponents, 2, this.quantizationType, this, string);
        this.setComponentTransformation("" + this.enableCT);
    }

    public AnWTFilterSpec getFilters() {
        return this.filters;
    }

    public void setDecompositionLevel(String string) {
        this.decompositionLevel = new IntegerSpec(this.numTiles, this.numComponents, 2, this, string, "5");
        this.setPrecinctPartition(null);
    }

    public IntegerSpec getDecompositionLevel() {
        return this.decompositionLevel;
    }

    public void setComponentTransformation(String string) {
        this.componentTransformation = new ForwCompTransfSpec(this.numTiles, this.numComponents, 1, this.filters, this, string);
    }

    public ForwCompTransfSpec getComponentTransformation() {
        return this.componentTransformation;
    }

    public void setMethodForMQLengthCalc(String string) {
        String[] stringArray = new String[]{"near_opt", "lazy_good", "lazy"};
        this.methodForMQLengthCalc = new StringSpec(this.numTiles, this.numComponents, 2, "near_opt", stringArray, this, string);
    }

    public StringSpec getMethodForMQLengthCalc() {
        return this.methodForMQLengthCalc;
    }

    public void setMethodForMQTermination(String string) {
        String[] stringArray = new String[]{"near_opt", "easy", "predict", "full"};
        this.methodForMQTermination = new StringSpec(this.numTiles, this.numComponents, 2, "near_opt", stringArray, this, string);
    }

    public StringSpec getMethodForMQTermination() {
        return this.methodForMQTermination;
    }

    public void setCodeSegSymbol(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.codeSegSymbol = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getCodeSegSymbol() {
        return this.codeSegSymbol;
    }

    public void setCausalCXInfo(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.causalCXInfo = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getCausalCXInfo() {
        return this.causalCXInfo;
    }

    public void setTerminateOnByte(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.terminateOnByte = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getTerminateOnByte() {
        return this.terminateOnByte;
    }

    public void setResetMQ(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.resetMQ = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getResetMQ() {
        return this.resetMQ;
    }

    public void setBypass(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.bypass = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getBypass() {
        return this.bypass;
    }

    public void setCodeBlockSize(String string) {
        this.codeBlockSize = new CBlkSizeSpec(this.numTiles, this.numComponents, 2, this, string);
    }

    public CBlkSizeSpec getCodeBlockSize() {
        return this.codeBlockSize;
    }

    public void setPrecinctPartition(String string) {
        String[] stringArray = new String[]{"true", "false"};
        if (this.imgsrc != null) {
            this.precinctPartition = new PrecinctSizeSpec(this.numTiles, this.numComponents, 2, new RenderedImageSrc(this.imgsrc, this, null), this.decompositionLevel, this, string);
        } else if (this.raster != null) {
            this.precinctPartition = new PrecinctSizeSpec(this.numTiles, this.numComponents, 2, new RenderedImageSrc(this.raster, this, null), this.decompositionLevel, this, string);
        }
    }

    public PrecinctSizeSpec getPrecinctPartition() {
        return this.precinctPartition;
    }

    public void setSOP(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.SOP = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getSOP() {
        return this.SOP;
    }

    public void setEPH(String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.EPH = new StringSpec(this.numTiles, this.numComponents, 2, "false", stringArray, this, string);
    }

    public StringSpec getEPH() {
        return this.EPH;
    }

    public void setProgressionName(String string) {
        this.progressionName = string;
    }

    public String getProgressionName() {
        return this.progressionName;
    }

    public void setProgressionType(LayersInfo layersInfo, String string) {
        String[] stringArray = new String[]{"true", "false"};
        this.progressionType = new ProgressionSpec(this.numTiles, this.numComponents, layersInfo.getTotNumLayers(), this.decompositionLevel, 2, this, string);
    }

    public ProgressionSpec getProgressionType() {
        return this.progressionType;
    }

    public void setStartLevelROI(int n) {
        this.startLevelROI = n;
    }

    public int getStartLevelROI() {
        return this.startLevelROI;
    }

    public void setLayers(String string) {
        this.layers = string;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setMinX(int n) {
        this.minX = n;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinY(int n) {
        this.minY = n;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNumTiles() {
        Rectangle rectangle = this.getSourceRegion();
        rectangle = rectangle == null ? (this.imgsrc != null ? new Rectangle(this.imgsrc.getMinX(), this.imgsrc.getMinY(), this.imgsrc.getWidth(), this.imgsrc.getHeight()) : this.raster.getBounds()) : (this.imgsrc != null ? rectangle.intersection(new Rectangle(this.imgsrc.getMinX(), this.imgsrc.getMinY(), this.imgsrc.getWidth(), this.imgsrc.getHeight())) : rectangle.intersection(this.raster.getBounds()));
        int n = this.getSourceXSubsampling();
        int n2 = this.getSourceYSubsampling();
        int n3 = this.getSubsamplingXOffset();
        int n4 = this.getSubsamplingYOffset();
        int n5 = (rectangle.width - n3 + n - 1) / n;
        int n6 = (rectangle.height - n4 + n2 - 1) / n2;
        this.minX = (rectangle.x + n3) / n;
        this.minY = (rectangle.y + n4) / n2;
        this.numTiles = (int)((Math.floor(((double)(this.minX + n5 + this.tileWidth) - 1.0) / (double)this.tileWidth) - Math.floor((double)this.minX / (double)this.tileWidth)) * (Math.floor(((double)(this.minY + n6 + this.tileHeight) - 1.0) / (double)this.tileHeight) - Math.floor((double)this.minY / (double)this.tileHeight)));
        this.tileGridXOffset += (this.minX - this.tileGridXOffset) / this.tileWidth * this.tileWidth;
        this.tileGridYOffset += (this.minY - this.tileGridYOffset) / this.tileHeight * this.tileHeight;
        return this.numTiles;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public void setSourceBands(int[] nArray) {
        super.setSourceBands(nArray);
        if (nArray != null) {
            this.numComponents = nArray.length;
            this.setDefaults();
        }
    }

    @Override
    public void setTiling(int n, int n2, int n3, int n4) {
        super.setTiling(n, n2, n3, n4);
        this.getNumTiles();
        this.setDefaults();
    }

    @Override
    public void setSourceSubsampling(int n, int n2, int n3, int n4) {
        super.setSourceSubsampling(n, n2, n3, n4);
        this.getNumTiles();
        this.setDefaults();
    }
}

