/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.io.RandomAccessIO;

public class IISRandomAccessIO
implements RandomAccessIO {
    private ImageInputStream iis;

    public IISRandomAccessIO(ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("iis == null!");
        }
        this.iis = imageInputStream;
    }

    @Override
    public void close() throws IOException {
        this.iis.close();
    }

    @Override
    public int getPos() throws IOException {
        long l = this.iis.getStreamPosition();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    @Override
    public void seek(int n) throws IOException {
        this.iis.seek(n);
    }

    @Override
    public int length() throws IOException {
        long l = this.iis.length();
        if (l != -1L) {
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }
        this.iis.mark();
        int n = 1024;
        byte[] byArray = new byte[n];
        long l2 = this.iis.getStreamPosition();
        while (l2 < Integer.MAX_VALUE) {
            int n2 = this.iis.read(byArray, 0, n);
            if (n2 == -1) break;
            l2 += (long)n2;
        }
        this.iis.reset();
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    @Override
    public int read() throws IOException {
        return this.iis.read();
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.iis.readFully(byArray, n, n2);
    }

    @Override
    public int getByteOrdering() {
        return this.iis.getByteOrder() == ByteOrder.BIG_ENDIAN ? 0 : 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.iis.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.iis.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.iis.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.iis.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.iis.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.iis.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.iis.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.iis.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.iis.readDouble();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.iis.skipBytes(n);
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeByte(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeShort(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeInt(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeLong(long l) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeFloat(float f) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeDouble(double d) throws IOException {
        throw new IOException("Writing is not supported!");
    }
}

