/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HeaderBox
extends Box {
    private static String[] elementNames = new String[]{"Height", "Width", "NumComponents", "BitDepth", "CompressionType", "UnknownColorspace", "IntellectualProperty"};
    private int width;
    private int height;
    private short numComp;
    private byte bitDepth;
    private byte compressionType;
    private byte unknownColor;
    private byte intelProp;

    public static String[] getElementNames() {
        return elementNames;
    }

    public HeaderBox(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(22, 1768449138, null);
        this.height = n;
        this.width = n2;
        this.numComp = (short)n3;
        this.bitDepth = (byte)n4;
        this.compressionType = (byte)n5;
        this.unknownColor = (byte)n6;
        this.intelProp = (byte)n7;
    }

    public HeaderBox(byte[] byArray) {
        super(8 + byArray.length, 1768449138, byArray);
    }

    public HeaderBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if ("Height".equals(string)) {
                this.height = Box.getIntElementValue(node2);
            }
            if ("Width".equals(string)) {
                this.width = Box.getIntElementValue(node2);
            }
            if ("NumComponents".equals(string)) {
                this.numComp = Box.getShortElementValue(node2);
            }
            if ("BitDepth".equals(string)) {
                this.bitDepth = Box.getByteElementValue(node2);
            }
            if ("CompressionType".equals(string)) {
                this.compressionType = Box.getByteElementValue(node2);
            }
            if ("UnknownColorspace".equals(string)) {
                this.unknownColor = Box.getByteElementValue(node2);
            }
            if ("IntellectualProperty".equals(string)) {
                this.intelProp = Box.getByteElementValue(node2);
            }
            ++n;
        }
    }

    @Override
    protected void parse(byte[] byArray) {
        this.height = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.width = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.numComp = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.bitDepth = byArray[10];
        this.compressionType = byArray[11];
        this.unknownColor = byArray[12];
        this.intelProp = byArray[13];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short getNumComponents() {
        return this.numComp;
    }

    public byte getCompressionType() {
        return this.compressionType;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getUnknownColorspace() {
        return this.unknownColor;
    }

    public byte getIntellectualProperty() {
        return this.intelProp;
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    @Override
    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[14];
        HeaderBox.copyInt(this.data, 0, this.height);
        HeaderBox.copyInt(this.data, 4, this.width);
        this.data[8] = (byte)(this.numComp >> 8);
        this.data[9] = (byte)(this.numComp & 0xFF);
        this.data[10] = this.bitDepth;
        this.data[11] = this.compressionType;
        this.data[12] = this.unknownColor;
        this.data[13] = this.intelProp;
    }
}

